/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Path;

public class TTGlyph
extends BaseTTGlyph
implements PdfGlyph,
Serializable {
    Area glyphShape;
    BufferedImage img;

    public void setPaths(Vector_Path vp) {
        this.paths = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.paths != null) {
            int i;
            GeneralPath[] generalPaths = this.paths.get();
            int count = 0;
            for (i = 0; i < generalPaths.length; ++i) {
                if (generalPaths[i] != null) continue;
                count = i;
                break;
            }
            os.writeObject(count);
            for (i = 0; i < count; ++i) {
                PathIterator pathIterator = generalPaths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    public TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName) {
        block6: {
            super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, baseFontName);
            if (debug) {
                try {
                    System.out.println("debugging" + idx);
                    BufferedImage img = new BufferedImage(700, 700, 2);
                    Graphics2D gg2 = img.createGraphics();
                    for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
                        if (jj == 0) {
                            gg2.setColor(Color.red);
                        } else {
                            gg2.setColor(Color.blue);
                        }
                        gg2.fill(this.paths.elementAt(jj));
                        gg2.draw(this.paths.elementAt(jj).getBounds());
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    public TTGlyph(Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, TTVM vm) {
        block6: {
            super(currentGlyf, glyfTable, currentHmtx, idx, unitsPerEm, vm);
            if (debug) {
                try {
                    System.out.println("debugging" + idx);
                    BufferedImage img = new BufferedImage(700, 700, 2);
                    Graphics2D gg2 = img.createGraphics();
                    for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
                        if (jj == 0) {
                            gg2.setColor(Color.red);
                        } else {
                            gg2.setColor(Color.blue);
                        }
                        gg2.fill(this.paths.elementAt(jj));
                        gg2.draw(this.paths.elementAt(jj).getBounds());
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block6;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    @Override
    public void render(int type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        AffineTransform restore = g2.getTransform();
        BasicStroke oldStroke = (BasicStroke)g2.getStroke();
        float strokeWidth = oldStroke.getLineWidth();
        if (strokeWidth < 0.0f) {
            strokeWidth = -strokeWidth;
        }
        if (useHinting) {
            g2.scale(0.01, 0.01);
            strokeWidth *= 100.0f;
        }
        g2.setStroke(new BasicStroke(strokeWidth, 0, 1, oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase()));
        for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
            if ((type & 2) == 2) {
                g2.fill(this.paths.elementAt(jj));
                continue;
            }
            if ((type & 1) != 1) continue;
            g2.draw(this.paths.elementAt(jj));
        }
        if (useHinting) {
            g2.setStroke(oldStroke);
            g2.setTransform(restore);
        }
    }

    @Override
    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath path = this.paths.elementAt(0);
            for (int jj = 1; jj < this.paths.size() - 1; ++jj) {
                path.append(this.paths.elementAt(jj), false);
            }
            if (path == null) {
                return null;
            }
            this.glyphShape = new Area(path);
        }
        return this.glyphShape;
    }

    @Override
    public void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex) {
        if (endOfContour == null) {
            return;
        }
        int ptCount = endOfContour.length;
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    int diff = firstPt - start;
                    int pXlength = pX.length;
                    int[] old_pX = new int[pXlength];
                    System.arraycopy(pX, 0, old_pX, 0, pXlength);
                    int[] old_pY = new int[pXlength];
                    System.arraycopy(pY, 0, old_pY, 0, pXlength);
                    boolean[] old_onCurve = new boolean[pXlength];
                    System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
                    for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
                        int newPos = oldPos + diff;
                        if (newPos > ii) {
                            newPos -= ii - start + 1;
                        }
                        pX[oldPos] = old_pX[newPos];
                        pY[oldPos] = old_pY[newPos];
                        onCurve[oldPos] = old_onCurve[newPos];
                    }
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        boolean isFirstDraw = true;
        GeneralPath current_path = new GeneralPath(1);
        int c = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        int x1 = pX[0];
        int y1 = pY[0];
        if (debug) {
            System.out.println(pX[0] + " " + pY[0] + " move to x1,y1=" + x1 + ' ' + y1);
        }
        current_path.moveTo(x1, y1);
        if (debug) {
            System.out.println("first contour=" + fc + "====================================" + pX[0] + ' ' + pY[0]);
        }
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < endIndex; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (debug) {
                System.out.println("points=" + lc + '/' + fc + ' ' + pm1 + ' ' + p + ' ' + p1 + ' ' + p2 + " j=" + j + " endOfContour[j]=" + endOfContour[j]);
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                for (int jj = j + 1; jj < c; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c;
                }
                if (debug) {
                    System.out.println("End of contour. next=" + j + ' ' + fc + ' ' + lc);
                }
            }
            if (debug) {
                if (j > 0) {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j-1=" + endOfContour[j - 1] + " j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                } else {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                }
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                if (!debug) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (debug) {
                System.out.println(fc + " " + pm1 + ' ' + p + ' ' + p1 + ' ' + p2);
            }
            if (onCurve[p] && onCurve[p1]) {
                x3 = pX[p1];
                y3 = pY[p1];
                current_path.lineTo(x3, y3);
                if (debug) {
                    System.out.println(p + " pt,pt " + x3 + ' ' + y3 + " (lineTo)");
                }
                isFirstDraw = false;
            } else if (j < c - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = pX[p2];
                    y3 = pY[p2];
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = TTGlyph.midPt(pX[p1], pX[p2]);
                    y3 = TTGlyph.midPt(pY[p1], pY[p2]);
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,cv " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2] && fc - p2 != 1)) {
                    x1 = TTGlyph.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyph.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = TTGlyph.midPt(pX[p], pX[p1]);
                    y3 = TTGlyph.midPt(pY[p], pY[p1]);
                    if (debug) {
                        System.out.println(p + " cv,cv1 " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!onCurve[p] && onCurve[p1]) {
                    x1 = TTGlyph.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyph.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = pX[p1];
                    y3 = pY[p1];
                    if (debug) {
                        System.out.println(p + " cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                }
                if (isFirstDraw) {
                    current_path.moveTo(x1, y1);
                    isFirstDraw = false;
                    if (debug) {
                        System.out.println("first draw move to " + x1 + ' ' + y1);
                    }
                }
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    current_path.curveTo(x1, y1, x2, y2, x3, y3);
                }
                if (debug) {
                    System.out.println("curveto " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                }
                if (checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j + 1; jj < c; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c;
                    }
                    if (debug) {
                        System.out.println("Curve");
                    }
                }
            }
            if (endOfContour[p]) {
                current_path.closePath();
            }
            if (debug) {
                System.out.println("x2 " + xs + ' ' + ys + ' ' + isEnd);
            }
            if (isEnd) {
                current_path.moveTo(xs, ys);
                isEnd = false;
                if (debug) {
                    System.out.println("Move to " + xs + ' ' + ys);
                }
            }
            if (!debug) continue;
            try {
                if (this.img == null) {
                    this.img = new BufferedImage(800, 800, 2);
                }
                Graphics2D g2 = this.img.createGraphics();
                g2.setColor(Color.green);
                g2.draw(current_path);
                String key = String.valueOf(p);
                ShowGUIMessage.showGUIMessage(key, this.img, key);
                continue;
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.paths.addElement(current_path);
        if (debug) {
            System.out.println("Ends at " + x1 + ' ' + y1 + " x=" + this.minX + ',' + this.maxX + " y=" + this.minY + ',' + this.maxY + " glyph x=" + this.compMinX + ',' + this.compMaxX + " y=" + this.compMinY + ',' + this.compMaxY);
        }
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    void clearPaths() {
        this.paths.clear();
    }
}

