/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;

public class Cvt
extends Table {
    final short[] unscaledCvt;
    final int[] cvt;
    double scale;
    private static boolean messageDisplayed;

    Cvt(FontFile2 currentFontFile) {
        int startPointer = currentFontFile.selectTable(9);
        if (startPointer != 0) {
            int len = currentFontFile.getOffset(9) / 2;
            this.unscaledCvt = new short[len];
            this.cvt = new int[len];
            for (int i = 0; i < len; ++i) {
                this.unscaledCvt[i] = currentFontFile.getFWord();
            }
        } else {
            this.unscaledCvt = new short[0];
            this.cvt = new int[0];
        }
    }

    public void scale(double scale) {
        this.scale = scale;
        for (int i = 0; i < this.unscaledCvt.length; ++i) {
            this.cvt[i] = (int)(scale * (double)this.unscaledCvt[i] + 0.5);
        }
    }

    public void putInPixels(int key, int value) {
        if (key >= 0 && key < this.cvt.length) {
            this.cvt[key] = value;
        }
    }

    public void putInFUnits(int key, int value) {
        value = (int)((double)value * this.scale + 0.5);
        if (key >= 0 && key < this.cvt.length) {
            this.cvt[key] = value;
        }
    }

    public int get(int key) {
        if (key >= 0 && key < this.cvt.length) {
            return this.cvt[key];
        }
        if (!messageDisplayed) {
            messageDisplayed = true;
        }
        return 0;
    }
}

