/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.io.Serializable;
import java.util.HashMap;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.Cvt;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.utils.LogWriter;

public class TTVM
implements Serializable {
    protected static final int TWILIGHT_ZONE = 0;
    protected static final int GLYPH_ZONE = 1;
    protected static final int ORIGINAL = 2;
    private boolean printOut;
    private final int[] preProgram;
    private final int[] fontProgram;
    private boolean fontProgramRun;
    private boolean scalerRun;
    private double ptSize;
    private double ppem;
    private double scaler;
    private final int[][] x;
    private final int[][] y;
    private final boolean[][] curve;
    private final boolean[][] contour;
    private boolean[][][] touched;
    final Maxp maxp;
    private boolean useDefaultGS;
    private Stack stack = new Stack();
    private final Cvt cvt;
    private final TTGraphicsState graphicsState;
    private final int[] storage;
    private final HashMap<Integer, int[]> functions;
    private final HashMap<Integer, int[]> instructions;
    private static final int SVTCAy = 0;
    private static final int SVTCAx = 1;
    private static final int SPVTCAy = 2;
    private static final int SPVTCAx = 3;
    private static final int SFVTCAy = 4;
    private static final int SFVTCAx = 5;
    private static final int SPVTL0 = 6;
    private static final int SPVTL1 = 7;
    private static final int SFVTL0 = 8;
    private static final int SFVTL1 = 9;
    private static final int SPVFS = 10;
    private static final int SFVFS = 11;
    private static final int GPV = 12;
    private static final int GFV = 13;
    private static final int SFVTPV = 14;
    private static final int ISECT = 15;
    private static final int SRP0 = 16;
    private static final int SRP1 = 17;
    private static final int SRP2 = 18;
    private static final int SZP0 = 19;
    private static final int SZP1 = 20;
    private static final int SZP2 = 21;
    private static final int SZPS = 22;
    private static final int SLOOP = 23;
    private static final int RTG = 24;
    private static final int RTHG = 25;
    private static final int SMD = 26;
    private static final int ELSE = 27;
    private static final int JMPR = 28;
    private static final int SCVTCI = 29;
    private static final int SSWCI = 30;
    private static final int SSW = 31;
    private static final int DUP = 32;
    private static final int POP = 33;
    private static final int CLEAR = 34;
    private static final int SWAP = 35;
    private static final int DEPTH = 36;
    private static final int CINDEX = 37;
    private static final int MINDEX = 38;
    private static final int ALIGNPTS = 39;
    private static final int UTP = 41;
    private static final int LOOPCALL = 42;
    private static final int CALL = 43;
    private static final int FDEF = 44;
    private static final int ENDF = 45;
    private static final int MDAP0 = 46;
    private static final int MDAP1 = 47;
    private static final int IUPy = 48;
    private static final int IUPx = 49;
    private static final int SHP0 = 50;
    private static final int SHP1 = 51;
    private static final int SHC0 = 52;
    private static final int SHC1 = 53;
    private static final int SHZ0 = 54;
    private static final int SHZ1 = 55;
    private static final int SHPIX = 56;
    private static final int IP = 57;
    private static final int MSIRP0 = 58;
    private static final int MSIRP1 = 59;
    private static final int ALIGNRP = 60;
    private static final int RTDG = 61;
    private static final int MIAP0 = 62;
    private static final int MIAP1 = 63;
    private static final int NPUSHB = 64;
    private static final int NPUSHW = 65;
    private static final int WS = 66;
    private static final int RS = 67;
    private static final int WCVTP = 68;
    private static final int RCVT = 69;
    private static final int GC0 = 70;
    private static final int GC1 = 71;
    private static final int SCFS = 72;
    private static final int MD0 = 73;
    private static final int MD1 = 74;
    private static final int MPPEM = 75;
    private static final int MPS = 76;
    private static final int FLIPON = 77;
    private static final int FLIPOFF = 78;
    private static final int DEBUG = 79;
    private static final int LT = 80;
    private static final int LTEQ = 81;
    private static final int GT = 82;
    private static final int GTEQ = 83;
    private static final int EQ = 84;
    private static final int NEQ = 85;
    private static final int ODD = 86;
    private static final int EVEN = 87;
    private static final int IF = 88;
    private static final int EIF = 89;
    private static final int AND = 90;
    private static final int OR = 91;
    private static final int NOT = 92;
    private static final int DELTAP1 = 93;
    private static final int SDB = 94;
    private static final int SDS = 95;
    private static final int ADD = 96;
    private static final int SUB = 97;
    private static final int DIV = 98;
    private static final int MUL = 99;
    private static final int ABS = 100;
    private static final int NEG = 101;
    private static final int FLOOR = 102;
    private static final int CEILING = 103;
    private static final int ROUND00 = 104;
    private static final int ROUND01 = 105;
    private static final int ROUND10 = 106;
    private static final int ROUND11 = 107;
    private static final int NROUND00 = 108;
    private static final int NROUND01 = 109;
    private static final int NROUND10 = 110;
    private static final int NROUND11 = 111;
    private static final int WCVTF = 112;
    private static final int DELTAP2 = 113;
    private static final int DELTAP3 = 114;
    private static final int DELTAC1 = 115;
    private static final int DELTAC2 = 116;
    private static final int DELTAC3 = 117;
    private static final int SROUND = 118;
    private static final int S45ROUND = 119;
    private static final int JROT = 120;
    private static final int JROF = 121;
    private static final int ROFF = 122;
    private static final int RUTG = 124;
    private static final int RDTG = 125;
    private static final int SANGW = 126;
    private static final int AA = 127;
    private static final int FLIPPT = 128;
    private static final int FLIPRGON = 129;
    private static final int FLIPRGOFF = 130;
    private static final int SCANCTRL = 133;
    private static final int SDPVTL0 = 134;
    private static final int SDPVTL1 = 135;
    private static final int GETINFO = 136;
    private static final int IDEF = 137;
    private static final int ROLL = 138;
    private static final int MAX = 139;
    private static final int MIN = 140;
    private static final int SCANTYPE = 141;
    private static final int INSTCTRL = 142;
    private static final int PUSHB = 176;
    private static final int PUSHW = 184;
    private static final int MDRP = 192;
    private static final int MIRP = 224;
    private static final int paramRESETRP0 = 16;
    private static final int paramUSEMINDIST = 8;
    private static final int paramROUND = 4;

    public TTVM(FontFile2 currentFontFile, Maxp maxp) {
        this.cvt = new Cvt(currentFontFile);
        this.graphicsState = new TTGraphicsState();
        this.preProgram = TTVM.readProgramTable(currentFontFile, 14);
        this.fontProgram = TTVM.readProgramTable(currentFontFile, 10);
        this.storage = new int[maxp.getMaxStorage()];
        this.functions = new HashMap();
        this.instructions = new HashMap();
        this.maxp = maxp;
        int len = maxp.getMaxPoints();
        this.x = new int[4][len];
        this.y = new int[4][len];
        this.curve = new boolean[2][len];
        this.contour = new boolean[2][len];
        this.touched = new boolean[4][len][2];
        this.x[0] = new int[maxp.getMaxTwilightPoints()];
        this.y[0] = new int[maxp.getMaxTwilightPoints()];
    }

    public void setScaleVars(double scaler, double ppem, double ptSize) {
        this.scalerRun = false;
        this.ppem = (int)(ppem + 0.5);
        this.ptSize = ptSize;
        if (!this.fontProgramRun) {
            this.execute(this.fontProgram, this.graphicsState);
            this.fontProgramRun = true;
        }
        if (scaler != this.scaler) {
            this.scaler = scaler;
            this.cvt.scale(scaler);
            this.execute(this.preProgram, this.graphicsState);
            this.scalerRun = true;
        }
    }

    public void processGlyph(int[] instructions, int[] glyfX, int[] glyfY, boolean[] curves, boolean[] contours) {
        TTGraphicsState gs;
        this.x[1] = glyfX;
        this.x[3] = new int[glyfX.length];
        System.arraycopy(this.x[1], 0, this.x[3], 0, this.x[1].length);
        this.y[1] = glyfY;
        this.y[3] = new int[glyfY.length];
        System.arraycopy(this.y[1], 0, this.y[3], 0, this.y[1].length);
        this.curve[1] = curves;
        this.contour[1] = contours;
        int max = this.maxp.getMaxTwilightPoints();
        if (glyfX.length > max) {
            max = glyfX.length;
        }
        this.touched = new boolean[4][max][2];
        this.stack = new Stack();
        if (this.useDefaultGS) {
            gs = new TTGraphicsState();
        } else {
            try {
                gs = (TTGraphicsState)this.graphicsState.clone();
                gs.resetForGlyph();
            }
            catch (CloneNotSupportedException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
                e.printStackTrace(System.out);
                gs = new TTGraphicsState();
            }
        }
        if (gs.instructControl != 0) {
            return;
        }
        this.execute(instructions, gs);
    }

    private void execute(int[] program, TTGraphicsState gs) {
        if (program == null) {
            return;
        }
        for (int currentPointer = 0; currentPointer < program.length; ++currentPointer) {
            if (this.printOut) {
                System.out.print(currentPointer + "\t");
            }
            currentPointer = this.process(program[currentPointer], currentPointer, program, gs);
            if (!BaseTTGlyph.redecodePage) continue;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process(int code, int currentPointer, int[] program, TTGraphicsState gs) {
        int bytesToRead = 0;
        if (code >= 176 && code <= 191) {
            bytesToRead = code % 8;
            code -= bytesToRead;
            ++bytesToRead;
        }
        try {
            switch (code) {
                case 0: {
                    gs.freedomVector = 16384;
                    gs.projectionVector = 16384;
                    gs.dualProjectionVector = 16384;
                    return currentPointer;
                }
                case 1: {
                    gs.freedomVector = 0x40000000;
                    gs.projectionVector = 0x40000000;
                    gs.dualProjectionVector = 0x40000000;
                    return currentPointer;
                }
                case 2: {
                    gs.projectionVector = 16384;
                    gs.dualProjectionVector = 16384;
                    return currentPointer;
                }
                case 3: {
                    gs.projectionVector = 0x40000000;
                    gs.dualProjectionVector = 0x40000000;
                    return currentPointer;
                }
                case 4: {
                    gs.freedomVector = 16384;
                    return currentPointer;
                }
                case 5: {
                    gs.freedomVector = 0x40000000;
                    return currentPointer;
                }
                case 6: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    return currentPointer;
                }
                case 7: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
                    return currentPointer;
                }
                case 8: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp1][p2] - this.x[gs.zp2][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp1][p2] - this.y[gs.zp2][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    return currentPointer;
                }
                case 9: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp1][p2] - this.x[gs.zp2][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp1][p2] - this.y[gs.zp2][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    gs.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(ydiff /= factor)), TTVM.storeDoubleAsF2Dot14(xdiff /= factor));
                    return currentPointer;
                }
                case 10: {
                    int y = this.stack.pop();
                    int x = this.stack.pop();
                    gs.dualProjectionVector = gs.projectionVector = TTGraphicsState.createVector(x, y);
                    return currentPointer;
                }
                case 11: {
                    int y = this.stack.pop();
                    int x = this.stack.pop();
                    gs.freedomVector = TTGraphicsState.createVector(x, y);
                    return currentPointer;
                }
                case 12: {
                    int[] pv = TTGraphicsState.getVectorComponents(gs.projectionVector);
                    this.stack.push(pv[0]);
                    this.stack.push(pv[1]);
                    return currentPointer;
                }
                case 13: {
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    this.stack.push(fv[0]);
                    this.stack.push(fv[1]);
                    return currentPointer;
                }
                case 14: {
                    gs.freedomVector = gs.projectionVector;
                    return currentPointer;
                }
                case 15: {
                    double am;
                    int y;
                    int x;
                    int b1 = this.stack.pop();
                    int b0 = this.stack.pop();
                    int a1 = this.stack.pop();
                    int a0 = this.stack.pop();
                    int ax = this.x[gs.zp1][a0];
                    int ay = this.y[gs.zp1][a0];
                    int adx = this.x[gs.zp1][a1] - ax;
                    int ady = this.y[gs.zp1][a1] - ay;
                    int bx = this.x[gs.zp0][b0];
                    int by = this.y[gs.zp0][b0];
                    int bdx = this.x[gs.zp0][b1] - bx;
                    int bdy = this.y[gs.zp0][b1] - by;
                    if (adx == 0 && bdx == 0) {
                        x = ax + bx / 2;
                        y = (ay + by + (ay + ady) + (by + bdy)) / 4;
                    } else if (adx == 0) {
                        double bm = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
                        double bc = TTVM.getDoubleFromF26Dot6(by) - bm * TTVM.getDoubleFromF26Dot6(bx);
                        x = ax;
                        y = TTVM.storeDoubleAsF26Dot6(bm * TTVM.getDoubleFromF26Dot6(ax) + bc);
                    } else if (bdx == 0) {
                        am = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
                        double ac = TTVM.getDoubleFromF26Dot6(ay) - am * TTVM.getDoubleFromF26Dot6(ax);
                        x = bx;
                        y = TTVM.storeDoubleAsF26Dot6(am * TTVM.getDoubleFromF26Dot6(bx) + ac);
                    } else {
                        am = TTVM.getDoubleFromF26Dot6(ady) / TTVM.getDoubleFromF26Dot6(adx);
                        double ac = TTVM.getDoubleFromF26Dot6(ay) - am * TTVM.getDoubleFromF26Dot6(ax);
                        double bm = TTVM.getDoubleFromF26Dot6(bdy) / TTVM.getDoubleFromF26Dot6(bdx);
                        double bc = TTVM.getDoubleFromF26Dot6(by) - bm * TTVM.getDoubleFromF26Dot6(bx);
                        if (am == bm) {
                            x = (ax + bx + (ax + adx) + (bx + bdx)) / 4;
                            y = (ay + by + (ay + ady) + (by + bdy)) / 4;
                        } else {
                            double fx = (bc - ac) / (am - bm);
                            x = TTVM.storeDoubleAsF26Dot6(fx);
                            y = TTVM.storeDoubleAsF26Dot6(am * fx + ac);
                        }
                    }
                    int p = this.stack.pop();
                    this.x[gs.zp2][p] = x;
                    this.y[gs.zp2][p] = y;
                    return currentPointer;
                }
                case 16: {
                    gs.rp0 = this.stack.pop();
                    return currentPointer;
                }
                case 17: {
                    gs.rp1 = this.stack.pop();
                    return currentPointer;
                }
                case 18: {
                    gs.rp2 = this.stack.pop();
                    return currentPointer;
                }
                case 19: {
                    int value;
                    gs.zp0 = value = this.stack.pop();
                    return currentPointer;
                }
                case 20: {
                    int value;
                    gs.zp1 = value = this.stack.pop();
                    return currentPointer;
                }
                case 21: {
                    int value;
                    gs.zp2 = value = this.stack.pop();
                    return currentPointer;
                }
                case 22: {
                    int value;
                    gs.zp0 = value = this.stack.pop();
                    gs.zp1 = value;
                    gs.zp2 = value;
                    return currentPointer;
                }
                case 23: {
                    gs.loop = this.stack.pop();
                    return currentPointer;
                }
                case 24: {
                    gs.roundState = 72;
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 25: {
                    gs.roundState = 104;
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 26: {
                    gs.minimumDistance = this.stack.pop();
                    return currentPointer;
                }
                case 27: {
                    int curr = 0;
                    int nest = 0;
                    do {
                        if (curr == 89 && nest != 0) {
                            --nest;
                        }
                        if ((curr = program[++currentPointer]) == 88) {
                            ++nest;
                        }
                        if (curr == 64) {
                            ++currentPointer;
                            currentPointer += program[currentPointer];
                            continue;
                        }
                        if (curr == 65) {
                            ++currentPointer;
                            currentPointer += program[currentPointer] * 2;
                            continue;
                        }
                        if (curr >= 176 && curr <= 183) {
                            currentPointer += curr + 1 - 176;
                            continue;
                        }
                        if (curr < 184 || curr > 191) continue;
                        currentPointer += (curr + 1 - 184) * 2;
                    } while (curr != 89 || nest != 0);
                    return currentPointer;
                }
                case 28: {
                    int value = this.stack.pop();
                    currentPointer = currentPointer + value - 1;
                    if (currentPointer >= 0) return currentPointer;
                    throw new RuntimeException("Jumped back further than the start of the instruction.");
                }
                case 29: {
                    gs.controlValueTableCutIn = this.stack.pop();
                    return currentPointer;
                }
                case 30: {
                    gs.singleWidthCutIn = this.stack.pop();
                    return currentPointer;
                }
                case 31: {
                    gs.singleWidthValue = this.stack.pop();
                    return currentPointer;
                }
                case 32: {
                    int value = this.stack.pop();
                    this.stack.push(value);
                    this.stack.push(value);
                    return currentPointer;
                }
                case 33: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 34: {
                    this.stack = new Stack();
                    return currentPointer;
                }
                case 35: {
                    int top = this.stack.pop();
                    int under = this.stack.pop();
                    this.stack.push(top);
                    this.stack.push(under);
                    return currentPointer;
                }
                case 36: {
                    this.stack.push(this.stack.size());
                    return currentPointer;
                }
                case 37: {
                    int key = this.stack.pop();
                    int value = this.stack.elementAt(key);
                    this.stack.push(value);
                    return currentPointer;
                }
                case 38: {
                    int key = this.stack.pop();
                    int value = this.stack.remove(key);
                    this.stack.push(value);
                    return currentPointer;
                }
                case 39: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    int p1loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p1], this.y[gs.zp1][p1]);
                    int p2loc = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p2], this.y[gs.zp0][p2]);
                    int target = (p1loc + p2loc) / 2;
                    int[] shift = gs.getFVMoveforPVDistance(target - p1loc);
                    int[] nArray = this.x[gs.zp1];
                    int n = p1;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray2 = this.y[gs.zp1];
                    int n2 = p1;
                    nArray2[n2] = nArray2[n2] + shift[1];
                    int[] nArray3 = this.x[gs.zp0];
                    int n3 = p2;
                    nArray3[n3] = nArray3[n3] - shift[0];
                    int[] nArray4 = this.y[gs.zp0];
                    int n4 = p2;
                    nArray4[n4] = nArray4[n4] - shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p1][0] = true;
                        this.touched[gs.zp0][p2][0] = true;
                    }
                    if (fv[1] == 0) return currentPointer;
                    this.touched[gs.zp1][p1][1] = true;
                    this.touched[gs.zp0][p2][1] = true;
                    return currentPointer;
                }
                case 41: {
                    int p = this.stack.pop();
                    if (gs.freedomVector == 0x40000000) {
                        this.touched[gs.zp0][p][0] = false;
                        return currentPointer;
                    }
                    if (gs.freedomVector == 16384) {
                        this.touched[gs.zp0][p][1] = false;
                        return currentPointer;
                    }
                    this.touched[gs.zp0][p][0] = false;
                    this.touched[gs.zp0][p][1] = false;
                    return currentPointer;
                }
                case 42: {
                    int func = this.stack.pop();
                    int count = this.stack.pop();
                    int[] function = this.functions.get(func);
                    for (int i = 0; i < count; ++i) {
                        this.execute(function, gs);
                    }
                    if (!this.printOut) return currentPointer;
                    System.out.println("LOOPCALL finished");
                    return currentPointer;
                }
                case 43: {
                    int func = this.stack.pop();
                    int[] function = this.functions.get(func);
                    this.execute(function, gs);
                    if (!this.printOut) return currentPointer;
                    System.out.println("CALL finished");
                    return currentPointer;
                }
                case 44: {
                    int curr;
                    int num = this.stack.pop();
                    int start = currentPointer;
                    do {
                        if ((curr = program[++currentPointer]) == 64) {
                            ++currentPointer;
                            currentPointer += program[currentPointer];
                            continue;
                        }
                        if (curr == 65) {
                            ++currentPointer;
                            currentPointer += program[currentPointer] * 2;
                            continue;
                        }
                        if (curr >= 176 && curr <= 183) {
                            currentPointer += curr + 1 - 176;
                            continue;
                        }
                        if (curr < 184 || curr > 191) continue;
                        currentPointer += (curr + 1 - 184) * 2;
                    } while (curr != 45);
                    int len = currentPointer - start - 1;
                    currentPointer = start;
                    int[] function = new int[len];
                    for (int i = 0; i < len; ++i) {
                        function[i] = program[++currentPointer];
                    }
                    this.functions.put(num, function);
                    ++currentPointer;
                    return currentPointer;
                }
                case 45: {
                    return currentPointer;
                }
                case 46: {
                    int p;
                    gs.rp0 = p = this.stack.pop();
                    gs.rp1 = p;
                    if (gs.freedomVector == 0x40000000) {
                        this.touched[gs.zp0][p][0] = true;
                        return currentPointer;
                    }
                    if (gs.freedomVector == 16384) {
                        this.touched[gs.zp0][p][1] = true;
                        return currentPointer;
                    }
                    this.touched[gs.zp0][p][0] = true;
                    this.touched[gs.zp0][p][1] = true;
                    return currentPointer;
                }
                case 47: {
                    int p;
                    gs.rp0 = p = this.stack.pop();
                    gs.rp1 = p;
                    int m = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    m = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(m))) - m;
                    int[] shift = gs.getFVMoveforPVDistance(m);
                    int[] nArray = this.x[gs.zp0];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray5 = this.y[gs.zp0];
                    int n5 = p;
                    nArray5[n5] = nArray5[n5] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] == 0) return currentPointer;
                    this.touched[gs.zp0][p][1] = true;
                    return currentPointer;
                }
                case 48: {
                    this.interpolateUntouchedPoints(48);
                    return currentPointer;
                }
                case 49: {
                    this.interpolateUntouchedPoints(49);
                    return currentPointer;
                }
                case 50: {
                    int p;
                    for (int i = 0; i < gs.loop && (p = this.stack.pop()) <= this.x[gs.zp2].length && gs.rp2 <= this.x[gs.zp1].length; ++i) {
                        int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                        int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                        int pMove = newRP - oldRP;
                        int[] shift = gs.getFVMoveforPVDistance(pMove);
                        int[] nArray = this.x[gs.zp2];
                        int n = p;
                        nArray[n] = nArray[n] + shift[0];
                        int[] nArray6 = this.y[gs.zp2];
                        int n6 = p;
                        nArray6[n6] = nArray6[n6] + shift[1];
                        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 51: {
                    for (int i = 0; i < gs.loop; ++i) {
                        int p = this.stack.pop();
                        int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                        int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                        int shift = newRP - oldRP;
                        int[] move = gs.getFVMoveforPVDistance(shift);
                        int[] nArray = this.x[gs.zp2];
                        int n = p;
                        nArray[n] = nArray[n] + move[0];
                        int[] nArray7 = this.y[gs.zp2];
                        int n7 = p;
                        nArray7[n7] = nArray7[n7] + move[1];
                        if (move[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (move[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 52: {
                    int c = this.stack.pop();
                    int[] contourLengths = new int[this.contour[1].length];
                    int[] contourStarts = new int[this.contour[1].length];
                    int contourCount = 0;
                    int lastContour = 0;
                    contourStarts[0] = 0;
                    for (int i = 0; i < this.contour[1].length; ++i) {
                        if (!this.contour[1][i]) continue;
                        contourStarts[contourCount + 1] = i + 1;
                        contourLengths[contourCount] = i + 1 - lastContour;
                        lastContour = i + 1;
                        ++contourCount;
                    }
                    int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                    int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                    int shift = newRP - oldRP;
                    int[] move = gs.getFVMoveforPVDistance(shift);
                    int i = contourStarts[c];
                    while (i < contourStarts[c] + contourLengths[c]) {
                        if (gs.zp1 == gs.zp2 || i != gs.rp2) {
                            int[] nArray = this.x[gs.zp2];
                            int n = i;
                            nArray[n] = nArray[n] + move[0];
                            int[] nArray8 = this.y[gs.zp2];
                            int n8 = i;
                            nArray8[n8] = nArray8[n8] + move[1];
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 53: {
                    int c = this.stack.pop();
                    int[] contourLengths = new int[this.contour[1].length];
                    int[] contourStarts = new int[this.contour[1].length];
                    int contourCount = 0;
                    int lastContour = 0;
                    contourStarts[0] = 0;
                    for (int i = 0; i < this.contour[1].length; ++i) {
                        if (!this.contour[1][i]) continue;
                        contourStarts[contourCount + 1] = i + 1;
                        contourLengths[contourCount] = i + 1 - lastContour;
                        lastContour = i + 1;
                        ++contourCount;
                    }
                    int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                    int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                    int shift = newRP - oldRP;
                    int[] move = gs.getFVMoveforPVDistance(shift);
                    int i = contourStarts[c];
                    while (i < contourStarts[c] + contourLengths[c]) {
                        if (gs.zp2 != gs.zp0 || i != gs.rp1) {
                            int[] nArray = this.x[gs.zp2];
                            int n = i;
                            nArray[n] = nArray[n] + move[0];
                            int[] nArray9 = this.y[gs.zp2];
                            int n9 = i;
                            nArray9[n9] = nArray9[n9] + move[1];
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 54: {
                    int z = this.stack.pop();
                    int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                    int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]);
                    int shift = newRP - oldRP;
                    int[] move = gs.getFVMoveforPVDistance(shift);
                    int i = 0;
                    while (i < this.x[z].length) {
                        if (z != gs.zp1 || i != gs.rp2) {
                            int[] nArray = this.x[z];
                            int n = i;
                            nArray[n] = nArray[n] + move[0];
                            int[] nArray10 = this.y[z];
                            int n10 = i;
                            nArray10[n10] = nArray10[n10] + move[1];
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 55: {
                    int z = this.stack.pop();
                    int newRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                    int oldRP = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                    int shift = newRP - oldRP;
                    int[] move = gs.getFVMoveforPVDistance(shift);
                    int i = 0;
                    while (i < this.x[z].length) {
                        if (z != gs.zp0 || i != gs.rp1) {
                            int[] nArray = this.x[z];
                            int n = i;
                            nArray[n] = nArray[n] + move[0];
                            int[] nArray11 = this.y[z];
                            int n11 = i;
                            nArray11[n11] = nArray11[n11] + move[1];
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 56: {
                    int magnitude = this.stack.pop();
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    for (int i = 0; i < gs.loop; ++i) {
                        int point = this.stack.pop();
                        int[] nArray = this.x[gs.zp2];
                        int n = point;
                        nArray[n] = (int)((double)nArray[n] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[0]) / 64.0);
                        int[] nArray12 = this.y[gs.zp2];
                        int n12 = point;
                        nArray12[n12] = (int)((double)nArray12[n12] + (double)magnitude * TTVM.getDoubleFromF2Dot14(fv[1]) / 64.0);
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][point][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][point][1] = true;
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 57: {
                    int p;
                    for (int i = 0; i < gs.loop && (p = this.stack.pop()) >= 0 && p <= this.x[gs.zp2].length && gs.rp1 <= this.x[gs.zp0].length && gs.rp2 <= this.x[gs.zp1].length; ++i) {
                        int originalRP2;
                        int originalRP1 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp1], this.y[2 + gs.zp0][gs.rp1]);
                        if (originalRP1 == (originalRP2 = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][gs.rp2], this.y[2 + gs.zp1][gs.rp2]))) continue;
                        int originalP = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp2][p], this.y[2 + gs.zp2][p]);
                        double pos = (double)(originalP - originalRP1) / (double)(originalRP2 - originalRP1);
                        int newRP1 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp1], this.y[gs.zp0][gs.rp1]);
                        int newRP2 = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][gs.rp2], this.y[gs.zp1][gs.rp2]);
                        int pMove = (int)(pos * (double)(newRP2 - newRP1) + (double)newRP1 + 0.5) - originalP;
                        int[] shift = gs.getFVMoveforPVDistance(pMove);
                        int[] nArray = this.x[gs.zp2];
                        int n = p;
                        nArray[n] = nArray[n] + shift[0];
                        int[] nArray13 = this.y[gs.zp2];
                        int n13 = p;
                        nArray13[n13] = nArray13[n13] + shift[1];
                        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp2][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp2][p][1] = true;
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 58: {
                    int d = this.stack.pop();
                    int p = this.stack.pop();
                    int[] shift = gs.getFVMoveforPVDistance(d - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0])));
                    int[] nArray = this.x[gs.zp1];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray14 = this.y[gs.zp1];
                    int n14 = p;
                    nArray14[n14] = nArray14[n14] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.rp1 = gs.rp0;
                    gs.rp2 = p;
                    return currentPointer;
                }
                case 59: {
                    int d = this.stack.pop();
                    int p = this.stack.pop();
                    int[] shift = gs.getFVMoveforPVDistance(d - (TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0])));
                    int[] nArray = this.x[gs.zp1];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray15 = this.y[gs.zp1];
                    int n15 = p;
                    nArray15[n15] = nArray15[n15] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp1][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.rp1 = gs.rp0;
                    gs.rp2 = p;
                    gs.rp0 = p;
                    return currentPointer;
                }
                case 60: {
                    for (int i = 0; i < gs.loop; ++i) {
                        int p = this.stack.pop();
                        int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]);
                        int pMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        int[] shift = gs.getFVMoveforPVDistance(pMove);
                        int[] nArray = this.x[gs.zp1];
                        int n = p;
                        nArray[n] = nArray[n] + shift[0];
                        int[] nArray16 = this.y[gs.zp1];
                        int n16 = p;
                        nArray16[n16] = nArray16[n16] + shift[1];
                        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] == 0) continue;
                        this.touched[gs.zp1][p][1] = true;
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 61: {
                    gs.roundState = 8;
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 62: {
                    int cvtEntry = this.stack.pop();
                    int p = this.stack.pop();
                    int target = this.cvt.get(cvtEntry);
                    int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    int pMove = target - current;
                    int[] shift = gs.getFVMoveforPVDistance(pMove);
                    int[] nArray = this.x[gs.zp0];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray17 = this.y[gs.zp0];
                    int n17 = p;
                    nArray17[n17] = nArray17[n17] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp0][p][1] = true;
                    }
                    gs.rp0 = gs.rp1 = p;
                    return currentPointer;
                }
                case 63: {
                    int cvtEntry = this.stack.pop();
                    int p = this.stack.pop();
                    int target = this.cvt.get(cvtEntry);
                    int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p], this.y[gs.zp0][p]);
                    int pMove = target - current;
                    if (Math.abs(pMove) > gs.controlValueTableCutIn) {
                        target = current;
                    }
                    target = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(target)));
                    pMove = target - current;
                    int[] shift = gs.getFVMoveforPVDistance(pMove);
                    int[] nArray = this.x[gs.zp0];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray18 = this.y[gs.zp0];
                    int n18 = p;
                    nArray18[n18] = nArray18[n18] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp0][p][0] = true;
                    }
                    if (fv[1] != 0) {
                        this.touched[gs.zp0][p][1] = true;
                    }
                    gs.rp0 = gs.rp1 = p;
                    return currentPointer;
                }
                case 64: {
                    ++currentPointer;
                    return this.readFromIS(program[currentPointer], false, currentPointer, program);
                }
                case 65: {
                    ++currentPointer;
                    return this.readFromIS(program[currentPointer], true, currentPointer, program);
                }
                case 66: {
                    int value = this.stack.pop();
                    int key = this.stack.pop();
                    this.storage[key] = value;
                    return currentPointer;
                }
                case 67: {
                    int key = this.stack.pop();
                    this.stack.push(this.storage[key]);
                    return currentPointer;
                }
                case 68: {
                    int value = this.stack.pop();
                    int key = this.stack.pop();
                    this.cvt.putInPixels(key, value);
                    return currentPointer;
                }
                case 69: {
                    int key = this.stack.pop();
                    this.stack.push(this.cvt.get(key));
                    return currentPointer;
                }
                case 70: {
                    int p = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp2][p], this.y[gs.zp2][p]));
                    return currentPointer;
                }
                case 71: {
                    int p = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp2][p], this.y[2 + gs.zp2][p]));
                    return currentPointer;
                }
                case 72: {
                    int value = this.stack.pop();
                    int p = this.stack.pop();
                    int current = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp2][p], this.y[gs.zp2][p]);
                    int pMove = value - current;
                    int[] shift = gs.getFVMoveforPVDistance(pMove);
                    int[] nArray = this.x[gs.zp2];
                    int n = p;
                    nArray[n] = nArray[n] + shift[0];
                    int[] nArray19 = this.y[gs.zp2];
                    int n19 = p;
                    nArray19[n19] = nArray19[n19] + shift[1];
                    int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                    if (fv[0] != 0) {
                        this.touched[gs.zp2][p][0] = true;
                    }
                    if (fv[1] == 0) return currentPointer;
                    this.touched[gs.zp2][p][1] = true;
                    return currentPointer;
                }
                case 73: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    int distance = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p2], this.y[gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][p1], this.y[gs.zp0][p1]);
                    this.stack.push(distance);
                    return currentPointer;
                }
                case 74: {
                    int p1 = this.stack.pop();
                    int p2 = this.stack.pop();
                    int distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p2], this.y[2 + gs.zp1][p2]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][p1], this.y[2 + gs.zp0][p1]);
                    this.stack.push(distance);
                    return currentPointer;
                }
                case 75: {
                    int pvppem = TTGraphicsState.getCoordsOnVector(gs.projectionVector, (int)(this.ppem * 64.0), (int)(this.ppem * 64.0)) / 64;
                    if (pvppem < 0) {
                        pvppem = -pvppem;
                    }
                    this.stack.push(pvppem);
                    return currentPointer;
                }
                case 76: {
                    this.stack.push((int)(this.ptSize * 64.0));
                    return currentPointer;
                }
                case 77: {
                    gs.autoFlip = true;
                    return currentPointer;
                }
                case 78: {
                    gs.autoFlip = false;
                    return currentPointer;
                }
                case 79: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 80: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left < right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 81: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left <= right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 82: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left > right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 83: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left >= right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 84: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left == right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 85: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (left != right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 86: {
                    int value = this.stack.pop();
                    value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
                    value = (value >> 6) % 2;
                    this.stack.push(value);
                    return currentPointer;
                }
                case 87: {
                    int value = this.stack.pop();
                    value = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(value)));
                    value = ((value >> 6) + 1) % 2;
                    this.stack.push(value);
                    return currentPointer;
                }
                case 88: {
                    boolean value = this.stack.pop() != 0;
                    if (value) return currentPointer;
                    int curr = 0;
                    int nest = 0;
                    do {
                        if (curr == 89 && nest != 0) {
                            --nest;
                        }
                        if ((curr = program[++currentPointer]) == 88) {
                            ++nest;
                        }
                        if (curr == 64) {
                            ++currentPointer;
                            currentPointer += program[currentPointer];
                            continue;
                        }
                        if (curr == 65) {
                            ++currentPointer;
                            currentPointer += program[currentPointer] * 2;
                            continue;
                        }
                        if (curr >= 176 && curr <= 183) {
                            currentPointer += curr + 1 - 176;
                            continue;
                        }
                        if (curr < 184 || curr > 191) continue;
                        currentPointer += (curr + 1 - 184) * 2;
                    } while (curr != 27 && curr != 89 || nest != 0);
                    return currentPointer;
                }
                case 89: {
                    return currentPointer;
                }
                case 90: {
                    boolean left;
                    boolean right = this.stack.pop() != 0;
                    boolean bl = left = this.stack.pop() != 0;
                    if (left && right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 91: {
                    boolean left;
                    boolean right = this.stack.pop() != 0;
                    boolean bl = left = this.stack.pop() != 0;
                    if (left || right) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 92: {
                    boolean value;
                    boolean bl = value = this.stack.pop() != 0;
                    if (!value) {
                        this.stack.push(1);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 93: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int p = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int[] shift = gs.getFVMoveforPVDistance(pMove);
                            int[] nArray = this.x[gs.zp0];
                            int n = p;
                            nArray[n] = nArray[n] + shift[0];
                            int[] nArray20 = this.y[gs.zp0];
                            int n20 = p;
                            nArray20[n20] = nArray20[n20] + shift[1];
                            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                            if (fv[0] != 0) {
                                this.touched[gs.zp0][p][0] = true;
                            }
                            if (fv[1] != 0) {
                                this.touched[gs.zp0][p][1] = true;
                            }
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 94: {
                    gs.deltaBase = this.stack.pop();
                    return currentPointer;
                }
                case 95: {
                    gs.deltaShift = this.stack.pop();
                    return currentPointer;
                }
                case 96: {
                    this.stack.push(this.stack.pop() + this.stack.pop());
                    return currentPointer;
                }
                case 97: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    this.stack.push(left - right);
                    return currentPointer;
                }
                case 98: {
                    int right = this.stack.pop();
                    int left = this.stack.pop();
                    if (right != 0) {
                        this.stack.push(left * 64 / right);
                        return currentPointer;
                    }
                    this.stack.push(0);
                    return currentPointer;
                }
                case 99: {
                    int a = this.stack.pop();
                    int b = this.stack.pop();
                    this.stack.push(a * b / 64);
                    return currentPointer;
                }
                case 100: {
                    int value = this.stack.pop();
                    if (value < 0) {
                        value = -value;
                    }
                    this.stack.push(value);
                    return currentPointer;
                }
                case 101: {
                    this.stack.push(-this.stack.pop());
                    return currentPointer;
                }
                case 102: {
                    this.stack.push(this.stack.pop() >> 6 << 6);
                    return currentPointer;
                }
                case 103: {
                    int value = this.stack.pop();
                    if ((value & 0x3F) != 0) {
                        value = (value >> 6) + 1 << 6;
                    }
                    this.stack.push(value);
                    return currentPointer;
                }
                case 104: {
                    int n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 0);
                    double num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)));
                    return currentPointer;
                }
                case 105: {
                    int n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 1);
                    double num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)));
                    return currentPointer;
                }
                case 106: {
                    int n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 2);
                    double num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)));
                    return currentPointer;
                }
                case 107: {
                    int n = this.stack.pop();
                    n = TTVM.engineCompensation(n, 3);
                    double num = TTVM.getDoubleFromF26Dot6(n);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(gs.round(num)));
                    return currentPointer;
                }
                case 108: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 0));
                    return currentPointer;
                }
                case 109: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 1));
                    return currentPointer;
                }
                case 110: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 2));
                    return currentPointer;
                }
                case 111: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 3));
                    return currentPointer;
                }
                case 112: {
                    int value = this.stack.pop();
                    int key = this.stack.pop();
                    this.cvt.putInFUnits(key, value);
                    return currentPointer;
                }
                case 113: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int p = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + 16 + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int[] shift = gs.getFVMoveforPVDistance(pMove);
                            int[] nArray = this.x[gs.zp0];
                            int n = p;
                            nArray[n] = nArray[n] + shift[0];
                            int[] nArray21 = this.y[gs.zp0];
                            int n21 = p;
                            nArray21[n21] = nArray21[n21] + shift[1];
                            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                            if (fv[0] != 0) {
                                this.touched[gs.zp0][p][0] = true;
                            }
                            if (fv[1] != 0) {
                                this.touched[gs.zp0][p][1] = true;
                            }
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 114: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int p = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + 32 + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int pMove = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int[] shift = gs.getFVMoveforPVDistance(pMove);
                            int[] nArray = this.x[gs.zp0];
                            int n = p;
                            nArray[n] = nArray[n] + shift[0];
                            int[] nArray22 = this.y[gs.zp0];
                            int n22 = p;
                            nArray22[n22] = nArray22[n22] + shift[1];
                            int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                            if (fv[0] != 0) {
                                this.touched[gs.zp0][p][0] = true;
                            }
                            if (fv[1] != 0) {
                                this.touched[gs.zp0][p][1] = true;
                            }
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 115: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int cvtEntry = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int value = this.cvt.get(cvtEntry);
                            this.cvt.putInPixels(cvtEntry, value += change);
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 116: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int cvtEntry = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + 16 + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int value = this.cvt.get(cvtEntry);
                            this.cvt.putInPixels(cvtEntry, value += change);
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 117: {
                    int loop = this.stack.pop();
                    int i = 0;
                    while (i < loop) {
                        int cvtEntry = this.stack.pop();
                        int arg = this.stack.pop();
                        int ppem = gs.deltaBase + 32 + (arg >> 4);
                        if ((double)ppem == this.ppem) {
                            int mag = (arg & 0xF) - 7;
                            if (mag <= 0) {
                                --mag;
                            }
                            int change = TTVM.storeDoubleAsF26Dot6((double)mag * (1.0 / Math.pow(2.0, gs.deltaShift)));
                            int value = this.cvt.get(cvtEntry);
                            this.cvt.putInPixels(cvtEntry, value += change);
                        }
                        ++i;
                    }
                    return currentPointer;
                }
                case 118: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 119: {
                    gs.roundState = this.stack.pop();
                    gs.gridPeriod = 0.7071067811865476;
                    return currentPointer;
                }
                case 120: {
                    boolean jump = this.stack.pop() != 0;
                    int amount = this.stack.pop();
                    if (!jump) return currentPointer;
                    return currentPointer + amount - 1;
                }
                case 121: {
                    boolean jump = this.stack.pop() != 0;
                    int amount = this.stack.pop();
                    if (jump) return currentPointer;
                    return currentPointer + amount - 1;
                }
                case 122: {
                    gs.roundState = -1;
                    return currentPointer;
                }
                case 124: {
                    gs.roundState = 64;
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 125: {
                    gs.roundState = 68;
                    gs.gridPeriod = 1.0;
                    return currentPointer;
                }
                case 126: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 127: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 128: {
                    for (int i = 0; i < gs.loop; ++i) {
                        int point = this.stack.pop();
                        this.curve[gs.zp0][point] = !this.curve[gs.zp0][point];
                    }
                    gs.loop = 1;
                    return currentPointer;
                }
                case 129: {
                    int low;
                    int high = this.stack.pop();
                    int i = low = this.stack.pop();
                    while (i <= high) {
                        this.curve[gs.zp0][i] = true;
                        ++i;
                    }
                    return currentPointer;
                }
                case 130: {
                    int low;
                    int high = this.stack.pop();
                    int i = low = this.stack.pop();
                    while (i <= high) {
                        this.curve[gs.zp0][i] = false;
                        ++i;
                    }
                    return currentPointer;
                }
                case 133: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 134: {
                    int p2 = this.stack.pop();
                    int p1 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    double dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
                    double dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    double dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
                    gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(xdiff /= factor), TTVM.storeDoubleAsF2Dot14(ydiff /= factor));
                    gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dxdiff /= dfactor), TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor));
                    return currentPointer;
                }
                case 135: {
                    int p2 = this.stack.pop();
                    int p1 = this.stack.pop();
                    double xdiff = TTVM.getDoubleFromF26Dot6(this.x[gs.zp2][p2] - this.x[gs.zp1][p1]);
                    double ydiff = TTVM.getDoubleFromF26Dot6(this.y[gs.zp2][p2] - this.y[gs.zp1][p1]);
                    double dxdiff = TTVM.getDoubleFromF26Dot6(this.x[2 + gs.zp2][p2] - this.x[2 + gs.zp1][p1]);
                    double dydiff = TTVM.getDoubleFromF26Dot6(this.y[2 + gs.zp2][p2] - this.y[2 + gs.zp1][p1]);
                    double factor = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
                    double dfactor = Math.sqrt(dxdiff * dxdiff + dydiff * dydiff);
                    gs.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(ydiff /= factor), TTVM.storeDoubleAsF2Dot14(-(xdiff /= factor)));
                    gs.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(dydiff /= dfactor), TTVM.storeDoubleAsF2Dot14(-(dxdiff /= dfactor)));
                    return currentPointer;
                }
                case 136: {
                    int selector = this.stack.pop();
                    int result = 0;
                    if ((selector & 1) == 1) {
                        result += 3;
                    }
                    this.stack.push(result);
                    return currentPointer;
                }
                case 137: {
                    int curr;
                    int func = this.stack.pop();
                    int start = currentPointer;
                    while ((curr = program[++currentPointer]) != 45) {
                    }
                    int len = currentPointer - start - 1;
                    currentPointer = start;
                    int[] instruction = new int[len];
                    for (int i = 0; i < len; ++i) {
                        instruction[i] = program[++currentPointer];
                    }
                    this.instructions.put(func, instruction);
                    ++currentPointer;
                    return currentPointer;
                }
                case 138: {
                    int top = this.stack.pop();
                    int middle = this.stack.pop();
                    int bottom = this.stack.pop();
                    this.stack.push(middle);
                    this.stack.push(top);
                    this.stack.push(bottom);
                    return currentPointer;
                }
                case 139: {
                    int value1 = this.stack.pop();
                    int value2 = this.stack.pop();
                    if (value1 > value2) {
                        this.stack.push(value1);
                        return currentPointer;
                    }
                    this.stack.push(value2);
                    return currentPointer;
                }
                case 140: {
                    int value1 = this.stack.pop();
                    int value2 = this.stack.pop();
                    if (value1 < value2) {
                        this.stack.push(value1);
                        return currentPointer;
                    }
                    this.stack.push(value2);
                    return currentPointer;
                }
                case 141: {
                    this.stack.pop();
                    return currentPointer;
                }
                case 142: {
                    int s = this.stack.pop();
                    int value = this.stack.pop();
                    if (s == 1) {
                        gs.instructControl = value;
                        return currentPointer;
                    }
                    if (s != 2) return currentPointer;
                    this.useDefaultGS = value == 2;
                    return currentPointer;
                }
                case 176: {
                    if (!this.printOut) return this.readFromIS(bytesToRead, false, currentPointer, program);
                    System.out.println("PUSHB1    - Push bytes from IS to stack");
                    return this.readFromIS(bytesToRead, false, currentPointer, program);
                }
                case 184: {
                    if (!this.printOut) return this.readFromIS(bytesToRead, true, currentPointer, program);
                    System.out.println("PUSHW1    - Push words from IS to stack");
                    return this.readFromIS(bytesToRead, true, currentPointer, program);
                }
                default: {
                    if (code >= 192 && code < 224) {
                        int args = code - 192;
                        if (this.printOut) {
                            System.out.println("MDRP      - Move direct relative point (" + Integer.toBinaryString(args) + ')');
                        }
                        boolean setRP0toP = false;
                        boolean useMinimumDistance = false;
                        boolean roundDistance = false;
                        if ((args & 0x10) == 16) {
                            setRP0toP = true;
                        }
                        if ((args & 8) == 8) {
                            useMinimumDistance = true;
                        }
                        if ((args & 4) == 4) {
                            roundDistance = true;
                        }
                        int distanceType = args & 3;
                        int p = this.stack.pop();
                        int originalDistance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p], this.y[2 + gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
                        if (Math.abs(originalDistance) < gs.singleWidthCutIn) {
                            originalDistance = originalDistance > 0 ? gs.singleWidthValue : -gs.singleWidthValue;
                        }
                        originalDistance = TTVM.engineCompensation(originalDistance, distanceType);
                        if (roundDistance) {
                            originalDistance = TTVM.storeDoubleAsF26Dot6(gs.round(TTVM.getDoubleFromF26Dot6(originalDistance)));
                        }
                        if (useMinimumDistance && Math.abs(originalDistance) < gs.minimumDistance) {
                            originalDistance = originalDistance < 0 ? -gs.minimumDistance : gs.minimumDistance;
                        }
                        int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + originalDistance;
                        int pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        int[] shift = gs.getFVMoveforPVDistance(pVMove);
                        int[] nArray = this.x[gs.zp1];
                        int n = p;
                        nArray[n] = nArray[n] + shift[0];
                        int[] nArray23 = this.y[gs.zp1];
                        int n23 = p;
                        nArray23[n23] = nArray23[n23] + shift[1];
                        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] != 0) {
                            this.touched[gs.zp1][p][1] = true;
                        }
                        gs.rp1 = gs.rp0;
                        gs.rp2 = p;
                        if (!setRP0toP) return currentPointer;
                        gs.rp0 = p;
                        return currentPointer;
                    }
                    if (code >= 224 && code <= 255) {
                        int args = code - 224;
                        if (this.printOut) {
                            System.out.println("MIRP      - Move Indirect Relative Point(" + Integer.toBinaryString(args) + ')');
                        }
                        boolean setRP0toP = false;
                        boolean useMinimumDistance = false;
                        boolean roundDistanceAndCheckCutIn = false;
                        if ((args & 0x10) == 16) {
                            setRP0toP = true;
                        }
                        if ((args & 8) == 8) {
                            useMinimumDistance = true;
                        }
                        if ((args & 4) == 4) {
                            roundDistanceAndCheckCutIn = true;
                        }
                        int distanceType = args & 3;
                        int cvtEntry = this.cvt.get(this.stack.pop());
                        int p = this.stack.pop();
                        int distance = TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp1][p], this.y[2 + gs.zp1][p]) - TTGraphicsState.getCoordsOnVector(gs.dualProjectionVector, this.x[2 + gs.zp0][gs.rp0], this.y[2 + gs.zp0][gs.rp0]);
                        if (Math.abs(distance - gs.singleWidthValue) < gs.singleWidthCutIn) {
                            distance = gs.singleWidthValue;
                        }
                        if (roundDistanceAndCheckCutIn) {
                            if (gs.autoFlip && (distance < 0 && cvtEntry > 0 || distance > 0 && cvtEntry < 0)) {
                                cvtEntry = -cvtEntry;
                            }
                            if (Math.abs(distance - cvtEntry) < gs.controlValueTableCutIn) {
                                distance = cvtEntry;
                            }
                        }
                        distance = TTVM.engineCompensation(distance, distanceType);
                        if (roundDistanceAndCheckCutIn) {
                            distance = gs.round(distance);
                        }
                        if (useMinimumDistance && Math.abs(distance) < gs.minimumDistance) {
                            distance = distance > 0 ? gs.minimumDistance : -gs.minimumDistance;
                        }
                        int target = TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp0][gs.rp0], this.y[gs.zp0][gs.rp0]) + distance;
                        int pVMove = target - TTGraphicsState.getCoordsOnVector(gs.projectionVector, this.x[gs.zp1][p], this.y[gs.zp1][p]);
                        int[] shift = gs.getFVMoveforPVDistance(pVMove);
                        int[] nArray = this.x[gs.zp1];
                        int n = p;
                        nArray[n] = nArray[n] + shift[0];
                        int[] nArray24 = this.y[gs.zp1];
                        int n24 = p;
                        nArray24[n24] = nArray24[n24] + shift[1];
                        int[] fv = TTGraphicsState.getVectorComponents(gs.freedomVector);
                        if (fv[0] != 0) {
                            this.touched[gs.zp1][p][0] = true;
                        }
                        if (fv[1] != 0) {
                            this.touched[gs.zp1][p][1] = true;
                        }
                        gs.rp1 = gs.rp0;
                        gs.rp2 = p;
                        if (!setRP0toP) return currentPointer;
                        gs.rp0 = p;
                        return currentPointer;
                    }
                    if (!this.instructions.containsKey(code)) return currentPointer;
                    if (this.printOut) {
                        System.out.println("I 0x" + Integer.toHexString(code) + "    - Custom Instruction");
                    }
                    this.execute(this.instructions.get(code), gs);
                    if (!this.printOut) return currentPointer;
                    System.out.println("I 0x" + Integer.toHexString(code) + " finished");
                }
            }
            return currentPointer;
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
            BaseTTGlyph.useHinting = false;
            BaseTTGlyph.redecodePage = true;
        }
        return currentPointer;
    }

    private void interpolateUntouchedPoints(int direction) {
        int point;
        int i;
        int[] original;
        int[] points;
        boolean[] touched = new boolean[this.touched[1].length];
        if (direction == 49) {
            points = this.x[1];
            original = this.x[3];
            for (i = 0; i < this.touched[1].length; ++i) {
                touched[i] = this.touched[1][i][0];
            }
        } else {
            points = this.y[1];
            original = this.y[3];
            for (i = 0; i < this.touched[1].length; ++i) {
                touched[i] = this.touched[1][i][1];
            }
        }
        for (int contourStart = 0; contourStart < points.length; contourStart += point) {
            int[] touchedPointNumbers = new int[original.length];
            int touchedCount = 0;
            point = 0;
            do {
                if (!touched[contourStart + point]) continue;
                touchedPointNumbers[touchedCount] = contourStart + point;
                ++touchedCount;
            } while (!this.contour[1][contourStart + ++point - 1] && contourStart + point < this.contour[1].length);
            if (touchedCount == 1) {
                int shift = points[touchedPointNumbers[0]] - original[touchedPointNumbers[0]];
                for (int i2 = contourStart; i2 < contourStart + point; ++i2) {
                    if (touched[i2]) continue;
                    int n = i2;
                    points[n] = points[n] + shift;
                }
                continue;
            }
            if (touchedCount <= 1) continue;
            for (int i3 = 0; i3 < touchedCount; ++i3) {
                if (i3 + 1 >= touchedCount) {
                    TTVM.interpolateRange(touchedPointNumbers[i3] + 1, contourStart + point - 1, touchedPointNumbers[i3], touchedPointNumbers[0], points, original);
                    TTVM.interpolateRange(contourStart, touchedPointNumbers[0] - 1, touchedPointNumbers[i3], touchedPointNumbers[0], points, original);
                    continue;
                }
                TTVM.interpolateRange(touchedPointNumbers[i3] + 1, touchedPointNumbers[i3 + 1] - 1, touchedPointNumbers[i3], touchedPointNumbers[i3 + 1], points, original);
            }
        }
    }

    private static void interpolateRange(int start, int end, int ref1, int ref2, int[] points, int[] original) {
        int higherRef;
        int lowerRef;
        if (original[ref2] < original[ref1]) {
            lowerRef = ref2;
            higherRef = ref1;
        } else {
            lowerRef = ref1;
            higherRef = ref2;
        }
        for (int i = start; i <= end; ++i) {
            if (original[i] < original[lowerRef]) {
                int n = i;
                points[n] = points[n] + (points[lowerRef] - original[lowerRef]);
                continue;
            }
            if (original[i] > original[higherRef]) {
                int n = i;
                points[n] = points[n] + (points[higherRef] - original[higherRef]);
                continue;
            }
            double pos = (double)(original[i] - original[lowerRef]) / (double)(original[higherRef] - original[lowerRef]);
            points[i] = points[lowerRef] + (int)(pos * (double)(points[higherRef] - points[lowerRef]));
        }
    }

    private static int engineCompensation(int num, int characteristics) {
        return num;
    }

    private int readFromIS(int number, boolean readWord, int currentPointer, int[] program) {
        for (int i = 0; i < number; ++i) {
            int data;
            ++currentPointer;
            if (!readWord) {
                data = program[currentPointer];
            } else {
                int d1 = program[currentPointer];
                int d2 = program[++currentPointer];
                data = TTVM.getIntFrom2Uint8(d1, d2);
            }
            this.stack.push(data);
        }
        return currentPointer;
    }

    protected static int getIntFrom2Uint8(int high, int low) {
        return (high << 8) + low + (high >> 7 & 1) * -65536;
    }

    protected static double getDoubleFromF26Dot6(int a) {
        return (double)a / 64.0;
    }

    protected static double getDoubleFromF2Dot14(int a) {
        return (double)a / 16384.0;
    }

    protected static int storeDoubleAsF26Dot6(double a) {
        return (int)(a * 64.0 + 0.5);
    }

    protected static int storeDoubleAsF2Dot14(double a) {
        return (int)(a * 16384.0 + 0.5);
    }

    private static int[] readProgramTable(FontFile2 currentFontFile, int table) {
        int[] program = new int[]{};
        int startPointer = currentFontFile.selectTable(table);
        if (startPointer == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No program table found: " + table);
            }
        } else {
            int len = currentFontFile.getOffset(table);
            program = new int[len];
            for (int i = 0; i < len; ++i) {
                program[i] = currentFontFile.getNextUint8();
            }
        }
        return program;
    }

    private static class Stack
    implements Serializable {
        private int pointer;
        private int[] stack = new int[10];

        Stack() {
        }

        public void push(int a) {
            if (this.pointer >= this.stack.length) {
                int[] newStack = new int[(int)((double)this.stack.length * 1.5)];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
            this.stack[this.pointer] = a;
            ++this.pointer;
        }

        public int pop() {
            --this.pointer;
            if (this.pointer >= 0) {
                return this.stack[this.pointer];
            }
            throw new RuntimeException("Popped an empty stack!");
        }

        public int size() {
            return this.pointer;
        }

        public int elementAt(int key) {
            return this.stack[this.pointer - key];
        }

        public int remove(int key) {
            int valPos = this.pointer - key;
            int result = this.stack[valPos];
            int[] newStack = new int[this.stack.length];
            System.arraycopy(this.stack, 0, newStack, 0, valPos);
            System.arraycopy(this.stack, valPos + 1, newStack, valPos, this.stack.length - valPos - 1);
            this.stack = newStack;
            --this.pointer;
            return result;
        }
    }
}

