/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.HashMap;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class NameLookup
extends HashMap {
    private final PdfFileReader objectReader;

    public NameLookup(PdfFileReader objectReader) {
        this.objectReader = objectReader;
    }

    public void readNames(PdfObject nameObject, Javascript javascript, boolean isKid) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(nameObject);
        int[] nameLists = new int[]{893600855, -2006286978, 1195921064};
        int count = nameLists.length;
        if (isKid) {
            count = 1;
        }
        for (int ii = 0; ii < count; ++ii) {
            PdfArrayIterator namesArray;
            int kidCount;
            PdfObject pdfObj = isKid ? nameObject : nameObject.getDictionary(nameLists[ii]);
            if (pdfObj == null) continue;
            byte[][] kidList = pdfObj.getKeyArray(456733763);
            if (kidList != null && (kidCount = kidList.length) > 0) {
                for (byte[] aKidList : kidList) {
                    String nextValue = new String(aKidList);
                    NamesObject nextObject = new NamesObject(nextValue);
                    nextObject.ignoreRecursion(false);
                    this.objectReader.readObject(nextObject);
                    this.readNames(nextObject, javascript, true);
                }
            }
            if ((namesArray = pdfObj.getMixedArray(826094945)) == null || namesArray.getTokenCount() <= 0) continue;
            block6: while (namesArray.hasMoreTokens()) {
                String name = namesArray.getNextValueAsString(true);
                if (!namesArray.hasMoreTokens()) continue;
                String value = namesArray.getNextValueAsString(true);
                switch (nameLists[ii]) {
                    case -2006286978: {
                        NameLookup.setJavaScriptName(value, objectDecoder, javascript, name);
                        continue block6;
                    }
                    case 1195921064: {
                        this.setXFAImage(value, objectDecoder, name);
                        continue block6;
                    }
                }
                this.put(name, value);
            }
        }
    }

    private void setXFAImage(String value, ObjectDecoder objectDecoder, String name) {
        XObject XFAImagesObj = new XObject(value);
        XFAImagesObj.decompressStreamWhenRead();
        byte[] xfaData = StringUtils.toBytes(value);
        if (xfaData[0] == 60) {
            XFAImagesObj.setStatus(2);
        } else {
            XFAImagesObj.setStatus(1);
        }
        if (value.contains(" ") || value.contains("<")) {
            XFAImagesObj.setUnresolvedData(xfaData, 979194486);
            objectDecoder.checkResolved(XFAImagesObj);
            byte[] decodedImageData = this.objectReader.readStream(XFAImagesObj, true, true, false, false, false, null);
            this.put(name, decodedImageData);
        }
    }

    static void setJavaScriptName(String value, ObjectDecoder objectDecoder, Javascript javascript, String name) {
        String JSstring;
        NamesObject javascriptObj = new NamesObject(value);
        byte[] jsData = StringUtils.toBytes(value);
        if (jsData[0] == 60) {
            javascriptObj.setStatus(2);
        } else {
            javascriptObj.setStatus(1);
        }
        if (value.contains(" ") || value.contains("<")) {
            javascriptObj.setUnresolvedData(jsData, 6691);
            objectDecoder.checkResolved(javascriptObj);
            PdfObject JS = ((PdfObject)javascriptObj).getDictionary(6691);
            JSstring = JS != null ? new String(JS.getDecodedStream()) : ((PdfObject)javascriptObj).getTextStreamValue(6691);
        } else {
            JSstring = value;
        }
        if (JSstring != null) {
            javascript.setCode(name, JSstring);
        }
    }
}

