/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.utils.LogWriter;

public class RandomAccessMemoryMapBuffer
implements RandomAccessBuffer {
    private long pointer;
    private int length;
    private File file;
    private RandomAccessFile buf;

    public RandomAccessMemoryMapBuffer(InputStream in) {
        block11: {
            block10: {
                BufferedInputStream from;
                FileOutputStream to;
                block9: {
                    this.pointer = -1L;
                    this.length = 0;
                    to = null;
                    from = null;
                    try {
                        int bytes_read;
                        this.file = File.createTempFile("page", ".bin", new File(ObjectStore.temp_dir));
                        to = new FileOutputStream(this.file);
                        from = new BufferedInputStream(in);
                        byte[] buffer = new byte[65535];
                        while ((bytes_read = from.read(buffer)) != -1) {
                            to.write(buffer, 0, bytes_read);
                            this.length += bytes_read;
                        }
                    }
                    catch (Exception e) {
                        if (!LogWriter.isOutput()) break block9;
                        LogWriter.writeLog("Exception: " + e.getMessage());
                    }
                }
                try {
                    if (to != null) {
                        to.close();
                    }
                    if (from != null) {
                        from.close();
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception " + e + " closing files");
                }
            }
            try {
                this.init();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block11;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    private void init() throws Exception {
        this.buf = new RandomAccessFile(this.file, "r");
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (!this.checkPos(pos)) {
            throw new IOException("Position out of bounds");
        }
        this.pointer = pos;
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.buf.close();
            this.buf = null;
        }
        this.pointer = -1L;
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    protected void finalize() {
        block5: {
            block4: {
                try {
                    super.finalize();
                }
                catch (Throwable e) {
                    if (!LogWriter.isOutput()) break block4;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            try {
                this.close();
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
    }

    @Override
    public long length() throws IOException {
        if (this.buf != null) {
            return this.length;
        }
        throw new IOException("Data buffer not initialized.");
    }

    @Override
    public int read() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.buf.seek(this.pointer++);
            return RandomAccessMemoryMapBuffer.b2i(this.buf.readByte());
        }
        return -1;
    }

    private int peek() throws IOException {
        if (this.checkPos(this.pointer)) {
            this.buf.seek(this.pointer++);
            return RandomAccessMemoryMapBuffer.b2i(this.buf.readByte());
        }
        return -1;
    }

    @Override
    public String readLine() throws IOException {
        int c;
        if (this.pointer >= (long)(this.length - 1)) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while ((c = this.read()) >= 0) {
            if (c == 10 || c == 13) {
                if (this.peek() != 10 && this.peek() != 13 || this.peek() == c) break;
                this.read();
                break;
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.buf == null) {
            throw new IOException("Data buffer not initialized.");
        }
        if (this.pointer < 0L || this.pointer >= (long)this.length) {
            return -1;
        }
        int length = this.length - (int)this.pointer;
        if (length > b.length) {
            length = b.length;
        }
        for (int i = 0; i < length; ++i) {
            this.buf.seek(this.pointer++);
            b[i] = this.buf.readByte();
        }
        return length;
    }

    private static int b2i(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private boolean checkPos(long pos) throws IOException {
        return pos >= 0L && pos < this.length();
    }

    @Override
    public byte[] getPdfBuffer() {
        byte[] bytes;
        block2: {
            bytes = new byte[this.length];
            try {
                this.buf.seek(0L);
                this.buf.read(bytes);
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return bytes;
    }
}

