/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class ASCIIHex
extends BaseFilter
implements PdfFilter {
    public ASCIIHex(PdfObject decodeParms) {
        super(decodeParms);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(byte[] data) throws IOException {
        char current;
        StringBuilder valuesRead;
        StringBuilder value;
        block11: {
            ByteArrayInputStream bis;
            BufferedReader mappingStream;
            block10: {
                value = new StringBuilder();
                valuesRead = new StringBuilder();
                mappingStream = null;
                bis = null;
                try {
                    bis = new ByteArrayInputStream(data);
                    mappingStream = new BufferedReader(new InputStreamReader(bis));
                    if (mappingStream != null) {
                        String line;
                        while ((line = mappingStream.readLine()) != null) {
                            void var2_6;
                            valuesRead.append((String)var2_6);
                        }
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception " + e + " reading ASCII stream ");
                }
            }
            if (mappingStream != null) {
                try {
                    mappingStream.close();
                    bis.close();
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        int data_size = valuesRead.length();
        int i = 0;
        int count = 0;
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(data.length);
        do {
            if (!((current = valuesRead.charAt(i)) >= '0' && current <= '9' || current >= 'a' && current <= 'f') && (current < 'A' || current > 'F')) continue;
            value.append(current);
            if (count == 1) {
                bos.write(Integer.valueOf(value.toString(), 16));
                count = 0;
                value = new StringBuilder();
                continue;
            }
            ++count;
        } while (current != '>' && ++i != data_size);
        if (count == 1) {
            value.append('0');
            bos.write(Integer.valueOf(value.toString(), 16));
        }
        return bos.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        block8: {
            this.bis = bis;
            this.streamCache = streamCache;
            this.cachedObjects = cachedObjects;
            try {
                StringBuffer value = new StringBuffer();
                int count = bis.available();
                for (int i = 0; i < count; ++i) {
                    char current = (char)bis.read();
                    while (current == '\n') {
                        current = (char)bis.read();
                    }
                    if (current >= '0' && current <= '9' || current >= 'a' && current <= 'f' || current >= 'A' && current <= 'F') {
                        value.append(current);
                        if (count == 1) {
                            streamCache.write(Integer.valueOf(value.toString(), 16));
                            count = 0;
                            value = new StringBuffer();
                        } else {
                            ++count;
                        }
                    }
                    if (current == '>') break;
                }
                if (count == 1) {
                    value.append('0');
                    streamCache.write(Integer.valueOf(value.toString(), 16));
                }
            }
            catch (IOException e1) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("IO exception in RunLength " + e1);
            }
        }
    }
}

