/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFLZWDecoder;

public class LZW
extends BaseFilter
implements PdfFilter {
    private int predictor = 1;
    private int EarlyChange = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int rows;
    private int columns;

    public LZW(PdfObject decodeParms, int width, int height) {
        super(decodeParms);
        this.rows = height;
        this.columns = width;
        if (decodeParms != null) {
            int columnsSet;
            int newColors;
            int newBitsPerComponent = decodeParms.getInt(-1344207655);
            if (newBitsPerComponent != -1) {
                this.bitsPerComponent = newBitsPerComponent;
            }
            if ((newColors = decodeParms.getInt(1010783618)) != -1) {
                this.colors = newColors;
            }
            if ((columnsSet = decodeParms.getInt(1162902911)) != -1) {
                this.columns = columnsSet;
            }
            this.EarlyChange = decodeParms.getInt(1838971823);
            this.predictor = decodeParms.getInt(1970893723);
            int rowsSet = decodeParms.getInt(574572355);
            if (rowsSet != -1) {
                this.rows = rowsSet;
            }
        }
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        if (this.rows * this.columns == 1) {
            if (data != null) {
                int bitsPerComponent1 = 8;
                byte[] processed_data = new byte[8 * this.rows * (this.columns + 7 >> 3)];
                TIFFLZWDecoder lzw_decode = new TIFFLZWDecoder();
                lzw_decode.decode(data, processed_data);
                return this.applyPredictor(this.predictor, processed_data, this.colors, 8, this.columns);
            }
        } else {
            if (data != null) {
                ByteArrayOutputStream processed = new ByteArrayOutputStream();
                LZWDecoder lzw = new LZWDecoder();
                lzw.decode(data, processed, this.EarlyChange == 1);
                processed.close();
                data = processed.toByteArray();
            }
            data = this.applyPredictor(this.predictor, data, this.colors, this.bitsPerComponent, this.columns);
        }
        return data;
    }

    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map cachedObjects) throws Exception {
        if (this.rows * this.columns != 1) {
            if (bis != null) {
                LZWDecoder2 lzw2 = new LZWDecoder2();
                lzw2.decode(null, streamCache, bis);
            }
            if (this.predictor != 1 && this.predictor != 10) {
                streamCache.flush();
                streamCache.close();
                if (cacheName != null) {
                    this.setupCachedObjectForDecoding(cacheName);
                }
            }
            this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
        }
    }
}

