/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class RunLength
extends BaseFilter
implements PdfFilter {
    public RunLength(PdfObject decodeParms) {
        super(decodeParms);
    }

    @Override
    public byte[] decode(byte[] data) throws Exception {
        int count = data.length;
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream(count);
        for (int i = 0; i < count; ++i) {
            int j;
            byte value;
            int len = data[i];
            if (len < 0) {
                len = 256 + len;
            }
            if (len == 128) {
                i = count;
                continue;
            }
            if (len > 128) {
                len = 257 - len;
                value = data[++i];
                for (j = 0; j < len; ++j) {
                    bos.write((int)value);
                }
                continue;
            }
            ++i;
            ++len;
            for (j = 0; j < len; ++j) {
                value = data[i + j];
                bos.write((int)value);
            }
            i = i + len - 1;
        }
        return bos.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        block11: {
            this.bis = bis;
            this.streamCache = streamCache;
            this.cachedObjects = cachedObjects;
            try {
                int count = bis.available();
                for (int i = 0; i < count; ++i) {
                    int j;
                    int value2;
                    int len;
                    int nextLen = bis.read();
                    if (nextLen >= 128) {
                        nextLen -= 256;
                    }
                    if ((len = nextLen) < 0) {
                        len = 256 + len;
                    }
                    if (len == 128) {
                        i = count;
                        continue;
                    }
                    if (len > 128) {
                        ++i;
                        len = 257 - len;
                        value2 = bis.read();
                        if (value2 >= 128) {
                            value2 -= 256;
                        }
                        for (j = 0; j < len; ++j) {
                            streamCache.write(value2);
                        }
                        continue;
                    }
                    ++i;
                    ++len;
                    for (j = 0; j < len; ++j) {
                        value2 = bis.read();
                        if (value2 >= 128) {
                            value2 -= 256;
                        }
                        streamCache.write(value2);
                    }
                    i = i + len - 1;
                }
            }
            catch (IOException e1) {
                if (!LogWriter.isOutput()) break block11;
                LogWriter.writeLog("IO exception in RunLength " + e1);
            }
        }
    }
}

