/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.Offsets;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class CompressedObjects {
    public static void extractCompressedObjectOffset(Map offsetStart, Map offsetEnd, int First2, byte[] compressedStream, int compressedID, Offsets offset) {
        String lastKey = null;
        for (int ii = 0; ii < First2; ++ii) {
            int i;
            if (compressedStream.length == 0) continue;
            while (compressedStream[ii] == 10 || compressedStream[ii] == 13 || compressedStream[ii] == 32) {
                ++ii;
            }
            int startKey = ii;
            if (startKey == First2) continue;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10) {
                ++ii;
            }
            int endKey = ii - 1;
            int length = endKey - startKey + 1;
            char[] newCommand = new char[length];
            for (i = 0; i < length; ++i) {
                newCommand[i] = (char)compressedStream[startKey + i];
            }
            String key = new String(newCommand);
            int id = NumberUtils.parseInt(startKey, startKey + length, compressedStream);
            while (compressedStream[ii] == 32 || compressedStream[ii] == 13 || compressedStream[ii] == 10) {
                ++ii;
            }
            int startOff = ii;
            while (compressedStream[ii] != 32 && compressedStream[ii] != 13 && compressedStream[ii] != 10 && ii < First2) {
                ++ii;
            }
            int endOff = ii - 1;
            length = endOff - startOff + 1;
            newCommand = new char[length];
            for (i = 0; i < length; ++i) {
                newCommand[i] = (char)compressedStream[startOff + i];
            }
            String offsetRef = new String(newCommand);
            if (compressedID != offset.elementAt(id)) continue;
            offsetStart.put(key, offsetRef);
            if (lastKey != null) {
                offsetEnd.put(lastKey, offsetRef);
            }
            lastKey = key;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int readCompressedOffsets(int pntr, int current, int numbEntries, int[] fieldSizes, byte[] xrefs, Offsets offset, RandomAccessBuffer pdf_datafile) throws PdfException {
        debug = false;
        defaultValue = new int[]{1, 0, 0};
        hasCase0 = false;
        block7: for (i = 0; i < numbEntries; ++i) {
            nextValue = new int[3];
            for (ii = 0; ii < 3; ++ii) {
                if (fieldSizes[ii] == 0) {
                    nextValue[ii] = defaultValue[ii];
                    continue;
                }
                nextValue[ii] = CompressedObjects.getWord(xrefs, pntr, fieldSizes[ii]);
                pntr += fieldSizes[ii];
            }
            switch (nextValue[0]) {
                case 0: {
                    ++current;
                    hasCase0 = nextValue[1] == 0 && nextValue[2] == 0;
                    continue block7;
                }
                case 1: {
                    id = nextValue[1];
                    gen = nextValue[2];
                    refIsvalid = true;
                    if (current != id) ** GOTO lbl43
                    refIsvalid = false;
                    try {
                        size = 20;
                        data = new byte[20];
                        pdf_datafile.seek(current);
                        pdf_datafile.read(data);
                        ptr = 0;
                        for (ii = 0; ii < 20; ++ii) {
                            if (data[ii] != 32 && data[ii] != 10 && data[ii] != 13) continue;
                            ptr = ii;
                            ii = 20;
                        }
                        if (ptr > 0 && (ref = NumberUtils.parseInt(0, ptr, data)) == current) {
                            refIsvalid = true;
                        }
                    }
                    catch (Exception ee) {
                        refIsvalid = false;
                        if (!LogWriter.isOutput()) ** GOTO lbl43
                        LogWriter.writeLog("Ref is invalid " + ee);
                    }
lbl43:
                    // 4 sources

                    if (refIsvalid || !hasCase0) {
                        offset.storeObjectOffset(current, id, gen, false, false);
                    }
                    ++current;
                    continue block7;
                }
                case 2: {
                    id = nextValue[1];
                    offset.storeObjectOffset(current, id, 0, true, false);
                    ++current;
                    continue block7;
                }
                default: {
                    throw new PdfException("Exception Unsupported Compression mode with value " + nextValue[0]);
                }
            }
        }
        return pntr;
    }

    static int getWord(byte[] content, int index, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result = (result << 8) + (content[index + i] & 0xFF);
        }
        return result;
    }
}

