/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.BrokenRefTable;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.Trailer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PageObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class RefTable {
    PdfObject encryptObj;
    private byte[] ID;
    static final String pattern = "obj";
    private PdfObject infoObject;
    static final int UNSET = -1;
    static final int COMPRESSED = 1;
    static final int LEGACY = 2;
    private RandomAccessBuffer pdf_datafile;
    static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private final long eof;
    final Offsets offset;

    public RefTable(RandomAccessBuffer pdf_datafile, long eof, Offsets offset) {
        this.pdf_datafile = pdf_datafile;
        this.eof = eof;
        this.offset = offset;
    }

    private int readFirstStartRef() throws PdfException {
        this.offset.setRefTableInvalid(false);
        int pointer = -1;
        int i = 1019;
        StringBuilder startRef = new StringBuilder(10);
        int block = 1024;
        byte[] lastBytes = new byte[1024];
        int[] EndOfFileMarker = new int[]{37, 37, 69, 79};
        int valReached = 3;
        boolean EOFFound = false;
        try {
            long end;
            block21: {
                end = this.eof;
                int bufSize = 255;
                do {
                    byte[] buffer = this.getBytes(end - 255L, 255);
                    int offset = 0;
                    for (int ii = 254; ii > -1; --ii) {
                        if (!EOFFound) {
                            valReached = 3;
                        }
                        if (buffer[ii] == EndOfFileMarker[valReached]) {
                            --valReached;
                            EOFFound = true;
                        } else {
                            EOFFound = false;
                        }
                        --offset;
                        if (valReached >= 0) continue;
                        ii = -1;
                    }
                    if (valReached >= 0) continue;
                    end -= (long)offset;
                    break block21;
                } while ((end -= 255L) >= 0L);
                end = this.eof;
            }
            int count = (int)(end - 1024L);
            if (count < 0) {
                count = 0;
                int size = (int)this.eof;
                lastBytes = new byte[size];
                i = size + 3;
            }
            lastBytes = this.getBytes(count, lastBytes.length);
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e + " reading last 1024 bytes");
            }
            throw new PdfException(e + " reading last 1024 bytes");
        }
        int fileSize = lastBytes.length;
        if (i > fileSize) {
            i = fileSize - 5;
        }
        while (!(i <= -1 || (lastBytes[i] == 116 && lastBytes[i + 1] == 120 || lastBytes[i] == 114 && lastBytes[i + 1] == 116) && lastBytes[i + 2] == 114 && lastBytes[i + 3] == 101 && lastBytes[i + 4] == 102)) {
            --i;
        }
        if (i == -1) {
            block22: {
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + e1 + " closing file");
                }
            }
            throw new PdfException("No Startxref found in last 1024 bytes ");
        }
        i += 5;
        while (i < 1024 && (lastBytes[i] == 10 || lastBytes[i] == 32 || lastBytes[i] == 13)) {
            ++i;
        }
        while (i < 1024 && lastBytes[i] != 10 && lastBytes[i] != 32 && lastBytes[i] != 13) {
            startRef.append((char)lastBytes[i]);
            ++i;
        }
        if (startRef.length() > 0) {
            pointer = Integer.parseInt(startRef.toString());
        }
        if (pointer == -1) {
            block23: {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No Startref found in last 1024 bytes ");
                }
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block23;
                    LogWriter.writeLog("Exception " + e1 + " closing file");
                }
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return pointer;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj, PdfFileReader currentPdfFile, ObjectReader objectReader) throws PdfException {
        int pointer = -1;
        int eof = (int)this.eof;
        boolean islinearizedCompressed = false;
        if (linearObj == null) {
            pointer = this.readFirstStartRef();
        } else {
            byte[] data = this.pdf_datafile.getPdfBuffer();
            int count = data.length;
            int ptr = 5;
            for (int i = 0; i < count; ++i) {
                if (data[i] == 101 && data[i + 1] == 110 && data[i + 2] == 100 && data[i + 3] == 111 && data[i + 4] == 98 && data[i + 5] == 106) {
                    ptr = i + 6;
                }
                if (data[i] == 120 && data[i + 1] == 114 && data[i + 2] == 101 && data[i + 3] == 102) {
                    pointer = i;
                    i = count;
                    continue;
                }
                if (data[i] != 88 || data[i + 1] != 82 || data[i + 2] != 101 || data[i + 3] != 102) continue;
                islinearizedCompressed = true;
                pointer = ptr;
                while (data[pointer] == 10 || data[pointer] == 13 || data[pointer] == 32) {
                    ++pointer;
                }
                i = count;
            }
        }
        this.offset.addXref(pointer);
        PageObject rootObj = null;
        if (pointer >= eof || pointer == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Pointer not if file - trying to manually find startref");
            }
            this.offset.setRefTableInvalid(true);
            try {
                rootObj = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            }
            catch (Error err) {
                throw new PdfException(err.getMessage() + " attempting to manually scan file for objects");
            }
            currentPdfFile.readObject(rootObj);
            return rootObj;
        }
        if (islinearizedCompressed || this.isCompressedStream(pointer, eof)) {
            return this.readCompressedStream(rootObj, pointer, currentPdfFile, objectReader, linearObj);
        }
        return this.readLegacyReferenceTable(rootObj, pointer, eof, currentPdfFile);
    }

    private PdfObject readLegacyReferenceTable(PdfObject rootObj, int pointer, int eof, PdfFileReader currentPdfFile) throws PdfException {
        int current = 0;
        int bufSize = 1024;
        do {
            int i;
            byte[] Bytes;
            try {
                Bytes = Trailer.readTrailer(bufSize, pointer, eof, this.pdf_datafile);
            }
            catch (Exception e) {
                block37: {
                    try {
                        this.closeFile();
                    }
                    catch (IOException e1) {
                        if (!LogWriter.isOutput()) break block37;
                        LogWriter.writeLog("Exception " + e + " closing file " + e1);
                    }
                }
                throw new PdfException("Exception " + e + " reading trailer");
            }
            if (Bytes == null) break;
            int maxLen = Bytes.length;
            for (i = 0; i < maxLen && (Bytes[i] != 116 || Bytes[i + 1] != 114 || Bytes[i + 2] != 97 || Bytes[i + 3] != 105 || Bytes[i + 4] != 108 || Bytes[i + 5] != 101 || Bytes[i + 6] != 114); ++i) {
            }
            int endTable = i;
            if (i == Bytes.length) break;
            while (Bytes[i] != 60 && Bytes[i - 1] != 60) {
                ++i;
            }
            CompressedObject pdfObject = new CompressedObject("1 0 R");
            Dictionary.readDictionary(pdfObject, ++i, Bytes, -1, true, currentPdfFile, false);
            int level = 0;
            while (true) {
                if (Bytes[i] == 60 && Bytes[i - 1] == 60) {
                    ++level;
                    ++i;
                } else if (Bytes[i] == 91) {
                    ++i;
                    while (Bytes[i] != 93 && ++i != Bytes.length) {
                    }
                } else if (Bytes[i] == 62 && Bytes[i - 1] == 62) {
                    --level;
                    ++i;
                }
                if (level == 0) break;
                ++i;
            }
            int XRefStm = ((PdfObject)pdfObject).getInt(910911090);
            if (XRefStm != -1) {
                pointer = XRefStm;
            } else {
                boolean hasRef = true;
                while (Bytes[i] == 10 || Bytes[i] == 13) {
                    ++i;
                }
                while (Bytes[i] == 37) {
                    while (Bytes[i] != 10) {
                        ++i;
                    }
                    ++i;
                }
                while (Bytes[i] != 116 && Bytes[i + 1] != 120 && Bytes[i + 2] != 114 && Bytes[i + 3] != 101 && Bytes[i + 4] != 102) {
                    if (Bytes[i] == 111 && Bytes[i + 1] == 98 && Bytes[i + 2] == 106) {
                        hasRef = false;
                        break;
                    }
                    ++i;
                }
                if (hasRef) {
                    i += 8;
                    while (i < maxLen && (Bytes[i] == 10 || Bytes[i] == 32 || Bytes[i] == 13)) {
                        ++i;
                    }
                    int s = i;
                    while (i < maxLen && Bytes[i] != 10 && Bytes[i] != 32 && Bytes[i] != 13) {
                        ++i;
                    }
                    if (s != i) {
                        pointer = NumberUtils.parseInt(s, i, Bytes);
                    }
                }
            }
            i = 0;
            while (Bytes[i] == 13 || Bytes[i] == 32 || Bytes[i] == 10 || Bytes[i] == 9) {
                ++i;
            }
            if (pointer == -1) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("No startRef");
                continue;
            }
            if (Bytes[i] == 120 && Bytes[i + 1] == 114 && Bytes[i + 2] == 101 && Bytes[i + 3] == 102) {
                i = 5;
                while (Bytes[i] == 10 || Bytes[i] == 32 || Bytes[i] == 13) {
                    ++i;
                }
                current = this.offset.readXRefs(current, Bytes, endTable, i, eof, this.pdf_datafile);
                if (rootObj == null) {
                    byte[][] IDs;
                    rootObj = ((PdfObject)pdfObject).getDictionary(574570308);
                    this.encryptObj = ((PdfObject)pdfObject).getDictionary(1113489015);
                    if (this.encryptObj != null && (IDs = ((PdfObject)pdfObject).getStringArray(6420)) != null && this.ID == null) {
                        this.ID = IDs[0];
                    }
                    this.infoObject = ((PdfObject)pdfObject).getDictionary(423507519);
                }
                if ((pointer = ((PdfObject)pdfObject).getInt(541209926)) != -1 && (long)pointer < this.eof) {
                    bufSize = 1024;
                    this.offset.addXref(pointer);
                    continue;
                }
                pointer = -1;
                continue;
            }
            pointer = -1;
            rootObj = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            currentPdfFile.readObject(rootObj);
            this.offset.setRefTableInvalid(true);
        } while (pointer != -1);
        if (this.encryptObj == null && rootObj != null) {
            int type;
            block38: {
                type = -1;
                int status = rootObj.getStatus();
                byte[] data = rootObj.getUnresolvedData();
                try {
                    ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
                    objectDecoder.checkResolved(rootObj);
                    type = rootObj.getParameterConstant(608780341);
                }
                catch (Exception e) {
                    rootObj.setStatus(status);
                    rootObj.setUnresolvedData(data, status);
                    if (!LogWriter.isOutput()) break block38;
                    LogWriter.writeLog("[PDF] Exception reading type on root object " + e);
                }
            }
            if (type == 373243460) {
                rootObj = null;
            }
        }
        if (rootObj == null) {
            this.offset.clear();
            this.offset.reuse();
            rootObj = new PageObject(BrokenRefTable.findOffsets(this.pdf_datafile, this.offset));
            currentPdfFile.readObject(rootObj);
            this.offset.setRefTableInvalid(true);
        }
        return rootObj;
    }

    private PdfObject readCompressedStream(PdfObject rootObj, int pointer, PdfFileReader currentPdfFile, ObjectReader objectReader, PdfObject linearObj) throws PdfException {
        while (pointer != -1) {
            int[] Index;
            this.movePointer(pointer);
            byte[] raw = objectReader.readObjectData(-1, null);
            StringBuilder objectName = new StringBuilder();
            int last = 32;
            int matched = 0;
            for (int i1 = 0; i1 < raw.length; ++i1) {
                char current1 = (char)raw[i1];
                if (current1 == '\n' || current1 == '\r') {
                    current1 = ' ';
                }
                if (current1 == ' ' && last == 32) {
                    matched = 0;
                } else if (current1 == pattern.charAt(matched)) {
                    ++matched;
                } else {
                    matched = 0;
                    objectName.append(current1);
                }
                if (matched == 3) break;
                last = current1;
            }
            objectName.append('R');
            CompressedObject pdfObject = new CompressedObject(objectName.toString());
            pdfObject.setCompressedStream(true);
            ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
            objectDecoder.readDictionaryAsObject(pdfObject, 0, raw);
            int[] fieldSizes = ((PdfObject)pdfObject).getIntArray(39);
            byte[] xrefs = pdfObject.getDecodedStream();
            if (xrefs == null) {
                xrefs = currentPdfFile.readStream(pdfObject, true, true, false, false, true, null);
            }
            if ((Index = ((PdfObject)pdfObject).getIntArray(1043608929)) == null) {
                CompressedObjects.readCompressedOffsets(0, 0, ((PdfObject)pdfObject).getInt(590957109), fieldSizes, xrefs, this.offset, this.pdf_datafile);
            } else {
                int count = Index.length;
                int pntr = 0;
                for (int aa = 0; aa < count; aa += 2) {
                    pntr = CompressedObjects.readCompressedOffsets(pntr, Index[aa], Index[aa + 1], fieldSizes, xrefs, this.offset, this.pdf_datafile);
                }
            }
            if (rootObj == null) {
                byte[][] IDs;
                rootObj = ((PdfObject)pdfObject).getDictionary(574570308);
                this.encryptObj = ((PdfObject)pdfObject).getDictionary(1113489015);
                if (this.encryptObj != null && (IDs = ((PdfObject)pdfObject).getStringArray(6420)) != null && this.ID == null) {
                    this.ID = IDs[0];
                }
                this.infoObject = ((PdfObject)pdfObject).getDictionary(423507519);
            }
            if (linearObj != null) {
                pointer = -1;
                continue;
            }
            pointer = ((PdfObject)pdfObject).getInt(541209926);
            if (pointer == -1 || this.isCompressedStream(pointer, (int)this.eof)) continue;
            return this.readLegacyReferenceTable(rootObj, pointer, (int)this.eof, currentPdfFile);
        }
        return rootObj;
    }

    byte[] getBytes(long start, int count) {
        byte[] buffer;
        block3: {
            buffer = new byte[count];
            if (start >= 0L) {
                try {
                    this.pdf_datafile.seek(start);
                    this.pdf_datafile.read(buffer);
                }
                catch (IOException e) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return buffer;
    }

    void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private boolean isCompressedStream(int pointer, int eof) throws PdfException {
        boolean debug = false;
        int bufSize = 50;
        int charReached_legacy = 0;
        int charReached_comp1 = 0;
        int charReached_comp2 = 0;
        int[] objStm = new int[]{79, 98, 106, 83, 116, 109};
        int[] XRef = new int[]{88, 82, 101, 102};
        int type = -1;
        boolean firstRead = true;
        while (true) {
            if (pointer + bufSize > eof) {
                bufSize = eof - pointer;
            }
            if (bufSize < 0) {
                bufSize = 50;
            }
            if (pointer < 0) {
                pointer += bufSize;
                continue;
            }
            byte[] buffer = this.getBytes(pointer, bufSize);
            if (firstRead && buffer[0] == 114 && buffer[1] == 101 && buffer[2] == 102) {
                charReached_legacy = 1;
            }
            firstRead = false;
            for (int i = 0; i < bufSize; ++i) {
                byte currentByte = buffer[i];
                if (currentByte == oldPattern[charReached_legacy] && type != 1) {
                    ++charReached_legacy;
                    type = 2;
                } else if (currentByte == objStm[charReached_comp1] && (charReached_comp1 == 0 || type == 1)) {
                    ++charReached_comp1;
                    type = 1;
                } else if (currentByte == XRef[charReached_comp2] && (charReached_comp2 == 0 || type == 1)) {
                    ++charReached_comp2;
                    type = 1;
                } else {
                    charReached_legacy = 0;
                    charReached_comp1 = 0;
                    charReached_comp2 = 0;
                    type = -1;
                }
                if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 3) break;
            }
            if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 3) break;
            pointer += bufSize;
        }
        if (type == -1) {
            block15: {
                try {
                    this.closeFile();
                }
                catch (IOException e1) {
                    if (!LogWriter.isOutput()) break block15;
                    LogWriter.writeLog("Exception 1 closing file " + e1);
                }
            }
            throw new PdfException("Exception unable to find ref or obj in trailer");
        }
        return type == 1;
    }

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public PdfObject getEncryptionObject() {
        return this.encryptObj;
    }

    public byte[] getID() {
        return this.ID;
    }

    public void movePointer(long pointer) {
        block5: {
            try {
                if (pointer > this.pdf_datafile.length()) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Attempting to access ref outside file");
                    }
                } else {
                    this.pdf_datafile.seek(pointer);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception " + e + " moving pointer to  " + pointer + " in file.");
            }
        }
    }
}

