/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.pattern;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pattern.PatternDictionaryFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class PatternDictionarySegment
extends Segment {
    PatternDictionaryFlags patternDictionaryFlags = new PatternDictionaryFlags();
    private int width;
    private int height;
    private int grayMax;
    private JBIG2Bitmap[] bitmaps;
    private int size;

    public PatternDictionarySegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        this.readPatternDictionaryFlags();
        this.width = this.decoder.readByte();
        this.height = this.decoder.readByte();
        if (JBIG2StreamDecoder.debug) {
            System.out.println("pattern dictionary size = " + this.width + " , " + this.height);
        }
        short[] buf = new short[4];
        this.decoder.readByte(buf);
        this.grayMax = BinaryOperation.getInt32(buf);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("grey max = " + this.grayMax);
        }
        boolean useMMR = this.patternDictionaryFlags.getFlagValue(PatternDictionaryFlags.HD_MMR) == 1;
        int template = this.patternDictionaryFlags.getFlagValue(PatternDictionaryFlags.HD_TEMPLATE);
        if (!useMMR) {
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        genericBAdaptiveTemplateX[0] = (short)(-this.width);
        genericBAdaptiveTemplateY[0] = 0;
        genericBAdaptiveTemplateX[1] = -3;
        genericBAdaptiveTemplateY[1] = -1;
        genericBAdaptiveTemplateX[2] = 2;
        genericBAdaptiveTemplateY[2] = -2;
        genericBAdaptiveTemplateX[3] = -2;
        genericBAdaptiveTemplateY[3] = -2;
        this.size = this.grayMax + 1;
        JBIG2Bitmap bitmap = new JBIG2Bitmap(this.size * this.width, this.height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        bitmap.clear(0);
        bitmap.readBitmap(useMMR, template, false, false, null, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY, this.segmentHeader.getSegmentDataLength() - 7);
        JBIG2Bitmap[] bitmaps = new JBIG2Bitmap[this.size];
        int x = 0;
        for (int i = 0; i < this.size; ++i) {
            bitmaps[i] = bitmap.getSlice(x, 0, this.width, this.height);
            x += this.width;
        }
        this.bitmaps = bitmaps;
    }

    public JBIG2Bitmap[] getBitmaps() {
        return this.bitmaps;
    }

    private void readPatternDictionaryFlags() throws IOException {
        short patternDictionaryFlagsField = this.decoder.readByte();
        this.patternDictionaryFlags.setFlags(patternDictionaryFlagsField);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("pattern Dictionary flags = " + patternDictionaryFlagsField);
        }
    }

    public PatternDictionaryFlags getPatternDictionaryFlags() {
        return this.patternDictionaryFlags;
    }

    public int getSize() {
        return this.size;
    }
}

