/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.objects.PdfClip;
import org.jpedal.objects.TextState;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class GraphicsState
implements Cloneable {
    public float x;
    public float y;
    TextState currentTextState = new TextState();
    private float strokeAlpha = 1.0f;
    private float nonstrokeAlpha = 1.0f;
    private float maxStrokeAlpha = 1.0f;
    private float maxNonstrokeAlpha = 1.0f;
    public final float[][] lastCTM = new float[3][3];
    private PdfObject TR;
    public PdfObject SMask;
    public GenericColorSpace strokeColorSpace = new DeviceGrayColorSpace();
    public GenericColorSpace nonstrokeColorSpace = new DeviceGrayColorSpace();
    private boolean hasClipChanged;
    private boolean op;
    private boolean OP;
    private float OPM;
    private PdfPaint nonstrokeColor = new PdfColor(0, 0, 0);
    private PdfPaint strokeColor = new PdfColor(0, 0, 0);
    private Area current_clipping_shape;
    private PdfClip current_clip;
    private static final boolean debugClip = false;
    public float[][] CTM = new float[3][3];
    public float[][] scaleFactor;
    private int current_line_dash_phase;
    private GeneralPath TRmask;
    private int fill_type;
    private int mitre_limit = 10;
    private float[] current_line_dash_array = new float[0];
    private int current_line_cap_style;
    private float current_line_width = 1.0f;
    private int output_line_width = -1;
    private int current_line_join_style;
    private int text_render_type = 2;
    private int minX;
    private int minY;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    public static final int FILLSTROKE = 3;
    public static final int INVISIBLE = 4;
    public static final int CLIPTEXT = 7;
    private int BMvalue = 1111314299;

    public GraphicsState(GraphicsState gs) {
        this.resetCTM();
        this.BMvalue = gs.BMvalue;
    }

    public GraphicsState() {
        this.resetCTM();
    }

    public GraphicsState(int minX, int minY) {
        this.minX = -minX;
        this.minY = -minY;
        this.resetCTM();
    }

    public void setMaxAlpha(int type, float value) {
        switch (type) {
            case 1: {
                this.maxStrokeAlpha = value;
                break;
            }
            case 2: {
                this.maxNonstrokeAlpha = value;
            }
        }
    }

    public void setAlpha(int type, float value) {
        switch (type) {
            case 1: {
                if (value > this.maxStrokeAlpha) {
                    value = this.maxStrokeAlpha;
                }
                this.strokeAlpha = value;
                break;
            }
            case 2: {
                if (value > this.maxNonstrokeAlpha) {
                    value = this.maxNonstrokeAlpha;
                }
                this.nonstrokeAlpha = value;
            }
        }
    }

    public float getAlpha(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                if (this.strokeAlpha > this.maxStrokeAlpha) {
                    value = this.maxStrokeAlpha;
                    break;
                }
                value = this.strokeAlpha;
                break;
            }
            case 2: {
                value = this.nonstrokeAlpha > this.maxNonstrokeAlpha ? this.maxNonstrokeAlpha : this.nonstrokeAlpha;
            }
        }
        return value;
    }

    public float getAlphaMax(int type) {
        float value = 1.0f;
        switch (type) {
            case 1: {
                value = this.maxStrokeAlpha;
                break;
            }
            case 2: {
                value = this.maxNonstrokeAlpha;
            }
        }
        return value;
    }

    public boolean getNonStrokeOP() {
        return this.op;
    }

    public float getOPM() {
        return this.OPM;
    }

    public PdfObject getTR() {
        return this.TR;
    }

    public final void setTextRenderType(int text_render_type) {
        this.text_render_type = text_render_type;
        this.TRmask = null;
    }

    public final int getTextRenderType() {
        return this.text_render_type;
    }

    public final void setMitreLimit(int mitre_limit) {
        this.mitre_limit = mitre_limit;
    }

    public final float getLineWidth() {
        return this.current_line_width;
    }

    public final int getOutputLineWidth() {
        return this.output_line_width;
    }

    public final void setFillType(int fill_type) {
        this.fill_type = fill_type;
    }

    public final void updateClip(Area current_area) {
        if (this.current_clipping_shape == null || current_area == null) {
            this.current_clipping_shape = current_area;
            this.hasClipChanged = true;
        } else {
            this.current_clipping_shape.intersect(current_area);
            this.hasClipChanged = true;
        }
    }

    public final void addClip(Area current_area) {
        if (this.TRmask == null) {
            this.TRmask = new GeneralPath();
        }
        this.TRmask.append(current_area, false);
    }

    public final Stroke getStroke() {
        BasicStroke current_stroke;
        int dashCount;
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        if ((dashCount = this.current_line_dash_array.length) > 0) {
            float[] dash = new float[dashCount];
            for (int aa = 0; aa < dashCount; ++aa) {
                dash[aa] = this.CTM[0][0] != 0.0f ? this.current_line_dash_array[aa] * this.CTM[0][0] : this.current_line_dash_array[aa] * this.CTM[0][1];
                if (dash[aa] < 0.0f) {
                    dash[aa] = -dash[aa];
                }
                if (!(dash[aa] < 0.07f)) continue;
                dash[aa] = 0.07f;
            }
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit, dash, Math.abs(this.current_line_dash_phase));
        } else {
            current_stroke = new BasicStroke(w, this.current_line_cap_style, this.current_line_join_style, this.mitre_limit);
        }
        return current_stroke;
    }

    public final void applyFXStroke(Shape shape) {
        int dashCount;
        if (shape == null) {
            return;
        }
        float w = this.current_line_width;
        if (w < 0.0f) {
            w = -w;
        }
        if (this.mitre_limit < 1) {
            this.mitre_limit = 1;
        }
        if ((dashCount = this.current_line_dash_array.length) > 0) {
            float[] dash = new float[dashCount];
            for (int aa = 0; aa < dashCount; ++aa) {
                if (dash[aa] < 0.0f) {
                    dash[aa] = -dash[aa];
                }
                if (!(dash[aa] < 0.05f)) continue;
                dash[aa] = 0.05f;
            }
            shape.getStrokeDashArray().clear();
            float[] fArray = dash;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                double value = fArray[i];
                shape.getStrokeDashArray().add((Object)value);
            }
            shape.setStrokeDashOffset((double)Math.abs(this.current_line_dash_phase));
        }
        shape.setStrokeWidth((double)w);
        switch (this.current_line_cap_style) {
            case 0: {
                shape.setStrokeLineCap(StrokeLineCap.BUTT);
                break;
            }
            case 1: {
                shape.setStrokeLineCap(StrokeLineCap.ROUND);
                break;
            }
            case 2: {
                shape.setStrokeLineCap(StrokeLineCap.SQUARE);
            }
        }
        switch (this.current_line_join_style) {
            case 0: {
                shape.setStrokeLineJoin(StrokeLineJoin.MITER);
                break;
            }
            case 1: {
                shape.setStrokeLineJoin(StrokeLineJoin.ROUND);
                break;
            }
            case 2: {
                shape.setStrokeLineJoin(StrokeLineJoin.BEVEL);
            }
        }
        shape.setStrokeMiterLimit((double)this.mitre_limit);
    }

    public float getCTMAdjustedLineWidth() {
        float w = this.current_line_width;
        if (this.CTM[0][0] != 0.0f) {
            w *= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            w *= this.CTM[0][1];
        }
        if (w < 0.0f) {
            w = -w;
        }
        return w;
    }

    public final void setLineWidth(float current_line_width) {
        this.current_line_width = current_line_width;
    }

    public void setCTMAdjustedLineWidth(float width) {
        if (this.CTM[0][0] != 0.0f) {
            width /= this.CTM[0][0];
        } else if (this.CTM[0][1] != 0.0f) {
            width /= this.CTM[0][1];
        }
        this.current_line_width = width;
    }

    public final void setOutputLineWidth(int output_line_width) {
        this.output_line_width = output_line_width;
    }

    public final Area getClippingShape() {
        if (this.TRmask != null && this.current_clipping_shape == null) {
            return new Area(this.TRmask);
        }
        if (this.TRmask != null) {
            Area clipAsArea = new Area(this.TRmask);
            clipAsArea.intersect(this.current_clipping_shape);
            return clipAsArea;
        }
        return this.current_clipping_shape;
    }

    public void setMode(PdfObject GS) {
        PdfArrayIterator BM;
        boolean notMask;
        this.nonstrokeAlpha = 1.0f;
        this.op = false;
        this.OP = false;
        if (GS == null) {
            return;
        }
        float LW = GS.getFloatNumber(7207);
        if (LW != -1.0f) {
            this.current_line_width = LW;
        }
        boolean AIS = GS.getBoolean(1120547);
        this.SMask = GS.getDictionary(489767774);
        boolean bl = notMask = this.SMask == null || AIS || this.SMask.getGeneralType(489767774) == 507461173;
        if (notMask) {
            float newCA = GS.getFloatNumber(4881);
            float newca = GS.getFloatNumber(13105);
            if (newCA != -1.0f) {
                this.setAlpha(1, newCA);
            }
            if (newca != -1.0f) {
                this.setAlpha(2, newca);
            }
        }
        this.OP = GS.getBoolean(7968);
        this.op = GS.getBoolean(16192);
        float newOPM = GS.getFloatNumber(2039837);
        this.OPM = newOPM != -1.0f ? newOPM : 0.0f;
        this.TR = GS.getDictionary(9250);
        if (this.TR != null) {
            boolean isIdentity = false;
            if (this.TR.getGeneralType(9250) == 1567455623) {
                isIdentity = true;
            } else {
                int count;
                byte[][] maskArray = this.TR.getKeyArray(9250);
                if (maskArray != null && (count = maskArray.length) > 0) {
                    isIdentity = true;
                    for (byte[] aMaskArray : maskArray) {
                        int nextID = PdfDictionary.getIntKey(1, aMaskArray.length - 1, aMaskArray);
                        if (nextID == 1567455623) continue;
                        isIdentity = false;
                        break;
                    }
                }
            }
            if (isIdentity) {
                this.TR = null;
            }
        }
        if ((BM = GS.getMixedArray(4637)) != null && BM.hasMoreTokens()) {
            this.BMvalue = BM.getNextValueAsConstant(false);
        }
    }

    public final void setCapStyle(int cap_style) {
        this.current_line_cap_style = cap_style;
    }

    public final void setJoinStyle(int join_style) {
        this.current_line_join_style = join_style;
    }

    public final void checkWholePageClip(int max_y) {
        if (this.current_clipping_shape != null && this.current_clipping_shape.getBounds().getHeight() > (double)(max_y + 2) && this.current_clipping_shape.getBounds().y >= 0) {
            this.current_clipping_shape = null;
            this.hasClipChanged = true;
        }
    }

    public final void setDashArray(float[] current_line_dash_array) {
        this.current_line_dash_array = current_line_dash_array;
    }

    public final Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogWriter.writeLog("Unable to clone " + ex);
        }
        GraphicsState newGS = new GraphicsState();
        newGS.x = this.x;
        newGS.y = this.y;
        if (this.TR != null) {
            newGS.TR = (PdfObject)this.TR.clone();
        }
        newGS.maxNonstrokeAlpha = this.maxNonstrokeAlpha;
        newGS.maxStrokeAlpha = this.maxStrokeAlpha;
        newGS.strokeAlpha = this.strokeAlpha;
        newGS.nonstrokeAlpha = this.nonstrokeAlpha;
        newGS.op = this.op;
        newGS.OP = this.OP;
        newGS.OPM = this.OPM;
        newGS.nonstrokeColor = this.nonstrokeColor;
        newGS.strokeColor = this.strokeColor;
        if (this.current_clipping_shape != null) {
            newGS.current_clipping_shape = (Area)this.current_clipping_shape.clone();
        }
        if (this.CTM != null) {
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(this.CTM[i], 0, newGS.CTM[i], 0, 3);
            }
        }
        newGS.hasClipChanged = this.hasClipChanged;
        newGS.current_line_dash_phase = this.current_line_dash_phase;
        if (this.TRmask != null) {
            newGS.TRmask = (GeneralPath)this.TRmask.clone();
        }
        newGS.fill_type = this.fill_type;
        newGS.mitre_limit = this.mitre_limit;
        if (this.current_line_dash_array != null) {
            int size = this.current_line_dash_array.length;
            newGS.current_line_dash_array = new float[size];
            System.arraycopy(this.current_line_dash_array, 0, newGS.current_line_dash_array, 0, size);
        }
        newGS.current_line_cap_style = this.current_line_cap_style;
        newGS.current_line_width = this.current_line_width;
        newGS.current_line_join_style = this.current_line_join_style;
        newGS.text_render_type = this.text_render_type;
        newGS.minX = this.minX;
        newGS.minY = this.minY;
        return newGS;
    }

    private void resetCTM() {
        this.CTM[0][0] = 1.0f;
        this.CTM[1][0] = 0.0f;
        this.CTM[2][0] = this.minX;
        this.CTM[0][1] = 0.0f;
        this.CTM[1][1] = 1.0f;
        this.CTM[2][1] = this.minY;
        this.CTM[0][2] = 0.0f;
        this.CTM[1][2] = 0.0f;
        this.CTM[2][2] = 1.0f;
    }

    public final void setDashPhase(int current_line_dash_phase) {
        this.current_line_dash_phase = current_line_dash_phase;
    }

    public final int getFillType() {
        return this.fill_type;
    }

    public final void setClippingShape(Area new_clip) {
        this.current_clipping_shape = new_clip;
        this.hasClipChanged = true;
    }

    public PdfPaint getNonstrokeColor() {
        return this.nonstrokeColor;
    }

    public void setNonstrokeColor(PdfPaint currentNonstrokeColor) {
        this.nonstrokeColor = currentNonstrokeColor;
    }

    public PdfPaint getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(PdfPaint strokeColor) {
        this.strokeColor = strokeColor;
    }

    public boolean hasClipChanged() {
        boolean flag = this.hasClipChanged;
        this.hasClipChanged = false;
        return flag;
    }

    public void setTextState(TextState currentTextState) {
        this.currentTextState = currentTextState;
    }

    public TextState getTextState() {
        return this.currentTextState;
    }

    public void updateClip(Object fxPath) {
        JavaFXSupport fxSupport;
        if (this.current_clip == null && (fxSupport = ExternalHandlers.getFXHandler()) != null) {
            this.current_clip = fxSupport.getFXClip();
        }
        this.hasClipChanged = this.current_clip.updateClip(fxPath);
    }

    public Shape getFXClippingShape() {
        if (this.current_clip == null) {
            return null;
        }
        return (Shape)this.current_clip.getClippingShape();
    }

    public int getBMValue() {
        return this.BMvalue;
    }
}

