/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.MetadataObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFileInformation {
    private static final String[] information_fields = new String[]{"Title", "Author", "Subject", "Keywords", "Creator", "Producer", "CreationDate", "ModDate", "Trapped"};
    public static final int[] information_field_IDs = new int[]{960773209, 1144541319, 978876534, 1517780362, 827818359, 1702196342, 1806481572, 340689769, 1080325989};
    private final String[] information_values = new String[]{"", "", "", "", "", "", "", "", ""};
    private String XMLmetadata;
    private byte[] rawData;

    public static String[] getFieldNames() {
        return information_fields;
    }

    public String getFileXMLMetaData() {
        if (this.rawData == null) {
            return "";
        }
        if (this.XMLmetadata == null) {
            int length = this.rawData.length;
            byte[] stream = new byte[length];
            System.arraycopy(this.rawData, 0, stream, 0, length);
            int count = stream.length;
            int reached = 0;
            int lastValue = 0;
            for (int ii = 0; ii < count; ++ii) {
                if (lastValue == 13 && stream[ii] == 10) {
                    stream[reached - 1] = 10;
                    continue;
                }
                if (!(lastValue != 10 && lastValue != 32 || stream[ii] != 32 && stream[ii] != 10)) continue;
                stream[reached] = stream[ii];
                lastValue = stream[ii];
                ++reached;
            }
            if (reached != count) {
                byte[] cleanedStream = new byte[reached];
                System.arraycopy(stream, 0, cleanedStream, 0, reached);
                stream = cleanedStream;
            }
            this.XMLmetadata = new String(stream);
        }
        return this.XMLmetadata;
    }

    public void setFileXMLMetaData(byte[] rawData) {
        this.rawData = rawData;
    }

    public String[] getFieldValues() {
        return this.information_values;
    }

    public void setFieldValue(int i, String convertedValue) {
        this.information_values[i] = convertedValue;
    }

    public void readInformationObject(PdfObject infoObj, ObjectDecoder objectDecoder) {
        block6: {
            try {
                objectDecoder.checkResolved(infoObj);
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        int count = information_field_IDs.length;
        for (int i = 0; i < count; ++i) {
            String newValue;
            int id = information_field_IDs[i];
            if (id == 1080325989) {
                newValue = infoObj.getName(id);
                if (newValue == null) {
                    newValue = "";
                }
            } else {
                byte[] data = infoObj.getTextStreamValueAsByte(id);
                newValue = data == null ? "" : StringUtils.getTextString(data, false);
            }
            this.setFieldValue(i, newValue);
        }
    }

    public final PdfFileInformation readPdfFileMetadata(PdfObject metadataObj, PdfObjectReader currentPdfFile) {
        PdfFileReader objectReader = currentPdfFile.getObjectReader();
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
        DecryptionFactory decryption = objectReader.getDecryptionObject();
        PdfObject infoObject = objectReader.getInfoObject();
        if (infoObject != null && (decryption == null || !decryption.getBooleanValue(101) && !decryption.getBooleanValue(104))) {
            this.readInformationObject(infoObject, objectDecoder);
        }
        if (metadataObj != null) {
            String objectRef = new String(metadataObj.getUnresolvedData());
            MetadataObject oldMetaDataObj = new MetadataObject(objectRef);
            objectReader.readObject(oldMetaDataObj);
            this.rawData = oldMetaDataObj.getDecodedStream();
            if (this.rawData != null) {
                int count;
                for (count = this.rawData.length; count > 1 && this.rawData[count - 1] != 62; --count) {
                }
                if (count > 0) {
                    byte[] trimmedVersion = new byte[count];
                    System.arraycopy(this.rawData, 0, trimmedVersion, 0, count);
                    this.rawData = trimmedVersion;
                }
            }
        }
        return this;
    }
}

