/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;

public class FormRenderUtilsG2 {
    private static Color getBorderColor(FormObject formObject) {
        Color BC = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject MK = formObject.getDictionary(7451);
            float[] bc = MK.getFloatArray(4627);
            BC = FormObject.generateColor(bc);
        }
        return BC;
    }

    private static Color getBorderBackgroundColor(FormObject formObject) {
        Color BG = new Color(0, 0, 0, 0);
        if (formObject.getDictionary(7451) != null) {
            PdfObject MK = formObject.getDictionary(7451);
            float[] bg = MK.getFloatArray(4631);
            BG = FormObject.generateColor(bg);
        }
        return BG;
    }

    private static void renderBorderSolid(Graphics2D g2, FormObject formObject, int page, int borderWidth, int pageHeight) {
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawRect(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2);
    }

    private static void renderBorderDashed(Graphics2D g2, FormObject formObject, PdfArrayIterator dashPattern, int page, int borderWidth, int pageHeight) {
        float[] dash = new float[]{3.0f};
        int phase = 0;
        if (dashPattern.getTokenCount() > 0) {
            int count = dashPattern.getTokenCount();
            if (count > 0) {
                dash = dashPattern.getNextValueAsFloatArray();
            }
            if (count > 1) {
                phase = dashPattern.getNextValueAsInteger();
            }
        }
        if (dash.length == 0) {
            g2.setStroke(new BasicStroke(borderWidth));
        } else if (dash.length > 0) {
            g2.setStroke(new BasicStroke(borderWidth, 0, 0, 10.0f, dash, phase));
        }
        g2.drawRect(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2);
    }

    private static void renderBorderBeveled(Graphics2D g2, FormObject formObject, Color BG, int page, int borderWidth, int pageHeight) {
        Color bckUp = g2.getColor();
        int x = formObject.getBoundingRectangle().x;
        int y = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height);
        int width = formObject.getBoundingRectangle().width;
        int height = formObject.getBoundingRectangle().height;
        g2.setStroke(new BasicStroke(borderWidth, 0, 0, 10.0f));
        g2.drawRect(x, y, width, height);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(BG.darker());
        g2.fillPolygon(new int[]{++x + (width -= 2), x + width, x + width - borderWidth, x + width - borderWidth, x + borderWidth, x}, new int[]{++y + (height -= 2), y, y + borderWidth, y + height - borderWidth, y + height - borderWidth, y + height}, 6);
        g2.setColor(BG.brighter());
        g2.fillPolygon(new int[]{x, x, x + borderWidth, x + borderWidth, x + width - borderWidth, x + width}, new int[]{y, y + height, y + height - borderWidth, y + borderWidth, y + borderWidth, y}, 6);
        g2.setColor(bckUp);
    }

    private static void renderBorderInset(Graphics2D g2, FormObject formObject, int page, int borderWidth, int pageHeight) {
        Color bckUp = g2.getColor();
        int x = formObject.getBoundingRectangle().x;
        int y = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height);
        int width = formObject.getBoundingRectangle().width;
        int height = formObject.getBoundingRectangle().height;
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawRect(x, y, width, height);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillPolygon(new int[]{++x + (width -= 2), x + width, x + width - borderWidth, x + width - borderWidth, x + borderWidth, x}, new int[]{++y + (height -= 2), y, y + borderWidth, y + height - borderWidth, y + height - borderWidth, y + height}, 6);
        g2.setColor(Color.GRAY);
        g2.fillPolygon(new int[]{x, x, x + borderWidth, x + borderWidth, x + width - borderWidth, x + width}, new int[]{y, y + height, y + height - borderWidth, y + borderWidth, y + borderWidth, y}, 6);
        g2.setColor(bckUp);
    }

    private static void renderBorderUnderline(Graphics2D g2, FormObject formObject, int page, int borderWidth, int pageHeight) {
        g2.setStroke(new BasicStroke(borderWidth));
        g2.drawLine(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - formObject.getBoundingRectangle().y + borderWidth - 1, formObject.getBoundingRectangle().x + formObject.getBoundingRectangle().width - 1, pageHeight - formObject.getBoundingRectangle().y + borderWidth - 1);
    }

    public static int renderBorder(Graphics2D g2, FormObject formObject, int page, int pageHeight) {
        Object antiA = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int borderWidth = 0;
        Color BC = FormRenderUtilsG2.getBorderColor(formObject);
        Color BG = FormRenderUtilsG2.getBorderBackgroundColor(formObject);
        boolean borderCreated = false;
        if (formObject.getDictionary(4643) != null) {
            PdfObject BS = formObject.getDictionary(4643);
            String s = BS.getName(35);
            borderWidth = BS.getInt(39);
            if (borderWidth > 0) {
                g2.setColor(BC);
                if (s == null || s.equals("S")) {
                    FormRenderUtilsG2.renderBorderSolid(g2, formObject, borderWidth, page, pageHeight);
                    borderCreated = true;
                } else if (s.equals("D")) {
                    PdfArrayIterator dashPattern = BS.getMixedArray(20);
                    FormRenderUtilsG2.renderBorderDashed(g2, formObject, dashPattern, borderWidth, page, pageHeight);
                    borderCreated = true;
                } else if (s.equals("B")) {
                    FormRenderUtilsG2.renderBorderBeveled(g2, formObject, BG, borderWidth, page, pageHeight);
                    borderCreated = true;
                } else if (s.equals("I")) {
                    FormRenderUtilsG2.renderBorderInset(g2, formObject, borderWidth, page, pageHeight);
                    borderCreated = true;
                } else if (s.equals("U")) {
                    FormRenderUtilsG2.renderBorderUnderline(g2, formObject, borderWidth, page, pageHeight);
                    borderCreated = true;
                }
            }
        } else if (formObject.getObjectArray(1110722433) != null) {
            throw new RuntimeException("Border Array not implemented yet");
        }
        if (!borderCreated) {
            g2.setColor(BC);
            borderWidth = 1;
            g2.setStroke(new BasicStroke(borderWidth));
            g2.drawRect(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antiA);
        return borderWidth;
    }

    public static FontMetrics renderFont(Graphics2D g2, FormObject formObject, String textValue, int borderWidth) {
        if (formObject.getTextSize() <= 0) {
            if (!formObject.getFieldFlags()[13]) {
                float fh = formObject.getBoundingRectangle().height - borderWidth * 2 - 2;
                g2.setFont(formObject.getTextFont().deriveFont(fh));
                FontMetrics metrics = g2.getFontMetrics(formObject.getTextFont().deriveFont(fh));
                Rectangle2D r = metrics.getStringBounds(textValue, g2);
                float scale = (float)((double)(formObject.getBoundingRectangle().width - borderWidth * 2 - 4) / r.getWidth());
                float hScale = (float)((double)formObject.getBoundingRectangle().height / r.getHeight());
                if (scale > 1.0f && scale > hScale) {
                    scale = hScale;
                }
                if (scale < 1.0f) {
                    g2.setFont(formObject.getTextFont().deriveFont(fh * scale));
                }
            } else {
                g2.setFont(formObject.getTextFont().deriveFont(12.0f));
            }
        } else {
            g2.setFont(formObject.getTextFont());
        }
        if (formObject.getTextColor() != null) {
            g2.setColor(formObject.getTextColor());
        } else {
            g2.setColor(Color.BLACK);
        }
        return g2.getFontMetrics();
    }

    public static void renderComboForms(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r, int page, int borderWidth, int justification, int pageHeight) {
        String[] values = formObject.getItemsList();
        if (values != null) {
            int[] selected = formObject.getIntArray(25);
            int startingIndex = formObject.getInt(9241);
            if (startingIndex < 0) {
                startingIndex = 0;
            }
            if (selected != null) {
                Color c = g2.getColor();
                Color highlight = new Color((float)(DecoderOptions.highlightColor.getRed() / 255), (float)(DecoderOptions.highlightColor.getGreen() / 255), (float)(DecoderOptions.highlightColor.getBlue() / 255), DecoderOptions.highlightComposite);
                g2.setColor(highlight);
                if (formObject.getBoundingRectangle().getHeight() < (double)(metrics.getHeight() * values.length)) {
                    startingIndex = selected[0];
                }
                for (int i = 0; i != selected.length; ++i) {
                    int x = formObject.getBoundingRectangle().x + borderWidth;
                    int y = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - borderWidth;
                    y += metrics.getDescent();
                    g2.fillRect(x, (y += metrics.getHeight() * (selected[i] - startingIndex)) + borderWidth, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, metrics.getHeight());
                }
                g2.setColor(c);
            }
            g2.setClip(new Rectangle(formObject.getBoundingRectangle().x + borderWidth - 1, pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth - 1, formObject.getBoundingRectangle().width - borderWidth * 2 + 2, formObject.getBoundingRectangle().height - borderWidth * 2 + 2));
            for (int i = startingIndex; i != values.length; ++i) {
                int x = formObject.getBoundingRectangle().x + borderWidth + 2;
                int y = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) + borderWidth + metrics.getHeight() - borderWidth;
                FormRenderUtilsG2.renderTextString(g2, formObject, values[i], r, x, y += metrics.getHeight() * (i - startingIndex), borderWidth, justification);
            }
        }
    }

    public static void renderMultilineTextField(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r, String textValue, int page, int borderWidth, int justification, int pageHeight) {
        int x = formObject.getBoundingRectangle().x + borderWidth;
        int y = pageHeight - (formObject.getBoundingRectangle().y + formObject.getBoundingRectangle().height) - borderWidth - borderWidth;
        StringTokenizer tokenizer = new StringTokenizer(textValue, "\n");
        while (tokenizer.hasMoreTokens()) {
            FormRenderUtilsG2.renderTextString(g2, formObject, tokenizer.nextToken(), r, x, y += metrics.getHeight(), borderWidth, justification);
        }
    }

    public static void renderSingleLineTextField(Graphics2D g2, FormObject formObject, FontMetrics metrics, Rectangle2D r, String textValue, int page, int borderWidth, int justification, int pageHeight) {
        int x = formObject.getBoundingRectangle().x + borderWidth;
        int y = pageHeight - formObject.getBoundingRectangle().y - (formObject.getBoundingRectangle().height - metrics.getHeight());
        FormRenderUtilsG2.renderTextString(g2, formObject, textValue, r, x, y, borderWidth, justification);
    }

    private static void renderTextString(Graphics2D g2, FormObject formObject, String textValue, Rectangle2D r, int x, int y, int borderWidth, int justification) {
        switch (justification) {
            case 0: {
                g2.drawString(textValue, (int)((double)x + ((double)(formObject.getBoundingRectangle().width - borderWidth * 2) - r.getWidth()) / 2.0), y);
                break;
            }
            case 4: {
                g2.drawString(textValue, (int)((double)(x + formObject.getBoundingRectangle().width - borderWidth * 2) - r.getWidth()) - 2, y);
                break;
            }
            default: {
                g2.drawString(textValue, x + 2, y);
            }
        }
    }

    public static void renderQuadPoint(Graphics2D g2, FormObject formObject, Color bgColor, int page, int pageHeight) {
        float[] quadPoints = formObject.getFloatArray(1785890247);
        if (quadPoints != null) {
            Color c = g2.getColor();
            Composite com = g2.getComposite();
            for (int i = 0; i != quadPoints.length / 8; ++i) {
                float minX = 0.0f;
                float minY = 0.0f;
                float maxX = 0.0f;
                float maxY = 0.0f;
                for (int j = 0; j != 8; ++j) {
                    if (j < 2) {
                        if (j % 2 == 0) {
                            minX = quadPoints[i * 8 + j];
                            maxX = quadPoints[i * 8 + j];
                            continue;
                        }
                        minY = quadPoints[i * 8 + j];
                        maxY = quadPoints[i * 8 + j];
                        continue;
                    }
                    if (j % 2 == 0) {
                        if (quadPoints[i * 8 + j] < minX) {
                            minX = quadPoints[i * 8 + j];
                        }
                        if (!(quadPoints[i * 8 + j] > maxX)) continue;
                        maxX = quadPoints[i * 8 + j];
                        continue;
                    }
                    if (quadPoints[i * 8 + j] < minY) {
                        minY = quadPoints[i * 8 + j];
                    }
                    if (!(quadPoints[i * 8 + j] > maxY)) continue;
                    maxY = quadPoints[i * 8 + j];
                }
                if (formObject.getParameterConstant(1147962727) == 1919840408) {
                    g2.setColor(bgColor);
                    g2.setComposite(new BlendMode(1451587725, 0.5f));
                    g2.fillRect((int)minX, (int)((float)pageHeight - maxY), (int)(maxX - minX), (int)(maxY - minY));
                }
                g2.setColor(c);
                g2.setComposite(com);
            }
        }
    }

    public static void renderPopupWindow(Graphics2D g2, FormObject formObject, Color bgColor, int page, boolean isPrinting, int pageHeight) {
        String t;
        int lineCount;
        StringTokenizer tokenizer;
        String mStream = formObject.getParentPdfObj().getTextStreamValue(29);
        StringBuffer date = null;
        if (mStream != null) {
            date = new StringBuffer(mStream);
            date.delete(0, 2);
            date.insert(10, ':');
            date.insert(13, ':');
            date.insert(16, ' ');
            String year = date.substring(0, 4);
            String day = date.substring(6, 8);
            date.delete(6, 8);
            date.delete(0, 4);
            date.insert(0, day);
            date.insert(4, year);
            date.insert(2, '/');
            date.insert(5, '/');
            date.insert(10, ' ');
        }
        String subject = formObject.getParentPdfObj().getTextStreamValue(591737402);
        String popupTitle = formObject.getParentPdfObj().getTextStreamValue(36);
        if (popupTitle == null) {
            popupTitle = "";
        }
        String title = "";
        if (subject != null) {
            title = title + subject + '\t';
        }
        if (date != null) {
            title = title + date;
        }
        title = title + '\n' + popupTitle;
        String contents = formObject.getParentPdfObj().getTextStreamValue(1216184967);
        if (contents == null) {
            contents = "";
        }
        if (contents.indexOf(13) != -1) {
            contents = contents.replaceAll("\r", "\n");
        }
        float[] rect = formObject.getFloatArray(573911876);
        int titleBarHeight = 24;
        if (isPrinting) {
            g2.translate(0, 24);
        }
        g2.setColor(Color.WHITE);
        g2.fillRect((int)rect[0], pageHeight - (int)rect[3], (int)(rect[2] - rect[0]), (int)(rect[3] - rect[1]));
        g2.setColor(bgColor);
        g2.fillRect((int)rect[0], pageHeight - (int)rect[3], (int)(rect[2] - rect[0]), 26);
        g2.setColor(Color.BLACK);
        g2.setFont(new Font("Monospaced", 0, 12));
        g2.setFont(g2.getFont().deriveFont(8.0f));
        if (title.indexOf(10) == -1) {
            g2.drawString(title, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + g2.getFont().getSize2D()) + 2);
        } else {
            tokenizer = new StringTokenizer(title, "\n", true);
            lineCount = 1;
            while (tokenizer.hasMoreTokens()) {
                t = tokenizer.nextToken();
                if (!t.equals("\n")) {
                    g2.drawString(t, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + (g2.getFont().getSize2D() + 2.0f) * (float)lineCount));
                    continue;
                }
                ++lineCount;
            }
        }
        g2.setFont(g2.getFont().deriveFont(7.0f));
        if (contents.indexOf(10) == -1) {
            g2.drawString(contents, (int)rect[0], (int)((float)(pageHeight - (int)rect[3]) + g2.getFont().getSize2D() + 24.0f));
        } else {
            tokenizer = new StringTokenizer(contents, "\n", true);
            lineCount = 1;
            while (tokenizer.hasMoreTokens()) {
                t = tokenizer.nextToken();
                if (!t.equals("\n")) {
                    g2.drawString(t, (int)rect[0] + 2, (int)((float)(pageHeight - (int)rect[3]) + (g2.getFont().getSize2D() + 3.0f) * (float)lineCount + 24.0f));
                    continue;
                }
                ++lineCount;
            }
        }
    }
}

