/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.creation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class PopupFactory {
    public static BufferedImage getIcon(PdfObject form) {
        BufferedImage commentIcon = null;
        switch (form.getParameterConstant(1147962727)) {
            case 607471684: {
                commentIcon = PopupFactory.getTextIcon(form);
                break;
            }
            case 1919840408: {
                commentIcon = PopupFactory.getHightlightIcon(form);
            }
        }
        return commentIcon;
    }

    private static BufferedImage getHightlightIcon(PdfObject form) {
        float[] quad;
        float[] f = form.getFloatArray(19);
        Color c = new Color(0);
        if (f != null) {
            switch (f.length) {
                case 0: {
                    break;
                }
                case 1: {
                    c = new Color(f[0], f[0], f[0], 0.5f);
                    break;
                }
                case 3: {
                    c = new Color(f[0], f[1], f[2], 0.5f);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(f, 4);
                    c = new Color(cmyk.getColor().getRGB());
                    c = new Color((float)c.getRed(), (float)c.getGreen(), (float)c.getBlue(), 0.5f);
                    break;
                }
            }
        }
        if ((quad = form.getFloatArray(1785890247)) != null) {
            Rectangle bounds = ((FormObject)form).getBoundingRectangle();
            if (bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) {
                for (int i = 0; i != quad.length; ++i) {
                    if (i % 2 == 0) {
                        if ((float)bounds.x > quad[i]) {
                            bounds.x = (int)quad[i];
                        }
                        if (!((float)(bounds.x + bounds.width) < quad[i])) continue;
                        bounds.width = (int)(quad[i] - (float)bounds.x);
                        continue;
                    }
                    if ((float)bounds.y > quad[i]) {
                        bounds.y = (int)quad[i];
                    }
                    if (!((float)(bounds.y + bounds.height) < quad[i])) continue;
                    bounds.height = (int)(quad[i] - (float)bounds.y);
                }
            }
            BufferedImage icon = new BufferedImage(bounds.width, bounds.height, 6);
            Graphics g = icon.getGraphics();
            if (quad.length >= 8) {
                for (int hi = 0; hi != quad.length; hi += 8) {
                    int x = (int)quad[hi] - bounds.x;
                    int y = (int)quad[hi + 5] - bounds.y;
                    y = bounds.height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                    int width = (int)(quad[hi + 2] - quad[hi]);
                    int height = (int)(quad[hi + 1] - quad[hi + 5]);
                    Rectangle rh = new Rectangle(x, y, width, height);
                    g.setColor(c);
                    g.fillRect(rh.x, rh.y, rh.width, rh.height);
                }
            }
            return icon;
        }
        return null;
    }

    private static BufferedImage getTextIcon(PdfObject form) {
        BufferedImage commentIcon;
        block6: {
            String name = form.getTextStreamValue(506543413);
            if (name == null) {
                name = "Note";
            }
            String iconFile = name.equals("Comment") ? "/org/jpedal/objects/acroforms/res/comment.png" : (name.equals("Check") ? "/org/jpedal/objects/acroforms/res/Check.png" : (name.equals("Checkmark") ? "/org/jpedal/objects/acroforms/res/Checkmark.png" : (name.equals("Circle") ? "/org/jpedal/objects/acroforms/res/Circle.png" : (name.equals("Cross") ? "/org/jpedal/objects/acroforms/res/Cross.png" : (name.equals("CrossHairs") ? "/org/jpedal/objects/acroforms/res/CrossHairs.png" : (name.equals("Help") ? "/org/jpedal/objects/acroforms/res/Help.png" : (name.equals("Insert") ? "/org/jpedal/objects/acroforms/res/InsertText.png" : (name.equals("Key") ? "/org/jpedal/objects/acroforms/res/Key.png" : (name.equals("NewParagraph") ? "/org/jpedal/objects/acroforms/res/NewParagraph.png" : (name.equals("Paragraph") ? "/org/jpedal/objects/acroforms/res/Paragraph.png" : (name.equals("RightArrow") ? "/org/jpedal/objects/acroforms/res/RightArrow.png" : (name.equals("RightPointer") ? "/org/jpedal/objects/acroforms/res/RightPointer.png" : (name.equals("Star") ? "/org/jpedal/objects/acroforms/res/Star.png" : (name.equals("UpLeftArrow") ? "/org/jpedal/objects/acroforms/res/Up-LeftArrow.png" : (name.equals("UpArrow") ? "/org/jpedal/objects/acroforms/res/UpArrow.png" : "/org/jpedal/objects/acroforms/res/TextNote.png")))))))))))))));
            commentIcon = null;
            try {
                commentIcon = ImageIO.read(PopupFactory.class.getResource(iconFile));
            }
            catch (IOException e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        float[] col = form.getFloatArray(19);
        if (col == null) {
            col = new float[]{1.0f, 1.0f, 1.0f};
        }
        Color c = new Color(col[0], col[1], col[2]);
        int rgb = c.getRGB();
        for (int x = 0; x != commentIcon.getWidth(); ++x) {
            for (int y = 0; y != commentIcon.getHeight(); ++y) {
                if (commentIcon.getRGB(x, y) != -256) continue;
                commentIcon.setRGB(x, y, rgb);
            }
        }
        return commentIcon;
    }

    public static void renderFlattenedAnnotation(PdfObject form, DynamicVectorRenderer current, int pageNumber, int rotation) {
        BufferedImage image = PopupFactory.getIcon(form);
        if (image != null) {
            GraphicsState gs = new GraphicsState();
            int iconHeight = image.getHeight();
            int iconWidth = image.getWidth();
            float[] rect = form.getFloatArray(573911876);
            if (form.getParameterConstant(1147962727) == 607471684) {
                rect[2] = rect[0] + (float)iconWidth;
                rect[1] = rect[3] - (float)iconHeight;
                form.setFloatArray(573911876, rect);
            }
            switch (rotation % 360) {
                case 0: {
                    gs.CTM = new float[][]{{iconWidth, 0.0f, 1.0f}, {0.0f, iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = rect[0];
                    gs.y = rect[3] - (float)iconHeight;
                    gs.CTM[2][0] = rect[0];
                    gs.CTM[2][1] = rect[3] - (float)iconHeight;
                    break;
                }
                case 90: {
                    gs.CTM = new float[][]{{0.0f, iconWidth, 1.0f}, {-iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = rect[0] + (float)iconHeight;
                    gs.y = rect[3];
                    gs.CTM[2][0] = rect[0] + (float)iconHeight;
                    gs.CTM[2][1] = rect[3];
                    break;
                }
                case 180: {
                    gs.CTM = new float[][]{{-iconWidth, 0.0f, 1.0f}, {0.0f, -iconHeight, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = rect[0];
                    gs.y = rect[3] + (float)iconHeight;
                    gs.CTM[2][0] = rect[0];
                    gs.CTM[2][1] = rect[3] + (float)iconHeight;
                    break;
                }
                case 270: {
                    gs.CTM = new float[][]{{0.0f, -iconWidth, 1.0f}, {iconHeight, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}};
                    gs.x = rect[0] - (float)iconHeight;
                    gs.y = rect[3];
                    gs.CTM[2][0] = rect[0] - (float)iconHeight;
                    gs.CTM[2][1] = rect[3];
                }
            }
            if (form.getParameterConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111181679);
                current.setGraphicsState(2, gs.getAlpha(2), 1111181679);
            }
            current.drawImage(pageNumber, image, gs, false, form.getObjectRefAsString(), -1);
            if (form.getParameterConstant(1147962727) == 1919840408) {
                current.setGraphicsState(1, gs.getAlpha(1), 1111314299);
                current.setGraphicsState(2, gs.getAlpha(2), 1111314299);
            }
        }
    }
}

