/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.awt.image.BufferedImage;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Callback;
import javax.imageio.ImageIO;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXComboListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXControlListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXFormButtonListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXFormsListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXListListener;
import org.jpedal.objects.acroforms.actions.JavaFX.JavaFXRadioListener;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.acroforms.javafx.JavaFXData;
import org.jpedal.objects.acroforms.javafx.JavaFXDocumentListener;
import org.jpedal.objects.acroforms.javafx.JavaFXImageIcon;
import org.jpedal.objects.acroforms.javafx.PdfJavaFXPopup;
import org.jpedal.objects.acroforms.utils.FormsCSSHelper;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Strip;

public class JavaFXFormFactory
extends GenericFormFactory
implements FormFactory {
    private Button setupAnnotationButton(FormObject form) {
        Button but = new Button();
        StringBuilder buttonStyle = new StringBuilder(200);
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)but);
        buttonStyle.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;-fx-border-radius:0;-fx-background-radius:0;");
        this.setupButton((ButtonBase)but, form, controlListener);
        this.setupUniversalFeatures((Control)but, form, buttonStyle, controlListener);
        but.setStyle(buttonStyle.toString());
        return but;
    }

    private Button createAnntoationHighlight(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        Color color = JavaFXFormFactory.getAnnotationColor(form);
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)form.getBoundingRectangle().width, (double)form.getBoundingRectangle().height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        if (quad.length >= 8) {
            for (int hi = 0; hi != quad.length; hi += 8) {
                int x = (int)quad[hi] - form.getBoundingRectangle().x;
                int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                int width = (int)(quad[hi + 2] - quad[hi]);
                int height = (int)(quad[hi + 1] - quad[hi + 5]);
                try {
                    gc.setFill((Paint)color);
                    gc.fillRect((double)x, (double)y, (double)width, (double)height);
                    but.setGraphic((Node)new JavaFXImageIcon((ButtonBase)but, (PdfObject)form, (Image)canvas.snapshot(params, null), 0));
                    continue;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return but;
    }

    private Button createAnnotationFreeText(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        but.setText(form.getTextStreamValue(1216184967));
        return but;
    }

    private Button createAnnotationText(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        String name = form.getTextStreamValue(506543413);
        BufferedImage commentIcon = this.getAnnotationTextIcon(form, name);
        float[] rect = form.getFloatArray(573911876);
        rect[1] = rect[3] - (float)commentIcon.getHeight();
        rect[2] = rect[0] + (float)commentIcon.getWidth();
        form.setFloatArray(573911876, rect);
        but.setGraphic((Node)new JavaFXImageIcon((ButtonBase)but, (PdfObject)form, commentIcon, 0));
        return but;
    }

    private Pane createAnnotationPopup(FormObject form) {
        Pane comp = (Pane)this.getPopupComponent(form, this.pageData.getCropBoxWidth(form.getPageNumber()));
        form.setGUIComponent(comp, 5);
        comp.setVisible(form.getBoolean(524301630));
        return comp;
    }

    private Button createAnnotationUnderline(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        Color color = JavaFXFormFactory.getAnnotationColor(form);
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)form.getBoundingRectangle().width, (double)form.getBoundingRectangle().height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        if (quad.length >= 8) {
            for (int hi = 0; hi != quad.length; hi += 8) {
                int x = (int)quad[hi] - form.getBoundingRectangle().x;
                int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                int width = (int)(quad[hi + 2] - quad[hi]);
                int height = (int)(quad[hi + 1] - quad[hi + 5]);
                try {
                    gc.setFill((Paint)new Color(0.0, 0.0, 0.0, 0.0));
                    gc.fillRect((double)x, (double)y, (double)width, (double)height);
                    gc.setFill((Paint)color);
                    gc.fillRect((double)x, (double)(y + height - 1), (double)width, 1.0);
                    but.setGraphic((Node)new JavaFXImageIcon((ButtonBase)but, (PdfObject)form, (Image)canvas.snapshot(params, null), 0));
                    continue;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return but;
    }

    private Button createAnnotationInk(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        but.setTooltip(new Tooltip(form.getTextStreamValue(1216184967)));
        Object[] InkListArray = form.getObjectArray(475169151);
        float[] r = JavaFXFormFactory.scanInkListTree(InkListArray, form, null);
        form.setFloatArray(573911876, new float[]{r[0], r[1], r[2], r[3]});
        Canvas canvas = new Canvas((double)form.getBoundingRectangle().width, (double)form.getBoundingRectangle().height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        JavaFXFormFactory.scanInkListTree(InkListArray, form, gc);
        but.setGraphic((Node)new JavaFXImageIcon((ButtonBase)but, (PdfObject)form, (Image)canvas.snapshot(params, null), 0));
        return but;
    }

    private Button createAnnotationStrikeOut(FormObject form) {
        Button but = this.setupAnnotationButton(form);
        Color color = JavaFXFormFactory.getAnnotationColor(form);
        float[] quad = form.getFloatArray(1785890247);
        if (quad == null) {
            quad = form.getFloatArray(573911876);
        }
        Canvas canvas = new Canvas((double)form.getBoundingRectangle().width, (double)form.getBoundingRectangle().height);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        if (quad.length >= 8) {
            for (int hi = 0; hi != quad.length; hi += 8) {
                int x = (int)quad[hi] - form.getBoundingRectangle().x;
                int y = (int)quad[hi + 5] - form.getBoundingRectangle().y;
                y = form.getBoundingRectangle().height - y - (int)(quad[hi + 1] - quad[hi + 5]);
                int width = (int)(quad[hi + 2] - quad[hi]);
                int height = (int)(quad[hi + 1] - quad[hi + 5]);
                try {
                    gc.setFill((Paint)Color.TRANSPARENT);
                    gc.fillRect(0.0, 0.0, (double)width, (double)height);
                    gc.setFill((Paint)color);
                    gc.fillRect((double)x, (double)(y + height / 2), (double)width, 1.0);
                    but.setGraphic((Node)new JavaFXImageIcon((ButtonBase)but, (PdfObject)form, (Image)canvas.snapshot(params, null), 0));
                    continue;
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        return but;
    }

    private static Color getAnnotationColor(FormObject form) {
        float[] formColor = form.getFloatArray(19);
        Color color = Color.TRANSPARENT;
        if (formColor != null) {
            switch (formColor.length) {
                case 0: {
                    break;
                }
                case 1: {
                    color = new Color((double)formColor[0], (double)formColor[0], (double)formColor[0], 1.0);
                    break;
                }
                case 3: {
                    color = new Color((double)formColor[0], (double)formColor[1], (double)formColor[2], 1.0);
                    break;
                }
                case 4: {
                    DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                    cmyk.setColor(formColor, 4);
                    int rgb = cmyk.getColor().getRGB();
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    color = new Color((double)r, (double)g, (double)b, 1.0);
                    break;
                }
            }
        }
        return color;
    }

    private BufferedImage getAnnotationTextIcon(FormObject form, String name) {
        BufferedImage commentIcon;
        block6: {
            commentIcon = null;
            if (name == null) {
                name = "Note";
            }
            try {
                commentIcon = name.equals("Comment") ? ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/comment.png")) : ImageIO.read(this.getClass().getResource("/org/jpedal/objects/acroforms/res/note.png"));
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block6;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        float[] col = form.getFloatArray(19);
        if (col != null) {
            PdfColor c = new PdfColor(col[0], col[1], col[2]);
            int rgb = c.getRGB();
            for (int x = 0; x != commentIcon.getWidth(); ++x) {
                for (int y = 0; y != commentIcon.getHeight(); ++y) {
                    if (commentIcon.getRGB(x, y) != -256) continue;
                    commentIcon.setRGB(x, y, rgb);
                }
            }
        }
        return commentIcon;
    }

    @Override
    public Object annotationButton(FormObject form) {
        int subtype = form.getParameterConstant(1147962727);
        if (subtype == 1061176672) {
            return this.createAnnotationPopup(form);
        }
        if (!form.isAppearanceUsed()) {
            switch (subtype) {
                case 607471684: {
                    return this.createAnnotationText(form);
                }
                case 980909433: {
                    return this.createAnnotationFreeText(form);
                }
                case 1919840408: {
                    return this.createAnntoationHighlight(form);
                }
                case 2053993372: {
                    return this.createAnnotationUnderline(form);
                }
                case 1654331: {
                    return this.createAnnotationInk(form);
                }
                case 2036432546: {
                    return this.createAnnotationStrikeOut(form);
                }
            }
        }
        return this.setupAnnotationButton(form);
    }

    static float[] curveInk(float[] points) {
        double smooth_value = 1.0;
        int currentIndex = 0;
        float[] returnPoints = new float[(points.length - 2) / 2 * 8];
        for (int i = 0; i < points.length; i += 2) {
            double[] cps;
            double y3;
            double x3;
            double y2;
            double x2;
            double y1;
            double x1;
            double y0;
            double x0;
            if (i == 0) {
                x0 = points[i];
                y0 = points[i + 1];
                x1 = points[i];
                y1 = points[i + 1];
                x2 = points[i + 2];
                y2 = points[i + 3];
                x3 = points[i + 4];
                y3 = points[i + 5];
                cps = JavaFXFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
                returnPoints[currentIndex] = (float)x1;
                returnPoints[++currentIndex] = (float)y1;
                returnPoints[++currentIndex] = (float)cps[0];
                returnPoints[++currentIndex] = (float)cps[1];
                returnPoints[++currentIndex] = (float)cps[2];
                returnPoints[++currentIndex] = (float)cps[3];
                returnPoints[++currentIndex] = (float)x2;
                returnPoints[++currentIndex] = (float)y2;
                ++currentIndex;
            }
            if (i + 6 >= points.length) {
                x0 = points[i];
                y0 = points[i + 1];
                x1 = points[i + 2];
                y1 = points[i + 3];
                x2 = points[i + 4];
                y2 = points[i + 5];
                x3 = points[i + 4];
                y3 = points[i + 5];
                cps = JavaFXFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
                returnPoints[currentIndex] = (float)x1;
                returnPoints[++currentIndex] = (float)y1;
                returnPoints[++currentIndex] = (float)cps[0];
                returnPoints[++currentIndex] = (float)cps[1];
                returnPoints[++currentIndex] = (float)cps[2];
                returnPoints[++currentIndex] = (float)cps[3];
                returnPoints[++currentIndex] = (float)x2;
                returnPoints[++currentIndex] = (float)y2;
                break;
            }
            x0 = points[i];
            y0 = points[i + 1];
            x1 = points[i + 2];
            y1 = points[i + 3];
            x2 = points[i + 4];
            y2 = points[i + 5];
            x3 = points[i + 6];
            y3 = points[i + 7];
            cps = JavaFXFormFactory.findControlPoint(x0, y0, x1, y1, x2, y2, x3, y3, 1.0);
            returnPoints[currentIndex] = (float)x1;
            returnPoints[++currentIndex] = (float)y1;
            returnPoints[++currentIndex] = (float)cps[0];
            returnPoints[++currentIndex] = (float)cps[1];
            returnPoints[++currentIndex] = (float)cps[2];
            returnPoints[++currentIndex] = (float)cps[3];
            returnPoints[++currentIndex] = (float)x2;
            returnPoints[++currentIndex] = (float)y2;
            ++currentIndex;
        }
        return returnPoints;
    }

    private static double[] findControlPoint(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3, double smooth_value) {
        double xc1 = (x0 + x1) / 2.0;
        double yc1 = (y0 + y1) / 2.0;
        double xc2 = (x1 + x2) / 2.0;
        double yc2 = (y1 + y2) / 2.0;
        double xc3 = (x2 + x3) / 2.0;
        double yc3 = (y2 + y3) / 2.0;
        double len1 = Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
        double len2 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        double len3 = Math.sqrt((x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2));
        double k1 = len1 / (len1 + len2);
        double k2 = len2 / (len2 + len3);
        double xm1 = xc1 + (xc2 - xc1) * k1;
        double ym1 = yc1 + (yc2 - yc1) * k1;
        double xm2 = xc2 + (xc3 - xc2) * k2;
        double ym2 = yc2 + (yc3 - yc2) * k2;
        double ctrl1_x = xm1 + (xc2 - xm1) * smooth_value + x1 - xm1;
        double ctrl1_y = ym1 + (yc2 - ym1) * smooth_value + y1 - ym1;
        double ctrl2_x = xm2 + (xc2 - xm2) * smooth_value + x2 - xm2;
        double ctrl2_y = ym2 + (yc2 - ym2) * smooth_value + y2 - ym2;
        return new double[]{ctrl1_x, ctrl1_y, ctrl2_x, ctrl2_y};
    }

    private static float[] scanInkListTree(Object[] InkListArray, FormObject form, GraphicsContext gc) {
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        float[] vals = null;
        if (InkListArray != null) {
            int count = InkListArray.length;
            boolean isFirstPoint = true;
            if (gc != null) {
                float[] underlineColor = form.getFloatArray(19);
                Color c1 = Color.TRANSPARENT;
                if (underlineColor != null) {
                    switch (underlineColor.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            c1 = new Color((double)underlineColor[0], (double)underlineColor[0], (double)underlineColor[0], 1.0);
                            break;
                        }
                        case 3: {
                            c1 = new Color((double)underlineColor[0], (double)underlineColor[1], (double)underlineColor[2], 1.0);
                            break;
                        }
                        case 4: {
                            DeviceCMYKColorSpace cmyk = new DeviceCMYKColorSpace();
                            cmyk.setColor(underlineColor, 4);
                            int rgb = cmyk.getColor().getRGB();
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb & 0xFF;
                            c1 = new Color((double)r, (double)g, (double)b, 1.0);
                            break;
                        }
                    }
                }
                gc.setFill((Paint)Color.TRANSPARENT);
                gc.fillRect(0.0, 0.0, (double)form.getBoundingRectangle().width, (double)form.getBoundingRectangle().height);
                gc.setStroke((Paint)c1);
            }
            for (int i = 0; i < count; ++i) {
                if (InkListArray[i] instanceof byte[]) {
                    byte[] decodeByteData = (byte[])InkListArray[i];
                    if (vals == null) {
                        vals = new float[count];
                    }
                    if (decodeByteData == null) continue;
                    String val = new String(decodeByteData);
                    float v = Float.parseFloat(val);
                    switch (i % 2) {
                        case 0: {
                            float x;
                            if (isFirstPoint) {
                                minX = v;
                                maxX = v;
                            } else {
                                if (v < minX) {
                                    minX = v;
                                }
                                if (v > maxX) {
                                    maxX = v;
                                }
                            }
                            vals[i] = x = v - (float)form.getBoundingRectangle().x;
                            break;
                        }
                        case 1: {
                            float y;
                            if (isFirstPoint) {
                                minY = v;
                                maxY = v;
                                isFirstPoint = false;
                            } else {
                                if (v < minY) {
                                    minY = v;
                                }
                                if (v > maxY) {
                                    maxY = v;
                                }
                            }
                            vals[i] = y = (float)form.getBoundingRectangle().height - (v - (float)form.getBoundingRectangle().y);
                        }
                    }
                    continue;
                }
                float[] r = JavaFXFormFactory.scanInkListTree((Object[])InkListArray[i], form, gc);
                if (isFirstPoint) {
                    minX = r[0];
                    maxX = r[2];
                    minY = r[1];
                    maxY = r[3];
                    continue;
                }
                if (r[0] < minX) {
                    minX = r[0];
                }
                if (r[2] > maxX) {
                    maxX = r[2];
                }
                if (r[1] < minY) {
                    minY = r[1];
                }
                if (!(r[3] > maxY)) continue;
                maxY = r[3];
            }
        }
        if (vals != null) {
            float[] values = JavaFXFormFactory.curveInk(vals);
            for (int i = 0; i < values.length; ++i) {
                if (i % 2 == 0) {
                    if (values[i] < minX) {
                        minX = values[i];
                    }
                    if (!(values[i] > maxX)) continue;
                    maxX = values[i];
                    continue;
                }
                if (values[i] < minY) {
                    minY = values[i];
                }
                if (!(values[i] > maxY)) continue;
                maxY = values[i];
            }
            float xOffset = 0.0f;
            float yOffset = 0.0f;
            if (minX < 0.0f) {
                xOffset = Math.abs(minX);
            }
            if (minY < 0.0f) {
                yOffset = Math.abs(minY);
            }
            minX += xOffset;
            maxX += xOffset;
            minY += yOffset;
            maxY += yOffset;
            if (gc != null) {
                gc.setLineWidth((double)1.52f);
                gc.setLineCap(StrokeLineCap.ROUND);
                gc.setLineJoin(StrokeLineJoin.ROUND);
                for (int i = 0; i < values.length; i += 8) {
                    gc.beginPath();
                    gc.moveTo((double)(values[i] + xOffset), (double)(values[i + 1] + yOffset));
                    gc.bezierCurveTo((double)(values[i + 2] + xOffset), (double)(values[i + 3] + yOffset), (double)(values[i + 4] + xOffset), (double)(values[i + 5] + yOffset), (double)(values[i + 6] + xOffset), (double)(values[i + 7] + yOffset));
                    gc.fill();
                    gc.stroke();
                    gc.closePath();
                }
            }
        }
        return new float[]{minX, minY, maxX, maxY};
    }

    @Override
    public Object comboBox(FormObject form) {
        ObservableList itemsNew = form.getItemsList() == null ? null : FXCollections.observableArrayList((Object[])form.getItemsList());
        StringBuilder styleBuilder = new StringBuilder(200);
        final ComboBox combo = itemsNew == null ? new ComboBox() : new ComboBox(itemsNew);
        boolean readonly = false;
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)combo);
        boolean[] flags = form.getFieldFlags();
        combo.setEditable(true);
        if (!flags[19]) {
            combo.getEditor().setEditable(false);
            combo.getEditor().setCursor(Cursor.DEFAULT);
            readonly = true;
        }
        if (flags[1]) {
            combo.setDisable(true);
            combo.getEditor().setEditable(false);
            combo.getEditor().setCursor(Cursor.DEFAULT);
            readonly = true;
        }
        String textValue = form.getSelectedItem();
        if (form.getValuesMap(true) != null) {
            combo.getSelectionModel().select((Object)textValue);
        } else {
            combo.getSelectionModel().select((Object)textValue);
        }
        int selectionIndex = combo.getSelectionModel().getSelectedIndex();
        Object selectedItem = combo.getSelectionModel().getSelectedItem();
        form.setSelection(new Object[]{selectedItem}, selectedItem != null ? selectedItem.toString() : null, new int[]{selectionIndex}, selectionIndex);
        this.setupUniversalFeatures((Control)combo, form, styleBuilder, controlListener);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        this.addFont(form, false, false, styleBuilder);
        combo.getStyleClass().add((Object)"formsComboBox");
        combo.setStyle(styleBuilder.toString());
        final boolean isReadonly = readonly;
        combo.getEditor().setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){
            boolean toggle;

            public void handle(MouseEvent event) {
                if (isReadonly) {
                    if (this.toggle) {
                        combo.hide();
                    } else {
                        combo.show();
                    }
                    this.toggle = !this.toggle;
                }
            }
        });
        int[] textColor = FormsCSSHelper.getTextColor(form);
        if (textColor != null) {
            final String textFill = String.format("-fx-text-fill:rgb(%d, %d, %d);", textColor[0], textColor[1], textColor[2]);
            combo.getEditor().setStyle(textFill);
            combo.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> param) {
                    return new ListCell<String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setStyle(textFill);
                            this.setText(item);
                        }
                    };
                }
            });
        }
        combo.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new JavaFXComboListener(combo, form));
        return combo;
    }

    @Override
    public Object checkBoxBut(FormObject form) {
        ToggleButton checkBut = new ToggleButton();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)checkBut);
        StringBuilder styleBuilder = new StringBuilder(200);
        checkBut.setUserData((Object)CHECKBOXBUTTON);
        this.setupUniversalFeatures((Control)checkBut, form, styleBuilder, controlListener);
        this.setupButton((ButtonBase)checkBut, form, controlListener);
        this.setupToggleGroup(form, checkBut);
        this.addFont(form, false, false, styleBuilder);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            checkBut.setDisable(true);
        }
        styleBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        checkBut.setStyle(styleBuilder.toString());
        return checkBut;
    }

    @Override
    public Object listField(FormObject form) {
        ObservableList items = FXCollections.observableArrayList((Object[])form.getItemsList());
        ListView lists = items == null ? new ListView() : new ListView(items);
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)lists);
        StringBuilder styleBuilder = new StringBuilder(200);
        if (!form.getFieldFlags()[22]) {
            lists.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        }
        if (form.getSelectionIndices() != null) {
            lists.getSelectionModel().selectFirst();
        } else if (form.getValuesMap(true) != null) {
            lists.getSelectionModel().select(form.getValuesMap(true).get(form.getSelectedItem()));
        } else {
            lists.getSelectionModel().select((Object)form.getSelectedItem());
        }
        int selectionIndex = lists.getSelectionModel().getSelectedIndex();
        form.setSelection(new Object[]{lists.getSelectionModel().getSelectedItem()}, lists.getSelectionModel().getSelectedItem().toString(), new int[]{selectionIndex}, selectionIndex);
        this.setupUniversalFeatures((Control)lists, form, styleBuilder, controlListener);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        this.addFont(form, true, true, styleBuilder);
        lists.getStyleClass().add((Object)"formsListBox");
        lists.setStyle(styleBuilder.toString());
        lists.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new JavaFXListListener(lists, form));
        return lists;
    }

    @Override
    public Object multiLinePassword(FormObject form) {
        boolean[] flags;
        final PasswordField multipass = new PasswordField();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)multipass);
        String textValue = form.getTextString();
        StringBuilder styleBuilder = new StringBuilder(200);
        final int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            multipass.setText(textValue);
            multipass.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (newValue.length() >= maxLength) {
                        multipass.setText(oldValue);
                    }
                }
            });
        }
        if ((flags = form.getFieldFlags()) != null && flags[1]) {
            multipass.setEditable(false);
        }
        this.setupUniversalFeatures((Control)multipass, form, styleBuilder, controlListener);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        this.addFont(form, true, true, styleBuilder);
        JavaFXFormFactory.setupTextFeatures((TextField)multipass, form);
        JavaFXFormFactory.setToolTip(form, (Control)multipass);
        multipass.getStyleClass().add((Object)"formsMultiLine");
        multipass.setStyle(styleBuilder.toString());
        return multipass;
    }

    @Override
    public Object multiLineText(FormObject form) {
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        TextArea comp = new TextArea(form.getTextString());
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)comp);
        StringBuilder styleBuilder = new StringBuilder(200);
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            if (form.isXFAObject()) {
                JavaFXFormFactory.setToolTip(form, (Control)comp);
                comp.setEditable(false);
            } else {
                JavaFXFormFactory.setToolTip(form, (Control)comp);
                comp.setEditable(false);
            }
        } else {
            JavaFXFormFactory.setToolTip(form, (Control)comp);
        }
        comp.setWrapText(true);
        this.setupUniversalFeatures((Control)comp, form, styleBuilder, controlListener);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        this.addFont(form, true, true, styleBuilder);
        comp.getStyleClass().add((Object)"formsMultiLine");
        comp.setStyle(styleBuilder.toString());
        return comp;
    }

    @Override
    public Object signature(FormObject form) {
        StringBuilder styleBuilder = new StringBuilder(200);
        Button sigBut = new Button();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)sigBut);
        String backgroundColor = !form.isAppearanceUsed() ? "rgb(221, 228, 255,0.7)" : "transparent";
        this.setupUniversalFeatures((Control)sigBut, form, styleBuilder, controlListener);
        this.setupButton((ButtonBase)sigBut, form, controlListener);
        styleBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:").append(backgroundColor).append(';');
        sigBut.setStyle(styleBuilder.toString());
        return sigBut;
    }

    @Override
    public Object pushBut(FormObject form) {
        Button push = new Button();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)push);
        StringBuilder styleBuilder = new StringBuilder(200);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            push.setDisable(true);
        }
        this.setupUniversalFeatures((Control)push, form, styleBuilder, controlListener);
        this.setupButton((ButtonBase)push, form, controlListener);
        this.addFont(form, false, false, styleBuilder);
        styleBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        push.setStyle(styleBuilder.toString());
        return push;
    }

    @Override
    public Object radioBut(FormObject form) {
        ToggleButton radioBut = new ToggleButton();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)radioBut);
        StringBuilder styleBuilder = new StringBuilder(200);
        radioBut.setUserData((Object)RADIOBUTTON);
        boolean[] flags = form.getFieldFlags();
        if (flags != null && flags[1]) {
            radioBut.setDisable(true);
        }
        this.setupUniversalFeatures((Control)radioBut, form, styleBuilder, controlListener);
        this.setupButton((ButtonBase)radioBut, form, controlListener);
        this.setupToggleGroup(form, radioBut);
        this.addFont(form, false, false, styleBuilder);
        styleBuilder.append("-fx-padding:0;-fx-border:none;-fx-background-color:transparent;");
        radioBut.selectedProperty().addListener((ChangeListener)new JavaFXRadioListener(radioBut, form));
        radioBut.setStyle(styleBuilder.toString());
        return radioBut;
    }

    @Override
    public Object singleLinePassword(FormObject form) {
        boolean[] flags;
        final PasswordField newPassword = new PasswordField();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)newPassword);
        StringBuilder styleBuilder = new StringBuilder(200);
        final int maxLength = form.getInt(1209815663);
        if (maxLength != -1) {
            newPassword.getLength();
            newPassword.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (newValue.length() >= maxLength) {
                        newPassword.setText(oldValue);
                    }
                }
            });
        }
        if ((flags = form.getFieldFlags()) != null && flags[1]) {
            newPassword.setEditable(false);
        }
        this.setupUniversalFeatures((Control)newPassword, form, styleBuilder, controlListener);
        this.addFont(form, false, false, styleBuilder);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        JavaFXFormFactory.setToolTip(form, (Control)newPassword);
        newPassword.getStyleClass().add((Object)"formsSingleline");
        newPassword.setStyle(styleBuilder.toString());
        return newPassword;
    }

    @Override
    public Object singleLineText(FormObject form) {
        boolean[] flags = form.getFieldFlags();
        boolean[] characteristics = form.getCharacteristics();
        TextField newComp = new TextField();
        JavaFXControlListener controlListener = new JavaFXControlListener((Control)newComp);
        StringBuilder styleBuilder = new StringBuilder(200);
        String aptext = this.readAPimagesForText(form);
        if (aptext != null && aptext.contains("&#")) {
            aptext = Strip.stripXML(aptext, true).toString();
        }
        if (aptext != null && !aptext.equals(form.getTextStreamValue(38))) {
            form.setTextStreamValue(38, aptext);
        }
        newComp.setText(form.getTextString());
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            newComp.setEditable(false);
        }
        this.setupUniversalFeatures((Control)newComp, form, styleBuilder, controlListener);
        JavaFXFormFactory.setupTextFeatures(newComp, form);
        JavaFXFormFactory.setToolTip(form, (Control)newComp);
        JavaFXFormFactory.setBorder(form, styleBuilder);
        this.addFont(form, false, false, styleBuilder);
        newComp.getStyleClass().add((Object)"formsSingleline");
        newComp.setStyle(styleBuilder.toString());
        return newComp;
    }

    private static void setupTextFeatures(TextField textcomp, FormObject form) {
        if (form.getAlignment() != -1) {
            switch (form.getAlignment()) {
                case 0: {
                    textcomp.setAlignment(Pos.CENTER);
                    break;
                }
                case 2: {
                    textcomp.setAlignment(Pos.CENTER_LEFT);
                    break;
                }
                case 4: {
                    textcomp.setAlignment(Pos.CENTER_RIGHT);
                    break;
                }
            }
        }
        textcomp.setOnAction((EventHandler)new JavaFXDocumentListener(textcomp, form));
    }

    private void setupButton(ButtonBase comp, FormObject form, JavaFXControlListener controlListener) {
        int textPosition;
        String normalCaption = form.getDictionary(7451).getTextStreamValue(4881);
        comp.setText(normalCaption);
        String downCaption = form.getDictionary(7451).getTextStreamValue(4371);
        String rolloverCaption = form.getDictionary(7451).getTextStreamValue(8723);
        if (!form.isAppearanceUsed() && (downCaption != null && !downCaption.isEmpty() || rolloverCaption != null && !rolloverCaption.isEmpty())) {
            controlListener.addMouseListener(new JavaFXFormButtonListener(normalCaption, rolloverCaption, downCaption));
        }
        if (form.isAppearanceUsed()) {
            this.setAPImages(form, comp, controlListener);
        }
        if ((textPosition = form.getTextPosition()) != -1) {
            switch (textPosition) {
                case 0: {
                    comp.setGraphic(null);
                    comp.setText(normalCaption);
                    break;
                }
                case 1: {
                    comp.setText(null);
                    break;
                }
                case 2: {
                    comp.setContentDisplay(ContentDisplay.TOP);
                    break;
                }
                case 3: {
                    comp.setContentDisplay(ContentDisplay.BOTTOM);
                    break;
                }
                case 4: {
                    comp.setContentDisplay(ContentDisplay.LEFT);
                    break;
                }
                case 5: {
                    comp.setContentDisplay(ContentDisplay.RIGHT);
                    break;
                }
                case 6: {
                    comp.setText(null);
                }
            }
        }
        controlListener.addMouseListener((EventHandler<MouseEvent>)((EventHandler)this.formsActionHandler.setHoverCursor()));
    }

    private void setupToggleGroup(FormObject form, ToggleButton comp) {
        ToggleGroup tg;
        String name = form.getTextStreamValue(36);
        if (name == null) {
            name = "";
        }
        if ((tg = (ToggleGroup)this.groups.get(name)) == null) {
            tg = new ToggleGroup();
            this.groups.put(name, tg);
            this.firstButtons.put(name, comp);
            final ToggleGroup group = tg;
            tg.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                    int newIndex = group.getToggles().indexOf((Object)newValue);
                    int oldIndex = group.getToggles().indexOf((Object)oldValue);
                    if (oldIndex > -1 && newIndex == -1 && oldValue.getUserData().equals(FormFactory.RADIOBUTTON)) {
                        oldValue.setSelected(true);
                    }
                }
            });
        } else {
            ToggleButton firstButton = (ToggleButton)this.firstButtons.get(name);
            if (firstButton != null) {
                this.firstButtons.remove(name);
                tg.getToggles().add((Object)firstButton);
            }
            tg.getToggles().add((Object)comp);
        }
    }

    private void setAPImages(FormObject form, ButtonBase comp, JavaFXControlListener controlListener) {
        PdfObject val;
        Map otherValues;
        JavaFXImageIcon normal = null;
        JavaFXImageIcon selected = null;
        JavaFXImageIcon rollover = null;
        JavaFXImageIcon rolloverSelected = null;
        JavaFXImageIcon down = null;
        PdfObject APobjN = form.getDictionary(4384).getDictionary(30);
        PdfObject APobjD = form.getDictionary(4384).getDictionary(20);
        PdfObject APobjR = form.getDictionary(4384).getDictionary(34);
        PdfObject normalOffDic = null;
        PdfObject normalOnDic = null;
        PdfObject downOffDic = null;
        PdfObject downOnDic = null;
        PdfObject rollOffDic = null;
        PdfObject rollOnDic = null;
        int offsetDownImage = 0;
        int subtype = form.getParameterConstant(1147962727);
        if (APobjN != null || form.getDictionary(7451).getDictionary(25) != null) {
            if (APobjN.getDictionary(2045494) != null) {
                normalOffDic = APobjN.getDictionary(2045494);
            } else if (form.getDictionary(7451).getDictionary(25) != null && form.getDictionary(7451).getDictionary(6422) == null) {
                normalOffDic = form.getDictionary(7451).getDictionary(25);
            } else if (APobjN.getDecodedStream() != null) {
                normalOffDic = APobjN;
            }
            if (normalOffDic != null) {
                comp.setText(null);
                normal = new JavaFXImageIcon(comp, form, normalOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0);
            }
            if (APobjN.getDictionary(7998) != null) {
                normalOnDic = APobjN.getDictionary(7998);
                form.setNormalOnState("On");
            } else {
                otherValues = APobjN.getOtherDictionaries();
                if (otherValues != null && !otherValues.isEmpty()) {
                    for (String key : otherValues.keySet()) {
                        normalOnDic = val = (PdfObject)otherValues.get(key);
                        form.setNormalOnState(key);
                    }
                }
            }
            if (normalOnDic != null) {
                comp.setText(null);
                selected = new JavaFXImageIcon(comp, form, normalOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0);
                if (normal == null) {
                    normal = new JavaFXImageIcon(comp, (PdfObject)form, (Image)null, form.getDictionary(7451).getInt(34));
                }
            }
        }
        if (!form.hasNoDownIcon()) {
            if (form.hasOffsetDownIcon()) {
                offsetDownImage = 1;
            } else if (form.hasInvertDownIcon()) {
                offsetDownImage = 2;
            }
            if (offsetDownImage != 0) {
                if (normalOffDic != null) {
                    if (normalOnDic != null) {
                        downOffDic = normalOffDic;
                        downOnDic = normalOnDic;
                    } else {
                        downOffDic = normalOffDic;
                    }
                } else if (normalOnDic != null) {
                    downOffDic = normalOnDic;
                }
            }
            if (APobjD != null) {
                if (APobjD.getDecodedStream() != null) {
                    downOffDic = APobjD;
                } else if (APobjD.getDictionary(2045494) != null) {
                    downOffDic = APobjD.getDictionary(2045494);
                }
                if (APobjD.getDictionary(7998) != null) {
                    downOnDic = APobjD.getDictionary(7998);
                } else {
                    otherValues = APobjD.getOtherDictionaries();
                    if (otherValues != null && !otherValues.isEmpty()) {
                        for (String key : otherValues.keySet()) {
                            downOnDic = val = (PdfObject)otherValues.get(key);
                        }
                    }
                }
            }
            if (downOffDic == null || downOnDic == null) {
                if (downOffDic != null) {
                    down = new JavaFXImageIcon(comp, form, downOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, offsetDownImage);
                } else if (downOnDic != null) {
                    down = new JavaFXImageIcon(comp, form, downOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, offsetDownImage);
                }
            } else {
                down = new JavaFXImageIcon(comp, form, downOnDic, downOffDic, form.getDictionary(7451).getInt(34), comp.isPressed() ? 1 : 0, this.currentPdfFile, subtype, offsetDownImage);
            }
        }
        if (APobjR != null) {
            if (APobjR.getDecodedStream() != null) {
                rollOffDic = APobjR;
            } else if (APobjR.getDictionary(2045494) != null) {
                rollOffDic = APobjR.getDictionary(2045494);
            }
            if (rollOffDic != null) {
                rollover = new JavaFXImageIcon(comp, form, rollOffDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0);
            }
            if (APobjR.getDictionary(7998) != null) {
                rollOnDic = APobjR.getDictionary(7998);
            } else {
                otherValues = APobjR.getOtherDictionaries();
                if (otherValues != null && !otherValues.isEmpty()) {
                    for (String key : otherValues.keySet()) {
                        rollOnDic = val = (PdfObject)otherValues.get(key);
                    }
                }
            }
            if (rollOnDic != null) {
                rolloverSelected = new JavaFXImageIcon(comp, form, rollOnDic, form.getDictionary(7451).getInt(34), this.currentPdfFile, subtype, 0);
                if (rollover == null) {
                    rollover = new JavaFXImageIcon(comp, (PdfObject)form, (Image)null, form.getDictionary(7451).getInt(34));
                }
            }
        }
        if (form.isSelected() && down != null && comp instanceof ToggleButton) {
            ((ToggleButton)comp).setSelected(true);
            down.swapImage(true);
        }
        JavaFXFormFactory.createListener(comp, normal, down, selected, rollover, rolloverSelected, controlListener);
    }

    private static void createListener(final ButtonBase comp, final JavaFXImageIcon normal, final JavaFXImageIcon down, final JavaFXImageIcon selected, final JavaFXImageIcon rollover, final JavaFXImageIcon rolloverSelected, JavaFXControlListener controlListener) {
        final boolean isToggleButton = comp instanceof ToggleButton;
        comp.setGraphic((Node)normal);
        if (down != null) {
            controlListener.addOnMousePressedListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    comp.setText(null);
                    comp.setGraphic((Node)down);
                }
            });
            controlListener.addOnMouseReleasedListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    JavaFXFormFactory.resetToDefault(isToggleButton, selected, normal, comp);
                }
            });
            controlListener.addOnTouchPressedListener(new EventHandler<TouchEvent>(){

                public void handle(TouchEvent event) {
                    comp.setText(null);
                    comp.setGraphic((Node)down);
                }
            });
            controlListener.addOnTouchReleasedListener(new EventHandler<TouchEvent>(){

                public void handle(TouchEvent event) {
                    JavaFXFormFactory.resetToDefault(isToggleButton, selected, normal, comp);
                }
            });
        }
        controlListener.addOnMouseExitedListener(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                JavaFXFormFactory.resetToDefault(isToggleButton, selected, normal, comp);
            }
        });
        if (rollover != null) {
            controlListener.addOnMouseEnteredListener(new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    comp.setText(null);
                    if (isToggleButton && ((ToggleButton)comp).isSelected() && rolloverSelected != null) {
                        comp.setGraphic((Node)rolloverSelected);
                    } else {
                        comp.setGraphic((Node)rollover);
                    }
                }
            });
        }
        if (isToggleButton) {
            ToggleButton tb = (ToggleButton)comp;
            if (tb.isSelected()) {
                tb.setGraphic((Node)selected);
            }
            tb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (down != null) {
                        down.swapImage(newValue);
                    }
                    selected.swapImage(newValue);
                    JavaFXFormFactory.resetToDefault(isToggleButton, selected, normal, comp);
                }
            });
        }
    }

    private static void resetToDefault(boolean isToggleButton, JavaFXImageIcon selected, JavaFXImageIcon normal, ButtonBase comp) {
        comp.setText(null);
        if (isToggleButton && ((ToggleButton)comp).isSelected() && selected != null) {
            comp.setGraphic((Node)selected);
        } else {
            comp.setGraphic((Node)normal);
        }
    }

    private void setupUniversalFeatures(Control comp, FormObject form, StringBuilder styleBuilder, JavaFXControlListener controlListener) {
        int[] textColor = FormsCSSHelper.getTextColor(form);
        if (textColor == null) {
            styleBuilder.append("-fx-text-fill:rgb(0, 0, 0);");
        } else {
            styleBuilder.append(String.format("-fx-text-fill:rgb(%d, %d, %d);", textColor[0], textColor[1], textColor[2]));
        }
        int[] backgroundColor = FormsCSSHelper.getBackgroundColor(form);
        if (backgroundColor == null) {
            styleBuilder.append("-fx-background-color:transparent;");
        } else {
            styleBuilder.append(String.format("-fx-background-color:rgb(%d, %d, %d);", backgroundColor[0], backgroundColor[1], backgroundColor[2]));
        }
        if (controlListener != null) {
            this.setupMouseListener(comp, form, controlListener);
        }
    }

    private void addFont(FormObject formObject, boolean area, boolean isMultiLine, StringBuilder styleBuilder) {
        String fontData = FormsCSSHelper.addFont(formObject, area, isMultiLine, this.pageData, formObject.getPageNumber(), 1.0f);
        if (formObject.isAppearanceUsed() && formObject.getFormType() == FormFactory.RADIOBUTTON.intValue()) {
            styleBuilder.append("-fx-text-fill:transparent;");
        } else {
            styleBuilder.append("-fx-font:").append(fontData).append(';');
        }
    }

    private void setupMouseListener(Control comp, FormObject form, JavaFXControlListener controlListener) {
        String noLinkToolTips;
        boolean[] characteristic = form.getCharacteristics();
        if (characteristic[0] || characteristic[1] || characteristic[5]) {
            comp.setVisible(false);
        }
        JavaFXFormsListener jpedalListener = new JavaFXFormsListener(form, this.formsActionHandler);
        controlListener.addMouseListener(jpedalListener.getMouseHandler());
        controlListener.addKeyListener(jpedalListener.getKeyHandler());
        controlListener.addFocusEvent(jpedalListener.getFocusHandler());
        PdfObject aData = form.getDictionary(17);
        if (!(aData == null || aData.getNameAsConstant(35) != 2433561 || (noLinkToolTips = System.getProperty("org.jpedal.noURLaccess")) != null && noLinkToolTips.equals("true"))) {
            String text = aData.getTextStreamValue(2433561);
            comp.setTooltip(new Tooltip(text));
        }
    }

    private static void setToolTip(FormObject formObject, Control retComponent) {
        String userName = formObject.getTextStreamValue(9253);
        if (userName != null && !userName.isEmpty()) {
            retComponent.setTooltip(new Tooltip(userName));
        }
    }

    @Override
    public GUIData getCustomCompData() {
        return new JavaFXData();
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void setAnnotOrder(Map<String, String> annotOrder) {
    }

    public Object getPopupComponent(FormObject form, int cropBoxWith) {
        return new PdfJavaFXPopup(form, cropBoxWith);
    }

    private static void setBorder(FormObject formObject, StringBuilder styleBuilder) {
        int[] borderColor = FormsCSSHelper.getBorderColor(formObject);
        int[] backgroundColor = new int[]{255, 255, 255};
        int width = FormsCSSHelper.getBorderWidth(formObject);
        if (borderColor == null && formObject.isXFAObject()) {
            borderColor = new int[]{0, 0, 0};
        }
        if (borderColor == null || width == 0) {
            return;
        }
        String foreColor = String.format("rgb(%d,%d,%d) ", borderColor[0], borderColor[1], borderColor[2]);
        String backColor = String.format("rgb(%d,%d,%d) ", backgroundColor[0], backgroundColor[1], backgroundColor[2]);
        String borderStyleColor = "-fx-border-color:" + foreColor + ';';
        String borderStyle = "-fx-border-style:solid;";
        String borderWidth = "-fx-border-width:" + width + "px;";
        int style = 35;
        PdfObject BS = formObject.getDictionary(4643);
        if (BS != null && (style = BS.getNameAsConstant(35)) == -1) {
            style = 35;
        }
        if (formObject.isXFAObject()) {
            int[] t = formObject.getMatteBorderDetails();
            borderWidth = String.format("-fx-border-width:%d %d %d %d;", t[0], t[1], t[2], t[3]);
        } else {
            switch (style) {
                case 37: {
                    borderWidth = "-fx-border-width:0 0 " + width + "px 0;";
                    break;
                }
                case 25: {
                    borderStyleColor = "-fx-border-color:" + foreColor + backColor + backColor + foreColor + ';';
                    break;
                }
                case 18: {
                    borderStyleColor = "-fx-border-color:" + backColor + foreColor + foreColor + backColor + ';';
                    break;
                }
                case 35: {
                    break;
                }
                case 20: {
                    borderStyle = "-fx-border-style:dashed;";
                }
            }
        }
        styleBuilder.append(borderStyleColor).append(borderStyle).append(borderWidth);
    }
}

