/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.javafx;

import java.awt.image.BufferedImage;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Transform;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;

public class JavaFXImageIcon
extends ImageView {
    PdfObject formObject;
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int selected = -1;
    private static final int UNSELECTEDICON = 0;
    private static final int SELECTEDICON = 1;
    private Image rootImageSelected;
    private Image rootImageUnselected;
    private Image imageSelected;
    private Image imageUnselected;
    private PdfObject selObj;
    private PdfObject unSelObj;
    private PdfObjectReader currentpdffile;
    private int subtype;
    private int offsetImage;
    protected static final float MAXSCALEFACTOR = 1.5f;
    protected static final int iconWidth = -1;
    protected static final int iconHeight = -1;
    private final SimpleDoubleProperty xScale;
    private final SimpleDoubleProperty yScale;
    protected int iconRotation;
    protected int iconOpp = 180;
    protected int pageRotate;
    protected boolean displaySingle;

    JavaFXImageIcon(ButtonBase parentButton, PdfObject formObject, PdfObject imgObj, int iconRot, PdfObjectReader pdfObjectReader, int type, int offset) {
        this.formObject = formObject;
        this.selObj = imgObj;
        this.selected = -1;
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.currentpdffile = pdfObjectReader;
        this.subtype = type;
        this.offsetImage = offset;
        this.setupButton(parentButton);
    }

    JavaFXImageIcon(ButtonBase parentButton, PdfObject formObject, BufferedImage img, int iconRot) {
        this(parentButton, formObject, (Image)(img == null ? null : SwingFXUtils.toFXImage((BufferedImage)img, null)), iconRot);
    }

    JavaFXImageIcon(ButtonBase parentButton, PdfObject formObject, Image img, int iconRot) {
        this.iconRotation = iconRot;
        this.formObject = formObject;
        this.imageSelected = img != null ? img : SwingFXUtils.toFXImage((BufferedImage)FormObject.getOpaqueImage(), null);
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.selected = -1;
        this.setupButton(parentButton);
    }

    JavaFXImageIcon(ButtonBase parentButton, PdfObject formObject, PdfObject selObject, PdfObject unselObject, int iconRot, int sel, PdfObjectReader pdfObjectReader, int type, int offset) {
        this.formObject = formObject;
        this.selObj = selObject;
        this.unSelObj = unselObject;
        this.selected = sel;
        this.currentpdffile = pdfObjectReader;
        this.subtype = type;
        this.offsetImage = offset;
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
        this.setupButton(parentButton);
    }

    private JavaFXImageIcon() {
        this.xScale = new SimpleDoubleProperty(1.0);
        this.yScale = new SimpleDoubleProperty(1.0);
    }

    private void setupButton(ButtonBase parentButton) {
        this.fitWidthProperty().bind((ObservableValue)parentButton.prefWidthProperty());
        this.fitHeightProperty().bind((ObservableValue)parentButton.prefHeightProperty());
        ListChangeListener<Transform> transListener = new ListChangeListener<Transform>(){

            public void onChanged(ListChangeListener.Change<? extends Transform> c) {
                c.next();
                if (c.wasAdded()) {
                    Transform newt = (Transform)c.getAddedSubList().get(0);
                    JavaFXImageIcon.this.xScale.set(Math.abs(newt.getMxx()));
                    JavaFXImageIcon.this.yScale.set(Math.abs(newt.getMyy()));
                    JavaFXImageIcon.this.setSelectedImage();
                }
            }
        };
        ChangeListener<Parent> listener = new ChangeListener<Parent>((ListChangeListener)transListener){
            final /* synthetic */ ListChangeListener val$transListener;
            {
                this.val$transListener = listChangeListener;
            }

            public void changed(ObservableValue<? extends Parent> observable, Parent oldValue, Parent newValue) {
                if (oldValue != null) {
                    oldValue.getTransforms().removeListener(this.val$transListener);
                }
                if (newValue != null) {
                    newValue.getTransforms().addListener(this.val$transListener);
                }
            }
        };
        parentButton.parentProperty().addListener((ChangeListener)listener);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int newWidth = (int)(this.getFitWidth() * this.xScale.get());
        int newHeight = (int)(this.getFitHeight() * this.yScale.get());
        if (this.currentlyPrinting) {
            newWidth = -1 * this.printMultiplier;
            newHeight = -1 * this.printMultiplier;
        }
        switch (this.selected) {
            case 0: {
                if (!(this.rootImageUnselected == null || (double)newWidth > this.rootImageUnselected.getWidth() || (double)newHeight > this.rootImageUnselected.getHeight() || (double)newWidth < this.rootImageUnselected.getWidth() / 1.5) && !((double)newHeight < this.rootImageUnselected.getHeight() / 1.5)) break;
                BufferedImage rootImageUnselectedAWT = FormStream.decode(this.formObject, this.currentpdffile, this.unSelObj, this.subtype, newWidth, newHeight, this.offsetImage, 1.0f);
                BufferedImage imageUnselectedAWT = FormStream.rotate(rootImageUnselectedAWT, this.iconRotation);
                this.rootImageUnselected = SwingFXUtils.toFXImage((BufferedImage)rootImageUnselectedAWT, null);
                this.imageUnselected = SwingFXUtils.toFXImage((BufferedImage)imageUnselectedAWT, null);
                break;
            }
            default: {
                if (!(this.rootImageSelected == null || (double)newWidth > this.rootImageSelected.getWidth() || (double)newHeight > this.rootImageSelected.getHeight() || (double)newWidth < this.rootImageSelected.getWidth() / 1.5) && !((double)newHeight < this.rootImageSelected.getHeight() / 1.5)) break;
                BufferedImage rootImageSelectedAWT = FormStream.decode(this.formObject, this.currentpdffile, this.selObj, this.subtype, newWidth, newHeight, this.offsetImage, 1.0f);
                BufferedImage imageSelectedAWT = FormStream.rotate(rootImageSelectedAWT, this.iconRotation);
                if (rootImageSelectedAWT != null) {
                    this.rootImageSelected = SwingFXUtils.toFXImage((BufferedImage)rootImageSelectedAWT, null);
                }
                if (imageSelectedAWT == null) break;
                this.imageSelected = SwingFXUtils.toFXImage((BufferedImage)imageSelectedAWT, null);
            }
        }
    }

    public void swapImage(boolean selectedImage) {
        if (this.selected == -1) {
            return;
        }
        this.selected = selectedImage ? 1 : 0;
        this.setSelectedImage();
    }

    public void setPrinting(boolean print, int multiplier) {
        this.currentlyPrinting = print;
        this.printMultiplier = multiplier;
        this.checkAndCreateimage();
    }

    private void setSelectedImage() {
        Image image;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        this.setImage(image);
    }

    public Image getSelectedImage() {
        Image image;
        this.checkAndCreateimage();
        switch (this.selected) {
            case 0: {
                image = this.imageUnselected;
                break;
            }
            default: {
                image = this.imageSelected;
            }
        }
        return image;
    }
}

