/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JInternalFrame;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;

public class PdfSwingPopup
extends JInternalFrame {
    private static final long serialVersionUID = 796302916236391896L;
    JTextArea titleBar;
    JTextArea contentArea;
    final FormObject formObject;
    final Point currPos = new Point(0, 0);

    public PdfSwingPopup(FormObject popupObj, int cropBoxWidth) {
        this.formObject = popupObj;
        PdfObject parentObj = popupObj.getParentPdfObj();
        if (parentObj == null) {
            return;
        }
        float[] col = popupObj.getFloatArray(19);
        if (col == null) {
            col = parentObj.getFloatArray(19);
        }
        if (col == null) {
            col = new float[]{255.0f, 255.0f, 0.0f};
        }
        String mStream = parentObj.getTextStreamValue(29);
        StringBuffer date = null;
        if (mStream != null) {
            date = new StringBuffer(mStream);
            date.delete(0, 2);
            date.insert(10, ':');
            date.insert(13, ':');
            date.insert(16, ' ');
            String year = date.substring(0, 4);
            String day = date.substring(6, 8);
            date.delete(6, 8);
            date.delete(0, 4);
            date.insert(0, day);
            date.insert(4, year);
            date.insert(2, '/');
            date.insert(5, '/');
            date.insert(10, ' ');
        }
        String subject = parentObj.getTextStreamValue(591737402);
        String popupTitle = popupObj.getTextStreamValue(36);
        if (popupTitle == null) {
            popupTitle = "";
        }
        String title = "";
        if (subject != null) {
            title = title + subject + '\t';
        }
        if (date != null) {
            title = title + date;
        }
        title = title + '\n' + popupTitle;
        String contentString = parentObj.getTextStreamValue(1216184967);
        if (contentString == null) {
            contentString = "";
        }
        if (contentString.indexOf(13) != -1) {
            contentString = contentString.replaceAll("\r", "\n");
        }
        Color bgColor = null;
        if (col != null) {
            bgColor = col[0] > 1.0f || col[1] > 1.0f || col[2] > 1.0f ? new Color((int)col[0], (int)col[1], (int)col[2]) : new Color(col[0], col[1], col[2]);
            this.setBorder(BorderFactory.createLineBorder(bgColor));
        }
        ((BasicInternalFrameUI)this.getUI()).setNorthPane(null);
        this.setLayout(new BorderLayout());
        this.titleBar = new JTextArea(title);
        this.titleBar.setEditable(false);
        if (bgColor != null) {
            this.titleBar.setBackground(bgColor);
        }
        this.add((Component)this.titleBar, "North");
        this.contentArea = new JTextArea(contentString);
        this.contentArea.setWrapStyleWord(true);
        this.contentArea.setLineWrap(true);
        this.add((Component)this.contentArea, "Center");
        Font titFont = this.titleBar.getFont();
        int baseFontSize = (int)this.formObject.getFontSize();
        this.titleBar.setFont(new Font(titFont.getName(), titFont.getStyle(), baseFontSize - 1));
        Font curFont = this.contentArea.getFont();
        this.contentArea.setFont(new Font(curFont.getName(), curFont.getStyle(), baseFontSize - 2));
        MyMouseMotionAdapter mmma = new MyMouseMotionAdapter();
        this.titleBar.addMouseMotionListener(mmma);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PdfSwingPopup.this.toFront();
                super.focusGained(e);
            }
        });
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                JInternalFrame frame = e.getInternalFrame();
                frame.getParent().setComponentZOrder(frame, 0);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
                JInternalFrame frame = e.getInternalFrame();
                if (frame.getParent() != null) {
                    frame.getParent().setComponentZOrder(frame, 1);
                }
            }
        });
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        int fontSize = f.getSize();
        if (this.titleBar != null) {
            this.titleBar.setFont(this.titleBar.getFont().deriveFont((float)fontSize - 1.0f));
        }
        if (this.contentArea != null && this.titleBar != null) {
            this.contentArea.setFont(this.titleBar.getFont().deriveFont((float)fontSize - 2.0f));
        }
    }

    private class MyMouseMotionAdapter
    extends MouseMotionAdapter {
        private MyMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point pt = e.getPoint();
            Point curLoc = PdfSwingPopup.this.getLocation();
            PdfSwingPopup.this.currPos.x += pt.x;
            PdfSwingPopup.this.currPos.y += pt.y;
            curLoc.translate(pt.x, pt.y);
            PdfSwingPopup.this.setLocation(curLoc);
            PdfSwingPopup.this.formObject.setUserSetOffset(PdfSwingPopup.this.currPos);
            super.mouseDragged(e);
        }
    }
}

