/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.utils;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConvertToString {
    public static String convertArrayToString(float[] values) {
        if (values != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(values[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static String convertArrayToString(int[] items) {
        if (items != null) {
            StringBuilder ret = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    ret.append(", ");
                }
                ret.append(items[i]);
            }
            return ret.toString();
        }
        return null;
    }

    public static void printStackTrace(int level) {
        ConvertToString.printStackTrace(2, level + 1, false);
    }

    public static void printStackTrace(int startLevel, int endLevel, boolean err) {
        Throwable stackgetter = new Throwable();
        StackTraceElement[] elems = stackgetter.getStackTrace();
        if (endLevel == -1 || endLevel > elems.length - 1) {
            endLevel = elems.length - 1;
        }
        for (int i = startLevel; i <= endLevel; ++i) {
            if (err) {
                System.err.println(elems[i]);
                continue;
            }
            System.out.println(elems[i]);
        }
    }

    public static String convertDocumentToString(Node formData) {
        return ConvertToString.convertDocumentToString(formData, 0);
    }

    private static String convertDocumentToString(Node formData, int level) {
        if (formData == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(formData.getNodeName());
        buf.append(" = ");
        buf.append(formData.getNodeValue());
        buf.append(" type=");
        buf.append(formData.getNodeType());
        buf.append(" textContent=");
        buf.append(formData.getTextContent());
        NamedNodeMap att = formData.getAttributes();
        if (att != null) {
            buf.append(" attributes=[");
            for (int i = 0; i < att.getLength(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(att.item(i));
            }
            buf.append(']');
        }
        NodeList nodes = formData.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            buf.append('\n');
            for (int d = 0; d < level; ++d) {
                buf.append('|');
            }
            buf.append(ConvertToString.convertDocumentToString(nodes.item(i), level + 1));
        }
        return buf.toString();
    }
}

