/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.functions.AFDate;
import org.jpedal.objects.javascript.functions.AFNumber;
import org.jpedal.objects.javascript.functions.AFPercent;
import org.jpedal.objects.javascript.functions.AFRange;
import org.jpedal.objects.javascript.functions.AFSimple;
import org.jpedal.objects.javascript.functions.AFSpecial;
import org.jpedal.objects.javascript.functions.AFTime;
import org.jpedal.objects.javascript.functions.JSFunction;
import org.jpedal.objects.raw.FormObject;

public class DefaultParser
implements ExpressionEngine {
    AcroRenderer acro;

    @Override
    public int execute(FormObject form, int type, Object code, int eventType, char keyPressed) {
        String js;
        String[] args;
        String command;
        int messageCode = 0;
        if (code instanceof String && (command = (args = JSFunction.convertToArray(js = (String)code))[0]).startsWith("AF")) {
            messageCode = this.handleAFCommands(form, command, js, args, eventType, keyPressed);
        }
        return messageCode;
    }

    protected int handleAFCommands(FormObject formObject, String command, String js, String[] args, int eventType, char keyPressed) {
        int messageCode = 0;
        int type = -1;
        if (js.contains("_Keystroke")) {
            type = 1;
        } else if (js.contains("_Validate")) {
            type = 2;
        } else if (js.contains("_Format")) {
            type = 3;
        } else if (js.contains("_Calculate")) {
            type = 4;
        }
        if (eventType != 6 && (type == 2 || type == 3)) {
            JSFunction.debug("Not called on key event " + js);
            return messageCode;
        }
        if (js.startsWith("AFSpecial_")) {
            new AFSpecial(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (command.startsWith("AFPercent_")) {
            new AFPercent(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (command.startsWith("AFSimple_")) {
            new AFSimple(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (command.startsWith("AFDate_")) {
            new AFDate(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (js.startsWith("AFNumber_")) {
            messageCode = new AFNumber(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (js.startsWith("AFRange_")) {
            new AFRange(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else if (js.startsWith("AFTime_")) {
            new AFTime(this.acro, formObject).execute(js, args, type, eventType, keyPressed);
        } else {
            JSFunction.debug("Unknown command " + js);
        }
        return messageCode;
    }

    @Override
    public void closeFile() {
        this.flush();
    }

    @Override
    public boolean reportError(int code, Object[] args) {
        return false;
    }

    @Override
    public int addCode(String value) {
        return 0;
    }

    @Override
    public void executeFunctions(String jsCode, FormObject formObject) {
    }

    @Override
    public void dispose() {
        this.flush();
    }

    @Override
    public void setAcroRenderer(AcroRenderer acro) {
        this.acro = acro;
    }

    public void flush() {
    }
}

