/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.utils.Messages;

public class JSApp {
    private static final int ICON_ERROR = 0;
    private static final int ICON_WARNING = 1;
    private static final int ICON_QUESTION = 2;
    private static final int ICON_STATUS = 3;
    private static final int BUTTONTYPE_OK = 0;
    private static final int BUTTONTYPE_OK_CANCEL = 1;
    private static final int BUTTONTYPE_YES_NO = 2;
    private static final int BUTTONTYPE_YES_NO_CANCEL = 3;
    private static final int BUTTON_OK = 1;
    private static final int BUTTON_CANCEL = 2;
    private static final int BUTTON_NO = 3;
    private static final int BUTTON_YES = 4;
    public static final boolean showOutput = false;
    private int count;
    public String viewerType = "Exchange-Pro";
    public String viewerVariation = "Reader";
    public int viewerVersion = 10;
    public String platform = "UNIX";

    private void setPlatform() {
        this.platform = DecoderOptions.isRunningOnWindows ? "WIN" : (DecoderOptions.isRunningOnMac ? "MAC" : "UNIX");
    }

    public static void alert() {
    }

    public static void alert(Object objA, Object objB, Object objC) {
    }

    public static int alert(String cMsg, int nIcon, int nType, String title) {
        int javaButtonType;
        int javaIcon;
        switch (nIcon) {
            case 0: {
                javaIcon = 0;
                break;
            }
            case 1: {
                javaIcon = 2;
                break;
            }
            case 2: {
                javaIcon = 3;
                break;
            }
            case 3: {
                javaIcon = -1;
                break;
            }
            default: {
                javaIcon = -1;
            }
        }
        switch (nType) {
            case 0: {
                javaButtonType = -1;
                break;
            }
            case 1: {
                javaButtonType = 2;
                break;
            }
            case 2: {
                javaButtonType = 0;
                break;
            }
            case 3: {
                javaButtonType = 1;
                break;
            }
            default: {
                javaButtonType = 2;
            }
        }
        if (title == null || title.length() <= 0) {
            title = "Jpedal JavaScript Window";
        }
        int nButton = JOptionPane.showConfirmDialog(null, cMsg, title, javaButtonType, javaIcon);
        switch (nButton) {
            case 0: {
                if (nType == 2 || nType == 3) {
                    nButton = 4;
                    break;
                }
                nButton = 1;
                break;
            }
            case 2: {
                nButton = 2;
                break;
            }
            case 1: {
                nButton = 3;
                break;
            }
            case -1: {
                nButton = javaButtonType == -1 ? 1 : (javaButtonType == 0 ? 3 : 2);
            }
        }
        return nButton;
    }

    public static int alert(String cMsg, int nIcon, int nType) {
        return JSApp.alert(cMsg, nIcon, nType, null);
    }

    public static int alert(String cMsg, int nIcon) {
        return JSApp.alert(cMsg, nIcon, -1, null);
    }

    public static int alert(String cMsg, int nIcon, int nType, String title, Object oDoc, Object oCheckbox) {
        return JSApp.alert(cMsg, nIcon, nType, title);
    }

    public static int alert(String cMsg, int nIcon, int nType, String title, Object oDoc) {
        return JSApp.alert(cMsg, nIcon, nType, title);
    }

    public static String response(String cQuestion, String cTitle, String cDefault, boolean bPassword, String cLabel) {
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        JPanel panel = new JPanel(layout);
        JLabel question = new JLabel(cQuestion);
        JTextField field = bPassword ? new JPasswordField() : new JTextField();
        if (cDefault != null) {
            field.setText(cDefault);
        }
        String title = cTitle != null ? cTitle : "Input";
        panel.add((Component)question, "North");
        if (cLabel != null) {
            JLabel label = new JLabel(cLabel);
            panel.add((Component)label, "West");
        }
        panel.add((Component)field, "Center");
        Object[] options = new String[]{"Ok", "Cancel"};
        int option = JOptionPane.showOptionDialog(null, panel, title, 1, -1, null, options, options[0]);
        if (option == 0) {
            return field.getText();
        }
        return null;
    }

    public static String response(String cQuestion, String cTitle, String cDefault, boolean bPassword) {
        return JSApp.response(cQuestion, cTitle, cDefault, bPassword, null);
    }

    public static String response(String cQuestion, String cTitle, String cDefault) {
        return JSApp.response(cQuestion, cTitle, cDefault, false, null);
    }

    public static String response(String cQuestion, String cTitle) {
        return JSApp.response(cQuestion, cTitle, null, false, null);
    }

    public static String response(String cQuestion) {
        return JSApp.response(cQuestion, null, null, false, null);
    }

    public static int alert(String cMsg) {
        return JOptionPane.showConfirmDialog(null, cMsg, "JavaScript", -1, 0);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void beep(int number) {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void launchURL(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void launchURL(String url, boolean newWindow) {
        JSApp.launchURL(url);
    }

    public static void popUpMenuEx(String[] array) {
    }

    public static void mailMsg(boolean bUI, String cTo, String cCc, String cBcc, String cSubject, String cMsg) {
        System.out.println("mailMsg(boolean bUI, String cTo)");
        if (cTo != null && !cTo.isEmpty()) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                try {
                    cTo = cTo.replace(';', ',');
                    String uriString = "mailto:" + cTo;
                    boolean addedExtras = false;
                    if (cCc != null && !cCc.isEmpty()) {
                        addedExtras = true;
                        uriString = uriString + "?";
                        uriString = uriString + "cc=" + cCc.replace(';', ',');
                    }
                    if (cBcc != null && !cBcc.isEmpty()) {
                        if (!addedExtras) {
                            addedExtras = true;
                            uriString = uriString + "?";
                        } else {
                            uriString = uriString + "&";
                        }
                        uriString = uriString + "bcc=" + cBcc.replace(';', ',');
                    }
                    if (cSubject != null && !cSubject.isEmpty()) {
                        if (!addedExtras) {
                            addedExtras = true;
                            uriString = uriString + "?";
                        } else {
                            uriString = uriString + "&";
                        }
                        uriString = uriString + "subject=" + cSubject.replace(" ", "%20");
                    }
                    if (cMsg != null && !cMsg.isEmpty()) {
                        uriString = !addedExtras ? uriString + "?" : uriString + "&";
                        uriString = uriString + "body=" + cMsg.replace(" ", "%20");
                    }
                    URI uri = URI.create(uriString);
                    Desktop.getDesktop().mail(uri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                JSApp.alert("Emailing is not supported on your platform.");
            }
        }
    }

    public static void mailMsg(boolean bUI, String cTo, String cCc, String cBcc, String cSubject) {
        JSApp.mailMsg(bUI, cTo, cCc, cBcc, cSubject, null);
    }

    public static void mailMsg(boolean bUI, String cTo, String cCc, String cBcc) {
        JSApp.mailMsg(bUI, cTo, cCc, cBcc, null, null);
    }

    public static void mailMsg(boolean bUI, String cTo, String cCc) {
        JSApp.mailMsg(bUI, cTo, cCc, null, null, null);
    }

    public static void mailMsg(boolean bUI, String cTo) {
        JSApp.mailMsg(bUI, cTo, null, null, null, null);
    }

    public static void mailMsg(Object jSon) {
        System.out.println("mailMsg(Object o)");
        System.out.println(jSon.getClass().getSimpleName());
    }

    public JSApp() {
        this.setPlatform();
    }

    public JSApp(int a) {
        this.count = a;
        this.setPlatform();
    }

    public int getCount() {
        return this.count++;
    }

    public void resetCount() {
        this.count = 0;
    }

    public static String getString(String section, String key) {
        String returnMessage = "";
        if (section.equals("EScript")) {
            if (key.equals("IDS_GREATER_THAN")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_GREATER_THAN");
            } else if (key.equals("IDS_GT_AND_LT")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_GT_AND_LT");
            } else if (key.equals("IDS_LESS_THAN")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_LESS_THAN");
            } else if (key.equals("IDS_INVALID_MONTH")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_INVALID_MONTH");
            } else if (key.equals("IDS_INVALID_DATE")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_INVALID_DATE");
            } else if (key.equals("IDS_INVALID_VALUE")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_INVALID_VALUE");
            } else if (key.equals("IDS_AM")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_AM");
            } else if (key.equals("IDS_PM")) {
                returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_PM");
            } else {
                if (key.equals("IDS_MONTH_INFO")) {
                    return "\"\"";
                }
                if (key.equals("IDS_STARTUP_CONSOLE_MSG")) {
                    returnMessage = Messages.getMessage("PdfJavaScriptMessage.IDS_STARTUP_CONSOLE_MSG");
                }
            }
        }
        return '\"' + returnMessage + '\"';
    }
}

