/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jpedal.color.DeviceCMYKColorSpace;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.objects.acroforms.creation.GenericFormFactory;
import org.jpedal.objects.javascript.defaultactions.DisplayJavascriptActions;
import org.jpedal.objects.raw.MKObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.ObjectCloneFactory;
import org.jpedal.utils.StringUtils;

public class FormObject
extends PdfObject {
    private static final JavaFXSupport fxSupport = ExternalHandlers.getFXHandler();
    private int formType = -1;
    private String fontName = "Arial";
    Object guiComp;
    private int guiType;
    private int rawRotation;
    Point currentLocation;
    float currentScaling = -1.0f;
    private String EOPROPtype;
    private String Filter;
    private String Location;
    private String M;
    private String Reason;
    private String SubFilter;
    private byte[] rawEOPROPtype;
    private byte[] rawFilter;
    private byte[] rawLocation;
    private byte[] rawM;
    private byte[] rawReason;
    private byte[] rawSubFilter;
    private Color cColor;
    private String contents;
    private boolean show;
    private Map OptValues;
    private String validValue;
    private int[] matteDetails = new int[]{0, 0, 0, 0};
    public static final int READONLY_ID = 1;
    public static final int REQUIRED_ID = 2;
    public static final int NOEXPORT_ID = 3;
    public static final int MULTILINE_ID = 13;
    public static final int PASSWORD_ID = 14;
    public static final int NOTOGGLETOOFF_ID = 15;
    public static final int RADIO_ID = 16;
    public static final int PUSHBUTTON_ID = 17;
    public static final int COMBO_ID = 18;
    public static final int EDIT_ID = 19;
    public static final int SORT_ID = 20;
    public static final int FILESELECT_ID = 21;
    public static final int MULTISELECT_ID = 22;
    public static final int DONOTSPELLCHECK_ID = 23;
    public static final int DONOTSCROLL_ID = 24;
    public static final int COMB_ID = 25;
    public static final int RICHTEXT_ID = 26;
    public static final int RADIOINUNISON_ID = 26;
    public static final int COMMITONSELCHANGE_ID = 27;
    private static final int READONLY_BIT = 1;
    private static final int REQUIRED_BIT = 2;
    private static final int NOEXPORT_BIT = 4;
    private static final int MULTILINE_BIT = 4096;
    private static final int PASSWORD_BIT = 8192;
    private static final int NOTOGGLETOOFF_BIT = 16384;
    private static final int RADIO_BIT = 32768;
    private static final int PUSHBUTTON_BIT = 65536;
    private static final int COMBO_BIT = 131072;
    private static final int EDIT_BIT = 262144;
    private static final int SORT_BIT = 524288;
    private static final int FILESELECT_BIT = 0x100000;
    private static final int MULTISELECT_BIT = 0x200000;
    private static final int DONOTSPELLCHECK_BIT = 0x400000;
    private static final int DONOTSCROLL_BIT = 0x800000;
    private static final int COMB_BIT = 0x1000000;
    private static final int RADIOINUNISON_BIT = 0x2000000;
    private static final int RICHTEXT_BIT = 0x2000000;
    private static final int COMMITONSELCHANGE_BIT = 0x4000000;
    private int rotationOriginX;
    private int rotationOriginY;
    private int elemRotationDegree;
    protected String[] OptString;
    protected boolean isXFAObject;
    private String parentRef;
    private PdfObject parentPdfObj;
    private String selectedItem;
    private Object[] selectedValues;
    private float[] textColor;
    private Font textFont;
    private int textSize = -1;
    private String textString;
    private String lastTextString;
    private boolean lastIsSelected;
    private boolean isSelected;
    private int selectionIndex = -1;
    private boolean appearancesUsed;
    private boolean offsetDownIcon;
    private boolean noDownIcon;
    private boolean invertDownIcon;
    private String normalOnState;
    private BufferedImage normalOffImage;
    private BufferedImage normalOnImage;
    private BufferedImage rolloverOffImage;
    private BufferedImage rolloverOnImage;
    private BufferedImage downOffImage;
    private BufferedImage downOnImage;
    public static final int POPUP = 1;
    private String layerName;
    private boolean[] Farray;
    protected Rectangle BBox;
    protected float[] C;
    protected float[] QuadPoints;
    protected float[] RD;
    protected float[] Rect;
    protected boolean[] flags;
    boolean Open;
    boolean H_Boolean = true;
    boolean NeedAppearances;
    protected int F = -1;
    protected int Ff = -1;
    protected int MaxLen = -1;
    protected int W = -1;
    protected int Q = -1;
    int SigFlags = -1;
    int StructParent = -1;
    protected int TI = -1;
    protected PdfObject A;
    private int popupFlag;
    protected PdfObject AA;
    protected PdfObject AP;
    protected PdfObject Cdict;
    private PdfObject BI;
    protected PdfObject BS;
    protected PdfObject D;
    protected PdfObject IF;
    protected PdfObject IRT;
    protected PdfObject RichMediaContent;
    protected int Flags;
    private PdfObject MK;
    private PdfObject DC;
    private PdfObject DP;
    private PdfObject DR;
    private PdfObject DS;
    private PdfObject E;
    private PdfObject Fdict;
    private PdfObject Fo;
    private PdfObject FS;
    private PdfObject JS;
    private PdfObject K;
    private PdfObject Nobj;
    private PdfObject Next;
    private PdfObject O;
    private PdfObject PC;
    private PdfObject PI;
    private PdfObject PO;
    private PdfObject Popup;
    private PdfObject PV;
    private PdfObject R;
    private PdfObject Sig;
    private PdfObject Sound;
    private PdfObject U;
    private PdfObject V;
    private PdfObject Win;
    private PdfObject WP;
    private PdfObject WS;
    private PdfObject X;
    protected int[] ByteRange;
    protected int[] selectionIndices;
    protected byte[] rawAS;
    protected byte[] rawCert;
    protected byte[] rawContactInfo;
    protected byte[] rawContents;
    protected byte[] rawDstring;
    protected byte[] rawDA;
    protected byte[] rawDV;
    protected byte[] rawFstring;
    protected byte[] rawJS;
    protected byte[] rawH;
    protected byte[] rawN;
    protected byte[] rawNM;
    protected byte[] rawPstring;
    protected byte[] rawRC;
    protected byte[] rawRT;
    protected byte[] rawS;
    protected byte[] rawSubj;
    protected byte[] rawT;
    protected byte[] rawTM;
    protected byte[] rawTU;
    protected byte[] rawURI;
    protected byte[] rawV;
    protected byte[] rawX;
    protected int FT = -1;
    protected String AS;
    protected String Cert;
    protected String ContactInfo;
    protected String Contents;
    protected String Dstring;
    protected String DA;
    protected String DV;
    protected String Fstring;
    protected String JSString;
    protected String H;
    protected String N;
    protected String NM;
    protected String Pstring;
    protected String RC;
    protected String S;
    protected String Subj;
    protected String T;
    protected String TM;
    protected String TU;
    protected String URI;
    protected String Vstring;
    private byte[][] Border;
    private byte[][] DmixedArray;
    private byte[][] Fields;
    private byte[][] State;
    private byte[][] rawXFAasArray;
    protected PdfObject Bl;
    protected PdfObject OC;
    protected PdfObject Off;
    protected PdfObject On;
    protected PdfObject P;
    private PdfObject XFAasStream;
    protected Object[] CO;
    protected Object[] InkList;
    protected Object[] Opt;
    protected Object[] Reference;
    protected byte[][] Kids;
    private String htmlName;
    private static final float baseFontSize = 12.0f;

    public void setHTMLName(String name) {
        this.htmlName = name;
    }

    public String getHTMLName() {
        return this.htmlName;
    }

    public FormObject(String ref) {
        super(ref);
        this.objType = 373244477;
    }

    public FormObject(String ref, boolean flag) {
        super(ref);
        this.objType = 373244477;
        this.includeParent = flag;
    }

    public FormObject(int ref, int gen) {
        super(ref, gen);
        this.objType = 373244477;
    }

    public FormObject(int type) {
        super(type);
        this.objType = 373244477;
    }

    public FormObject() {
        this.objType = 373244477;
    }

    public FormObject(String ref, int parentType) {
        super(ref);
        this.objType = 373244477;
        this.parentType = parentType;
    }

    @Override
    public boolean getBoolean(int id) {
        switch (id) {
            case 24: {
                return this.H_Boolean;
            }
            case -1483477783: {
                return this.NeedAppearances;
            }
            case 524301630: {
                return this.Open;
            }
        }
        return super.getBoolean(id);
    }

    @Override
    public void setBoolean(int id, boolean value) {
        switch (id) {
            case 24: {
                this.H_Boolean = value;
                break;
            }
            case -1483477783: {
                this.NeedAppearances = value;
                break;
            }
            case 524301630: {
                this.Open = value;
                break;
            }
            default: {
                super.setBoolean(id, value);
            }
        }
    }

    public void setActionFlag(int popup) {
        this.popupFlag = popup;
    }

    public int getActionFlag() {
        return this.popupFlag;
    }

    @Override
    public PdfObject getDictionary(int id) {
        switch (id) {
            case 17: {
                return this.A;
            }
            case 4369: {
                return this.AA;
            }
            case 4384: {
                if (this.AP == null) {
                    this.AP = new FormObject();
                }
                return this.AP;
            }
            case 4633: {
                return this.BI;
            }
            case 4668: {
                return this.Bl;
            }
            case 4643: {
                if (this.BS == null) {
                    PdfObject BSdic;
                    if (this.parentPdfObj != null && (BSdic = this.parentPdfObj.getDictionary(4643)) != null) {
                        return (PdfObject)BSdic.clone();
                    }
                    this.BS = new FormObject();
                }
                return this.BS;
            }
            case 19: {
                return this.Cdict;
            }
            case 20: {
                return this.D;
            }
            case 5139: {
                return this.DC;
            }
            case 5152: {
                return this.DP;
            }
            case 5154: {
                return this.DR;
            }
            case 5155: {
                return this.DS;
            }
            case 21: {
                return this.E;
            }
            case 22: {
                return this.Fdict;
            }
            case 5695: {
                return this.Fo;
            }
            case 5667: {
                return this.FS;
            }
            case 6691: {
                return this.JS;
            }
            case 6422: {
                return this.IF;
            }
            case 1647140: {
                return this.IRT;
            }
            case 27: {
                return this.K;
            }
            case 7451: {
                if (this.MK == null) {
                    PdfObject MKdic;
                    if (this.parentPdfObj != null && (MKdic = this.parentPdfObj.getDictionary(7451)) != null) {
                        return (PdfObject)MKdic.clone();
                    }
                    this.MK = new MKObject();
                }
                return this.MK;
            }
            case 30: {
                return this.Nobj;
            }
            case 506808388: {
                return this.Next;
            }
            case 31: {
                return this.O;
            }
            case 7955: {
                return this.OC;
            }
            case 2045494: {
                return this.Off;
            }
            case 7998: {
                return this.On;
            }
            case 32: {
                return this.P;
            }
            case 8211: {
                return this.PC;
            }
            case 8217: {
                return this.PI;
            }
            case 8223: {
                return this.PO;
            }
            case 1061176672: {
                return this.Popup;
            }
            case 8230: {
                return this.PV;
            }
            case 34: {
                return this.R;
            }
            case -1263082253: {
                return this.RichMediaContent;
            }
            case 2308407: {
                return this.Sig;
            }
            case 1061502534: {
                return this.Sound;
            }
            case 37: {
                return this.U;
            }
            case 38: {
                return this.V;
            }
            case 2570558: {
                return this.Win;
            }
            case 10016: {
                return this.WP;
            }
            case 10019: {
                return this.WS;
            }
            case 40: {
                return this.X;
            }
            case 2627089: {
                return this.XFAasStream;
            }
        }
        return super.getDictionary(id);
    }

    @Override
    public void setIntNumber(int id, int value) {
        block0 : switch (id) {
            case 22: {
                this.F = value;
                break;
            }
            case 5686: {
                this.Ff = value;
                this.commandFf(this.Ff);
                break;
            }
            case 33: {
                switch (value) {
                    case 0: {
                        this.Q = 2;
                        break block0;
                    }
                    case 1: {
                        this.Q = 0;
                        break block0;
                    }
                    case 2: {
                        this.Q = 4;
                        break block0;
                    }
                }
                this.Q = 2;
                break;
            }
            case 1209815663: {
                this.MaxLen = value;
                break;
            }
            case 1144088180: {
                if (this.MK == null) {
                    this.MK = new MKObject();
                }
                if (this.rawRotation == 0) {
                    this.MK.setIntNumber(34, value);
                    break;
                }
                int diff = this.rawRotation - value;
                if (diff < 0) {
                    diff = 360 + diff;
                }
                this.MK.setIntNumber(34, diff);
                break;
            }
            case 1600810585: {
                this.SigFlags = value;
                break;
            }
            case -1732403014: {
                this.StructParent = value;
                break;
            }
            case 9241: {
                this.TI = value;
                break;
            }
            case 39: {
                this.W = value;
                break;
            }
            case 1009858393: {
                this.Flags = value;
                break;
            }
            default: {
                super.setIntNumber(id, value);
            }
        }
    }

    @Override
    public int getInt(int id) {
        switch (id) {
            case 22: {
                return this.F;
            }
            case 5686: {
                return this.Ff;
            }
            case 1209815663: {
                return this.MaxLen;
            }
            case 33: {
                return this.Q;
            }
            case 1600810585: {
                return this.SigFlags;
            }
            case -1732403014: {
                return this.StructParent;
            }
            case 9241: {
                return this.TI;
            }
            case 39: {
                return this.W;
            }
            case 1009858393: {
                return this.Flags;
            }
        }
        return super.getInt(id);
    }

    @Override
    public void setDictionary(int id, PdfObject value) {
        value.setID(id);
        if (this.currentKey != null) {
            this.setOtherValues(value);
            return;
        }
        switch (id) {
            case 17: {
                this.A = value;
                break;
            }
            case 4369: {
                this.AA = value;
                break;
            }
            case 4384: {
                this.AP = value;
                if (this.MK != null || this.AP == null || this.AP.getDictionary(30) == null) break;
                this.MK = this.AP.getDictionary(30).getDictionary(7451);
                break;
            }
            case 4633: {
                this.BI = value;
                break;
            }
            case 4668: {
                this.Bl = value;
                break;
            }
            case 4643: {
                this.BS = value;
                break;
            }
            case 19: {
                this.Cdict = value;
                break;
            }
            case 20: {
                this.D = value;
                break;
            }
            case 5139: {
                this.DC = value;
                break;
            }
            case 5152: {
                this.DP = value;
                break;
            }
            case 5154: {
                this.DR = value;
                break;
            }
            case 5155: {
                this.DS = value;
                break;
            }
            case 21: {
                this.E = value;
                break;
            }
            case 22: {
                this.Fdict = value;
                break;
            }
            case 5695: {
                this.Fo = value;
                break;
            }
            case 5667: {
                this.FS = value;
                break;
            }
            case 6422: {
                this.IF = value;
                break;
            }
            case 1647140: {
                this.IRT = value;
                break;
            }
            case 6691: {
                this.JS = value;
                break;
            }
            case 27: {
                this.K = value;
                break;
            }
            case 7451: {
                this.MK = value;
                break;
            }
            case 30: {
                this.Nobj = value;
                break;
            }
            case 506808388: {
                this.Next = value;
                break;
            }
            case 31: {
                this.O = value;
                break;
            }
            case 7955: {
                this.OC = value;
                break;
            }
            case 2045494: {
                this.Off = value;
                break;
            }
            case 7998: {
                this.On = value;
                break;
            }
            case 32: {
                this.P = value;
                break;
            }
            case 8211: {
                this.PC = value;
                break;
            }
            case 8217: {
                this.PI = value;
                break;
            }
            case 8223: {
                this.PO = value;
                break;
            }
            case 1061176672: {
                this.Popup = value;
                break;
            }
            case 8230: {
                this.PV = value;
                break;
            }
            case 34: {
                this.R = value;
                break;
            }
            case -1263082253: {
                this.RichMediaContent = value;
                break;
            }
            case 2308407: {
                this.Sig = value;
                break;
            }
            case 1061502534: {
                this.Sound = value;
                break;
            }
            case 37: {
                this.U = value;
                break;
            }
            case 38: {
                this.V = value;
                break;
            }
            case 2570558: {
                this.Win = value;
                break;
            }
            case 10016: {
                this.WP = value;
                break;
            }
            case 10019: {
                this.WS = value;
                break;
            }
            case 40: {
                this.X = value;
                break;
            }
            case 2627089: {
                this.XFAasStream = value;
                break;
            }
            default: {
                super.setDictionary(id, value);
            }
        }
    }

    @Override
    public int setConstant(int pdfKeyType, int keyStart, int keyLength, byte[] raw) {
        int id;
        int PDFvalue;
        block8: {
            PDFvalue = -1;
            id = 0;
            int x = 0;
            try {
                for (int i2 = keyLength - 1; i2 > -1; --i2) {
                    int next = raw[keyStart + i2];
                    id += (next -= 48) << x;
                    x += 8;
                }
                switch (id) {
                    default: 
                }
                PDFvalue = super.setConstant(pdfKeyType, id);
                if (PDFvalue == -1 && debug) {
                    byte[] bytes = new byte[keyLength];
                    System.arraycopy(raw, keyStart, bytes, 0, keyLength);
                    System.out.println("key=" + new String(bytes) + ' ' + id + " not implemented in setConstant in " + this);
                    System.out.println("final public static int " + new String(bytes) + '=' + id + ';');
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        switch (pdfKeyType) {
            default: 
        }
        super.setConstant(pdfKeyType, id);
        return PDFvalue;
    }

    @Override
    public int getNameAsConstant(int id) {
        byte[] raw;
        switch (id) {
            case 5668: {
                return this.FT;
            }
            case 24: {
                raw = this.rawH;
                break;
            }
            case 30: {
                raw = this.rawN;
                break;
            }
            case 8740: {
                raw = this.rawRT;
                break;
            }
            case 35: {
                raw = this.rawS;
                break;
            }
            case 40: {
                raw = this.rawX;
                break;
            }
            default: {
                return super.getNameAsConstant(id);
            }
        }
        if (raw == null) {
            return super.getNameAsConstant(id);
        }
        return PdfDictionary.generateChecksum(0, raw.length, raw);
    }

    @Override
    public int getParameterConstant(int key) {
        switch (key) {
            case 1147962727: {
                if (this.FT != -1) {
                    return this.FT;
                }
                return super.getParameterConstant(key);
            }
        }
        return super.getParameterConstant(key);
    }

    @Override
    public PdfArrayIterator getMixedArray(int id) {
        switch (id) {
            case 1110722433: {
                return new PdfArrayIterator(this.Border);
            }
            case 20: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 339034948: {
                return new PdfArrayIterator(this.DmixedArray);
            }
            case 893143676: {
                return new PdfArrayIterator(this.Fields);
            }
            case 1144079448: {
                return new PdfArrayIterator(this.State);
            }
            case 2627089: {
                return new PdfArrayIterator(this.rawXFAasArray);
            }
        }
        return super.getMixedArray(id);
    }

    @Override
    public byte[] getTextStreamValueAsByte(int id) {
        switch (id) {
            case 322257476: {
                return this.rawCert;
            }
            case 1568843969: {
                return this.rawContactInfo;
            }
            case 1216184967: {
                return this.rawContents;
            }
            case 5137: {
                return this.rawDA;
            }
        }
        return super.getTextStreamValueAsByte(id);
    }

    @Override
    public double[] getDoubleArray(int id) {
        switch (id) {
            default: 
        }
        return super.getDoubleArray(id);
    }

    @Override
    public void setDoubleArray(int id, double[] value) {
        switch (id) {
            default: 
        }
        super.setDoubleArray(id, value);
    }

    @Override
    public int[] getIntArray(int id) {
        switch (id) {
            case 25: {
                return FormObject.deepCopy(this.selectionIndices);
            }
            case 2055367785: {
                return FormObject.deepCopy(this.ByteRange);
            }
        }
        return super.getIntArray(id);
    }

    @Override
    public void setIntArray(int id, int[] value) {
        switch (id) {
            case 25: {
                this.selectionIndices = value;
                break;
            }
            case 2055367785: {
                this.ByteRange = value;
                break;
            }
            default: {
                super.setIntArray(id, value);
            }
        }
    }

    @Override
    public void setMixedArray(int id, byte[][] value) {
        switch (id) {
            case 1110722433: {
                this.Border = value;
                break;
            }
            case 339034948: {
                this.DmixedArray = value;
                break;
            }
            case 893143676: {
                this.Fields = value;
                break;
            }
            case 1144079448: {
                this.State = value;
                break;
            }
            case 2627089: {
                this.rawXFAasArray = value;
                break;
            }
            default: {
                super.setMixedArray(id, value);
            }
        }
    }

    @Override
    public float[] getFloatArray(int id) {
        switch (id) {
            case 19: {
                return this.C;
            }
            case 1785890247: {
                return this.QuadPoints;
            }
            case 573911876: {
                return this.Rect;
            }
            case 8724: {
                return this.RD;
            }
        }
        return super.getFloatArray(id);
    }

    @Override
    public void setFloatArray(int id, float[] value) {
        switch (id) {
            case 19: {
                this.C = value;
                break;
            }
            case 1785890247: {
                this.QuadPoints = value;
                break;
            }
            case 8724: {
                this.RD = value;
                break;
            }
            case 573911876: {
                this.Rect = value;
                break;
            }
            default: {
                super.setFloatArray(id, value);
            }
        }
    }

    @Override
    public void setName(int id, byte[] value) {
        switch (id) {
            case 4387: {
                this.rawAS = value;
                break;
            }
            case 5158: {
                this.rawDV = value;
                break;
            }
            case 1011108731: {
                this.rawFilter = value;
                break;
            }
            case -2122953826: {
                this.rawSubFilter = value;
                break;
            }
            case 5668: {
                this.FT = PdfDictionary.generateChecksum(0, value.length, value);
                break;
            }
            case 24: {
                this.rawH = value;
                break;
            }
            case 30: {
                this.rawN = value;
                break;
            }
            case 8740: {
                this.rawRT = value;
                break;
            }
            case 35: {
                this.rawS = value;
                break;
            }
            case 40: {
                this.rawX = value;
                break;
            }
            default: {
                super.setName(id, value);
            }
        }
    }

    @Override
    public void setObjectArray(int id, Object[] objectValues) {
        switch (id) {
            case 4895: {
                this.CO = objectValues;
                break;
            }
            case 475169151: {
                this.InkList = objectValues;
                break;
            }
            case 2048068: {
                this.Opt = objectValues;
                break;
            }
            case 1786013849: {
                this.Reference = objectValues;
                break;
            }
            default: {
                super.setObjectArray(id, objectValues);
            }
        }
    }

    @Override
    public Object[] getObjectArray(int id) {
        switch (id) {
            case 4895: {
                return this.CO;
            }
            case 475169151: {
                return this.InkList;
            }
            case 2048068: {
                return this.Opt;
            }
            case 1786013849: {
                return this.Reference;
            }
        }
        return super.getObjectArray(id);
    }

    @Override
    public byte[][] getStringArray(int id) {
        switch (id) {
            default: 
        }
        return super.getStringArray(id);
    }

    @Override
    public void setStringArray(int id, byte[][] value) {
        switch (id) {
            default: 
        }
        super.setStringArray(id, value);
    }

    @Override
    public void setTextStreamValue(int id, byte[] value) {
        switch (id) {
            case 322257476: {
                this.rawCert = value;
                break;
            }
            case 1568843969: {
                this.rawContactInfo = value;
                break;
            }
            case 1216184967: {
                this.rawContents = value;
                break;
            }
            case 20: {
                this.rawDstring = value;
                break;
            }
            case 5137: {
                this.rawDA = value;
                break;
            }
            case 5158: {
                this.rawDV = value;
                break;
            }
            case 1684763764: {
                this.rawEOPROPtype = value;
                break;
            }
            case 22: {
                this.rawFstring = value;
                break;
            }
            case 6691: {
                this.rawJS = value;
                break;
            }
            case 1618506351: {
                this.rawLocation = value;
                break;
            }
            case 29: {
                this.rawM = value;
                break;
            }
            case 32: {
                this.rawPstring = value;
                break;
            }
            case 8723: {
                this.rawRC = value;
                break;
            }
            case 826499443: {
                this.rawReason = value;
                break;
            }
            case 7709: {
                this.rawNM = value;
                break;
            }
            case 591737402: {
                this.rawSubj = value;
                break;
            }
            case 36: {
                this.rawT = value;
                this.T = null;
                break;
            }
            case 9245: {
                this.rawTM = value;
                break;
            }
            case 9253: {
                this.rawTU = value;
                break;
            }
            case 2433561: {
                this.rawURI = value;
                break;
            }
            case 38: {
                this.rawV = value;
                this.Vstring = null;
                break;
            }
            default: {
                super.setTextStreamValue(id, value);
            }
        }
    }

    @Override
    public void setTextStreamValue(int id, String value) {
        switch (id) {
            case 38: {
                this.Vstring = value;
                break;
            }
            case 36: {
                this.setTextStreamValue(id, StringUtils.toBytes(value));
                break;
            }
            default: {
                super.setTextStreamValue(id, value);
            }
        }
    }

    @Override
    public String getName(int id) {
        switch (id) {
            case 4387: {
                if (this.AS == null && this.rawAS != null) {
                    this.AS = new String(this.rawAS);
                }
                return this.AS;
            }
            case 5668: {
                return null;
            }
            case 24: {
                if (this.H == null && this.rawH != null) {
                    this.H = new String(this.rawH);
                }
                return this.H;
            }
            case 1011108731: {
                if (this.Filter == null && this.rawFilter != null) {
                    this.Filter = new String(this.rawFilter);
                }
                return this.Filter;
            }
            case -2122953826: {
                if (this.SubFilter == null && this.rawSubFilter != null) {
                    this.SubFilter = new String(this.rawSubFilter);
                }
                return this.SubFilter;
            }
            case 30: {
                if (this.N == null && this.rawN != null) {
                    this.N = new String(this.rawN);
                }
                return this.N;
            }
            case 8740: {
                if (this.rawRT != null) {
                    return new String(this.rawRT);
                }
            }
            case 35: {
                if (this.S == null && this.rawS != null) {
                    this.S = new String(this.rawS);
                }
                return this.S;
            }
            case 40: {
                if (this.rawX == null) break;
                return new String(this.rawX);
            }
        }
        return super.getName(id);
    }

    @Override
    public String getTextStreamValue(int id) {
        switch (id) {
            case 322257476: {
                if (this.Cert == null && this.rawCert != null) {
                    this.Cert = StringUtils.getTextString(this.rawCert, false);
                }
                return this.Cert;
            }
            case 1568843969: {
                if (this.ContactInfo == null && this.rawContactInfo != null) {
                    this.ContactInfo = StringUtils.getTextString(this.rawContactInfo, false);
                }
                return this.ContactInfo;
            }
            case 1216184967: {
                if (this.Contents == null && this.rawContents != null) {
                    this.Contents = StringUtils.getTextString(this.rawContents, true);
                }
                return this.Contents;
            }
            case 20: {
                if (this.Dstring == null && this.rawDstring != null) {
                    this.Dstring = StringUtils.getTextString(this.rawDstring, false);
                }
                return this.Dstring;
            }
            case 5137: {
                if (this.DA == null && this.rawDA != null) {
                    this.DA = StringUtils.getTextString(this.rawDA, false);
                }
                return this.DA;
            }
            case 5158: {
                if (this.DV == null && this.rawDV != null) {
                    this.DV = StringUtils.getTextString(this.rawDV, true);
                }
                return this.DV;
            }
            case 1684763764: {
                if (this.EOPROPtype == null && this.rawEOPROPtype != null) {
                    this.EOPROPtype = new String(this.rawEOPROPtype);
                }
                return this.EOPROPtype;
            }
            case 22: {
                if (this.Fstring == null && this.rawFstring != null) {
                    this.Fstring = StringUtils.getTextString(this.rawFstring, false);
                }
                return this.Fstring;
            }
            case 6691: {
                if (this.JSString == null && this.rawJS != null) {
                    this.JSString = StringUtils.getTextString(this.rawJS, true);
                }
                return this.JSString;
            }
            case 7709: {
                if (this.NM == null && this.rawNM != null) {
                    this.NM = StringUtils.getTextString(this.rawNM, false);
                }
                return this.NM;
            }
            case 1618506351: {
                if (this.Location == null && this.rawLocation != null) {
                    this.Location = new String(this.rawLocation);
                }
                return this.Location;
            }
            case 29: {
                if (this.M == null && this.rawM != null) {
                    this.M = new String(this.rawM);
                }
                return this.M;
            }
            case 32: {
                if (this.Pstring == null && this.rawPstring != null) {
                    this.Pstring = StringUtils.getTextString(this.rawPstring, false);
                }
                return this.Pstring;
            }
            case 8723: {
                if (this.RC == null && this.rawRC != null) {
                    this.RC = new String(this.rawRC);
                }
                return this.RC;
            }
            case 826499443: {
                if (this.Reason == null && this.rawReason != null) {
                    this.Reason = new String(this.rawReason);
                }
                return this.Reason;
            }
            case 591737402: {
                if (this.Subj == null && this.rawSubj != null) {
                    this.Subj = StringUtils.getTextString(this.rawSubj, false);
                }
                return this.Subj;
            }
            case 36: {
                if (this.T == null && this.rawT != null) {
                    this.T = StringUtils.getTextString(this.rawT, false);
                }
                if (this.T == null && this.parentPdfObj != null) {
                    return this.parentPdfObj.getTextStreamValue(36);
                }
                return this.T;
            }
            case 9245: {
                if (this.TM == null && this.rawTM != null) {
                    this.TM = StringUtils.getTextString(this.rawTM, false);
                }
                return this.TM;
            }
            case 9253: {
                if (this.TU == null && this.rawTU != null) {
                    this.TU = StringUtils.getTextString(this.rawTU, false);
                }
                return this.TU;
            }
            case 2433561: {
                if (this.URI == null && this.rawURI != null) {
                    this.URI = StringUtils.getTextString(this.rawURI, false);
                }
                return this.URI;
            }
            case 38: {
                if (this.Vstring == null && this.rawV != null) {
                    this.Vstring = StringUtils.getTextString(this.rawV, true);
                }
                return this.Vstring;
            }
        }
        return super.getTextStreamValue(id);
    }

    @Override
    public String getStringValue(int id, int mode) {
        byte[] data = null;
        switch (mode) {
            case 0: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 1: {
                if (data != null) {
                    return new String(data);
                }
                return null;
            }
            case 2: {
                if (data != null) {
                    int len = data.length;
                    if (len > 6 && data[6] == 43) {
                        int length = len - 7;
                        byte[] newData = new byte[length];
                        System.arraycopy(data, 7, newData, 0, length);
                        return new String(newData);
                    }
                    return new String(data);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode) in " + this);
    }

    @Override
    public byte[][] getKeyArray(int id) {
        switch (id) {
            case 456733763: {
                return FormObject.deepCopy(this.Kids);
            }
        }
        return super.getKeyArray(id);
    }

    @Override
    public void setKeyArray(int id, byte[][] value) {
        switch (id) {
            case 456733763: {
                this.Kids = value;
                break;
            }
            default: {
                super.setKeyArray(id, value);
            }
        }
    }

    @Override
    public boolean decompressStreamWhenRead() {
        return true;
    }

    protected void commandFf(int flagValue) {
        this.flags = new boolean[32];
        this.flags[1] = (flagValue & 1) == 1;
        this.flags[2] = (flagValue & 2) == 2;
        this.flags[3] = (flagValue & 4) == 4;
        this.flags[13] = (flagValue & 0x1000) == 4096;
        this.flags[14] = (flagValue & 0x2000) == 8192;
        this.flags[15] = (flagValue & 0x4000) == 16384;
        this.flags[16] = (flagValue & 0x8000) == 32768;
        this.flags[17] = (flagValue & 0x10000) == 65536;
        this.flags[18] = (flagValue & 0x20000) == 131072;
        this.flags[19] = (flagValue & 0x40000) == 262144;
        this.flags[20] = (flagValue & 0x80000) == 524288;
        this.flags[21] = (flagValue & 0x100000) == 0x100000;
        this.flags[22] = (flagValue & 0x200000) == 0x200000;
        this.flags[23] = (flagValue & 0x400000) == 0x400000;
        this.flags[24] = (flagValue & 0x800000) == 0x800000;
        this.flags[25] = (flagValue & 0x1000000) == 0x1000000;
        this.flags[26] = (flagValue & 0x2000000) == 0x2000000;
        this.flags[26] = (flagValue & 0x2000000) == 0x2000000;
        this.flags[27] = (flagValue & 0x4000000) == 0x4000000;
    }

    public static Color generateColor(float[] toks) {
        int i = -1;
        if (toks != null) {
            i = toks.length;
        }
        Color newColor = null;
        if (i == 0) {
            newColor = new Color(0, 0, 0, 0);
        } else if (i == 1) {
            float tok0 = toks[0];
            newColor = tok0 <= 1.0f ? new Color(tok0, tok0, tok0) : new Color((int)tok0, (int)tok0, (int)tok0);
        } else if (i == 3) {
            if (debug) {
                System.out.println("rgb color=" + toks[0] + ' ' + toks[1] + ' ' + toks[2]);
            }
            float tok0 = toks[0];
            float tok1 = toks[1];
            float tok2 = toks[2];
            newColor = tok0 <= 1.0f && tok1 <= 1.0f && tok2 <= 1.0f ? new Color(tok0, tok1, tok2) : new Color((int)tok0, (int)tok1, (int)tok2);
        } else if (i == 4) {
            DeviceCMYKColorSpace cs = new DeviceCMYKColorSpace();
            cs.setColor(new float[]{toks[3], toks[2], toks[1], toks[0]}, 4);
            newColor = (Color)((Object)cs.getColor());
        }
        return newColor;
    }

    public boolean isXFAObject() {
        return this.isXFAObject;
    }

    @Override
    public PdfObject duplicate() {
        FormObject newObject = new FormObject();
        newObject.AS = this.AS;
        newObject.contents = this.contents;
        newObject.Cert = this.Cert;
        newObject.ContactInfo = this.ContactInfo;
        newObject.contents = this.contents;
        newObject.Contents = this.Contents;
        newObject.DA = this.DA;
        newObject.Dstring = this.Dstring;
        newObject.DV = this.DV;
        newObject.Filter = this.Filter;
        newObject.Fstring = this.Fstring;
        newObject.H = this.H;
        newObject.JSString = this.JSString;
        newObject.layerName = this.layerName;
        newObject.Location = this.Location;
        newObject.M = this.M;
        newObject.N = this.N;
        newObject.NM = this.NM;
        newObject.normalOnState = this.normalOnState;
        newObject.Pstring = this.Pstring;
        newObject.ref = this.ref;
        newObject.RC = this.RC;
        newObject.Reason = this.Reason;
        newObject.S = this.S;
        newObject.selectedItem = this.selectedItem;
        newObject.SubFilter = this.SubFilter;
        newObject.Subj = this.Subj;
        newObject.T = this.T;
        newObject.TM = this.TM;
        newObject.TU = this.TU;
        newObject.textString = this.textString;
        newObject.URI = this.URI;
        newObject.Vstring = this.Vstring;
        newObject.F = this.F;
        newObject.Ff = this.Ff;
        newObject.formType = this.formType;
        newObject.FT = this.FT;
        newObject.MaxLen = this.MaxLen;
        newObject.pageNumber = this.pageNumber;
        newObject.popupFlag = this.popupFlag;
        newObject.Q = this.Q;
        newObject.rawRotation = this.rawRotation;
        newObject.SigFlags = this.SigFlags;
        newObject.StructParent = this.StructParent;
        newObject.textSize = this.textSize;
        newObject.TI = this.TI;
        newObject.W = this.W;
        newObject.appearancesUsed = this.appearancesUsed;
        newObject.offsetDownIcon = this.offsetDownIcon;
        newObject.noDownIcon = this.noDownIcon;
        newObject.invertDownIcon = this.invertDownIcon;
        newObject.show = this.show;
        newObject.H_Boolean = this.H_Boolean;
        newObject.NeedAppearances = this.NeedAppearances;
        newObject.isXFAObject = this.isXFAObject;
        newObject.Open = this.Open;
        newObject.textFont = this.textFont;
        newObject.fontName = this.fontName;
        newObject.cColor = this.cColor;
        newObject.OptString = this.OptString == null ? null : (String[])this.OptString.clone();
        newObject.flags = this.flags == null ? null : (boolean[])this.flags.clone();
        newObject.Farray = this.Farray == null ? null : (boolean[])this.Farray.clone();
        newObject.selectionIndices = this.selectionIndices == null ? null : (int[])this.selectionIndices.clone();
        newObject.C = this.C == null ? null : (float[])this.C.clone();
        newObject.InkList = this.InkList == null ? null : (Object[])this.InkList.clone();
        newObject.QuadPoints = this.QuadPoints == null ? null : (float[])this.QuadPoints.clone();
        newObject.Rect = this.Rect == null ? null : (float[])this.Rect.clone();
        newObject.RD = this.RD == null ? null : (float[])this.RD.clone();
        newObject.textColor = this.textColor == null ? null : (float[])this.textColor.clone();
        newObject.A = this.A.duplicate();
        newObject.AA = this.AA.duplicate();
        newObject.AP = this.AP.duplicate();
        newObject.BS = this.BS.duplicate();
        newObject.BI = this.BI.duplicate();
        newObject.Bl = this.Bl.duplicate();
        newObject.Cdict = this.Cdict.duplicate();
        newObject.D = this.D.duplicate();
        newObject.DC = this.DC.duplicate();
        newObject.DP = this.DP.duplicate();
        newObject.DS = this.DS.duplicate();
        newObject.E = this.E.duplicate();
        newObject.Fdict = this.Fdict.duplicate();
        newObject.Fo = this.Fo.duplicate();
        newObject.FS = this.FS.duplicate();
        newObject.IF = this.IF.duplicate();
        newObject.JS = this.JS.duplicate();
        newObject.K = this.K.duplicate();
        newObject.MK = this.MK.duplicate();
        newObject.Next = this.Next.duplicate();
        newObject.Nobj = this.Nobj.duplicate();
        newObject.O = this.O.duplicate();
        newObject.OC = this.OC.duplicate();
        newObject.Off = this.Off.duplicate();
        newObject.On = this.On.duplicate();
        newObject.P = this.P.duplicate();
        newObject.PC = this.PC.duplicate();
        newObject.PI = this.PI.duplicate();
        newObject.PO = this.PO.duplicate();
        newObject.Popup = this.Popup.duplicate();
        newObject.PV = this.PV.duplicate();
        newObject.R = this.R.duplicate();
        newObject.Sig = this.Sig.duplicate();
        newObject.Sound = this.Sound.duplicate();
        newObject.U = this.U.duplicate();
        newObject.V = this.V.duplicate();
        newObject.Win = this.Win.duplicate();
        newObject.WP = this.WP.duplicate();
        newObject.WS = this.WS.duplicate();
        newObject.X = this.X.duplicate();
        newObject.XFAasStream = this.XFAasStream.duplicate();
        newObject.CO = this.CO == null ? null : (Object[])this.CO.clone();
        newObject.Opt = this.Opt == null ? null : (Object[])this.Opt.clone();
        newObject.Reference = this.Reference == null ? null : (Object[])this.Reference.clone();
        newObject.rawAS = this.rawAS == null ? null : (byte[])this.rawAS.clone();
        newObject.rawCert = this.rawCert == null ? null : (byte[])this.rawCert.clone();
        newObject.rawContactInfo = this.rawContactInfo == null ? null : (byte[])this.rawContactInfo.clone();
        newObject.rawContents = this.rawContents == null ? null : (byte[])this.rawContents.clone();
        newObject.rawDA = this.rawDA == null ? null : (byte[])this.rawDA.clone();
        newObject.rawDstring = this.rawDstring == null ? null : (byte[])this.rawDstring.clone();
        newObject.rawDV = this.rawDV == null ? null : (byte[])this.rawDV.clone();
        newObject.rawEOPROPtype = this.rawEOPROPtype == null ? null : (byte[])this.rawEOPROPtype.clone();
        newObject.rawFilter = this.rawFilter == null ? null : (byte[])this.rawFilter.clone();
        newObject.rawFstring = this.rawFstring == null ? null : (byte[])this.rawFstring.clone();
        newObject.rawH = this.rawH == null ? null : (byte[])this.rawH.clone();
        newObject.rawJS = this.rawJS == null ? null : (byte[])this.rawJS.clone();
        newObject.rawLocation = this.rawLocation == null ? null : (byte[])this.rawLocation.clone();
        newObject.rawM = this.rawM == null ? null : (byte[])this.rawM.clone();
        newObject.rawN = this.rawN == null ? null : (byte[])this.rawN.clone();
        newObject.rawNM = this.rawNM == null ? null : (byte[])this.rawNM.clone();
        newObject.rawPstring = this.rawPstring == null ? null : (byte[])this.rawPstring.clone();
        newObject.rawRC = this.rawRC == null ? null : (byte[])this.rawRC.clone();
        newObject.rawReason = this.rawReason == null ? null : (byte[])this.rawReason.clone();
        newObject.rawS = this.rawS == null ? null : (byte[])this.rawS.clone();
        newObject.rawSubFilter = this.rawSubFilter == null ? null : (byte[])this.rawSubFilter.clone();
        newObject.rawSubj = this.rawSubj == null ? null : (byte[])this.rawSubj.clone();
        newObject.rawT = this.rawT == null ? null : (byte[])this.rawT.clone();
        newObject.rawTM = this.rawTM == null ? null : (byte[])this.rawTM.clone();
        newObject.rawTU = this.rawTU == null ? null : (byte[])this.rawTU.clone();
        newObject.rawURI = this.rawURI == null ? null : (byte[])this.rawURI.clone();
        newObject.rawV = this.rawV == null ? null : (byte[])this.rawV.clone();
        newObject.rawX = this.rawX == null ? null : (byte[])this.rawX.clone();
        newObject.Border = this.Border == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.Border);
        newObject.DmixedArray = this.DmixedArray == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.DmixedArray);
        newObject.Fields = this.Fields == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.Fields);
        newObject.rawXFAasArray = this.rawXFAasArray == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.rawXFAasArray);
        newObject.State = this.State == null ? (byte[][])null : ObjectCloneFactory.cloneDoubleArray(this.State);
        newObject.normalOffImage = ObjectCloneFactory.deepCopy(this.normalOffImage);
        newObject.normalOnImage = ObjectCloneFactory.deepCopy(this.normalOnImage);
        newObject.rolloverOffImage = ObjectCloneFactory.deepCopy(this.rolloverOffImage);
        newObject.rolloverOnImage = ObjectCloneFactory.deepCopy(this.rolloverOnImage);
        newObject.downOffImage = ObjectCloneFactory.deepCopy(this.downOffImage);
        newObject.downOnImage = ObjectCloneFactory.deepCopy(this.downOnImage);
        newObject.OptValues = ObjectCloneFactory.cloneMap(this.OptValues);
        return newObject;
    }

    public void copyInheritedValuesFromParent(FormObject parentObj) {
        if (parentObj == null) {
            return;
        }
        if (this.pageNumber == -1 && parentObj.pageNumber != -1) {
            this.pageNumber = parentObj.pageNumber;
        }
        if (this.rawAS == null) {
            this.rawAS = parentObj.rawAS;
        }
        if (this.rawDA == null) {
            this.rawDA = parentObj.rawDA;
        }
        if (this.rawDV == null) {
            this.rawDV = parentObj.rawDV;
        }
        if (this.rawJS == null) {
            this.rawJS = parentObj.rawJS;
        }
        if (this.rawNM == null) {
            this.rawNM = parentObj.rawNM;
        }
        if (this.rawTM == null) {
            this.rawTM = parentObj.rawTM;
        }
        if (this.rawTU == null) {
            this.rawTU = parentObj.rawTU;
        }
        if (this.rawV == null) {
            this.rawV = parentObj.rawV;
        }
        if (parentObj.T == null && parentObj.rawT != null) {
            parentObj.T = StringUtils.getTextString(parentObj.rawT, false);
        }
        if (parentObj.T != null) {
            if (this.T == null && this.rawT != null) {
                this.T = StringUtils.getTextString(this.rawT, false);
            }
            if (this.T != null && !this.T.contains(parentObj.T)) {
                this.T = parentObj.T + '.' + this.T;
                this.rawT = StringUtils.toBytes(this.T);
            }
        }
        if (this.A == null) {
            this.A = parentObj.A;
        }
        if (this.AA == null) {
            this.AA = parentObj.AA;
        }
        if (this.AP == null) {
            this.AP = parentObj.AP;
        }
        if (this.D == null) {
            this.D = parentObj.D;
        }
        if (this.OC == null) {
            this.OC = parentObj.OC;
        }
        if (this.C == null) {
            float[] fArray = this.C = parentObj.C == null ? null : (float[])parentObj.C.clone();
        }
        if (this.QuadPoints == null) {
            float[] fArray = this.QuadPoints = parentObj.QuadPoints == null ? null : (float[])parentObj.QuadPoints.clone();
        }
        if (this.InkList == null) {
            Object[] objectArray = this.InkList = parentObj.InkList == null ? null : (Object[])parentObj.InkList.clone();
        }
        if (this.Rect == null) {
            float[] fArray = this.Rect = parentObj.Rect == null ? null : (float[])parentObj.Rect.clone();
        }
        if (this.F == -1) {
            this.F = parentObj.F;
        }
        if (this.Ff == -1) {
            this.Ff = parentObj.Ff;
        }
        if (this.Q == -1) {
            this.Q = parentObj.Q;
        }
        if (this.MaxLen == -1) {
            this.MaxLen = parentObj.MaxLen;
        }
        if (this.FT == -1) {
            this.FT = parentObj.FT;
        }
        if (this.TI == -1) {
            this.TI = parentObj.TI;
        }
        if (this.flags == null) {
            boolean[] blArray = this.flags = parentObj.flags == null ? null : (boolean[])parentObj.flags.clone();
        }
        if (this.Opt == null) {
            Object[] objectArray = this.Opt = parentObj.Opt == null ? null : (Object[])parentObj.Opt.clone();
        }
        if (this.CO == null) {
            Object[] objectArray = this.CO = parentObj.CO == null ? null : (Object[])parentObj.CO.clone();
        }
        if (this.textString == null) {
            this.textString = parentObj.textString;
        }
        if (this.OptString == null) {
            this.OptString = parentObj.OptString;
        }
        if (this.selectedItem == null) {
            this.selectedItem = parentObj.selectedItem;
        }
    }

    public int getAlignment() {
        if (this.Q == -1) {
            this.Q = 2;
        }
        return this.Q;
    }

    public void setTextColor(float[] color) {
        if (color.length > 0 && Float.isNaN(color[0])) {
            float[] tmp = new float[color.length - 1];
            System.arraycopy(color, 1, tmp, 0, color.length - 1);
            color = tmp;
        }
        this.textColor = color;
    }

    public void setFontName(String font) {
        this.fontName = font;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void setTextSize(int size) {
        this.textSize = size;
    }

    public void setTextValue(String text) {
        if (text == null) {
            text = "";
        }
        this.updateValue(text, false, true);
    }

    public void setSelection(Object[] selectedValues, String curValue, int[] indices, int index) {
        if (index != this.selectionIndex) {
            this.selectedValues = selectedValues;
            this.selectedItem = curValue;
            this.selectionIndex = index;
            this.selectionIndices = indices;
            if (this.guiComp != null) {
                this.updateCombo();
            }
        }
    }

    public void setFieldName(String field) {
        this.T = null;
        this.setTextStreamValue(36, StringUtils.toBytes(field));
    }

    public void setParent(String parent) {
        this.setParent(parent, null, false);
    }

    public void setParent(String parent, FormObject parentObj, boolean copyValuesFromParent) {
        if (copyValuesFromParent) {
            this.copyInheritedValuesFromParent(parentObj);
        }
        this.parentRef = parent;
        if (parentObj != null) {
            this.parentPdfObj = parentObj;
        }
    }

    public PdfObject getParentPdfObj() {
        return this.parentPdfObj;
    }

    public void setParentPdfObj(PdfObject parent) {
        this.parentPdfObj = parent;
    }

    public String getParentRef() {
        if (this.parentRef == null && this.includeParent) {
            return this.getStringKey(1110793845);
        }
        return this.parentRef;
    }

    private static boolean[] calcFarray(int flagValue) {
        if (flagValue == 0) {
            return new boolean[10];
        }
        boolean[] Farray = new boolean[10];
        int[] pow = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
        for (int jj = 1; jj < 10; ++jj) {
            if ((flagValue & pow[jj]) != pow[jj]) continue;
            Farray[jj - 1] = true;
        }
        return Farray;
    }

    public Rectangle2D getBounding2DRectangleForTabbing() {
        float[] coords = this.getFloatArray(573911876);
        if (coords != null) {
            float tmp;
            float x1 = coords[0];
            float y1 = coords[1];
            float x2 = coords[2];
            float y2 = coords[3];
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            double ix1 = x1;
            double iy1 = y1;
            double ix2 = x2 + (float)(x2 - x2 > 0.0f ? 1 : 0);
            double iy2 = y2 + (float)(y2 - y2 > 0.0f ? 1 : 0);
            return new Rectangle2D.Double(ix1, iy1, ix2 - ix1, iy2 - iy1);
        }
        if (this.currentLocation != null) {
            this.BBox.x += this.currentLocation.x;
            this.BBox.y += -this.currentLocation.y;
        }
        return this.BBox;
    }

    public Rectangle getBoundingRectangle() {
        float[] coords = this.getFloatArray(573911876);
        if (coords != null) {
            float tmp;
            float x1 = coords[0];
            float y1 = coords[1];
            float x2 = coords[2];
            float y2 = coords[3];
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            int ix1 = (int)x1;
            int iy1 = (int)y1;
            int ix2 = (int)x2 + (x2 - (float)((int)x2) > 0.0f ? 1 : 0);
            int iy2 = (int)y2 + (y2 - (float)((int)y2) > 0.0f ? 1 : 0);
            this.BBox = new Rectangle(ix1, iy1, ix2 - ix1, iy2 - iy1);
        }
        if (this.currentLocation != null) {
            this.BBox.x += this.currentLocation.x;
            this.BBox.y += -this.currentLocation.y;
        }
        return this.BBox;
    }

    public void setType(int type, boolean isXFA) {
        if (isXFA) {
            this.FT = type;
        }
    }

    public void setFlag(int pos, boolean flag) {
        if (this.flags == null) {
            this.flags = new boolean[32];
        }
        this.flags[pos] = flag;
    }

    public boolean[] getFieldFlags() {
        if (this.flags == null) {
            this.flags = new boolean[32];
        }
        return this.flags;
    }

    public void setNormalOnState(String state) {
        this.normalOnState = state;
    }

    public boolean isAppearanceUsed() {
        return this.appearancesUsed;
    }

    public void setAppreancesUsed(boolean used) {
        this.appearancesUsed = used;
    }

    public void setAppearanceImage(BufferedImage image, int imageType, int status) {
        if (image == null) {
            image = FormObject.getOpaqueImage();
        }
        switch (imageType) {
            case 20: {
                if (status == 7998) {
                    this.downOnImage = image;
                    break;
                }
                if (status == 2045494) {
                    this.downOffImage = image;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 30: {
                if (status == 7998) {
                    this.normalOnImage = image;
                    break;
                }
                if (status == 2045494) {
                    this.normalOffImage = image;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            case 34: {
                if (status == 7998) {
                    this.rolloverOnImage = image;
                    break;
                }
                if (status == 2045494) {
                    this.rolloverOffImage = image;
                    break;
                }
                throw new RuntimeException("Unknown status use PdfDictionary.On or PdfDictionary.Off");
            }
            default: {
                throw new RuntimeException("Unknown type use PdfDictionary.D, PdfDictionary.N or PdfDictionary.R");
            }
        }
        this.appearancesUsed = true;
    }

    public void setBorderColor(String nextField) {
        if (nextField != null) {
            this.getDictionary(7451).setFloatArray(4627, FormObject.generateFloatFromString(nextField));
        }
    }

    public void setBackgroundColor(String nextField) {
        if (nextField != null) {
            this.getDictionary(7451).setFloatArray(4631, FormObject.generateFloatFromString(nextField));
        }
    }

    private static float[] generateFloatFromString(String colorString) {
        if (debug) {
            System.out.println("CHECK generateColorFromString=" + colorString);
        }
        StringTokenizer tokens = new StringTokenizer(colorString, "[()] ,");
        float[] toks = new float[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if (debug) {
                System.out.println("token" + (i + 1) + '=' + tok + ' ' + colorString);
            }
            toks[i] = Float.parseFloat(tok);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return toks;
    }

    public void setNormalCaption(String caption) {
        if (caption != null) {
            this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(caption));
        }
    }

    protected void setOffsetDownApp() {
        this.offsetDownIcon = true;
    }

    protected void setNoDownIcon() {
        this.noDownIcon = true;
    }

    protected void setInvertForDownIcon() {
        this.invertDownIcon = true;
    }

    public boolean hasNormalOff() {
        return this.normalOffImage != null;
    }

    public boolean hasRolloverOff() {
        return this.rolloverOffImage != null;
    }

    public boolean hasDownOff() {
        return this.downOffImage != null;
    }

    public boolean hasDownImage() {
        return this.downOnImage != null || this.hasDownOff();
    }

    public void overwriteWith(FormObject form) {
        if (form == null) {
            return;
        }
        if (form.parentRef != null) {
            this.parentRef = form.parentRef;
        }
        if (form.flags != null) {
            this.flags = (boolean[])form.flags.clone();
        }
        if (form.selectionIndices != null) {
            this.selectionIndices = (int[])form.selectionIndices.clone();
        }
        if (form.selectedItem != null) {
            this.selectedItem = form.selectedItem;
        }
        if (form.ref != null) {
            this.ref = form.ref;
        }
        if (form.textColor != null) {
            this.textColor = (float[])form.textColor.clone();
        }
        if (form.textFont != null) {
            this.textFont = form.textFont;
        }
        if (form.textSize != -1) {
            this.textSize = form.textSize;
        }
        if (form.textString != null) {
            this.textString = form.textString;
        }
        if (form.appearancesUsed) {
            this.appearancesUsed = form.appearancesUsed;
        }
        if (form.offsetDownIcon) {
            this.offsetDownIcon = form.offsetDownIcon;
        }
        if (form.noDownIcon) {
            this.noDownIcon = form.noDownIcon;
        }
        if (form.invertDownIcon) {
            this.invertDownIcon = form.invertDownIcon;
        }
        if (form.normalOffImage != null) {
            this.normalOffImage = form.normalOffImage;
        }
        if (form.normalOnImage != null) {
            this.normalOnImage = form.normalOnImage;
        }
        if (form.rolloverOffImage != null) {
            this.rolloverOffImage = form.rolloverOffImage;
        }
        if (form.rolloverOnImage != null) {
            this.rolloverOnImage = form.rolloverOnImage;
        }
        if (form.downOffImage != null) {
            this.downOffImage = form.downOffImage;
        }
        if (form.downOnImage != null) {
            this.downOnImage = form.downOnImage;
        }
        if (form.pageNumber != -1) {
            this.pageNumber = form.pageNumber;
        }
        if (form.cColor != null) {
            this.cColor = form.cColor;
        }
        if (form.contents != null) {
            this.contents = form.contents;
        }
        if (form.show) {
            this.show = form.show;
        }
        this.AA = form.AA;
        this.AP = form.AP;
        this.BS = form.BS;
        this.D = form.D;
        this.OC = form.OC;
        this.C = form.C == null ? null : (float[])form.C.clone();
        this.QuadPoints = form.QuadPoints == null ? null : (float[])form.QuadPoints.clone();
        this.InkList = form.InkList == null ? null : (Object[])form.InkList.clone();
        this.F = form.F;
        this.Ff = form.Ff;
        this.CO = form.CO == null ? null : (Object[])form.CO.clone();
        this.Opt = form.Opt == null ? null : (Object[])form.Opt.clone();
        this.Q = form.Q;
        this.MaxLen = form.MaxLen;
        this.FT = form.FT;
        this.rawAS = form.rawAS == null ? null : (byte[])form.rawAS.clone();
        this.rawDA = form.rawDA == null ? null : (byte[])form.rawDA.clone();
        this.rawDV = form.rawDV == null ? null : (byte[])form.rawDV.clone();
        this.rawJS = form.rawJS == null ? null : (byte[])form.rawJS.clone();
        this.rawNM = form.rawNM == null ? null : (byte[])form.rawNM.clone();
        this.rawTM = form.rawTM == null ? null : (byte[])form.rawTM.clone();
        this.rawTU = form.rawTU == null ? null : (byte[])form.rawTU.clone();
        this.rawV = form.rawV == null ? null : (byte[])form.rawV.clone();
        this.T = form.T;
        this.rawT = form.rawT == null ? null : (byte[])form.rawT.clone();
        this.Rect = form.Rect == null ? null : (float[])form.Rect.clone();
        this.TI = form.TI;
        this.MK = form.MK == null ? null : (PdfObject)form.MK.clone();
        this.setSelected(form.isSelected);
    }

    public boolean[] getCharacteristics() {
        if (this.Farray == null) {
            this.Farray = this.F == -1 ? new boolean[10] : FormObject.calcFarray(this.F);
        }
        return this.Farray;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public Map getValuesMap(boolean keyFirst) {
        Object[] rawOpt;
        if (this.Opt != null && this.OptValues == null && (rawOpt = this.getObjectArray(2048068)) != null) {
            for (Object aRawOpt : rawOpt) {
                String value;
                String key;
                if (!(aRawOpt instanceof Object[])) continue;
                Object[] obj = (Object[])aRawOpt;
                if (keyFirst) {
                    key = StringUtils.getTextString((byte[])obj[0], false);
                    value = StringUtils.getTextString((byte[])obj[1], false);
                } else {
                    key = StringUtils.getTextString((byte[])obj[1], false);
                    value = StringUtils.getTextString((byte[])obj[0], false);
                }
                if (this.OptValues == null) {
                    this.OptValues = new HashMap();
                }
                this.OptValues.put(key, value);
            }
        }
        if (this.OptValues == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.OptValues);
    }

    public String[] getItemsList() {
        Object[] rawOpt;
        if (this.OptString == null && (rawOpt = this.getObjectArray(2048068)) != null) {
            int count = rawOpt.length;
            this.OptString = new String[count];
            for (int ii = 0; ii < count; ++ii) {
                if (rawOpt[ii] instanceof Object[]) {
                    Object[] obj = (Object[])rawOpt[ii];
                    this.OptString[ii] = StringUtils.getTextString((byte[])obj[1], false);
                    continue;
                }
                if (rawOpt[ii] instanceof byte[]) {
                    this.OptString[ii] = StringUtils.getTextString((byte[])rawOpt[ii], false);
                    continue;
                }
                if (rawOpt[ii] == null) continue;
            }
        }
        return this.OptString;
    }

    public String getSelectedItem() {
        if (this.selectedItem == null) {
            this.selectedItem = this.getTextStreamValue(38);
        }
        if (this.selectedItem == null && this.selectionIndices != null) {
            String[] items = this.getItemsList();
            int itemSelected = this.selectionIndices[0];
            if (items != null && itemSelected > -1 && itemSelected < items.length) {
                this.selectedItem = items[itemSelected];
            }
        }
        return this.selectedItem;
    }

    public int[] getSelectionIndices() {
        if (this.selectionIndices == null && this.TI != -1) {
            this.selectionIndices = new int[1];
            this.selectionIndices[0] = this.TI;
            this.selectionIndex = this.TI;
        }
        return this.selectionIndices;
    }

    public String getTextString() {
        if (this.textString == null) {
            this.textString = this.getTextStreamValue(38);
        }
        if (this.textString == null && this.getTextStreamValue(5158) != null) {
            return this.getTextStreamValue(5158);
        }
        this.textString = this.textString != null ? this.textString.replaceAll("\r", "\n").trim() : "";
        return this.textString;
    }

    public int getTextPosition() {
        return this.getDictionary(7451).getInt(9248);
    }

    public String getNormalOnState() {
        return this.normalOnState;
    }

    public BufferedImage getNormalOffImage() {
        return this.normalOffImage;
    }

    public BufferedImage getNormalOnImage() {
        return this.normalOnImage;
    }

    public BufferedImage getAPImage(int type, int key) {
        BufferedImage image = null;
        block0 : switch (type) {
            case 7998: {
                switch (key) {
                    case 20: {
                        image = this.downOnImage;
                        break;
                    }
                    case 30: {
                        image = this.normalOnImage;
                        break;
                    }
                    case 34: {
                        image = this.rolloverOnImage;
                    }
                }
                break;
            }
            case 2045494: {
                switch (key) {
                    case 20: {
                        image = this.downOffImage;
                        break block0;
                    }
                    case 30: {
                        image = this.normalOffImage;
                        break block0;
                    }
                    case 34: {
                        image = this.rolloverOffImage;
                    }
                }
            }
        }
        return image;
    }

    public boolean hasNoDownIcon() {
        return this.noDownIcon;
    }

    public boolean hasOffsetDownIcon() {
        return this.offsetDownIcon;
    }

    public boolean hasInvertDownIcon() {
        return this.invertDownIcon;
    }

    public BufferedImage getDownOffImage() {
        return this.downOffImage;
    }

    public BufferedImage getDownOnImage() {
        return this.downOnImage;
    }

    public BufferedImage getRolloverOffImage() {
        return this.rolloverOffImage;
    }

    public BufferedImage getRolloverOnImage() {
        return this.rolloverOnImage;
    }

    public Font getTextFont() {
        if (this.textFont == null) {
            this.textFont = new Font("Arial", 0, 8);
        }
        return this.textFont;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getTextColor() {
        return FormObject.generateColor(this.textColor);
    }

    public String getLayerName() {
        PdfObject OC;
        if (this.layerName == null && (OC = this.getDictionary(7955)) != null) {
            this.layerName = OC.getName(506543413);
        }
        return this.layerName;
    }

    public String getValue() {
        int subtype = this.getParameterConstant(1147962727);
        switch (subtype) {
            case 9288: {
                return this.getTextString();
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                return this.selectedItem;
            }
            case 1197118: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
            case 2308407: {
                return this.getDictionary(7451).getTextStreamValue(4881);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void setValue(String inVal) {
        int subtype = this.getParameterConstant(1147962727);
        switch (subtype) {
            case 9288: {
                String curVal = this.getTextStreamValue(38);
                if (curVal != null && curVal.equals(inVal) || this.textString != null && this.textString.equals(inVal)) break;
                if (inVal == null) {
                    inVal = "";
                }
                this.textString = inVal;
                break;
            }
            case 4920: {
                if (this.selectedItem == null) {
                    this.selectedItem = this.getTextStreamValue(38);
                }
                if (this.selectedItem != null && this.selectedItem.equals(inVal)) break;
                this.selectedItem = inVal;
                break;
            }
            case 1197118: {
                String CA = this.getDictionary(7451).getTextStreamValue(4881);
                if (CA != null && CA.equals(inVal)) break;
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(inVal));
                break;
            }
            default: {
                String CA = this.getDictionary(7451).getTextStreamValue(4881);
                if (CA != null && CA.equals(inVal)) break;
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(inVal));
            }
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.BS == null) {
            this.BS = new FormObject();
        }
        this.BS.setIntNumber(39, lineWidth);
    }

    public void setBorderWidth(int width) {
        this.setLineWidth(width);
    }

    public void setUserSetOffset(Point offset) {
        if (this.currentLocation == null) {
            this.currentLocation = new Point();
        }
        this.currentLocation.x = (int)((float)offset.x / this.currentScaling);
        this.currentLocation.y = (int)((float)offset.y / this.currentScaling);
    }

    public void setCurrentScaling(float scale) {
        this.currentScaling = scale;
    }

    public float getCurrentScaling() {
        return this.currentScaling;
    }

    public String buttonGetCaption() {
        return this.buttonGetCaption(0);
    }

    public String buttonGetCaption(int nFace) {
        switch (nFace) {
            case 1: {
                return this.getDictionary(7451).getTextStreamValue(4371);
            }
            case 2: {
                return this.getDictionary(7451).getTextStreamValue(8723);
            }
        }
        return this.getDictionary(7451).getTextStreamValue(4881);
    }

    public void buttonSetCaption(String cCaption) {
        this.buttonSetCaption(cCaption, 0);
    }

    public void buttonSetCaption(String cCaption, int nFace) {
        switch (nFace) {
            case 1: {
                this.getDictionary(7451).setTextStreamValue(4371, StringUtils.toBytes(cCaption));
                break;
            }
            case 2: {
                this.getDictionary(7451).setTextStreamValue(8723, StringUtils.toBytes(cCaption));
                break;
            }
            default: {
                this.getDictionary(7451).setTextStreamValue(4881, StringUtils.toBytes(cCaption));
            }
        }
    }

    public Object getfillColor() {
        return FormObject.generateColor(this.getDictionary(7451).getFloatArray(4631));
    }

    public void setfillColor(float[] newColor) {
        if (newColor != null) {
            if (newColor.length > 0 && Float.isNaN(newColor[0])) {
                float[] tmp = new float[newColor.length - 1];
                System.arraycopy(newColor, 1, tmp, 0, newColor.length - 1);
                newColor = tmp;
            }
            this.getDictionary(7451).setFloatArray(4631, newColor);
        }
    }

    public void setfillColor(Object newColor) {
        if (newColor != null) {
            float[] color = DisplayJavascriptActions.convertToColorFloatArray((String)newColor);
            this.getDictionary(7451).setFloatArray(4631, color);
        }
    }

    public void setFormType(int widgetType) {
        this.formType = widgetType;
    }

    public int getFormType() {
        return this.formType;
    }

    public static BufferedImage getOpaqueImage() {
        return new BufferedImage(20, 20, 2);
    }

    public void setGUIComponent(Object guiComp, int guiType) {
        this.guiComp = guiComp;
        this.guiType = guiType;
    }

    public Object getGUIComponent() {
        return this.guiComp;
    }

    public boolean isReadOnly() {
        boolean isReadOnly = false;
        boolean[] flags = this.getFieldFlags();
        boolean[] characteristics = this.getCharacteristics();
        if (flags != null && flags[1] || characteristics != null && characteristics[9]) {
            isReadOnly = true;
        }
        return isReadOnly;
    }

    public void updateValue(Object value, boolean isSelected, boolean sync) {
        if (this.isReadOnly()) {
            return;
        }
        if (GenericFormFactory.isTextForm(this.formType)) {
            this.textString = (String)value;
            if (this.textString != null && this.textString.equals(this.lastTextString)) {
                sync = false;
            }
            this.lastTextString = this.textString;
        } else {
            this.textString = (String)value;
            this.isSelected = isSelected;
            if (isSelected != this.lastIsSelected && this.lastTextString != null && this.textString != null && this.textString.equals(this.lastTextString)) {
                sync = false;
            }
            this.lastTextString = this.textString;
            this.lastIsSelected = isSelected;
        }
        if (sync && this.guiType != 2 && this.guiComp != null) {
            this.syncGUI(value);
        }
    }

    private void syncGUI(final Object value) {
        if (this.guiType == 1) {
            if (SwingUtilities.isEventDispatchThread()) {
                FormObject.setGUI(this.formType, value, this.guiComp, this.guiType);
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        FormObject.setGUI(FormObject.this.formType, value, FormObject.this.guiComp, FormObject.this.guiType);
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        } else if (this.guiType == 5) {
            FormObject.setGUI(this.formType, value, this.guiComp, this.guiType);
        }
    }

    private static void setGUI(int formType, Object value, Object guiComp, int guiType) {
        block13: {
            try {
                if (guiType == 5) {
                    if (fxSupport != null) {
                        fxSupport.renderGUIComponent(formType, value, guiComp, guiType);
                    }
                } else if (guiType == 1) {
                    if (GenericFormFactory.isTextForm(formType)) {
                        ((JTextComponent)guiComp).setText((String)value);
                    } else if (formType == 9) {
                        ((JCheckBox)guiComp).setSelected(Boolean.valueOf((String)value));
                    } else if (GenericFormFactory.isButtonForm(formType)) {
                        ((JRadioButton)guiComp).setText((String)value);
                        ((JRadioButton)guiComp).setSelected(Boolean.valueOf((String)value));
                    } else if (formType == 10 && guiComp instanceof JButton) {
                        ((JButton)guiComp).setSelected(Boolean.valueOf((String)value));
                    }
                }
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Caught an Exception " + ee);
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean setSelected) {
        this.isSelected = setSelected;
        if (this.guiComp != null) {
            this.syncGUI(setSelected);
        }
    }

    public int getSelectedIndex() {
        return this.selectionIndex;
    }

    public void setSelectedIndex(int index) {
        if (index != this.selectionIndex) {
            this.selectionIndex = index;
            this.selectionIndices = new int[1];
            this.selectionIndices[0] = index;
            if (this.guiComp != null) {
                if (this.guiType == 5) {
                    if (fxSupport != null) {
                        this.selectedItem = JavaFXSupport.getSelectedItem(this.guiComp, this.formType);
                    }
                } else if (SwingUtilities.isEventDispatchThread()) {
                    if (this.formType == 2) {
                        ((JComboBox)this.guiComp).setSelectedIndex(this.selectionIndex);
                        this.selectedItem = (String)((JComboBox)this.guiComp).getSelectedItem();
                    } else {
                        ((JList)this.guiComp).setSelectedIndex(this.selectionIndex);
                        this.selectedItem = (String)((JList)this.guiComp).getSelectedValue();
                    }
                } else {
                    Runnable doPaintComponent = new Runnable(){

                        @Override
                        public void run() {
                            if (FormObject.this.formType == 2) {
                                ((JComboBox)FormObject.this.guiComp).setSelectedIndex(FormObject.this.selectionIndex);
                                FormObject.this.selectedItem = (String)((JComboBox)FormObject.this.guiComp).getSelectedItem();
                            } else {
                                ((JList)FormObject.this.guiComp).setSelectedIndex(FormObject.this.selectionIndex);
                                FormObject.this.selectedItem = (String)((JList)FormObject.this.guiComp).getSelectedValue();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(doPaintComponent);
                }
            }
        }
    }

    public void setSelectedItem(String value) {
        this.selectedItem = value;
        if (this.guiComp != null) {
            this.updateCombo();
        }
    }

    private void updateCombo() {
        if (this.formType == 2 || this.formType == 1) {
            if (this.guiType == 5) {
                if (fxSupport != null) {
                    JavaFXSupport.select(this.guiComp, this.selectedItem, this.formType);
                }
            } else if (SwingUtilities.isEventDispatchThread()) {
                if (this.formType == 2) {
                    ((JComboBox)this.guiComp).setSelectedItem(this.selectedItem);
                } else {
                    ((JList)this.guiComp).setSelectedValue(this.selectedItem, true);
                }
            } else {
                Runnable doPaintComponent = new Runnable(){

                    @Override
                    public void run() {
                        if (FormObject.this.formType == 2) {
                            ((JComboBox)FormObject.this.guiComp).setSelectedItem(FormObject.this.selectedItem);
                        } else {
                            ((JList)FormObject.this.guiComp).setSelectedValue(FormObject.this.selectedItem, true);
                        }
                    }
                };
                SwingUtilities.invokeLater(doPaintComponent);
            }
        } else {
            throw new RuntimeException("Unexpected type must be FormFactory.combobox or FormFactory.list");
        }
    }

    public float getFontSize() {
        return 12.0f;
    }

    public Object getFormValue() {
        Object retValue;
        switch (this.formType) {
            case 9: {
                retValue = this.isSelected;
                break;
            }
            case 2: {
                retValue = this.isSelected;
                break;
            }
            case 1: {
                retValue = this.selectedValues;
                break;
            }
            case 8: {
                retValue = this.isSelected;
                break;
            }
            default: {
                retValue = this.getTextString();
            }
        }
        return retValue;
    }

    public String getLastValidValue() {
        return this.validValue;
    }

    public void setLastValidValue(String value) {
        this.validValue = value;
    }

    public void setPageRotation(int rotation) {
        this.rawRotation = rotation;
    }

    public void setVisible(boolean isVisible) {
        if (this.guiComp != null) {
            if (this.guiType == 5) {
                if (fxSupport != null) {
                    JavaFXSupport.setVisible(this.guiComp, isVisible);
                }
            } else {
                ((JComponent)this.guiComp).setVisible(isVisible);
            }
        }
    }

    public int getRotationOriginX() {
        return this.rotationOriginX;
    }

    public void setRotationOriginX(int rotationOriginX) {
        this.rotationOriginX = rotationOriginX;
    }

    public int getRotationOriginY() {
        return this.rotationOriginY;
    }

    public void setRotationOriginY(int rotationOriginY) {
        this.rotationOriginY = rotationOriginY;
    }

    public int getElemRotationDegree() {
        return this.elemRotationDegree;
    }

    public void setElemRotationDegree(int elemRotationDegree) {
        this.elemRotationDegree = elemRotationDegree;
    }

    public void setMatteBorderDetails(int[] matteDetails) {
        this.matteDetails = matteDetails;
    }

    public int[] getMatteBorderDetails() {
        return this.matteDetails;
    }
}

