/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;

public class PdfKeyPairsIterator {
    private final byte[][] keys;
    private final byte[][] values;
    private final PdfObject[] objs;
    int maxCount;
    int current;

    public PdfKeyPairsIterator(byte[][] keys, byte[][] values, PdfObject[] objs) {
        this.keys = keys;
        this.values = values;
        this.objs = objs;
        if (keys != null) {
            this.maxCount = keys.length;
        }
        this.current = 0;
    }

    public int getTokenCount() {
        return this.maxCount;
    }

    public void nextPair() {
        if (this.current < this.maxCount) {
            ++this.current;
        } else {
            throw new RuntimeException("No keys left in PdfKeyPairsIterator");
        }
    }

    public String getNextKeyAsString() {
        return new String(this.keys[this.current]);
    }

    public int getNextKeyAsNumber() {
        int length = this.keys[this.current].length;
        boolean isNumber = this.isNextKeyANumber();
        if (!isNumber) {
            if (this.keys[this.current].length != 1) {
                throw new RuntimeException("Unexpected value in getNextKeyAsNumber >" + new String(this.keys[this.current]) + '<');
            }
            return this.keys[this.current][0] & 0xFF;
        }
        return NumberUtils.parseInt(0, length, this.keys[this.current]);
    }

    public boolean isNextKeyANumber() {
        int length = this.keys[this.current].length;
        boolean isNumber = true;
        for (int ii = 0; ii < length; ++ii) {
            byte nextChar = this.keys[this.current][ii];
            if (nextChar >= 48 && nextChar <= 57) continue;
            isNumber = false;
            ii = length;
        }
        return isNumber;
    }

    public boolean hasMorePairs() {
        return this.current < this.maxCount;
    }

    public String getNextValueAsString() {
        if (this.values[this.current] == null) {
            return null;
        }
        return new String(this.values[this.current]);
    }

    public PdfObject getNextValueAsDictionary() {
        return this.objs[this.current];
    }
}

