/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.structuredtext.StructuredContentHandler;
import org.jpedal.render.DynamicVectorRenderer;

public class HTMLStructuredContentHandler
extends StructuredContentHandler {
    public HTMLStructuredContentHandler(Object markedContent, DynamicVectorRenderer current) {
        super(markedContent);
        this.current = current;
        this.isHTML = true;
    }

    @Override
    public void BDC(PdfObject BDCobj) {
        super.BDC(BDCobj);
        if (BDCobj != null) {
            this.setHTMLTag(BDCobj, true);
        }
    }

    private void setHTMLTag(PdfObject BDCobj, boolean isOpenTag) {
        int MCID = BDCobj.getInt(487790868);
        String param = (String)this.values.get(String.valueOf(MCID));
        if (isOpenTag) {
            this.current.writeCustom(40, param);
        } else {
            this.current.writeCustom(42, param);
        }
    }

    @Override
    public void BMC(String op) {
        this.setBMCvalues(op);
        PdfObject BDCobj = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
        if (BDCobj != null) {
            this.setHTMLTag(BDCobj, true);
        }
    }

    @Override
    public void EMC() {
        this.setEMCValues();
        PdfObject BDCobj = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
        if (BDCobj != null) {
            this.setHTMLTag(BDCobj, false);
        }
    }
}

