/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.structuredtext;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.render.DynamicVectorRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class StructuredContentHandler {
    private final Map markedContentProperties;
    int markedContentLevel;
    private StringBuffer markedContentSequence;
    private static final boolean debug = false;
    private boolean contentExtracted;
    private String currentKey;
    final Map keys;
    final Map dictionaries;
    Map values;
    final boolean buildDirectly;
    DynamicVectorRenderer current;
    Document doc;
    Element root;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    boolean isHTML;

    public StructuredContentHandler(Object markedContent) {
        if (markedContent instanceof Map) {
            this.buildDirectly = false;
            this.values = (Map)markedContent;
        } else {
            this.buildDirectly = true;
            this.doc = (Document)markedContent;
            this.root = this.doc.createElement("TaggedPDF-doc");
            this.doc.appendChild(this.root);
        }
        this.markedContentProperties = new HashMap();
        this.markedContentLevel = 0;
        this.markedContentSequence = new StringBuffer();
        this.currentKey = "";
        this.keys = new HashMap();
        this.dictionaries = new HashMap();
    }

    public void DP(PdfObject BDCobj) {
    }

    public void BDC(PdfObject BDCobj) {
        int MCID;
        if (this.markedContentLevel == 0) {
            this.markedContentSequence = new StringBuffer();
        }
        ++this.markedContentLevel;
        if (this.buildDirectly) {
            BDCobj.setIntNumber(487790868, -1);
        }
        if ((MCID = BDCobj.getInt(487790868)) != -1) {
            this.keys.put(this.markedContentLevel, String.valueOf(MCID));
        }
        this.dictionaries.put(String.valueOf(this.markedContentLevel), BDCobj);
    }

    public void BMC(String op) {
        op = this.setBMCvalues(op);
        if (this.buildDirectly && op != null) {
            Element newRoot = (Element)this.root.getElementsByTagName(op).item(0);
            if (newRoot == null) {
                newRoot = this.doc.createElement(op);
                this.root.appendChild(newRoot);
            }
            this.root = newRoot;
        }
    }

    String setBMCvalues(String op) {
        if (op.startsWith("/")) {
            op = op.substring(1);
        }
        if (this.markedContentLevel == 0 && !this.isHTML) {
            this.markedContentSequence = new StringBuffer();
        }
        this.markedContentProperties.put(this.markedContentLevel, op);
        ++this.markedContentLevel;
        this.keys.put(this.markedContentLevel, op);
        return op;
    }

    public void EMC() {
        this.setEMCValues();
        if (this.buildDirectly) {
            Map metadata;
            boolean isBMC;
            PdfObject BDCobj = (PdfObject)this.dictionaries.get(this.currentKey);
            boolean bl = isBMC = BDCobj == null;
            if (BDCobj != null && (metadata = BDCobj.getOtherDictionaries()) != null) {
                for (Object key : metadata.keySet()) {
                    this.root.setAttribute(key.toString(), metadata.get(key).toString());
                    this.root.setAttribute("x1", String.valueOf((int)this.x1));
                    this.root.setAttribute("y1", String.valueOf((int)this.y1));
                    this.root.setAttribute("x2", String.valueOf((int)this.x2));
                    this.root.setAttribute("y2", String.valueOf((int)this.y2));
                }
            }
            if (isBMC) {
                if (this.currentKey != null) {
                    Text child = this.doc.createTextNode(StructuredContentHandler.stripEscapeChars(this.markedContentSequence.toString()));
                    this.root.appendChild(child);
                    Node oldRoot = this.root.getParentNode();
                    if (oldRoot instanceof Element) {
                        this.root = (Element)oldRoot;
                    }
                }
            } else {
                String S2 = "p";
                if (S2 == null) {
                    S2 = "p";
                }
                Element tag = this.doc.createElement(S2);
                this.root.appendChild(tag);
                Text child = this.doc.createTextNode(this.markedContentSequence.toString());
                tag.appendChild(child);
            }
            this.markedContentSequence = new StringBuffer();
        } else {
            String ContentSequence = this.markedContentSequence.toString();
            PdfObject BDCobj = (PdfObject)this.dictionaries.get(String.valueOf(this.markedContentLevel));
            int MCID = -1;
            if (BDCobj != null) {
                MCID = BDCobj.getInt(487790868);
            }
            if (MCID != -1) {
                this.values.put(String.valueOf(MCID), ContentSequence);
                this.markedContentSequence = new StringBuffer();
            }
            this.dictionaries.remove(String.valueOf(this.markedContentLevel));
        }
        if (this.markedContentLevel > 0) {
            --this.markedContentLevel;
        }
    }

    void setEMCValues() {
        this.contentExtracted = true;
        this.currentKey = (String)this.keys.get(this.markedContentLevel);
        if (this.currentKey == null) {
            this.currentKey = String.valueOf(this.markedContentLevel);
        }
    }

    public void setText(StringBuffer current_value, float x1, float y1, float x2, float y2) {
        if (this.markedContentSequence.length() == 0) {
            this.markedContentSequence = current_value;
            if (this.markedContentSequence.length() > 0 && this.markedContentSequence.charAt(0) == ' ') {
                this.markedContentSequence.deleteCharAt(0);
            }
        } else {
            this.markedContentSequence.append(current_value);
        }
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    private static String stripEscapeChars(Object dict) {
        int lastC = 32;
        StringBuilder str = new StringBuilder((String)dict);
        int length = str.length();
        for (int ii = 0; ii < length; ++ii) {
            char c = str.charAt(ii);
            if (c == '\\' && lastC != 92) {
                str.deleteCharAt(ii);
                --length;
            }
            lastC = c;
        }
        return str.toString();
    }

    public boolean hasContent() {
        return this.contentExtracted;
    }
}

