/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.util.HashMap;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfFontException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FontFactory;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class PdfFontFactory {
    private boolean hasEmbeddedFonts;
    private boolean hasNonEmbeddedCIDFonts;
    private String fontsInFile;
    private final StringBuilder nonEmbeddedCIDFonts = new StringBuilder(200);
    private String baseFont = "";
    private String rawFontName;
    private String subFont;
    private int origfontType;
    private final HashMap fontsLoaded = new HashMap(50);
    final PdfObjectReader currentPdfFile;

    public PdfFontFactory(PdfObjectReader currentPdfFile) {
        this.currentPdfFile = currentPdfFile;
    }

    public PdfFont createFont(boolean fallbackToArial, PdfObject pdfObject, String font_id, ObjectStore objectStoreStreamRef, boolean renderPage, ErrorTracker errorTracker, boolean isPrinting) throws PdfException {
        PdfFont currentFontData = null;
        this.baseFont = "";
        this.rawFontName = null;
        this.subFont = null;
        int fontType = -1;
        this.origfontType = -1;
        PdfObject descendantFont = pdfObject.getDictionary(-1547306032);
        boolean isEmbedded = PdfFontFactory.isFontEmbedded(pdfObject);
        boolean isFontBroken = true;
        while (isFontBroken) {
            isFontBroken = false;
            if (FontMappings.fontSubstitutionTable != null && !isEmbedded && pdfObject.getParameterConstant(1147962727) != 1228944679) {
                fontType = this.getFontMapping(pdfObject, font_id, fontType, descendantFont);
            }
            if (fontType == -1 && (fontType = pdfObject.getParameterConstant(1147962727)) == 1228944676) {
                PdfObject desc = pdfObject.getDictionary(-1547306032);
                this.origfontType = fontType = desc.getParameterConstant(1147962727);
            }
            if (fontType == -1) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Font type not supported");
                }
                currentFontData = new PdfFont(this.currentPdfFile);
            }
            if (fontType == 1228944677 || fontType == -1684566724) {
                fontType = PdfFontFactory.scanForOpenType(pdfObject, this.currentPdfFile, fontType);
            }
            if (!isEmbedded && this.subFont == null && fallbackToArial && fontType != 1228944679) {
                String replacementFont = "arial";
                String testFont = pdfObject.getName(678461817);
                if (testFont != null) {
                    if ((testFont = testFont.toLowerCase()).contains("bolditalic")) {
                        replacementFont = "arial bold italic";
                    } else if (testFont.contains("italic")) {
                        replacementFont = "arial italic";
                    } else if (testFont.contains("bold")) {
                        replacementFont = "arial bold";
                    }
                }
                this.subFont = (String)FontMappings.fontSubstitutionLocation.get(replacementFont);
                fontType = 1217103210;
            }
            try {
                currentFontData = FontFactory.createFont(fontType, this.currentPdfFile, this.subFont, isPrinting);
                if (FontMappings.defaultFont != null) {
                    currentFontData.setDefaultDisplayFont(FontMappings.defaultFont);
                }
                currentFontData.createFont(pdfObject, font_id, renderPage, objectStoreStreamRef, this.fontsLoaded);
                if (!(fontType != -1684566726 && fontType != -1684566724 || isEmbedded || this.subFont != null)) {
                    this.subFont = currentFontData.getSubstituteFont();
                    if (this.subFont == null) {
                        this.hasNonEmbeddedCIDFonts = true;
                        if (this.nonEmbeddedCIDFonts.length() > 0) {
                            this.nonEmbeddedCIDFonts.append(',');
                        }
                        this.nonEmbeddedCIDFonts.append(this.baseFont);
                    }
                }
                currentFontData.setRawFontName(this.rawFontName);
                if (fontType == 1228944677 && currentFontData.is1C() && pdfObject.getInt(1283093660) == 32 && pdfObject.getInt(1283093660) == pdfObject.getInt(795440262)) {
                    if (isEmbedded) {
                        isFontBroken = true;
                        isEmbedded = false;
                    } else {
                        currentFontData.isFontEmbedded = false;
                    }
                }
                if (currentFontData.isFontEmbedded || !isEmbedded) continue;
                isFontBroken = true;
                isEmbedded = false;
            }
            catch (Exception e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("[PDF] Problem " + e + " reading Font  type " + StandardFonts.getFontypeAsString(fontType));
                }
                errorTracker.addPageFailureMessage("Problem " + e + " reading Font type " + StandardFonts.getFontypeAsString(fontType));
            }
        }
        this.setDetails(font_id, currentFontData, fontType, descendantFont);
        return currentFontData;
    }

    private void setDetails(String font_id, PdfFont currentFontData, int fontType, PdfObject descendantFont) {
        String details;
        String name = currentFontData.getFontName();
        if (name.indexOf(35) != -1) {
            name = StringUtils.convertHexChars(name);
        }
        if (currentFontData.isFontSubstituted()) {
            details = font_id + "  " + name + "  " + StandardFonts.getFontypeAsString(this.origfontType) + "  Substituted (" + this.subFont + ' ' + StandardFonts.getFontypeAsString(fontType) + ')';
        } else if (currentFontData.isFontEmbedded) {
            this.hasEmbeddedFonts = true;
            details = currentFontData.is1C() && descendantFont == null ? font_id + "  " + name + " Type1C  Embedded" : font_id + "  " + name + "  " + StandardFonts.getFontypeAsString(fontType) + "  Embedded";
        } else {
            details = font_id + "  " + name + "  " + StandardFonts.getFontypeAsString(fontType);
        }
        this.fontsInFile = this.fontsInFile == null ? details : details + '\n' + this.fontsInFile;
    }

    private static int scanForOpenType(PdfObject pdfObject, PdfObjectReader currentPdfFile, int fontType) {
        if (fontType == -1684566724) {
            byte[] stream;
            PdfObject FontFile22;
            PdfObject FontDescriptor;
            PdfObject desc = pdfObject.getDictionary(-1547306032);
            if (pdfObject != null && (FontDescriptor = desc.getDictionary(-1044665361)) != null && (FontFile22 = FontDescriptor.getDictionary(2021292334)) != null && (stream = currentPdfFile.readStream(FontFile22, true, true, false, false, false, FontFile22.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                fontType = -1684566726;
            }
        } else {
            byte[] stream;
            PdfObject FontFile3;
            PdfObject FontDescriptor = pdfObject.getDictionary(-1044665361);
            if (FontDescriptor != null && (FontFile3 = FontDescriptor.getDictionary(2021292335)) != null && (stream = currentPdfFile.readStream(FontFile3, true, true, false, false, false, FontFile3.getCacheName(currentPdfFile.getObjectReader()))) != null && stream.length > 3 && stream[0] == 79 && stream[1] == 84 && stream[2] == 84 && stream[3] == 79) {
                fontType = 1217103210;
            }
        }
        return fontType;
    }

    private int getFontMapping(PdfObject pdfObject, String font_id, int fontType, PdfObject descendantFont) throws PdfException {
        String newSubtype;
        String rawFont = descendantFont == null ? pdfObject.getName(678461817) : descendantFont.getName(678461817);
        if (rawFont == null) {
            rawFont = pdfObject.getName(506543413);
        }
        if (rawFont == null) {
            rawFont = font_id;
        }
        if ((newSubtype = this.getFontSub(rawFont)) != null && descendantFont == null) {
            if (newSubtype.equals("/Type1") || newSubtype.equals("/Type1C") || newSubtype.equals("/MMType1")) {
                fontType = 1228944677;
            } else if (newSubtype.equals("/TrueType")) {
                fontType = 1217103210;
            } else if (newSubtype.equals("/Type3")) {
                fontType = 1228944679;
            } else {
                throw new RuntimeException("Unknown font type " + newSubtype + " used for font substitution");
            }
            this.origfontType = pdfObject.getParameterConstant(1147962727);
        } else if (FontMappings.enforceFontSubstitution) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("baseFont=" + this.baseFont + " fonts added= " + FontMappings.fontSubstitutionTable);
            }
            throw new PdfFontException("No substitute Font found for font=" + this.baseFont + '<');
        }
        return fontType;
    }

    public String getFontSub(String rawFont) throws PdfException {
        if (rawFont.indexOf(35) != -1) {
            rawFont = StringUtils.convertHexChars(rawFont);
        }
        this.rawFontName = rawFont;
        this.baseFont = rawFont.toLowerCase();
        int pointer = this.baseFont.indexOf(43);
        if (pointer == 6) {
            this.baseFont = this.baseFont.substring(7);
        }
        String testFont = this.baseFont;
        this.subFont = (String)FontMappings.fontSubstitutionLocation.get(testFont);
        String newSubtype = (String)FontMappings.fontSubstitutionTable.get(testFont);
        if (DecoderOptions.isRunningOnMac && testFont.equals("zapfdingbats")) {
            testFont = "No match found";
        }
        if (newSubtype == null) {
            String nextFont;
            HashMap<String, String> fontsMapped = new HashMap<String, String>(50);
            while ((nextFont = (String)FontMappings.fontSubstitutionAliasTable.get(testFont)) != null) {
                testFont = nextFont;
                String nextSubType = (String)FontMappings.fontSubstitutionTable.get(testFont);
                if (nextSubType != null) {
                    newSubtype = nextSubType;
                    this.subFont = (String)FontMappings.fontSubstitutionLocation.get(testFont);
                }
                if (fontsMapped.containsKey(testFont)) {
                    StringBuilder errorMessage = new StringBuilder("[PDF] Circular font mapping for fonts");
                    for (Object o : fontsMapped.keySet()) {
                        errorMessage.append(' ');
                        errorMessage.append(o);
                    }
                    throw new PdfException(errorMessage.toString());
                }
                fontsMapped.put(nextFont, "x");
            }
        }
        return newSubtype;
    }

    private static boolean isFontEmbedded(PdfObject pdfObject) {
        PdfObject descFontObj;
        int fontType = pdfObject.getParameterConstant(1147962727);
        if (fontType == 1228944676) {
            pdfObject = pdfObject.getDictionary(-1547306032);
        }
        if ((descFontObj = pdfObject.getDictionary(-1044665361)) == null) {
            return false;
        }
        return descFontObj.hasStream();
    }

    public String getnonEmbeddedCIDFonts() {
        return this.nonEmbeddedCIDFonts.toString();
    }

    public String getFontsInFile() {
        return this.fontsInFile;
    }

    public void resetfontsInFile() {
        this.fontsInFile = "";
    }

    public boolean hasEmbeddedFonts() {
        return this.hasEmbeddedFonts;
    }

    public boolean hasNonEmbeddedCIDFonts() {
        return this.hasNonEmbeddedCIDFonts;
    }

    public String getMapFont() {
        return this.subFont;
    }
}

