/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ExternalHandlers;
import org.jpedal.external.ImageHandler;
import org.jpedal.external.ShapeTracker;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.JavaFXSupport;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.DefaultErrorTracker;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.io.StatusBar;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfData;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.PdfShape;
import org.jpedal.objects.SwingShape;
import org.jpedal.objects.TextState;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.Cmd;
import org.jpedal.parser.CommandParser;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.FontResolver;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.T3Decoder;
import org.jpedal.parser.XFormDecoder;
import org.jpedal.parser.color.CS;
import org.jpedal.parser.color.G;
import org.jpedal.parser.color.K;
import org.jpedal.parser.color.RG;
import org.jpedal.parser.color.SCN;
import org.jpedal.parser.gs.CM;
import org.jpedal.parser.gs.Q;
import org.jpedal.parser.image.DO;
import org.jpedal.parser.image.ID;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.parser.shape.B;
import org.jpedal.parser.shape.D;
import org.jpedal.parser.shape.F;
import org.jpedal.parser.shape.J;
import org.jpedal.parser.shape.N;
import org.jpedal.parser.shape.S;
import org.jpedal.parser.shape.SH;
import org.jpedal.parser.text.BDC;
import org.jpedal.parser.text.EMC;
import org.jpedal.parser.text.TD;
import org.jpedal.parser.text.TR;
import org.jpedal.parser.text.Tj;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class PdfStreamDecoder
extends BaseDecoder {
    private static boolean showFXShadingMessage;
    int formLevel;
    private int BDCDepth = -1;
    PdfObjectCache cache;
    PdfPageData pageData;
    ErrorTracker errorTracker;
    PdfObjectReader currentPdfFile;
    protected GraphicsState newGS;
    protected byte[] pageStream;
    PdfLayerList layers;
    protected boolean getSamplingOnly;
    private final Map shadingColorspacesObjects = new HashMap(50);
    private boolean isTTHintingRequired;
    final Vector_Int textDirections = new Vector_Int();
    final Vector_Rectangle_Int textAreas = new Vector_Rectangle_Int();
    public boolean ignoreColors;
    int imageCount;
    float[] BBox;
    String lastTextValue = "";
    int lastDataPointer = -1;
    private T3Decoder t3Decoder;
    private boolean removeRenderImages;
    private boolean multipleTJs;
    private boolean textColorExtracted;
    private boolean textExtracted = true;
    private boolean renderText;
    private int tokenNumber;
    String imagesInFile;
    public static final float currentThreshold = 0.595f;
    protected ImageHandler customImageHandler;
    private PdfFontFactory pdfFontFactory;
    boolean isXMLExtraction;
    public static final boolean showCommands = false;
    private StatusBar statusBar;
    final PdfData pdfData = new PdfData();
    final PdfImageData pdfImages = new PdfImageData();
    protected static String indent;
    protected boolean isDataValid = true;
    private PdfFont currentFontData;
    protected boolean useHiResImageForDisplay;
    protected ObjectStore objectStoreStreamRef;
    String formName = "";
    protected boolean isType3Font;
    public static boolean useTextPrintingForNonEmbeddedFonts;
    private static int maxShapesAllowed;
    private int currentBlendMode = 1111314299;
    boolean isPrinting;

    public PdfStreamDecoder(PdfObjectReader currentPdfFile) {
        this.init(currentPdfFile);
    }

    public PdfStreamDecoder(PdfObjectReader currentPdfFile, boolean useHiResImageForDisplay, PdfLayerList layers) {
        if (layers != null) {
            this.layers = layers;
        }
        this.useHiResImageForDisplay = useHiResImageForDisplay;
        this.init(currentPdfFile);
    }

    private void init(PdfObjectReader currentPdfFile) {
        this.cache = new PdfObjectCache();
        this.gs = new GraphicsState();
        this.errorTracker = new DefaultErrorTracker();
        this.pageData = new PdfPageData();
        StandardFonts.checkLoaded(1);
        StandardFonts.checkLoaded(0);
        this.currentPdfFile = currentPdfFile;
        this.pdfFontFactory = new PdfFontFactory(currentPdfFile);
    }

    public T3Size decodePageContent(PdfObject pdfObject) throws PdfException {
        try {
            this.parserOptions.imagesProcessedFully = true;
            this.parserOptions.tooManyShapes = false;
            this.imageCount = 0;
            this.parserOptions.setPdfLayerList(this.layers);
            this.imagesInFile = null;
            if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
                this.statusBar.percentageDone = 0.0f;
            }
            this.gs = this.newGS != null ? this.newGS : new GraphicsState(0, 0);
            if (this.parserOptions.isRenderPage()) {
                if (this.current == null) {
                    throw new PdfException("DynamicVectorRenderer not setup PdfStreamDecoder setStore(...) should be called");
                }
                this.current.drawClip(this.gs, this.parserOptions.defaultClip, false);
                int pageNum = this.parserOptions.getPageNumber();
                this.current.paintBackground(new Rectangle(this.pageData.getCropBoxX(pageNum), this.pageData.getCropBoxY(pageNum), this.pageData.getCropBoxWidth(pageNum), this.pageData.getCropBoxHeight(pageNum)));
            }
            byte[][] pageContents = null;
            if (pdfObject != null) {
                pageContents = pdfObject.getKeyArray(1216184967);
                this.isDataValid = pdfObject.streamMayBeCorrupt();
            }
            byte[] b_data = pdfObject != null && pageContents == null ? this.currentPdfFile.readStream(pdfObject, true, true, false, false, false, pdfObject.getCacheName(this.currentPdfFile.getObjectReader())) : (this.pageStream != null ? this.pageStream : this.currentPdfFile.getObjectReader().readPageIntoStream(pdfObject));
            this.lastDataPointer = -1;
            if (b_data != null && b_data.length > 0) {
                this.decodeStreamIntoObjects(b_data, false);
            }
            if (!this.isType3Font) {
                this.cache.resetFonts();
            }
            T3Size t3 = new T3Size();
            if (this.t3Decoder != null) {
                t3.x = this.t3Decoder.T3maxWidth;
                t3.y = this.t3Decoder.T3maxHeight;
                this.ignoreColors = this.t3Decoder.ignoreColors;
                this.t3Decoder = null;
            }
            return t3;
        }
        catch (Error err) {
            if (ExternalHandlers.throwMissingCIDError && err.getMessage() != null && err.getMessage().contains("kochi")) {
                throw err;
            }
            this.errorTracker.addPageFailureMessage("Problem decoding page " + err);
            return null;
        }
    }

    public void setObjectValue(int key, Object obj) {
        switch (key) {
            case -9: {
                this.parserOptions.setName((String)obj);
                break;
            }
            case -18: {
                this.pageData = (PdfPageData)obj;
                if (!this.textColorExtracted) break;
                this.pdfData.enableTextColorDataExtraction();
                break;
            }
            case -3: {
                this.statusBar = (StatusBar)obj;
                break;
            }
            case -4: {
                this.layers = (PdfLayerList)obj;
                break;
            }
            case -6: {
                this.customImageHandler = (ImageHandler)obj;
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case -7: {
                this.current.setIsRenderingToImage(true);
                this.parserOptions.setRenderDirectly(true);
                if (obj == null) break;
                Graphics2D g2 = (Graphics2D)obj;
                this.parserOptions.defaultClip = g2.getClip();
                break;
            }
            case -8: {
                this.objectStoreStreamRef = (ObjectStore)obj;
                if (this.current == null) break;
                this.current.setHiResImageForDisplayMode(this.useHiResImageForDisplay);
                if (this.customImageHandler == null || this.current == null) break;
                this.current.setCustomImageHandler(this.customImageHandler);
                break;
            }
            case 31: {
                this.errorTracker = (ErrorTracker)obj;
                break;
            }
            case 13: {
                this.parserOptions.setCustomShapeTracker((ShapeTracker)obj);
            }
        }
    }

    public void setBooleanValue(int key, boolean value) {
        switch (key) {
            case 21: {
                this.parserOptions.setGenerateGlyphOnRender(value);
            }
        }
    }

    public void setDefaultColors(PdfPaint strokeCol, PdfPaint nonstrokeCol) {
        this.gs.strokeColorSpace.setColor(strokeCol);
        this.gs.nonstrokeColorSpace.setColor(nonstrokeCol);
        this.gs.setStrokeColor(strokeCol);
        this.gs.setNonstrokeColor(nonstrokeCol);
    }

    public Object getObjectValue(int key) {
        switch (key) {
            case -19: {
                if (DecoderOptions.embedWidthData) {
                    this.pdfData.widthIsEmbedded();
                }
                return this.pdfData;
            }
            case -20: {
                return this.pdfImages;
            }
            case -21: {
                return this.textAreas;
            }
            case 22: {
                return this.textDirections;
            }
            case 23: {
                return this.current;
            }
            case 373243460: {
                return this.pdfFontFactory.getFontsInFile();
            }
            case 1026635598: {
                return this.imagesInFile;
            }
            case 4: {
                return this.pdfFontFactory.getnonEmbeddedCIDFonts();
            }
            case 1: {
                return this.cache.iterator(1);
            }
        }
        return null;
    }

    public final void readResources(PdfObject Resources, boolean resetList) throws PdfException {
        if (resetList) {
            this.pdfFontFactory.resetfontsInFile();
        }
        this.currentPdfFile.checkResolved(Resources);
        this.cache.readResources(Resources, resetList);
    }

    public String decodeStreamIntoObjects(byte[] stream, boolean returnText) {
        Tj textDecoder;
        if (stream.length == 0) {
            return null;
        }
        int startInlineStream = 0;
        CommandParser parser = new CommandParser(stream);
        int streamSize = stream.length;
        int dataPointer = 0;
        int startCommand = 0;
        int shapeCommandCount = 0;
        String csInUse = "";
        String CSInUse = "";
        PdfShape currentDrawShape = null;
        if (this.parserOptions.useJavaFX()) {
            JavaFXSupport fxSupport = ExternalHandlers.getFXHandler();
            if (fxSupport != null) {
                currentDrawShape = fxSupport.getFXShape();
            }
        } else {
            currentDrawShape = new SwingShape();
        }
        if (this.parserOptions.hasContentHandler()) {
            textDecoder = new Tj(this.parserOptions, this.textAreas, this.textDirections, this.current, this.errorTracker);
        } else {
            textDecoder = new Tj(this.parserOptions, this.pdfData, this.isXMLExtraction, this.textAreas, this.textDirections, this.current, this.errorTracker);
            textDecoder.setReturnText(returnText);
        }
        textDecoder.setStreamType(this.streamType);
        if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
            this.statusBar.percentageDone = 0.0f;
            this.statusBar.resetStatus("stream");
        }
        while (!this.errorTracker.checkForExitRequest(dataPointer, streamSize)) {
            if (this.statusBar != null && !this.parserOptions.renderDirectly()) {
                this.statusBar.percentageDone = 90 * dataPointer / streamSize;
            }
            dataPointer = parser.getCommandValues(dataPointer, streamSize, this.tokenNumber);
            int commandID = parser.getCommandID();
            if (dataPointer < 0) {
                block53: {
                    dataPointer = -dataPointer;
                    try {
                        int commandType = Cmd.getCommandType(commandID);
                        block1 : switch (commandType) {
                            case 0: {
                                if (commandID != 4541763 && !this.parserOptions.isLayerVisible() || this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                                dataPointer = this.processTextToken(textDecoder, parser, commandID, startCommand, dataPointer);
                                break;
                            }
                            case 2: {
                                if (this.getSamplingOnly) break;
                                this.processShapeCommands(parser, currentDrawShape, commandID);
                                if (maxShapesAllowed <= 0 || ++shapeCommandCount <= maxShapesAllowed) break;
                                String errMessage = "[PDF] Shapes on page exceed limit set by JVM flag org.jpedal.maxShapeCount - value " + maxShapesAllowed;
                                this.parserOptions.tooManyShapes = true;
                                throw new PdfException(errMessage);
                            }
                            case 3: {
                                if (this.getSamplingOnly || !this.parserOptions.isRenderPage()) break;
                                if (this.parserOptions.useJavaFX) {
                                    if (showFXShadingMessage) break;
                                    System.out.println("SH not implemented in JavaFX yet");
                                    showFXShadingMessage = true;
                                    break;
                                }
                                SH.execute(parser.generateOpAsString(0, true), this.cache, this.gs, this.isPrinting, this.shadingColorspacesObjects, this.parserOptions.getPageNumber(), this.currentPdfFile, this.pageData, this.current);
                                break;
                            }
                            case 1: {
                                if (this.getSamplingOnly) break;
                                if (commandID != 5456718 && commandID != 7562094 && commandID != 21315 && commandID != 29539) {
                                    this.current.resetOnColorspaceChange();
                                }
                                switch (commandID) {
                                    case 25459: {
                                        String colorspaceObject = parser.generateOpAsString(0, true);
                                        boolean isLowerCase = true;
                                        boolean alreadyUsed = colorspaceObject.equals(CSInUse);
                                        csInUse = colorspaceObject;
                                        CS.execute(true, colorspaceObject, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.parserOptions.getPageNumber(), this.pageData, alreadyUsed);
                                        break block1;
                                    }
                                    case 17235: {
                                        String colorspaceObject = parser.generateOpAsString(0, true);
                                        boolean isLowerCase = false;
                                        boolean alreadyUsed = colorspaceObject.equals(csInUse);
                                        CSInUse = colorspaceObject;
                                        CS.execute(false, colorspaceObject, this.gs, this.cache, this.currentPdfFile, this.isPrinting, this.parserOptions.getPageNumber(), this.pageData, alreadyUsed);
                                        break block1;
                                    }
                                    case 29287: {
                                        RG.execute(true, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 21063: {
                                        RG.execute(false, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 5456718: {
                                        SCN.execute(false, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 7562094: {
                                        SCN.execute(true, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 21315: {
                                        SCN.execute(false, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 29539: {
                                        SCN.execute(true, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 103: {
                                        G.execute(true, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 71: {
                                        G.execute(false, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 107: {
                                        K.execute(true, this.gs, parser, this.cache);
                                        break block1;
                                    }
                                    case 75: {
                                        K.execute(false, this.gs, parser, this.cache);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                this.processGScommands(parser, commandID);
                                if (commandID != 25453 || textDecoder == null) break;
                                this.multipleTJs = false;
                                break;
                            }
                            case 5: {
                                if (commandID == 16969) {
                                    startInlineStream = dataPointer;
                                    break;
                                }
                                PdfObject XObject2 = null;
                                int subtype = 1;
                                if (commandID == 17519) {
                                    String name = parser.generateOpAsString(0, true);
                                    XObject2 = this.cache.getXObjects(name);
                                    if (XObject2 != null) {
                                        this.currentPdfFile.checkResolved(XObject2);
                                        subtype = XObject2.getParameterConstant(1147962727);
                                    }
                                    if (subtype == 373244477 && (this.formLevel <= 100 || dataPointer != this.lastDataPointer)) {
                                        this.lastDataPointer = dataPointer;
                                        if (this.parserOptions.isLayerVisible() && (this.layers == null || this.layers.isVisible(XObject2)) && XObject2 != null) {
                                            XFormDecoder.processXForm(this, dataPointer, XObject2, this.parserOptions.defaultClip, parser);
                                        }
                                    }
                                }
                                if (subtype != 373244477) {
                                    ImageDecoder imageDecoder = commandID != 17519 ? new ID(this.imageCount, this.currentPdfFile, this.errorTracker, this.customImageHandler, this.objectStoreStreamRef, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName) : new DO(this.imageCount, this.currentPdfFile, this.errorTracker, this.customImageHandler, this.objectStoreStreamRef, this.pdfImages, this.formLevel, this.pageData, this.imagesInFile, this.formName);
                                    imageDecoder.setRes(this.cache);
                                    imageDecoder.setGS(this.gs);
                                    imageDecoder.setSamplingOnly(this.getSamplingOnly);
                                    imageDecoder.setStreamType(this.streamType);
                                    imageDecoder.setMultiplyer(this.multiplyer);
                                    imageDecoder.setRenderer(this.current);
                                    imageDecoder.setParameters(this.parserOptions.isRenderPage(), this.parserOptions.getRenderMode(), this.parserOptions.getExtractionMode(), this.isPrinting, this.isType3Font, this.useHiResImageForDisplay);
                                    imageDecoder.setParams(this.parserOptions);
                                    if (commandID == 17519) {
                                        if (!(XObject2 == null || !this.parserOptions.isLayerVisible() || this.layers != null && !this.layers.isVisible(XObject2) || this.gs.CTM != null && this.gs.CTM[1][1] == 0.0f && this.gs.CTM[1][0] != 0.0f && (double)Math.abs(this.gs.CTM[1][0]) < 0.2)) {
                                            dataPointer = imageDecoder.processImage(parser.generateOpAsString(0, true), dataPointer, XObject2);
                                        }
                                    } else if (this.parserOptions.isLayerVisible()) {
                                        dataPointer = imageDecoder.processImage(dataPointer, startInlineStream, parser.getStream(), this.tokenNumber);
                                    }
                                    ++this.imageCount;
                                    this.imagesInFile = imageDecoder.getImagesInFile();
                                }
                                break;
                            }
                            case 6: {
                                if (this.getSamplingOnly || !this.renderText && !this.textExtracted) break;
                                if (this.t3Decoder == null) {
                                    this.t3Decoder = new T3Decoder();
                                }
                                this.t3Decoder.setCommands(parser);
                                this.t3Decoder.setCommands(parser);
                                this.t3Decoder.processToken(commandID);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("[PDF] " + e + " Processing token >" + Cmd.getCommandAsString(commandID) + "<>" + this.parserOptions.getFileName() + " <" + this.parserOptions.getPageNumber());
                        }
                        if (!this.isDataValid) {
                            dataPointer = streamSize;
                        }
                    }
                    catch (OutOfMemoryError ee) {
                        this.errorTracker.addPageFailureMessage("Memory error decoding token stream " + ee);
                        if (!LogWriter.isOutput()) break block53;
                        LogWriter.writeLog("[MEMORY] Memory error - trying to recover");
                    }
                }
                startCommand = dataPointer;
                parser.reset();
                ++this.tokenNumber;
            }
            if (streamSize > dataPointer) continue;
            break;
        }
        if (!this.parserOptions.renderDirectly() && this.statusBar != null) {
            this.statusBar.percentageDone = 100.0f;
        }
        this.isTTHintingRequired = textDecoder.isTTHintingRequired();
        if (returnText) {
            return this.lastTextValue;
        }
        return "";
    }

    private void processGScommands(CommandParser parser, int commandID) {
        switch (commandID) {
            case 25453: {
                CM.execute(this.gs, parser);
                break;
            }
            case 113: {
                this.gs = Q.execute(this.gs, true, this.graphicsStates, this.current);
                break;
            }
            case 81: {
                this.gs = Q.execute(this.gs, false, this.graphicsStates, this.current);
                break;
            }
            case 26483: {
                if (this.getSamplingOnly) break;
                PdfObject GS = (PdfObject)this.cache.GraphicsStates.get(parser.generateOpAsString(0, true));
                this.currentPdfFile.checkResolved(GS);
                this.gs.setMode(GS);
                int blendMode = this.gs.getBMValue();
                this.current.setGraphicsState(2, this.gs.getAlpha(2), blendMode);
                this.current.setGraphicsState(1, this.gs.getAlpha(1), blendMode);
                this.currentBlendMode = blendMode;
            }
        }
    }

    private void processShapeCommands(CommandParser parser, PdfShape currentDrawShape, int commandID) {
        switch (commandID) {
            case 66: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = B.execute(false, false, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 66, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 98: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = B.execute(false, true, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 98, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 25130: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = B.execute(true, true, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 25130, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 16938: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = B.execute(true, false, this.gs, this.formLevel, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 16938, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 99: {
                float x3 = parser.parseFloat(1);
                float y3 = parser.parseFloat(0);
                float x2 = parser.parseFloat(3);
                float y2 = parser.parseFloat(2);
                float x = parser.parseFloat(5);
                float y = parser.parseFloat(4);
                currentDrawShape.addBezierCurveC(x, y, x2, y2, x3, y3);
                break;
            }
            case 100: {
                D.execute(parser, this.gs);
                break;
            }
            case 70: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, false, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 102: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, false, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 17962: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, true, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 26154: {
                if (this.removeRenderImages) break;
                F.execute(this.tokenNumber, true, this.formLevel, currentDrawShape, this.gs, this.cache, this.currentPdfFile, this.current, this.parserOptions, this.multiplyer);
                break;
            }
            case 104: {
                currentDrawShape.closeShape();
                break;
            }
            case 74: {
                J.execute(false, parser.parseInt(), this.gs);
                break;
            }
            case 106: {
                J.execute(true, parser.parseInt(), this.gs);
                break;
            }
            case 108: {
                currentDrawShape.lineTo(parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 77: {
                this.gs.setMitreLimit((int)parser.parseFloat(0));
                break;
            }
            case 109: {
                currentDrawShape.setClip(false);
                currentDrawShape.moveTo(parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 110: {
                N.execute(currentDrawShape, this.gs, this.formLevel, this.parserOptions.defaultClip, this.parserOptions, this.current, this.pageData);
                break;
            }
            case 29285: {
                currentDrawShape.appendRectangle(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 83: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = S.execute(false, this.gs, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 83, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 115: {
                ShapeTracker customShapeTracker;
                Shape currentShape;
                if (this.removeRenderImages || (currentShape = S.execute(true, this.gs, currentDrawShape, this.current, this.parserOptions)) == null || (customShapeTracker = this.parserOptions.getCustomShapeTraker()) == null) break;
                customShapeTracker.addShape(this.tokenNumber, 115, currentShape, this.gs.nonstrokeColorSpace.getColor(), this.gs.strokeColorSpace.getColor());
                break;
            }
            case 118: {
                currentDrawShape.addBezierCurveV(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
                break;
            }
            case 119: {
                this.gs.setLineWidth(parser.parseFloat(0));
                break;
            }
            case 22314: {
                currentDrawShape.setEVENODDWindingRule();
                currentDrawShape.setClip(true);
                break;
            }
            case 87: {
                currentDrawShape.setNONZEROWindingRule();
                currentDrawShape.setClip(true);
                break;
            }
            case 121: {
                currentDrawShape.addBezierCurveY(parser.parseFloat(3), parser.parseFloat(2), parser.parseFloat(1), parser.parseFloat(0));
            }
        }
    }

    public boolean getBooleanValue(int key) {
        switch (key) {
            case -1: {
                return this.pdfFontFactory.hasEmbeddedFonts();
            }
            case 1: {
                return this.errorTracker.ispageSuccessful();
            }
            case 4: {
                return this.pdfFontFactory.hasNonEmbeddedCIDFonts();
            }
            case 2: {
                return this.parserOptions.imagesProcessedFully;
            }
            case 64: {
                return this.parserOptions.tooManyShapes;
            }
            case 8: {
                return this.parserOptions.hasYCCKimages;
            }
            case 32: {
                return this.isTTHintingRequired;
            }
        }
        throw new RuntimeException("Unknown value " + key);
    }

    public void dispose() {
        if (this.pdfData != null) {
            this.pdfData.dispose();
        }
    }

    public void setIntValue(int key, int value) {
        switch (key) {
            case -10: {
                this.parserOptions.setPageNumber(value);
                break;
            }
            case -15: {
                this.parserOptions.setTextPrint(value);
            }
        }
    }

    public void setXMLExtraction(boolean isXMLExtraction) {
        this.isXMLExtraction = isXMLExtraction;
    }

    public void setParameters(boolean isPageContent, boolean renderPage, int renderMode, int extractionMode, boolean isPrinting, boolean useJavaFX) {
        this.parserOptions.init(isPageContent, renderPage, renderMode, extractionMode, isPrinting, useJavaFX);
        this.renderText = renderPage && (renderMode & 1) == 1;
        this.textExtracted = (extractionMode & 1) == 1;
        this.textColorExtracted = (extractionMode & 0x40) == 64;
        this.removeRenderImages = renderPage && (renderMode & 0x10) == 16;
    }

    public void setFormLevel(int value) {
        this.formLevel = value;
    }

    private int processTextToken(Tj textDecoder, CommandParser parser, int commandID, int startCommand, int dataPointer) {
        textDecoder.setGS(this.gs);
        TextState currentTextState = this.gs.getTextState();
        if (commandID == 16980 && this.parserOptions.isRenderPage()) {
            this.current.drawClip(this.gs, this.parserOptions.defaultClip, true);
            this.current.drawTR(2);
        }
        if (commandID == 21610 || commandID == 21578 || commandID == 39 || commandID == 34) {
            String fontID;
            PdfFont restoredFont;
            this.current.flagCommand(21610, this.tokenNumber);
            if (currentTextState.hasFontChanged() && currentTextState.getTfs() != 0.0f && (restoredFont = FontResolver.resolveFont(this.gs, this, fontID = currentTextState.getFontID(), this.pdfFontFactory, this.cache)) != null) {
                this.currentFontData = restoredFont;
                this.current.drawFontBounds(this.currentFontData.getBoundingBox());
            }
            if (this.currentFontData == null) {
                this.currentFontData = new PdfFont(this.currentPdfFile);
                this.currentFontData.getGlyphData().logicalfontName = StandardFonts.expandName(currentTextState.getFontID());
            }
            if (currentTextState.hasFontChanged()) {
                currentTextState.setFontChanged(false);
            }
        }
        switch (commandID) {
            case 4345155: {
                this.parserOptions.setLayerLevel(this.parserOptions.getLayerLevel() + 1);
                if (!this.parserOptions.isLayerVisible()) break;
                this.parserOptions.getLayerVisibility().add(this.parserOptions.getLayerLevel());
                break;
            }
            case 0x424443: {
                PdfObject BDCobj = BDC.execute(startCommand, dataPointer, parser.getStream(), parser.generateOpAsString(0, false), this.gs, this.currentPdfFile, this.current, this.parserOptions);
                this.BDCDepth = BDCobj.getClip() != null ? this.graphicsStates.getDepth() : -1;
                textDecoder.setActualText(BDCobj.getTextStreamValue(1752861363));
                break;
            }
            case 16980: {
                currentTextState.resetTm();
                break;
            }
            case 4541763: {
                textDecoder.setActualText(null);
                if (this.parserOptions.getLayerLevel() == 1 && this.BDCDepth != -1 && this.BDCDepth != this.graphicsStates.getDepth()) {
                    this.graphicsStates.correctDepth(0, this.gs, this.current);
                }
                this.BDCDepth = -1;
                EMC.execute(this.current, this.gs, this.parserOptions);
                break;
            }
            case 17748: {
                this.current.resetOnColorspaceChange();
                if (this.gs.getTextRenderType() != 7) break;
                this.current.drawClip(this.gs, null, false);
                break;
            }
            case 17488: {
                break;
            }
            case 21606: {
                currentTextState.TF(parser.parseFloat(0), parser.generateOpAsString(1, true));
                break;
            }
            case 21603: {
                currentTextState.setCharacterSpacing(parser.parseFloat(0));
                break;
            }
            case 21572: {
                TD.execute(false, parser.parseFloat(1), parser.parseFloat(0), currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21604: {
                TD.execute(true, parser.parseFloat(1), parser.parseFloat(0), currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21610: {
                if (currentTextState.getTfs() != 0.0f) {
                    this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
                }
                this.multipleTJs = true;
                break;
            }
            case 21578: {
                this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 39: {
                TD.relativeMove(0.0f, -currentTextState.getLeading(), currentTextState);
                this.multipleTJs = false;
                this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, parser.getStream(), startCommand, dataPointer, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 34: {
                byte[] characterStream = parser.getStream();
                currentTextState.setCharacterSpacing(parser.parseFloat(1));
                currentTextState.setWordSpacing(parser.parseFloat(2));
                TD.relativeMove(0.0f, -currentTextState.getLeading(), currentTextState);
                this.multipleTJs = false;
                while (characterStream[startCommand] != 40 && characterStream[startCommand] != 60 && characterStream[startCommand] != 91) {
                    ++startCommand;
                }
                this.lastTextValue = textDecoder.TJ(currentTextState, this.currentFontData, characterStream, startCommand, dataPointer, this.multipleTJs);
                this.multipleTJs = true;
                break;
            }
            case 21613: {
                currentTextState.Tm[0][0] = parser.parseFloat(5);
                currentTextState.Tm[0][1] = parser.parseFloat(4);
                currentTextState.Tm[0][2] = 0.0f;
                currentTextState.Tm[1][0] = parser.parseFloat(3);
                currentTextState.Tm[1][1] = parser.parseFloat(2);
                currentTextState.Tm[1][2] = 0.0f;
                currentTextState.Tm[2][0] = parser.parseFloat(1);
                currentTextState.Tm[2][1] = parser.parseFloat(0);
                currentTextState.Tm[2][2] = 1.0f;
                currentTextState.setTMAtLineStart();
                this.multipleTJs = false;
                break;
            }
            case 21546: {
                TD.relativeMove(0.0f, -currentTextState.getLeading(), currentTextState);
                this.multipleTJs = false;
                break;
            }
            case 21618: {
                int value = TR.execute(parser.parseInt(), this.gs);
                if (!this.parserOptions.isRenderPage() || this.parserOptions.renderDirectly()) break;
                this.current.drawTR(value);
                break;
            }
            case 21619: {
                currentTextState.setTextRise(parser.parseFloat(0));
                break;
            }
            case 21623: {
                currentTextState.setWordSpacing(parser.parseFloat(0));
                break;
            }
            case 21626: {
                currentTextState.setHorizontalScaling(parser.parseFloat(0) / 100.0f);
                break;
            }
            case 21580: {
                currentTextState.setLeading(parser.parseFloat(0));
            }
        }
        return dataPointer;
    }

    public PdfObjectCache getObjectCache() {
        return this.cache;
    }

    public void setBBox(float[] BBox) {
        this.BBox = BBox;
    }

    public int getBlendMode() {
        return this.currentBlendMode;
    }

    static {
        indent = "";
        maxShapesAllowed = -1;
        SamplingFactory.setDownsampleMode(null);
        String maxShapes = System.getProperty("org.jpedal.maxShapeCount");
        if (maxShapes != null) {
            try {
                maxShapesAllowed = Integer.parseInt(maxShapes);
            }
            catch (Exception e) {
                throw new RuntimeException("Your setting (" + maxShapes + ")for org.jpedal.maxShapeCount is not a valid number " + e);
            }
        }
    }
}

