/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.fx;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotResult;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Transform;
import javafx.util.Callback;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.render.FXDisplayForRasterizing;

public class PDFtoImageConvertorFX
extends PDFtoImageConvertor {
    int pageIndex;

    public PDFtoImageConvertorFX(float multiplyer, DecoderOptions options) {
        super(multiplyer, options);
        this.isFX = true;
    }

    @Override
    public DynamicVectorRenderer getDisplay(int pageIndex, ObjectStore localStore) {
        this.pageIndex = pageIndex;
        this.imageDisplay = new FXDisplayForRasterizing(pageIndex, true, 5000, localStore);
        return this.imageDisplay;
    }

    @Override
    public BufferedImage pageToImage(boolean imageIsTransparent, final PdfStreamDecoder currentImageDecoder, final float scaling, final PdfObject pdfObject, final AcroRenderer formRenderer) throws PdfException {
        final SimpleObjectProperty imageProperty = new SimpleObjectProperty();
        final CountDownLatch latch = new CountDownLatch(1);
        if (Platform.isFxApplicationThread()) {
            this.snapshot(currentImageDecoder, scaling, pdfObject, null, (SimpleObjectProperty<BufferedImage>)imageProperty, formRenderer);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PDFtoImageConvertorFX.this.snapshot(currentImageDecoder, scaling, pdfObject, latch, (SimpleObjectProperty<BufferedImage>)imageProperty, formRenderer);
                }
            });
        }
        try {
            if (!Platform.isFxApplicationThread()) {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return (BufferedImage)imageProperty.get();
    }

    private void snapshot(PdfStreamDecoder currentImageDecoder, float scaling, PdfObject pdfObject, final CountDownLatch latch, final SimpleObjectProperty<BufferedImage> imageProperty, AcroRenderer formRenderer) {
        Pane g = new Pane();
        try {
            formRenderer.getCompData().setRootDisplayComponent(g);
            currentImageDecoder.decodePageContent(pdfObject);
            formRenderer.createDisplayComponentsForPage(this.pageIndex, currentImageDecoder);
            formRenderer.displayComponentsOnscreen(this.pageIndex, this.pageIndex);
            formRenderer.getCompData().resetScaledLocation(scaling, 0, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Group group = ((FXDisplay)this.imageDisplay).getFXPane();
        group.getChildren().addAll((Collection)g.getChildren());
        group.getTransforms().add((Object)Transform.affine((double)(1.0f * scaling), (double)0.0, (double)0.0, (double)(-1.0f * scaling), (double)this.crx, (double)((float)this.h + this.cry)));
        Scene scene = new Scene((Parent)group, (double)this.w, (double)this.h);
        scene.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)1.0));
        if (latch != null) {
            scene.snapshot((Callback)new Callback<SnapshotResult, Void>(){

                public Void call(SnapshotResult p) {
                    imageProperty.set((Object)SwingFXUtils.fromFXImage((Image)p.getImage(), null));
                    latch.countDown();
                    return null;
                }
            }, null);
        } else {
            imageProperty.set((Object)SwingFXUtils.fromFXImage((Image)scene.snapshot(null), null));
        }
    }
}

