/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ImageHandler;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.utils.LogWriter;

public class DO
extends ImageDecoder {
    public DO(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ImageHandler customImageHandler, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, int formLevel, PdfPageData pageData, String imagesInFile, String formName) {
        super(imageCount, currentPdfFile, errorTracker, customImageHandler, objectStoreStreamRef, pdfImages, formLevel, pageData, imagesInFile, formName);
    }

    @Override
    public int processImage(String name, int dataPointer, PdfObject XObject2) throws PdfException {
        if (this.formLevel > 0) {
            name = this.formName + '_' + this.formLevel + '_' + name;
        }
        String key = null;
        if (ImageCommands.rejectSuperimposedImages) {
            key = (int)this.gs.CTM[2][0] + "-" + (int)this.gs.CTM[2][1] + '-' + (int)this.gs.CTM[0][0] + '-' + (int)this.gs.CTM[1][1] + '-' + (int)this.gs.CTM[0][1] + '-' + (int)this.gs.CTM[1][0];
        }
        try {
            this.processXImage(name, name, key, XObject2);
        }
        catch (Error e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Error: " + e.getMessage());
            }
            this.parserOptions.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        catch (Exception e) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception " + e);
            }
            this.parserOptions.imagesProcessedFully = false;
            this.errorTracker.addPageFailureMessage("Error " + e + " in DO");
        }
        return dataPointer;
    }

    private void processXImage(String name, String details, String key, PdfObject XObject2) throws PdfException {
        int previousUse = -1;
        if (ImageCommands.trackImages) {
            details = details + " Image";
            if (this.imagesInFile == null) {
                this.imagesInFile = "";
            }
        }
        boolean isForHTML = this.current.isHTMLorSVG();
        if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
            byte[] objectData = this.currentPdfFile.readStream(XObject2, true, true, false, false, false, XObject2.getCacheName(this.currentPdfFile.getObjectReader()));
            if (objectData == null) {
                this.parserOptions.imagesProcessedFully = false;
            } else {
                this.currentImage = this.parserOptions.getFileName() + '-' + name;
                BufferedImage image = this.processImageXObject(XObject2, name, objectData, false, details);
                if (image != null && image.getWidth() == 1 && image.getHeight() == 1 && this.isType3Font) {
                    image.flush();
                    image = null;
                }
                if (image != null) {
                    block19: {
                        if (!isForHTML && (this.parserOptions.renderDirectly() || this.useHiResImageForDisplay)) {
                            this.gs.x = this.gs.CTM[2][0];
                            this.gs.y = this.gs.CTM[2][1];
                            if (this.finalImagesExtracted || this.rawImagesExtracted) {
                                int h;
                                int w = (int)Math.abs(this.gs.CTM[0][0]);
                                if (w == 0) {
                                    w = (int)Math.abs(this.gs.CTM[0][1]);
                                }
                                if ((h = (int)Math.abs(this.gs.CTM[1][1])) == 0) {
                                    h = (int)Math.abs(this.gs.CTM[1][0]);
                                }
                                this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), this.gs.x, this.gs.y, w, h);
                            }
                            if (this.parserOptions.renderDirectly()) {
                                this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, name, -1);
                            } else {
                                int id = this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, name, -1);
                                if (ImageCommands.rejectSuperimposedImages && key != null) {
                                    this.cache.setImposedKey(key, id);
                                }
                            }
                        } else if (this.clippedImagesExtracted || isForHTML) {
                            this.generateTransformedImage(image, name);
                        } else {
                            try {
                                this.generateTransformedImageSingle(image, name);
                            }
                            catch (Exception e) {
                                if (!LogWriter.isOutput()) break block19;
                                LogWriter.writeLog("Exception " + e + " on transforming image in file");
                            }
                        }
                    }
                    image.flush();
                }
            }
        }
    }
}

