/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;

class IgnoreMask {
    IgnoreMask() {
    }

    public static boolean isIgnored(PdfObject XObject2, ImageData imageData, GenericColorSpace decodeColorData, PdfObjectReader currentPdfFile) throws PdfException {
        boolean ignoreImage = false;
        XObject2.setFloatArray(859785322, new float[]{1.0f, 0.0f});
        PdfArrayIterator Filters = XObject2.getMixedArray(1011108731);
        boolean isMaskJPX = false;
        if (Filters != null && Filters.hasMoreTokens()) {
            while (Filters.hasMoreTokens()) {
                int firstValue = Filters.getNextValueAsConstant(true);
                isMaskJPX = firstValue == 1399277700;
            }
        }
        byte[] objData = currentPdfFile.readStream(XObject2, true, true, false, false, false, null);
        imageData.setDepth(1);
        int w = XObject2.getInt(959726687);
        int h = XObject2.getInt(959926393);
        int newDepth = XObject2.getInt(-1344207655);
        if (isMaskJPX) {
            BufferedImage img = decodeColorData.JPEG2000ToRGBImage(objData, w, h, null, -1, -1, 8);
            img = ColorSpaceConvertor.convertColorspace(img, 10);
            byte[] objectData = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
            boolean isEmptyMask = true;
            for (byte b : objectData) {
                if (b == 0) continue;
                isEmptyMask = false;
                break;
            }
            if (isEmptyMask) {
                ignoreImage = true;
            }
            XObject2.setMixedArray(1011108731, null);
        }
        if (newDepth != -1) {
            imageData.setDepth(newDepth);
        }
        imageData.setWidth(w);
        imageData.setHeight(h);
        imageData.setObjectData(objData);
        return ignoreImage;
    }
}

