/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import com.idrsolutions.pdf.color.shading.BitReader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.ColorspaceFactory;
import org.jpedal.color.DeviceGrayColorSpace;
import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ErrorTracker;
import org.jpedal.external.ImageDataHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.images.ImageTransformer;
import org.jpedal.images.ImageTransformerDouble;
import org.jpedal.images.SamplingFactory;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.PdfImageData;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.BaseDecoder;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.image.BinaryImage;
import org.jpedal.parser.image.EightBitDownSampler;
import org.jpedal.parser.image.ImageCommands;
import org.jpedal.parser.image.IndexedImage;
import org.jpedal.parser.image.JPeg2000ImageDecoder;
import org.jpedal.parser.image.MaskDataDecoder;
import org.jpedal.parser.image.MaskDecoder;
import org.jpedal.parser.image.OneBitDownSampler;
import org.jpedal.parser.image.OneBitImage;
import org.jpedal.parser.image.SMaskDecoder;
import org.jpedal.parser.image.ThreeComponentImage;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.utils.ArrayUtils;
import org.jpedal.parser.image.utils.ConvertImageToShape;
import org.jpedal.parser.image.utils.ConvertMaskToImage;
import org.jpedal.parser.image.utils.ConvertMaskToShape;
import org.jpedal.parser.image.utils.JPegImageDecoder;
import org.jpedal.utils.LogWriter;

public class ImageDecoder
extends BaseDecoder {
    public static boolean allowPrintTransparency;
    final PdfImageData pdfImages;
    private boolean getSamplingOnly;
    boolean isMask = true;
    String imagesInFile;
    PdfObjectCache cache;
    boolean isPrinting;
    final ImageHandler customImageHandler;
    boolean useHiResImageForDisplay;
    boolean isType3Font;
    final int formLevel;
    final PdfPageData pageData;
    final ObjectStore objectStoreStreamRef;
    boolean clippedImagesExtracted = true;
    private boolean extractRawCMYK;
    boolean finalImagesExtracted = true;
    boolean createScaledVersion = true;
    boolean renderImages;
    boolean rawImagesExtracted = true;
    String currentImage = "";
    final String formName;
    final ErrorTracker errorTracker;
    final PdfObjectReader currentPdfFile;
    public final int imageCount;

    public ImageDecoder(int imageCount, PdfObjectReader currentPdfFile, ErrorTracker errorTracker, ImageHandler customImageHandler, ObjectStore objectStoreStreamRef, PdfImageData pdfImages, int formLevel, PdfPageData pageData, String imagesInFile, String formName) {
        this.imageCount = imageCount;
        this.currentPdfFile = currentPdfFile;
        this.errorTracker = errorTracker;
        this.formName = formName;
        this.customImageHandler = customImageHandler;
        this.objectStoreStreamRef = objectStoreStreamRef;
        this.pdfImages = pdfImages;
        this.formLevel = formLevel;
        this.pageData = pageData;
        this.imagesInFile = imagesInFile;
    }

    private GenericColorSpace setupXObjectColorspace(PdfObject XObject2, ImageData imageData) {
        PdfObject parms;
        int width = imageData.getWidth();
        int height = imageData.getHeight();
        int depth = imageData.getDepth();
        PdfObject ColorSpace2 = XObject2.getDictionary(2087749783);
        GenericColorSpace decodeColorData = new DeviceRGBColorSpace();
        if (ColorSpace2 != null) {
            decodeColorData = ColorspaceFactory.getColorSpaceInstance(this.currentPdfFile, ColorSpace2, this.cache.XObjectColorspaces);
            decodeColorData.setPrinting(this.isPrinting);
            this.cache.put(1, decodeColorData.getID(), (Object)"x");
            if (depth == 1 && decodeColorData.getID() == 1785221209 && XObject2.getDictionary(489767739) == null) {
                byte[] data = decodeColorData.getIndexedMap();
                if (decodeColorData.getIndexedMap() == null || data.length == 6 && data[0] == 0 && data[1] == 0 && data[2] == 0) {
                    decodeColorData = new DeviceGrayColorSpace();
                }
            }
        }
        byte[] indexData = decodeColorData.getIndexedMap();
        if (depth == 8) {
            int[] maskArray;
            PdfObject newMask;
            byte[] objectData = imageData.getObjectData();
            if (indexData != null && decodeColorData.getID() == 1785221209 && width * height == objectData.length && (newMask = XObject2.getDictionary(489767739)) != null && (maskArray = newMask.getIntArray(489767739)) != null && maskArray.length == 2 && maskArray[0] == 255 && maskArray[0] == maskArray[1] && decodeColorData.getIndexedMap() != null && decodeColorData.getIndexedMap().length == 768) {
                boolean isCorrupt = true;
                for (int jj = 0; jj < 768; ++jj) {
                    if (indexData[jj] == 0) continue;
                    isCorrupt = false;
                    jj = 768;
                }
                if (isCorrupt) {
                    decodeColorData = new DeviceGrayColorSpace();
                }
            }
        }
        if ((parms = XObject2.getDictionary(1888135062)) != null) {
            decodeColorData.setDecodeParms(parms);
        }
        return decodeColorData;
    }

    public BufferedImage processImageXObject(PdfObject XObject2, String image_name, byte[] objectData, boolean saveRawData, String details) throws PdfException {
        BufferedImage image = null;
        image_name = this.parserOptions.getFileName() + '-' + image_name;
        PdfObject newSMask = XObject2.getDictionary(489767774);
        PdfObject newMask = XObject2.getDictionary(489767739);
        ImageData imageData = new ImageData(XObject2, objectData);
        imageData.getFilter(XObject2);
        GenericColorSpace decodeColorData = this.setupXObjectColorspace(XObject2, imageData);
        imageData.setCompCount(decodeColorData.getColorSpace().getNumComponents());
        byte[] convertedData = XObject2.getConvertedData();
        if (convertedData != null) {
            objectData = convertedData;
            decodeColorData = new DeviceRGBColorSpace();
            imageData = null;
        } else if (!(newSMask == null && newMask == null || newSMask != null && XObject2.getInt(959726687) == 1 && XObject2.getInt(959926393) == 1 && XObject2.getInt(-1344207655) == 8)) {
            if (imageData.isDCT()) {
                objectData = JPEGDecoder.getBytesFromJPEG(objectData, decodeColorData, XObject2);
                imageData.setObjectData(objectData);
                XObject2.setMixedArray(1011108731, null);
                XObject2.setDecodedStream(objectData);
            } else if (imageData.isJPX()) {
                objectData = JPeg2000ImageDecoder.getBytesFromJPEG2000(objectData, decodeColorData, XObject2);
                imageData.setObjectData(objectData);
                XObject2.setMixedArray(1011108731, null);
                XObject2.setDecodedStream(objectData);
                decodeColorData = new DeviceRGBColorSpace();
            }
            if (newSMask != null) {
                ImageData smaskImageData = new ImageData(newSMask, null);
                smaskImageData.getFilter(newSMask);
                GenericColorSpace maskColorSpace = this.setupXObjectColorspace(newSMask, smaskImageData);
                byte[] maskData = this.currentPdfFile.readStream(newSMask, true, true, false, false, false, newSMask.getCacheName(this.currentPdfFile.getObjectReader()));
                objectData = SMaskDecoder.applyJPX_JBIG_Smask(imageData, smaskImageData, maskData, XObject2, newSMask, decodeColorData, maskColorSpace);
            } else {
                byte[] index = decodeColorData.getIndexedMap();
                int[] maskArray = newMask.getIntArray(489767739);
                if (index != null) {
                    index = decodeColorData.convertIndexToRGB(index);
                    if (maskArray != null) {
                        return ImageDecoder.geIndexedMaskImage(index, imageData, maskArray);
                    }
                    objectData = ColorSpaceConvertor.convertIndexToRGBByte(index, imageData.getWidth(), imageData.getHeight(), imageData.getCompCount(), imageData.getDepth(), objectData, false, false);
                    decodeColorData = new DeviceRGBColorSpace();
                    imageData.setObjectData(objectData);
                    decodeColorData.setIndex(null, 0);
                }
                ImageData maskImageData = new ImageData(newMask, objectData);
                if (maskArray != null) {
                    return MaskDataDecoder.applyMaskArray(imageData, maskArray);
                }
                byte[] maskData = this.currentPdfFile.readStream(newMask, true, true, false, false, false, newMask.getCacheName(this.currentPdfFile.getObjectReader()));
                maskData = MaskDataDecoder.getSMaskData(maskData, maskImageData, newMask, this.setupXObjectColorspace(newMask, maskImageData));
                objectData = MaskDecoder.applyMask(imageData, decodeColorData, newMask, XObject2, maskData);
                XObject2.setConvertedData(objectData);
                decodeColorData = new DeviceRGBColorSpace();
                XObject2.setDictionary(489767739, null);
            }
            imageData = null;
        }
        if (imageData == null) {
            imageData = new ImageData(XObject2, objectData);
            decodeColorData = new DeviceRGBColorSpace(true);
            imageData.setCompCount(4);
            newSMask = null;
        }
        this.isMask = XObject2.getBoolean(1516403337);
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Processing XObject: " + image_name + ' ' + XObject2.getObjectRefAsString() + " width=" + imageData.getWidth() + " Height=" + imageData.getHeight() + " Depth=" + imageData.getDepth() + " colorspace=" + decodeColorData);
        }
        if (this.customImageHandler != null && !(this.customImageHandler instanceof ImageDataHandler)) {
            image = this.customImageHandler.processImageData(this.gs, XObject2);
        }
        if (newSMask != null && XObject2.getInt(959726687) == 1 && XObject2.getInt(959926393) == 1 && XObject2.getInt(-1344207655) == 8) {
            image = ConvertMaskToImage.convert(newSMask, this.currentPdfFile);
        } else if (this.customImageHandler == null || image == null && !this.customImageHandler.alwaysIgnoreGenericHandler()) {
            image = this.processImage(decodeColorData, image_name, imageData, this.isMask, XObject2, saveRawData);
        }
        if (ImageCommands.trackImages && image != null && details != null) {
            this.setImageInfo(imageData, details, decodeColorData, image);
        }
        return image;
    }

    private static BufferedImage geIndexedMaskImage(byte[] index, ImageData imageData, int[] maskArray) {
        int d = imageData.getDepth();
        int p = 0;
        int c = 0;
        boolean[] invisible = new boolean[1 << d];
        for (int i = 0; i < maskArray.length; i += 2) {
            int start = maskArray[i];
            int end = maskArray[i + 1];
            if (start == end) {
                invisible[start] = true;
                continue;
            }
            for (int j = start; j < end; ++j) {
                invisible[j] = true;
            }
        }
        int[] indexColors = new int[index.length / 3];
        for (int i = 0; i < indexColors.length; ++i) {
            indexColors[i] = 0xFF000000 | (index[c++] & 0xFF) << 16 | (index[c++] & 0xFF) << 8 | index[c++] & 0xFF;
        }
        BitReader reader = new BitReader(imageData.getObjectData(), d < 8);
        BufferedImage img = new BufferedImage(imageData.getWidth(), imageData.getHeight(), 2);
        int[] output = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int imageDim = imageData.getWidth() * imageData.getHeight();
        int w = imageData.getWidth();
        int wc = 0;
        for (int i = 0; i < imageDim; ++i) {
            int v = reader.getPositive(d);
            if (!invisible[v]) {
                output[p++] = indexColors[v];
            } else {
                ++p;
            }
            if (++wc != w) continue;
            int balance = 8 - reader.getPointer() % 8;
            wc = 0;
            if (balance == 8) continue;
            reader.getPositive(balance);
        }
        return img;
    }

    private void setImageInfo(ImageData imageData, String details, GenericColorSpace decodeColorData, BufferedImage image) {
        int width = imageData.getWidth();
        int height = imageData.getHeight();
        float dpi = this.gs.CTM[0][0];
        if (dpi == 0.0f) {
            dpi = this.gs.CTM[0][1];
        }
        if (dpi < 0.0f) {
            dpi = -dpi;
        }
        dpi = (int)((float)width / dpi * 100.0f);
        StringBuilder imageInfo = new StringBuilder(details);
        imageInfo.append(" w=");
        imageInfo.append(width);
        imageInfo.append(" h=");
        imageInfo.append(height);
        imageInfo.append(' ');
        imageInfo.append((int)dpi);
        imageInfo.append(' ');
        imageInfo.append(ColorSpaces.IDtoString(decodeColorData.getID()));
        imageInfo.append(" (");
        imageInfo.append(image.getWidth());
        imageInfo.append(' ');
        imageInfo.append(image.getHeight());
        imageInfo.append(" type=");
        imageInfo.append(image.getType());
        imageInfo.append(')');
        if (this.imagesInFile.isEmpty()) {
            this.imagesInFile = imageInfo.toString();
        } else {
            imageInfo.append('\n');
            imageInfo.append(this.imagesInFile);
            this.imagesInFile = imageInfo.toString();
        }
    }

    public void setSamplingOnly(boolean getSamplingOnly) {
        this.getSamplingOnly = getSamplingOnly;
    }

    public String getImagesInFile() {
        return this.imagesInFile;
    }

    public void setParameters(boolean renderPage, int renderMode, int extractionMode, boolean isPrinting, boolean isType3Font, boolean useHiResImageForDisplay) {
        this.isPrinting = isPrinting;
        this.isType3Font = isType3Font;
        this.useHiResImageForDisplay = useHiResImageForDisplay;
        this.renderImages = renderPage && (renderMode & 2) == 2;
        this.finalImagesExtracted = (extractionMode & 4) == 4;
        this.extractRawCMYK = (extractionMode & 0x80) == 128;
        this.clippedImagesExtracted = (extractionMode & 0x20) == 32;
        this.rawImagesExtracted = (extractionMode & 2) == 2;
        this.createScaledVersion = this.finalImagesExtracted || this.renderImages;
        String value = System.getProperty("org.jpedal.printTransparency");
        if (value != null) {
            allowPrintTransparency = isPrinting && value.equalsIgnoreCase("true");
        }
    }

    public void generateTransformedImage(BufferedImage image, String image_name) {
        float x = 0.0f;
        float y = 0.0f;
        if (image != null) {
            boolean ignoreRotation;
            ImageTransformerDouble image_transformation = null;
            boolean isHTML = this.current.isHTMLorSVG();
            if (isHTML) {
                this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -3);
            }
            int pageRotation = this.pageData.getRotation(this.parserOptions.getPageNumber());
            boolean bl = ignoreRotation = isHTML && this.useHiResImageForDisplay && pageRotation == 90;
            if (!ignoreRotation) {
                float scaling = 1.0f;
                if (!isHTML) {
                    image_transformation = new ImageTransformerDouble(this.gs, image, this.createScaledVersion, 1.0f, pageRotation);
                }
                if (image_transformation != null) {
                    image_transformation.doubleScaleTransformShear();
                    image = image_transformation.getImage();
                }
            }
            if (!isHTML) {
                String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                if (image_type == null) {
                    image_type = "tif";
                }
                BufferedImage outputImage = image;
                if (this.isMask) {
                    int foreground = this.gs.nonstrokeColorSpace.getColor().getRGB();
                    int[] maskCol = new int[]{foreground >> 16 & 0xFF, foreground >> 8 & 0xFF, foreground & 0xFF, 255};
                    BufferedImage img = new BufferedImage(outputImage.getWidth(), outputImage.getHeight(), outputImage.getType());
                    WritableRaster src = outputImage.getRaster();
                    WritableRaster dest = img.getRaster();
                    int[] values = new int[4];
                    for (int yy = 0; yy < outputImage.getHeight(); ++yy) {
                        for (int xx = 0; xx < outputImage.getWidth(); ++xx) {
                            src.getPixel(xx, yy, values);
                            if (values[3] <= 2) continue;
                            dest.setPixel(xx, yy, maskCol);
                        }
                    }
                    outputImage = img;
                }
                if (this.objectStoreStreamRef.saveStoredImage("CLIP_" + this.currentImage, outputImage, false, false, image_type)) {
                    this.errorTracker.addPageFailureMessage("Problem saving " + image);
                }
            }
            if (isHTML) {
                if (image != null) {
                    this.gs.x = x;
                    this.gs.y = y;
                    this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -2);
                }
            } else {
                if (this.finalImagesExtracted || this.renderImages) {
                    image_transformation.doubleScaleTransformScale();
                }
                image_transformation.completeImage();
                x = image_transformation.getImageX();
                y = image_transformation.getImageY();
                float w = image_transformation.getImageW();
                float h = image_transformation.getImageH();
                image = image_transformation.getImage();
                if (image != null) {
                    if (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted) {
                        this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), x, y, w, h);
                    }
                    if (this.renderImages || !this.parserOptions.isPageContent()) {
                        this.gs.x = x;
                        this.gs.y = y;
                        this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -1);
                    }
                    if (!this.parserOptions.renderDirectly() && this.parserOptions.isPageContent() && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                        String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                        if (image_type == null) {
                            image_type = "jpg";
                        }
                        this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false, false, image_type);
                    }
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    public void generateTransformedImageSingle(BufferedImage image, String image_name) {
        if (image != null) {
            boolean ignore_image;
            Area clipping_shape = this.gs.getClippingShape();
            ImageTransformer image_transformation = new ImageTransformer(this.gs, image);
            float x = image_transformation.getImageX();
            float y = image_transformation.getImageY();
            float w = image_transformation.getImageW();
            float h = image_transformation.getImageH();
            image = image_transformation.getImage();
            if (image != null && this.customImageHandler != null && clipping_shape != null && clipping_shape.getBounds().getWidth() > 1.0 && clipping_shape.getBounds().getHeight() > 1.0 && !this.customImageHandler.imageHasBeenScaled() && !(ignore_image = clipping_shape.contains(x, y, w, h))) {
                image_transformation.clipImage(clipping_shape);
                x = image_transformation.getImageX();
                y = image_transformation.getImageY();
                w = image_transformation.getImageW();
                h = image_transformation.getImageH();
            }
            if ((image = image_transformation.getImage()) != null) {
                if (this.finalImagesExtracted || this.rawImagesExtracted) {
                    this.pdfImages.setImageInfo(this.currentImage, this.parserOptions.getPageNumber(), x, y, w, h);
                }
                if (this.renderImages || !this.parserOptions.isPageContent()) {
                    this.gs.x = x;
                    this.gs.y = y;
                    this.current.drawImage(this.parserOptions.getPageNumber(), image, this.gs, false, image_name, -1);
                }
                if (this.parserOptions.isPageContent() && this.finalImagesExtracted && ImageCommands.isExtractionAllowed(this.currentPdfFile)) {
                    String image_type = this.objectStoreStreamRef.getImageType(this.currentImage);
                    this.objectStoreStreamRef.saveStoredImage(this.currentImage, ImageCommands.addBackgroundToMask(image, this.isMask), false, false, image_type);
                }
            }
        } else if (LogWriter.isOutput()) {
            LogWriter.writeLog("NO image written");
        }
    }

    BufferedImage processImage(GenericColorSpace decodeColorData, String name, ImageData imageData, boolean imageMask, PdfObject XObject2, boolean saveRawData) throws PdfException {
        this.cache.put(1, decodeColorData.getID(), (Object)"x");
        int rawd = imageData.getDepth();
        int sampling = 1;
        float[] decodeArray = XObject2.getFloatArray(859785322);
        boolean arrayInverted = ArrayUtils.isArrayInverted(decodeArray);
        PdfArrayIterator Filters = imageData.getFilter(XObject2);
        boolean isDownsampled = false;
        BufferedImage image = null;
        if (this.customImageHandler instanceof ImageDataHandler) {
            image = this.customImageHandler.processImageData(this.gs, XObject2);
        }
        byte[] maskCol = new byte[4];
        if (imageMask) {
            ImageCommands.getMaskColor(maskCol, this.gs);
        }
        if (this.parserOptions.isRenderPage() && this.streamType != 1 && !this.current.avoidDownSamplingImage()) {
            this.setDownsampledImageSize(imageData, XObject2, this.multiplyer, decodeColorData);
        }
        if (!(!this.parserOptions.isRenderPage() || decodeColorData.getID() == 1247168582 || !arrayInverted && decodeArray != null && decodeArray.length != 0 || imageData.getDepth() != 1 && imageData.getDepth() != 8 || imageData.getpX() <= 0 || imageData.getpY() <= 0 || !SamplingFactory.isPrintDownsampleEnabled && this.isPrinting || (sampling = this.setSampling(imageData, decodeColorData)) <= 1 || !(this.multiplyer > 1.0f))) {
            sampling = (int)((float)sampling / this.multiplyer);
        }
        if (this.getSamplingOnly) {
            int w = imageData.getWidth();
            int h = imageData.getHeight();
            if (imageData.getpX() > 0 && imageData.getpY() > 0) {
                float scaleX = (float)w / (float)imageData.getpX();
                float scaleY = (float)h / (float)imageData.getpY();
                if (!(scaleX > 100.0f) && !(scaleY > 100.0f)) {
                    if (scaleX < scaleY) {
                        this.parserOptions.setSamplingUsed(scaleX);
                    } else {
                        this.parserOptions.setSamplingUsed(scaleY);
                    }
                }
            }
            return null;
        }
        byte[] index = decodeColorData.getIndexedMap();
        if (sampling > 1) {
            isDownsampled = true;
            boolean saveData = false;
            if (imageMask && imageData.getWidth() > 2000 && imageData.getHeight() > 2000 && imageData.getDepth() == 1 && decodeColorData.getID() == 1785221209 && this.gs.CTM[0][0] > 0.0f && this.gs.CTM[1][1] > 0.0f) {
                saveData = true;
            }
            if (imageData.getDepth() == 1 && (decodeColorData.getID() != 1785221209 || index == null)) {
                if (this.formLevel < 2 && (saveData || !imageMask && saveRawData && decodeColorData.getID() == 1568372915)) {
                    this.saveRawOneBitDataForResampling(saveData, imageData, index, arrayInverted, decodeColorData, maskCol, XObject2);
                }
                if (index != null) {
                    index = decodeColorData.convertIndexToRGB(index);
                }
                decodeColorData = OneBitDownSampler.downSample(sampling, imageData, imageMask, arrayInverted, maskCol, index, decodeColorData);
            } else if (imageData.getDepth() == 8 && (Filters == null || !imageData.isDCT() && !imageData.isJPX())) {
                decodeColorData = EightBitDownSampler.downSample(imageData, decodeColorData, sampling, index);
            }
        }
        return this.convertImageDataToJavaImage(image, imageData, decodeArray, Filters, index, decodeColorData, imageMask, isDownsampled, maskCol, name, arrayInverted, XObject2, rawd);
    }

    private BufferedImage convertImageDataToJavaImage(BufferedImage image, ImageData imageData, float[] decodeArray, PdfArrayIterator Filters, byte[] index, GenericColorSpace decodeColorData, boolean imageMask, boolean isDownsampled, byte[] maskCol, String name, boolean arrayInverted, PdfObject XObject2, int rawd) throws RuntimeException, PdfException {
        PdfObject DecodeParms;
        PdfObject TR2;
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int d = imageData.getDepth();
        byte[] data = imageData.getObjectData();
        if (decodeArray != null && decodeArray.length != 0 && (Filters == null || !imageData.isJPX() && !imageData.isDCT()) && index == null) {
            ImageCommands.applyDecodeArray(data, d, decodeArray, decodeColorData.getID());
        }
        if (imageMask) {
            image = this.makeMaskImage(h, w, image, d, data, isDownsampled, imageData, imageMask, decodeColorData, maskCol, name);
        } else if (image == null) {
            if (Filters == null) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Image " + name + ' ' + w + "W * " + h + "H with No Compression at BPC " + d);
                }
                image = ImageDecoder.makeImage(decodeColorData, w, h, d, data, imageData.getCompCount());
            } else if (imageData.isDCT()) {
                if (decodeColorData.getID() == 1498837125 && this.extractRawCMYK) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Raw CMYK image " + name + " saved.");
                    }
                    if (!this.objectStoreStreamRef.saveRawCMYKImage(data, name)) {
                        this.errorTracker.addPageFailureMessage("Problem saving Raw CMYK image " + name);
                    }
                }
                image = JPegImageDecoder.decode(name, w, h, arrayInverted, decodeColorData, data, decodeArray, imageData, XObject2, this.errorTracker, this.parserOptions);
            } else if (imageData.isJPX()) {
                image = JPeg2000ImageDecoder.decode(name, w, h, decodeColorData, data, decodeArray, imageData, d);
            } else {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog(name + ' ' + w + "W * " + h + "H BPC=" + d + ' ' + decodeColorData);
                }
                image = ImageDecoder.makeImage(decodeColorData, w, h, d, data, imageData.getCompCount());
            }
        }
        if (image != null) {
            if ((image = this.addOverPrint(decodeColorData, data, image, imageData)) == null) {
                return null;
            }
            if (!this.current.isHTMLorSVG() && !this.parserOptions.renderDirectly() && (this.finalImagesExtracted || this.rawImagesExtracted)) {
                this.saveImage(name, this.createScaledVersion, image, "jpg");
            }
        }
        if (image == null && !imageData.isRemoved()) {
            this.parserOptions.imagesProcessedFully = false;
        }
        if ((TR2 = this.gs.getTR()) != null) {
            image = ImageCommands.applyTR(image, TR2, this.currentPdfFile);
        }
        if ((DecodeParms = XObject2.getDictionary(1888135062)) != null && DecodeParms.getInt(1010122310) != -1 && this.current.hasObjectsBehind(this.gs.CTM) && image != null && image.getType() != 2 && image.getType() != 1 && (!imageData.isDCT() || DecodeParms.getInt(862279027) == 0)) {
            image = ImageCommands.makeBlackandWhiteTransparent(image);
        }
        if (rawd == 1 && imageData.getpX() > 0 && imageData.getpY() > 0 && ImageCommands.sharpenDownsampledImages && (decodeColorData.getID() == 1568372915 || decodeColorData.getID() == 1785221209)) {
            Kernel kernel = new Kernel(3, 3, new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f});
            ConvolveOp op = new ConvolveOp(kernel);
            image = op.filter(image, null);
        }
        if (!allowPrintTransparency && imageData.getMode() == 0 && this.isPrinting && image != null && d == 1 && maskCol != null && maskCol[0] == 0 && maskCol[1] == 0 && maskCol[2] == 0 && maskCol[3] == 0) {
            int iw = image.getWidth();
            int ih = image.getHeight();
            BufferedImage newImage = new BufferedImage(iw, ih, 10);
            newImage.getGraphics().setColor(Color.WHITE);
            newImage.getGraphics().fillRect(0, 0, iw, ih);
            newImage.getGraphics().drawImage(image, 0, 0, null);
            image = newImage;
        }
        if (imageMask && this.gs.nonstrokeColorSpace.getColor().isTexture()) {
            float[][] mm = this.gs.CTM;
            AffineTransform affine = new AffineTransform(mm[0][0], mm[0][1], mm[1][0], mm[1][1], mm[2][0], mm[2][1]);
            BufferedImage temp = ((PatternColorSpace)this.gs.nonstrokeColorSpace).getRawImage(w, h, affine);
            BufferedImage scrap = new BufferedImage(w, h, 2);
            if (temp != null) {
                TexturePaint tp = new TexturePaint(temp, new Rectangle(0, 0, temp.getWidth(), temp.getHeight()));
                Graphics2D g2 = scrap.createGraphics();
                g2.setPaint(tp);
                Rectangle rect = new Rectangle(0, 0, w, h);
                g2.fill(rect);
            }
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    if (image.getRGB(x, y) != -16777216) continue;
                    int pRGB = scrap.getRGB(x, y);
                    image.setRGB(x, y, pRGB);
                }
            }
        }
        return image;
    }

    private BufferedImage makeMaskImage(int h, int w, BufferedImage image, int d, byte[] data, boolean isDownsampled, ImageData imageData, boolean imageMask, GenericColorSpace decodeColorData, byte[] maskCol, String name) {
        float ratio = (float)h / (float)w;
        if (this.isPrinting && ratio < 0.1f && w > 4000 && h > 1 || ratio < 0.001f && w > 4000 && h > 1 || w == 1 && h == 1) {
            ConvertMaskToShape.convert(this.gs, this.current, this.parserOptions);
            image = null;
            imageData.setRemoved(true);
        } else if (h == 2 && d == 1 && ImageCommands.isRepeatingLine(data, h)) {
            ConvertImageToShape.convert(data, h, this.gs, this.current, this.parserOptions);
            image = null;
            imageData.setRemoved(true);
        } else {
            image = MaskDecoder.createMaskImage(isDownsampled, this.isPrinting && !allowPrintTransparency, this.gs, this.isType3Font, this.current, data, image, w, h, imageData, imageMask, d, decodeColorData, maskCol, name);
        }
        return image;
    }

    private BufferedImage addOverPrint(GenericColorSpace decodeColorData, byte[] data, BufferedImage image, ImageData imageData) {
        int colorspaceID = decodeColorData.getID();
        if (image != null) {
            image = ImageCommands.simulateOverprint(decodeColorData, data, imageData.isDCT(), imageData.isJPX(), image, colorspaceID, this.current, this.gs);
        }
        return image;
    }

    public void saveRawOneBitDataForResampling(boolean saveData, ImageData imageData, byte[] index, boolean arrayInverted, GenericColorSpace decodeColorData, byte[] maskCol, PdfObject XObject2) {
        if (!(decodeColorData.getID() == 1785221209 && maskCol != null && imageData.getDepth() == 1 || (imageData.getWidth() >= 4000 || imageData.getHeight() >= 4000) && decodeColorData.getID() != 1568372915 || XObject2 instanceof MaskObject)) {
            byte[] data = imageData.getObjectData();
            int count = data.length;
            byte[] turnedData = new byte[count];
            System.arraycopy(data, 0, turnedData, 0, count);
            if (arrayInverted) {
                for (int aa = 0; aa < count; ++aa) {
                    turnedData[aa] = (byte)(turnedData[aa] ^ 0xFF);
                }
            }
            String key = this.parserOptions.getPageNumber() + String.valueOf(this.imageCount);
            if (saveData) {
                this.current.getObjectStore().saveRawImageData(key, turnedData, imageData.getWidth(), imageData.getHeight(), imageData.getpX(), imageData.getpY(), maskCol, decodeColorData.getID());
            } else {
                this.current.getObjectStore().saveRawImageData(key, turnedData, imageData.getWidth(), imageData.getHeight(), imageData.getpX(), imageData.getpY(), null, decodeColorData.getID());
            }
        }
    }

    private int setSampling(ImageData imageData, GenericColorSpace decodeColorData) {
        int scaleY;
        int sampling = 1;
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        int newW = w;
        int newH = h;
        int pX = imageData.getpX();
        int pY = imageData.getpY();
        if (this.multiplyer <= 1.0f && !this.isPrinting) {
            int maxAllowed = 1000;
            if (decodeColorData.getID() == 1568372915) {
                maxAllowed = 4000;
            }
            if (pX > maxAllowed) {
                pX = maxAllowed;
            }
            if (pY > maxAllowed) {
                pY = maxAllowed;
            }
        }
        int smallestH = pY << 2;
        int smallestW = pX << 2;
        while (newW > smallestW && newH > smallestH) {
            sampling <<= 1;
            newW >>= 1;
            newH >>= 1;
        }
        int scaleX = w / pX;
        if (scaleX < 1) {
            scaleX = 1;
        }
        if ((scaleY = h / pY) < 1) {
            scaleY = 1;
        }
        if ((sampling = scaleX) > scaleY) {
            sampling = scaleY;
        }
        imageData.setpX(pX);
        imageData.setpY(pY);
        return sampling;
    }

    private void setDownsampledImageSize(ImageData imageData, PdfObject XObject2, float multiplyer, GenericColorSpace decodeColorData) {
        int w = imageData.getWidth();
        int h = imageData.getHeight();
        if (this.isPrinting && SamplingFactory.isPrintDownsampleEnabled && w < 4000) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()) * 4);
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()) * 4);
        } else if (SamplingFactory.downsampleLevel == 2 || this.getSamplingOnly) {
            float[][] CTM = new float[3][3];
            for (int ii = 0; ii < 3; ++ii) {
                for (int jj = 0; jj < 3; ++jj) {
                    CTM[ii][jj] = this.gs.CTM[ii][jj] < 0.0f ? -this.gs.CTM[ii][jj] : this.gs.CTM[ii][jj];
                }
            }
            if (CTM[0][0] == 0.0f || CTM[0][0] < CTM[0][1]) {
                imageData.setpX((int)CTM[0][1]);
            } else {
                imageData.setpX((int)CTM[0][0]);
            }
            if (CTM[1][1] == 0.0f || CTM[1][1] < CTM[1][0]) {
                imageData.setpY((int)CTM[1][0]);
            } else {
                imageData.setpY((int)CTM[1][1]);
            }
            if (!this.getSamplingOnly && (w < 500 || h < 600 && (w < 1000 || imageData.isJPX()))) {
                imageData.setpX(0);
                imageData.setpX(0);
            }
        } else if (SamplingFactory.downsampleLevel == 1) {
            imageData.setpX(this.pageData.getCropBoxWidth(this.parserOptions.getPageNumber()));
            imageData.setpY(this.pageData.getCropBoxHeight(this.parserOptions.getPageNumber()));
        }
        int maxHTMLImageSize = 4000;
        if (this.current.avoidDownSamplingImage() || w < 4000 && h < 4000 && this.current.isHTMLorSVG() && (imageData.getDepth() != 1 || XObject2.getRawObjectType() != 489767739)) {
            imageData.setpX(-1);
            imageData.setpY(1);
        }
        if ((imageData.isDCT() || imageData.isJPX()) && multiplyer > 1.0f) {
            imageData.setpX((int)((float)imageData.getpX() * multiplyer));
            imageData.setpY((int)((float)imageData.getpX() * multiplyer));
        }
        if (imageData.getDepth() == 1 && XObject2.getObjectType() != 489767739 && decodeColorData.getID() == 1568372915 && imageData.getHeight() < 300) {
            imageData.setpX(0);
            imageData.setpY(0);
        }
    }

    private void saveImage(String name, boolean createScaledVersion, BufferedImage image, String type) {
        if (image != null && image.getSampleModel().getNumBands() == 1) {
            type = "tif";
        }
        if (this.parserOptions.isPageContent() && (this.renderImages || this.finalImagesExtracted || this.clippedImagesExtracted || this.rawImagesExtracted)) {
            this.objectStoreStreamRef.saveStoredImage(name, ImageCommands.addBackgroundToMask(image, this.isMask), false, createScaledVersion, type);
        }
    }

    private static BufferedImage makeImage(GenericColorSpace decodeColorData, int w, int h, int d, byte[] data, int comp) {
        if (decodeColorData.getID() == 1568372915) {
            data = ImageDecoder.correctDataArraySize(d, w, h, data);
        }
        int ID2 = decodeColorData.getID();
        BufferedImage image = null;
        byte[] index = decodeColorData.getIndexedMap();
        if (index != null) {
            image = IndexedImage.make(w, h, decodeColorData, index, d, data);
        } else if (d == 1) {
            image = BinaryImage.make(w, h, data, decodeColorData, d);
        } else if (ID2 == -2073385820 || ID2 == 960981604) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Converting Separation/DeviceN colorspace to sRGB ");
            }
            image = decodeColorData.dataToRGB(data, w, h);
        } else {
            switch (comp) {
                case 4: {
                    if (decodeColorData.getID() == 1785221209) {
                        image = ColorSpaceConvertor.createARGBImage(w, h, data);
                        break;
                    }
                    image = ColorSpaceConvertor.convertFromICCCMYK(w, h, data);
                    break;
                }
                case 3: {
                    image = ThreeComponentImage.make(d, data, index, w, h);
                    break;
                }
                case 1: {
                    image = OneBitImage.make(d, w, h, data);
                }
            }
        }
        return image;
    }

    static byte[] correctDataArraySize(int d, int w, int h, byte[] data) {
        int requiredSize;
        int oldSize;
        if (d == 1) {
            int oldSize2 = data.length;
            int requiredSize2 = (w + 7 >> 3) * h;
            if (oldSize2 < requiredSize2) {
                byte[] oldData = data;
                data = new byte[requiredSize2];
                System.arraycopy(oldData, 0, data, 0, oldSize2);
                for (int aa = oldSize2; aa < requiredSize2; ++aa) {
                    data[aa] = -1;
                }
            }
        } else if (d == 8 && (oldSize = data.length) < (requiredSize = w * h)) {
            byte[] oldData = data;
            data = new byte[requiredSize];
            System.arraycopy(oldData, 0, data, 0, oldSize);
        }
        return data;
    }

    static boolean allBytesZero(byte[] data) {
        boolean allZero = true;
        for (byte bytes : data) {
            if (bytes == 0) continue;
            allZero = false;
            break;
        }
        return allZero;
    }

    public void setRes(PdfObjectCache cache) {
        this.cache = cache;
    }

    public int processImage(String s, int dataPointer, PdfObject xObject) throws Exception {
        return 0;
    }

    public int processImage(int dataPointer, int startInlineStream, byte[] stream, int tokenNumber) throws Exception {
        return 0;
    }
}

