/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.parser.image.ImageDecoder;
import org.jpedal.utils.LogWriter;

public class IndexedImage {
    public static BufferedImage make(int w, int h, GenericColorSpace decodeColorData, byte[] index, int d, byte[] data) {
        BufferedImage image;
        block13: {
            image = null;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Indexed " + w + ' ' + h);
            }
            if (!decodeColorData.isIndexConverted()) {
                index = decodeColorData.convertIndexToRGB(index);
            }
            if (d == 8 && decodeColorData.getIndexSize() == 0 && decodeColorData.getID() == 1785221209 && decodeColorData.getRawColorSpacePDFType() != 1247168582) {
                boolean hasPixels = false;
                int indexCount = index.length;
                for (int ii = 0; ii < indexCount; ++ii) {
                    if (index[ii] == 0) continue;
                    hasPixels = true;
                    ii = indexCount;
                }
                if (!hasPixels) {
                    int pixelCount = data.length;
                    for (int ii = 0; ii < pixelCount; ++ii) {
                        if (data[ii] == 0) continue;
                        hasPixels = true;
                        ii = pixelCount;
                    }
                }
                if (!hasPixels) {
                    return new BufferedImage(1, 1, 2);
                }
            }
            try {
                if (d == 1 && index.length == 6 && index[0] == index[3] && index[1] == index[4] && index[2] == index[5]) {
                    image = null;
                } else if (d == 8 && w == 1 && h == 1 && index[0] == -1 && index[1] == -1 && index[2] == -1 && ImageDecoder.allBytesZero(data)) {
                    image = new BufferedImage(1, 1, 1);
                    image.createGraphics().setPaint(Color.CYAN);
                    Raster raster = ColorSpaceConvertor.createInterleavedRaster(new byte[]{-1, -1, -1}, 1, 1);
                    image.setData(raster);
                } else {
                    image = ColorSpaceConvertor.convertIndexedToFlat(d, w, h, data, index, false, false);
                }
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block13;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return image;
    }
}

