/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.utils.LogWriter;

public class JPeg2000ImageDecoder {
    public static BufferedImage decode(String name, int w, int h, GenericColorSpace decodeColorData, byte[] data, float[] decodeArray, ImageData imageData, int d) throws RuntimeException, PdfException {
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("JPeg 2000 Image " + name + ' ' + w + "W * " + h + 'H');
        }
        BufferedImage image = decodeColorData.JPEG2000ToRGBImage(data, w, h, decodeArray, imageData.getpX(), imageData.getpY(), d);
        return image;
    }

    public static byte[] getBytesFromJPEG2000(byte[] data, GenericColorSpace decodeColorData, PdfObject XObject2) {
        Raster ras = JPeg2000ImageDecoder.getRasterFromJPEG2000(data);
        return ((DataBufferByte)ras.getDataBuffer()).getData();
    }

    static Raster getRasterFromJPEG2000(byte[] data) {
        WritableRaster ras;
        block3: {
            ImageReader iir = null;
            ras = null;
            try {
                ImageReader o;
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
                while (iterator.hasNext() && !(iir = (o = iterator.next())).canReadRaster()) {
                }
                ImageIO.setUseCache(false);
                ImageInputStream iin = ImageIO.createImageInputStream(in);
                iir.setInput(iin, true);
                ras = iir.read(0).getRaster();
                in.close();
                iir.dispose();
                iin.close();
            }
            catch (Exception ee) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Problem closing  " + ee);
            }
        }
        return ras;
    }
}

