/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.utils;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;

public class ConvertMaskToImage {
    public static BufferedImage convert(PdfObject newSMask, PdfObjectReader currentPdfFile) {
        byte opacity;
        byte d0 = 0;
        byte d1 = -1;
        float[] maskDecode = newSMask.getFloatArray(859785322);
        if (maskDecode != null) {
            opacity = (byte)(maskDecode[0] * 255.0f);
            if (maskDecode[0] <= 1.0f && maskDecode[1] <= 1.0f) {
                if (maskDecode[0] == 1.0f && maskDecode[1] == 0.0f) {
                    d1 = (byte)(255.0f * maskDecode[0]);
                    d0 = (byte)(255.0f * maskDecode[1]);
                } else if (maskDecode[0] < maskDecode[1]) {
                    d1 = (byte)(255.0f * maskDecode[0]);
                    d0 = (byte)(255.0f * (1.0f - maskDecode[1]));
                } else {
                    d0 = (byte)(255.0f * maskDecode[0]);
                    d1 = (byte)(255.0f * maskDecode[1]);
                }
            }
        } else {
            d0 = -1;
            d1 = 0;
            opacity = 0;
        }
        byte[] maskIndex = new byte[]{d0, d0, d0, d1, d1, d1};
        byte[] data = currentPdfFile.readStream(newSMask, true, true, false, false, false, null);
        int w = newSMask.getInt(959726687);
        int h = newSMask.getInt(959926393);
        int length = w * h * 4;
        byte[] objData = new byte[length];
        ColorSpaceConvertor.flatten1bpc(w, data, 3, maskIndex, true, length, opacity, objData);
        BufferedImage image = new BufferedImage(w, h, 2);
        DataBufferByte db = new DataBufferByte(objData, objData.length);
        WritableRaster raster = Raster.createInterleavedRaster(db, w, h, w * 4, 4, new int[]{0, 1, 2, 3}, null);
        image.setData(raster);
        return image;
    }
}

