/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.MCObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.ParserOptions;
import org.jpedal.render.DynamicVectorRenderer;

public class BDC {
    public static PdfObject execute(int startCommand, int dataPointer, byte[] raw, String op, GraphicsState gs, PdfObjectReader currentPdfFile, DynamicVectorRenderer current, ParserOptions parserOptions) {
        MCObject BDCobj = new MCObject(op);
        BDCobj.setID(1184787);
        int rawStart = startCommand;
        if (startCommand < 1) {
            startCommand = 1;
        }
        boolean hasDictionary = true;
        while (startCommand < raw.length && raw[startCommand] != 60 && raw[startCommand - 1] != 60) {
            if (raw[++startCommand] != 66 || raw[startCommand + 1] != 68 || raw[startCommand + 2] != 67) continue;
            hasDictionary = false;
            break;
        }
        if (hasDictionary) {
            ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile.getObjectReader());
            objectDecoder.setEndPt(dataPointer);
            objectDecoder.readDictionaryAsObject(BDCobj, startCommand + 1, raw);
        }
        BDC.handleCommand(BDCobj, gs, current, dataPointer, raw, hasDictionary, rawStart, parserOptions);
        return BDCobj;
    }

    private static void handleCommand(PdfObject BDCobj, GraphicsState gs, DynamicVectorRenderer current, int dataPointer, byte[] raw, boolean hasDictionary, int rawStart, ParserOptions parserOptions) {
        parserOptions.setLayerLevel(parserOptions.getLayerLevel() + 1);
        if (parserOptions.layers != null && parserOptions.isLayerVisible()) {
            String name = "";
            if (hasDictionary) {
                Area clip;
                PdfObject layerObj;
                name = BDCobj.getName(7955);
                if (name == null && (layerObj = BDCobj.getDictionary(826881374)) != null) {
                    name = layerObj.getTextStreamValue(960773209);
                }
                parserOptions.layerClips.add(parserOptions.getLayerLevel());
                float[] BBox = BDCobj.getFloatArray(303185736);
                if (BBox != null && (clip = new Area(new Rectangle2D.Float(BBox[0], BBox[1], -gs.CTM[2][0] + (BBox[2] - BBox[0]), -gs.CTM[2][1] + (BBox[3] - BBox[1])))).getBounds().getWidth() > 0.0 && clip.getBounds().getHeight() > 0.0) {
                    gs.setClippingShape(clip);
                    current.drawClip(gs, clip, true);
                    BDCobj.setClip(clip);
                }
            } else {
                name = BDC.readOPName(dataPointer, raw, rawStart, name);
            }
            if (name != null && !name.isEmpty()) {
                parserOptions.setIsLayerVisible(parserOptions.layers.decodeLayer(name, true));
            }
            if (parserOptions.isLayerVisible()) {
                parserOptions.getLayerVisibility().add(parserOptions.getLayerLevel());
            }
        }
    }

    private static String readOPName(int dataPointer, byte[] raw, int rawStart, String name) {
        for (int ii = rawStart; ii < dataPointer; ++ii) {
            if (raw[ii] != 47 || raw[ii + 1] != 79 || raw[ii + 2] != 67) continue;
            ii += 2;
            while (raw[ii] != 47) {
                ++ii;
            }
            int strStart = ++ii;
            int charCount = 0;
            while (ii < dataPointer) {
                ++charCount;
                if (raw[++ii] != 13 && raw[ii] != 10 && raw[ii] != 32 && raw[ii] != 47) continue;
            }
            name = new String(raw, strStart, charCount);
        }
        return name;
    }
}

