/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.parser.text.GlyphData;

class HTMLTextUtils {
    HTMLTextUtils() {
    }

    static boolean remapGlyph(PdfFont currentFontData, GlyphData glyphData) {
        int altValue;
        boolean alreadyRemaped = false;
        String charGlyph = currentFontData.getMappedChar(glyphData.getRawInt(), false);
        if (charGlyph != null && !glyphData.getDisplayValue().isEmpty() && glyphData.getDisplayValue().charAt(0) < ' ' && currentFontData.getDiffChar(charGlyph) == -1 && (altValue = StandardFonts.getAdobeMap(charGlyph)) > -1 && currentFontData.getMappedChar(altValue, false) != null) {
            glyphData.setRawInt(altValue);
            glyphData.set(String.valueOf((char)altValue));
            alreadyRemaped = true;
        }
        return alreadyRemaped;
    }
}

