/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.text;

import org.jpedal.objects.TextState;
import org.jpedal.utils.Matrix;

public class TD {
    static final int[] multiply8 = new int[]{0, 3, 6, 9, 12, 15};
    static final int[] multiply16 = new int[]{0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40};

    public static void execute(boolean isLowerCase, float x, float y, TextState currentTextState) {
        TD.relativeMove(x, y, currentTextState);
        if (!isLowerCase) {
            float TL = -y;
            currentTextState.setLeading(TL);
        }
    }

    public static void relativeMove(float new_x, float new_y, TextState currentTextState) {
        float[][] temp = new float[3][3];
        currentTextState.Tm = currentTextState.getTMAtLineStart();
        temp[0][0] = 1.0f;
        temp[0][1] = 0.0f;
        temp[0][2] = 0.0f;
        temp[1][0] = 0.0f;
        temp[1][1] = 1.0f;
        temp[1][2] = 0.0f;
        temp[2][0] = new_x;
        temp[2][1] = new_y;
        temp[2][2] = 1.0f;
        currentTextState.Tm = Matrix.multiply(temp, currentTextState.Tm);
        currentTextState.setTMAtLineStart();
    }

    static int readEscapeValue(int start, int count, int base, byte[] characterStream) {
        int val;
        switch (base) {
            case 8: {
                val = TD.getOctal(start, count, characterStream);
                break;
            }
            case 16: {
                val = TD.getHex(start, count, characterStream);
                break;
            }
            default: {
                val = TD.getGeneral(start, count, base, characterStream);
            }
        }
        return val;
    }

    private static int getGeneral(int start, int count, int base, byte[] characterStream) {
        StringBuilder chars = new StringBuilder(10);
        for (int pointer = 0; pointer < count; ++pointer) {
            chars.append((char)characterStream[start + pointer]);
        }
        return Integer.parseInt(chars.toString(), base);
    }

    private static int getHex(int start, int count, byte[] characterStream) {
        int val = 0;
        int ptr = 0;
        for (int aa = 1; aa < count + 1; ++aa) {
            int topHex = characterStream[start + count - aa];
            if (topHex >= 65 && topHex <= 70) {
                topHex -= 55;
            } else if (topHex >= 97 && topHex <= 102) {
                topHex -= 87;
            } else {
                if (topHex < 48 || topHex > 57) continue;
                topHex -= 48;
            }
            val += topHex << multiply16[ptr];
            ++ptr;
        }
        return val;
    }

    private static int getOctal(int start, int count, byte[] characterStream) {
        int ptr = 0;
        int val = 0;
        for (int aa = 1; aa < count + 1; ++aa) {
            int topHex = characterStream[start + count - aa];
            if (topHex < 48 || topHex > 55) continue;
            val += (topHex -= 48) << multiply8[ptr];
            ++ptr;
        }
        return val;
    }

    static String getString(int start, int end, byte[] dataStream) {
        while (dataStream[end] == 32 || dataStream[end] == 13 || dataStream[end] == 10) {
            --end;
        }
        int count = end - start + 1;
        int spaces = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii <= 0 || dataStream[start + ii] != 32 && dataStream[start + ii] != 13 && dataStream[start + ii] != 10 || dataStream[start + ii - 1] != 32 && dataStream[start + ii - 1] != 13 && dataStream[start + ii - 1] != 10) continue;
            ++spaces;
        }
        char[] charString = new char[count - spaces];
        int pos = 0;
        for (int ii = 0; ii < count; ++ii) {
            if (ii > 0 && (dataStream[start + ii] == 32 || dataStream[start + ii] == 13 || dataStream[start + ii] == 10) && (dataStream[start + ii - 1] == 32 || dataStream[start + ii - 1] == 13 || dataStream[start + ii - 1] == 10)) continue;
            charString[pos] = dataStream[start + ii] == 10 || dataStream[start + ii] == 13 ? 32 : (char)dataStream[start + ii];
            ++pos;
        }
        String s = String.copyValueOf(charString);
        return s;
    }
}

