/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import org.jpedal.color.PatternColorSpace;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.render.GUIDisplay;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class FXDisplay
extends GUIDisplay {
    final Group pdfContent = new Group();
    private final List collection = new ArrayList(2000);

    public FXDisplay(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
    }

    @Override
    public void flushAdditionalObjOnPage() {
        throw new RuntimeException("NOt used in JavaFX implementation - please redecode the page");
    }

    public FXDisplay(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.isPrinting = isPrinting;
        this.setupArrays(5000);
    }

    @Override
    public void flush() {
        this.pageObjects.clear();
        this.objectType.clear();
        this.areas.clear();
        this.currentItem = 0;
    }

    @Override
    public void drawAdditionalObjectsOverPage(final int[] type, final java.awt.Color[] colors, final Object[] obj) throws PdfException {
        if (obj == null) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            this.drawUserContent(type, obj, colors);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FXDisplay.this.drawUserContent(type, obj, colors);
                        }
                        catch (PdfException e) {
                            if (!LogWriter.isOutput()) break block2;
                            LogWriter.writeLog("Exception with additional objects: " + e.getMessage());
                        }
                    }
                }
            });
        }
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int previousUse) {
        this.rawPageNumber = pageNumber;
        float[][] CTM = currentGraphicsState.CTM;
        WritableImage fxImage = SwingFXUtils.toFXImage((BufferedImage)image, null);
        float imageW = (float)fxImage.getWidth();
        float imageH = (float)fxImage.getHeight();
        ImageView im1View = new ImageView((Image)fxImage);
        float[] affine = new float[]{CTM[0][0] / imageW, CTM[0][1] / imageW, -CTM[1][0] / imageH, -CTM[1][1] / imageH, CTM[2][0] + CTM[1][0], CTM[2][1] + CTM[1][1]};
        im1View.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)affine[0], (double)affine[1], (double)affine[2], (double)affine[3], (double)affine[4], (double)affine[5])});
        FXDisplay.setClip(currentGraphicsState, affine, (Node)im1View);
        FXDisplay.setBlendMode(currentGraphicsState, (Node)im1View);
        this.addToScene((Node)im1View);
        float WidthModifier = 1.0f;
        float HeightModifier = 1.0f;
        if (CTM[0][0] > 0.0f && (double)CTM[0][0] < 0.05 && CTM[0][1] != 0.0f && CTM[1][0] != 0.0f && CTM[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            this.w = (int)(CTM[0][0] * 1.0f);
            if (this.w == 0) {
                this.w = (int)(CTM[0][1] * 1.0f);
            }
            this.h = (int)(CTM[1][1] * 1.0f);
            if (this.h == 0) {
                this.h = (int)(CTM[1][0] * 1.0f);
            }
            if (!this.useHiResImageForDisplay && CTM[1][0] < 0.0f && CTM[0][1] > 0.0f && CTM[0][0] == 0.0f && CTM[1][1] == 0.0f) {
                int tmp = this.w;
                this.w = -this.h;
                this.h = tmp;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            int x1 = (int)currentGraphicsState.x;
            int y1 = (int)currentGraphicsState.y;
            int w1 = this.w;
            int h1 = this.h;
            if (h1 < 0) {
                y1 += h1;
                h1 = -h1;
            }
            if (h1 == 0) {
                h1 = 1;
            }
            int[] rectParams = new int[]{x1, y1, w1, h1};
            this.areas.addElement(rectParams);
            this.objectType.addElement(3);
        }
        if (!this.isRenderingToImage()) {
            boolean cacheInMemory;
            boolean bl = cacheInMemory = image.getWidth() < 100 && image.getHeight() < 100 || image.getHeight() == 1;
            if (this.useHiResImageForDisplay && !cacheInMemory) {
                this.pageObjects.addElement(null);
            } else {
                this.pageObjects.addElement(image);
            }
            if (this.rawKey == null) {
                this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem, image, false, false, "tif");
                this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem);
            } else {
                this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey, image, false, false, "tif");
                this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey);
            }
        }
        ++this.currentItem;
        return this.currentItem - 1;
    }

    @Override
    public void drawShape(Object rawShape, GraphicsState currentGraphicsState, int cmd) {
        javafx.scene.shape.Shape currentShape = (javafx.scene.shape.Shape)rawShape;
        float[] affine = new float[]{currentGraphicsState.CTM[0][0], currentGraphicsState.CTM[0][1], currentGraphicsState.CTM[1][0], currentGraphicsState.CTM[1][1], currentGraphicsState.CTM[2][0], currentGraphicsState.CTM[2][1]};
        currentShape.getTransforms().add((Object)Transform.affine((double)affine[0], (double)affine[1], (double)affine[2], (double)affine[3], (double)affine[4], (double)affine[5]));
        if (currentGraphicsState.nonstrokeColorSpace.getID() == 1146450818) {
            this.drawPatternedShape(currentGraphicsState, (Path)currentShape);
        } else {
            FXDisplay.setFXParams(currentShape, currentGraphicsState.getFillType(), currentGraphicsState, this.changeLineArtAndText);
            FXDisplay.setClip(currentGraphicsState, affine, (Node)currentShape);
            FXDisplay.setBlendMode(currentGraphicsState, (Node)currentShape);
            this.addToScene((Node)currentShape);
        }
        int[] shapeBounds = new int[]{(int)currentShape.getBoundsInLocal().getMinX(), (int)currentShape.getBoundsInLocal().getMinY(), (int)currentShape.getBoundsInLocal().getWidth(), (int)currentShape.getBoundsInLocal().getHeight()};
        this.pageObjects.addElement(currentShape);
        this.objectType.addElement(2);
        this.areas.addElement(shapeBounds);
        ++this.currentItem;
    }

    private void drawPatternedShape(GraphicsState currentGraphicsState, Path currentShape) {
        PatternColorSpace fillCS = (PatternColorSpace)currentGraphicsState.nonstrokeColorSpace;
        BufferedImage imageForPattern = fillCS.getImageForPatternedShape(currentGraphicsState);
        if (imageForPattern == null) {
            return;
        }
        WritableImage fxImage = SwingFXUtils.toFXImage((BufferedImage)imageForPattern, null);
        double iw = fxImage.getWidth();
        double ih = fxImage.getHeight();
        ImagePattern pattern = new ImagePattern((Image)fxImage, 0.0, 0.0, iw, ih, false);
        currentShape.setStroke((Paint)new Color(0.0, 0.0, 0.0, 0.0));
        currentShape.setFill((Paint)pattern);
        this.addToScene((Node)currentShape);
    }

    protected static void setFXParams(javafx.scene.shape.Shape currentShape, int fillType, GraphicsState currentGraphicsState, boolean allowColorChange) {
        double a;
        int b;
        int g;
        int r;
        currentShape.setStroke(null);
        if (fillType == 2 || fillType == 3) {
            int fillCol = currentGraphicsState.nonstrokeColorSpace.getColor().getRGB();
            if (allowColorChange && textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && FXDisplay.checkColorThreshold(fillCol)) {
                fillCol = textColor.getRGB();
            }
            r = fillCol >> 16 & 0xFF;
            g = fillCol >> 8 & 0xFF;
            b = fillCol & 0xFF;
            a = currentGraphicsState.getAlpha(2);
            currentShape.setFill((Paint)Color.rgb((int)r, (int)g, (int)b, (double)a));
        }
        if (fillType == 1) {
            int strokeCol = currentGraphicsState.strokeColorSpace.getColor().getRGB();
            if (allowColorChange && textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && FXDisplay.checkColorThreshold(strokeCol)) {
                strokeCol = textColor.getRGB();
            }
            r = strokeCol >> 16 & 0xFF;
            g = strokeCol >> 8 & 0xFF;
            b = strokeCol & 0xFF;
            a = currentGraphicsState.getAlpha(1);
            currentShape.setStroke((Paint)Color.rgb((int)r, (int)g, (int)b, (double)a));
            currentGraphicsState.applyFXStroke(currentShape);
        }
    }

    @Override
    public void drawCustom(Object value) {
        this.addToScene((Node)((javafx.scene.shape.Shape)value));
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] textScaling, String glyf, PdfFont currentFontData, float glyfWidth) {
        if (type == 6) {
            return;
        }
        if (embeddedGlyph == null && javaGlyph == null) {
            double r;
            Text t = new Text(glyf);
            Font f = Font.font((String)currentFontData.getGlyphData().font_family_name, (double)fontSize);
            t.setFont(f);
            FXDisplay.setFXParams((javafx.scene.shape.Shape)t, 2, gs, textColor != null);
            if ((gs.getTextRenderType() & 1) == 1) {
                FXDisplay.setFXParams((javafx.scene.shape.Shape)t, 1, gs, textColor != null);
            }
            FXDisplay.setBlendMode(gs, (Node)t);
            if (type != 4) {
                r = 1.0 / (double)fontSize;
                t.getTransforms().add((Object)Transform.affine((double)(textScaling[0] * r), (double)(textScaling[1] * r), (double)(textScaling[2] * r), (double)(textScaling[3] * r), (double)Trm[2][0], (double)Trm[2][1]));
            } else {
                r = 1.0 / (double)fontSize;
                t.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)((double)Trm[0][0] * r), (double)((double)Trm[0][1] * r), (double)((double)Trm[1][0] * r), (double)((double)Trm[1][1] * r), (double)Trm[2][0], (double)Trm[2][1])});
            }
            float[] transform = new float[]{Trm[0][0], Trm[1][0], Trm[0][1], Trm[1][1], Trm[2][0], Trm[2][1]};
            javafx.scene.shape.Shape clip = gs.getFXClippingShape();
            if (clip != null && !clip.contains((double)Trm[2][0], (double)Trm[2][1])) {
                FXDisplay.setClip(gs, transform, (Node)t);
            }
            this.pageObjects.addElement(t);
            this.addToScene((Node)t);
        } else {
            Path path = embeddedGlyph.getPath();
            if (path == null) {
                return;
            }
            path.setFillRule(FillRule.EVEN_ODD);
            if (type != 4) {
                path.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)textScaling[0], (double)textScaling[1], (double)textScaling[2], (double)textScaling[3], (double)textScaling[4], (double)textScaling[5])});
            } else {
                double r = 0.01;
                if (!TTGlyph.useHinting) {
                    path.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)textScaling[0], (double)textScaling[1], (double)textScaling[2], (double)textScaling[3], (double)textScaling[4], (double)textScaling[5])});
                } else {
                    path.getTransforms().setAll((Object[])new Transform[]{Transform.affine((double)(textScaling[0] * 0.01), (double)(textScaling[1] * 0.01), (double)(textScaling[2] * 0.01), (double)(textScaling[3] * 0.01), (double)textScaling[4], (double)textScaling[5])});
                }
            }
            FXDisplay.setFXParams((javafx.scene.shape.Shape)path, gs.getTextRenderType(), gs, textColor != null);
            FXDisplay.setBlendMode(gs, (Node)path);
            float[] transform = new float[]{Trm[0][0], Trm[1][0], Trm[0][1], Trm[1][1], Trm[2][0], Trm[2][1]};
            javafx.scene.shape.Shape clip = gs.getFXClippingShape();
            if (clip != null && !clip.contains((double)Trm[2][0], (double)Trm[2][1])) {
                FXDisplay.setClip(gs, transform, (Node)path);
            }
            this.pageObjects.addElement(path);
            this.addToScene((Node)path);
        }
        this.objectType.addElement(type);
        if (type < 0) {
            this.areas.addElement(null);
        } else if (javaGlyph != null) {
            int[] rectParams = new int[]{(int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize};
            this.areas.addElement(rectParams);
        } else {
            int realSize = fontSize;
            if (realSize < 0) {
                realSize = -realSize;
            }
            int[] area = new int[]{(int)Trm[2][0], (int)Trm[2][1], realSize, realSize};
            this.areas.addElement(area);
        }
        ++this.currentItem;
    }

    private static void setClip(GraphicsState currentGraphicsState, float[] affine, Node baseNode) {
        javafx.scene.shape.Shape clip = currentGraphicsState.getFXClippingShape();
        if (clip != null) {
            try {
                boolean applyClip;
                if (!Arrays.equals(affine, new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f})) {
                    Affine inverseAff = Transform.affine((double)affine[0], (double)affine[1], (double)affine[2], (double)affine[3], (double)affine[4], (double)affine[5]).createInverse();
                    clip.getTransforms().add((Object)inverseAff);
                }
                boolean bl = applyClip = clip.getBoundsInLocal().getMinX() > baseNode.getBoundsInLocal().getMinX() && baseNode.getBoundsInLocal().getMaxY() > clip.getBoundsInLocal().getMaxY();
                if (applyClip) {
                    baseNode.setClip((Node)clip);
                }
            }
            catch (NonInvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Group getFXPane() {
        if (this.collection != null && !this.collection.isEmpty()) {
            this.pdfContent.getChildren().addAll((Collection)this.collection);
            this.collection.clear();
        }
        return this.pdfContent;
    }

    protected static void setBlendMode(GraphicsState gs, Node n) {
        switch (gs.getBMValue()) {
            case 1451587725: {
                n.setBlendMode(BlendMode.MULTIPLY);
                break;
            }
            case 1110792305: {
                n.setBlendMode(BlendMode.SCREEN);
                break;
            }
            case 1113290622: {
                n.setBlendMode(BlendMode.OVERLAY);
                break;
            }
            case 1111181679: {
                n.setBlendMode(BlendMode.DARKEN);
                break;
            }
            case 945843829: {
                n.setBlendMode(BlendMode.LIGHTEN);
                break;
            }
            case 2071170184: {
                n.setBlendMode(BlendMode.COLOR_DODGE);
                break;
            }
            case 1367441811: {
                n.setBlendMode(BlendMode.COLOR_BURN);
                break;
            }
            case 1786342520: {
                n.setBlendMode(BlendMode.HARD_LIGHT);
                break;
            }
            case 2020441219: {
                n.setBlendMode(BlendMode.SOFT_LIGHT);
                break;
            }
            case 1802796208: {
                n.setBlendMode(BlendMode.DIFFERENCE);
                break;
            }
            case -1955824744: {
                n.setBlendMode(BlendMode.EXCLUSION);
                break;
            }
            default: {
                n.setBlendMode(null);
            }
        }
    }

    private void addToScene(Node items) {
        this.collection.add(items);
    }

    private void setupArrays(int defaultSize) {
        this.areas = new Vector_Rectangle_Int(defaultSize);
        this.objectType = new Vector_Int(defaultSize);
        this.pageObjects = new Vector_Object(defaultSize);
        this.currentItem = 0;
    }

    @Override
    public void paintBackground(Shape dirtyRegion) {
        if (this.addBackground) {
            Path background = new Path();
            background.getElements().add((Object)new MoveTo((double)this.xx, (double)this.yy));
            background.getElements().add((Object)new LineTo((double)this.xx, (double)(this.yy + (int)((float)this.h * this.scaling))));
            background.getElements().add((Object)new LineTo((double)(this.xx + (int)((float)this.w * this.scaling)), (double)(this.yy + (int)((float)this.h * this.scaling))));
            background.getElements().add((Object)new LineTo((double)(this.xx + (int)((float)this.w * this.scaling)), (double)this.yy));
            background.getElements().add((Object)new LineTo((double)this.xx, (double)this.yy));
            background.setFill((Paint)new Color((double)((float)this.backgroundColor.getRed() / 255.0f), (double)((float)this.backgroundColor.getGreen() / 255.0f), (double)((float)this.backgroundColor.getBlue() / 255.0f), 1.0));
            this.addToScene((Node)background);
        }
    }
}

