/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JOptionPane;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.GUIDisplay;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class SwingDisplay
extends GUIDisplay {
    boolean ignoreHighlight;
    float lastStrokeOpacity;
    float lastFillOpacity;
    private boolean noRepaint;
    private int lastItemPainted;
    private boolean optimsePainting;
    private int pageX1;
    private int pageX2;
    private int pageY1;
    private int pageY2;
    private BufferedImage singleImage;
    private int imageCount;
    private static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private final Map cachedWidths;
    private final Map cachedHeights;
    private Map fonts;
    private Set<String> fontsUsed;
    protected GlyphFactory factory;
    private Map imageID;
    private Map storedImageValues;
    private int[] textHighlightsX;
    boolean stopG2setting;
    float[] x_coord;
    float[] y_coord;
    private Map largeImages;
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    Vector_Int shapeType;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private Vector_Int BMvalues;
    int lastFillTextCol;
    int lastFillCol;
    int lastStrokeCol;
    Stroke lastStroke;
    private double[] lastAf;
    private int lastTR;
    private int lastFS;
    private int lastLW;
    boolean resetTextColors;
    boolean fillSet;
    boolean strokeSet;
    private boolean needsHighlights;
    private int paintThreadCount;
    private int paintThreadID;
    private boolean[] drawnHighlights;
    private boolean hasOCR;
    protected int type;
    private boolean renderFailed;
    private Container frame;
    private static boolean userAlerted;
    private Rectangle[] objectAreas;

    public SwingDisplay() {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.currentItem = 0;
    }

    void setupArrays(int defaultSize) {
        this.x_coord = new float[defaultSize];
        this.y_coord = new float[defaultSize];
        this.text_color = new Vector_Object(defaultSize);
        this.textFillType = new Vector_Int(defaultSize);
        this.stroke_color = new Vector_Object(defaultSize);
        this.fill_color = new Vector_Object(defaultSize);
        this.stroke = new Vector_Object(defaultSize);
        this.pageObjects = new Vector_Object(defaultSize);
        this.javaObjects = new Vector_Object(defaultSize);
        this.shapeType = new Vector_Int(defaultSize);
        this.areas = new Vector_Rectangle_Int(defaultSize);
        this.af1 = new Vector_Double(defaultSize);
        this.af2 = new Vector_Double(defaultSize);
        this.af3 = new Vector_Double(defaultSize);
        this.af4 = new Vector_Double(defaultSize);
        this.fontBounds = new Vector_Rectangle(defaultSize);
        this.clips = new Vector_Shape(defaultSize);
        this.objectType = new Vector_Int(defaultSize);
        this.opacity = new Vector_Float(defaultSize);
        this.currentItem = 0;
    }

    public SwingDisplay(int pageNumber, boolean addBackground, int defaultSize, ObjectStore newObjectRef) {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.addBackground = addBackground;
        this.setupArrays(defaultSize);
    }

    public SwingDisplay(int pageNumber, ObjectStore newObjectRef, boolean isPrinting) {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.rawPageNumber = pageNumber;
        this.objectStoreRef = newObjectRef;
        this.isPrinting = isPrinting;
        this.setupArrays(5000);
    }

    @Override
    public void setOptimsePainting(boolean optimsePainting) {
        this.optimsePainting = optimsePainting;
        this.lastItemPainted = -1;
    }

    private void renderHighlight(Rectangle highlight, Graphics2D g2) {
        if (highlight != null && !this.ignoreHighlight) {
            Shape currentClip = g2.getClip();
            g2.setClip(null);
            Composite comp = g2.getComposite();
            Paint p = g2.getPaint();
            g2.setComposite(AlphaComposite.getInstance(3, DecoderOptions.highlightComposite));
            if (invertHighlight) {
                g2.setColor(Color.WHITE);
                g2.setXORMode(Color.BLACK);
            } else {
                g2.setPaint(DecoderOptions.highlightColor);
            }
            g2.fill(highlight);
            g2.setComposite(comp);
            g2.setPaint(p);
            this.needsHighlights = false;
            g2.setClip(currentClip);
        }
    }

    @Override
    public void stopG2HintSetting(boolean isSet) {
        this.stopG2setting = isSet;
    }

    @Override
    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        this.objectAreas = null;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.javaObjects.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.BMvalues != null) {
                this.BMvalues.clear();
            }
            this.lastStrokeOpacity = -1.0f;
            this.lastFillOpacity = -1.0f;
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    @Override
    public void dispose() {
        this.singleImage = null;
        this.shapeType = null;
        this.pageObjects = null;
        this.objectType = null;
        this.areas = null;
        this.clips = null;
        this.x_coord = null;
        this.y_coord = null;
        this.textFillType = null;
        this.text_color = null;
        this.fill_color = null;
        this.stroke_color = null;
        this.stroke = null;
        this.TRvalues = null;
        this.fs = null;
        this.lw = null;
        this.af1 = null;
        this.af2 = null;
        this.af3 = null;
        this.af4 = null;
        this.fontBounds = null;
        this.opacity = null;
        this.BMvalues = null;
        this.largeImages = null;
        this.lastClip = null;
        this.lastStroke = null;
        this.lastAf = null;
        this.fonts = null;
        this.fontsUsed = null;
        this.imageID = null;
        this.storedImageValues = null;
    }

    @Override
    public void paint(Rectangle[] highlights, AffineTransform viewScaling, Rectangle userAnnot) {
        int h;
        Vector_Rectangle ocr_highlights = null;
        HashSet<String> ocr_used = null;
        if (this.hasOCR) {
            ocr_highlights = new Vector_Rectangle(4000);
            ocr_used = new HashSet<String>(10);
        }
        int currentThreadID = ++this.paintThreadID;
        ++this.paintThreadCount;
        if (highlights != null) {
            this.drawnHighlights = new boolean[highlights.length];
            for (int i = 0; i != this.drawnHighlights.length; ++i) {
                this.drawnHighlights[i] = false;
            }
        }
        if (this.paintThreadCount > 1) {
            block106: {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    if (!LogWriter.isOutput()) break block106;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return;
            }
        }
        boolean debug = false;
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        float d = 0.0f;
        Rectangle dirtyRegion = null;
        int[] objectTypes = this.objectType.get();
        int[] textFill = this.textFillType.get();
        int count = this.currentItem;
        Area[] pageClips = this.clips.get();
        double[] afValues1 = this.af1.get();
        int[] fsValues = null;
        if (this.fs != null) {
            fsValues = this.fs.get();
        }
        int[] lwValues = null;
        if (this.lw != null) {
            lwValues = this.lw.get();
        }
        double[] afValues2 = this.af2.get();
        double[] afValues3 = this.af3.get();
        double[] afValues4 = this.af4.get();
        Object[] text_color = this.text_color.get();
        Object[] fill_color = this.fill_color.get();
        Object[] stroke_color = this.stroke_color.get();
        Object[] pageObjects = this.pageObjects.get();
        Object[] javaObjects = this.javaObjects.get();
        Object[] stroke = this.stroke.get();
        int[] fillType = this.shapeType.get();
        float[] opacity = null;
        if (this.opacity != null) {
            opacity = this.opacity.get();
        }
        int[] BMvalues = null;
        if (this.BMvalues != null) {
            BMvalues = this.BMvalues.get();
        }
        int[] TRvalues = null;
        if (this.TRvalues != null) {
            TRvalues = this.TRvalues.get();
        }
        int[][] areas = null;
        if (this.areas != null) {
            areas = this.areas.get();
        }
        boolean isInitialised = false;
        Shape defaultClip = null;
        if (this.g2 != null) {
            Shape rawClip = this.g2.getClip();
            if (rawClip != null) {
                dirtyRegion = rawClip.getBounds();
            }
            defaultClip = this.g2.getClip();
        }
        Area clipToUse = null;
        boolean newClip = false;
        if (this.noRepaint) {
            this.noRepaint = false;
        } else if (this.lastItemPainted == -1) {
            this.paintBackground(dirtyRegion);
        }
        AffineTransform rawScaling = null;
        if (this.g2 != null) {
            rawScaling = this.g2.getTransform();
            if (viewScaling != null) {
                this.g2.transform(viewScaling);
                defaultClip = this.g2.getClip();
            }
        }
        int currentTR = 2;
        int lineWidth = 0;
        float fillOpacity = 1.0f;
        float strokeOpacity = 1.0f;
        int iCount = 0;
        int cCount = 0;
        int sCount = 0;
        int fsCount = -1;
        int lwCount = 0;
        int afCount = -1;
        int tCount = 0;
        int stCount = 0;
        int fillCount = 0;
        int strokeCount = 0;
        int trCount = 0;
        int opCount = 0;
        int BMCount = 0;
        int stringCount = 0;
        PdfPaint textStrokeCol = null;
        PdfPaint textFillCol = null;
        PdfPaint fillCol = null;
        PdfPaint strokeCol = null;
        Stroke currentStroke = null;
        if (this.colorsLocked) {
            strokeCol = this.strokeCol;
            fillCol = this.fillCol;
        }
        block38: for (int i = 0; i < count; ++i) {
            int imageUsed;
            itemToRender = i;
            int type = objectTypes[i];
            if (type == 27) continue;
            Rectangle currentArea = null;
            if (currentThreadID != this.paintThreadID) {
                --this.paintThreadCount;
                return;
            }
            if (type <= 0) continue;
            float x = this.x_coord[i];
            float y = this.y_coord[i];
            Object currentObject = pageObjects[i];
            if (type == 29) {
                type = 3;
                imageUsed = (Integer)currentObject;
                currentObject = pageObjects[imageUsed];
            } else {
                imageUsed = -1;
            }
            if (currentArea == null) {
                currentArea = this.getObjectArea(afValues1, fsValues, afValues2, afValues3, afValues4, pageObjects, areas, type, x, y, fsCount, afCount, i);
            }
            boolean ignoreItem = false;
            if (currentArea != null && type < 7 && userAnnot != null && !userAnnot.intersects(currentArea) && currentArea.width > 0) {
                ignoreItem = true;
            }
            if (ignoreItem || this.lastItemPainted != -1 && i < this.lastItemPainted) {
                switch (type) {
                    case 2: {
                        ++sCount;
                        break;
                    }
                    case 3: {
                        ++iCount;
                        break;
                    }
                    case 29: {
                        ++iCount;
                        break;
                    }
                    case 7: {
                        ++cCount;
                        break;
                    }
                    case 21: {
                        ++fsCount;
                        break;
                    }
                    case 22: {
                        ++lwCount;
                        break;
                    }
                    case 10: {
                        ++tCount;
                        break;
                    }
                    case 11: {
                        ++fillCount;
                        break;
                    }
                    case 12: {
                        ++strokeCount;
                        break;
                    }
                    case 14: {
                        ++stCount;
                        break;
                    }
                    case 15: {
                        ++trCount;
                    }
                }
                continue;
            }
            if (!isInitialised && !this.stopG2setting && this.g2 != null) {
                if (userHints != null) {
                    this.g2.setRenderingHints(userHints);
                } else {
                    this.g2.setRenderingHints(hints);
                }
                isInitialised = true;
            }
            if (currentTR == 4) {
                this.needsHighlights = true;
            }
            Rectangle highlight = null;
            switch (type) {
                case 2: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    this.paintShape(fillType[sCount], defaultClip, currentObject, fillOpacity, strokeOpacity, fillCol, strokeCol, currentStroke, i);
                    ++sCount;
                    continue block38;
                }
                case 1: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    this.paintText(highlights, ocr_highlights, ocr_used, afValues1, afValues2, afValues3, afValues4, (Area)currentObject, currentTR, fillOpacity, strokeOpacity, x, y, afCount, textStrokeCol, textFillCol, currentArea, highlight);
                    continue block38;
                }
                case 4: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    this.paintTrueType(highlights, ocr_highlights, ocr_used, afValues1, afValues2, afValues3, afValues4, currentObject, currentTR, lineWidth, fillOpacity, strokeOpacity, x, y, afCount, textStrokeCol, textFillCol, currentArea, highlight);
                    continue block38;
                }
                case 5: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.contains(key = highlight.x + " " + highlight.y)) {
                        ocr_used.add(key);
                        ocr_highlights.addElement(highlight);
                    }
                    this.renderEmbeddedText(currentTR, currentObject, 5, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
                    continue block38;
                }
                case 6: {
                    String key;
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
                    if (!invertHighlight) {
                        highlight = this.setHighlightForGlyph(currentArea, highlights);
                    }
                    if (this.hasOCR && highlight != null && ocr_used.contains(key = highlight.x + " " + highlight.y)) {
                        ocr_used.add(key);
                        ocr_highlights.addElement(highlight);
                    }
                    this.renderEmbeddedText(currentTR, currentObject, 6, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
                    continue block38;
                }
                case 3: {
                    if (newClip) {
                        RenderUtils.renderClip(clipToUse, dirtyRegion, defaultClip, this.g2);
                        newClip = false;
                    }
                    this.renderImage(afValues1, afValues2, afValues3, afValues4, pageObjects, currentObject, fillOpacity, x, y, iCount, afCount, imageUsed, i);
                    ++iCount;
                    continue block38;
                }
                case 7: {
                    clipToUse = pageClips[cCount];
                    newClip = true;
                    ++cCount;
                    continue block38;
                }
                case 9: {
                    ++afCount;
                    continue block38;
                }
                case 21: {
                    ++fsCount;
                    continue block38;
                }
                case 22: {
                    lineWidth = lwValues[lwCount];
                    ++lwCount;
                    continue block38;
                }
                case 10: {
                    int textFillType = textFill[tCount];
                    if (textFillType == 1) {
                        textStrokeCol = (PdfPaint)text_color[tCount];
                    } else {
                        textFillCol = (PdfPaint)text_color[tCount];
                    }
                    ++tCount;
                    continue block38;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        fillCol = (PdfPaint)fill_color[fillCount];
                    }
                    ++fillCount;
                    continue block38;
                }
                case 12: {
                    if (!this.colorsLocked && (strokeCol = (PdfPaint)stroke_color[strokeCount]) != null) {
                        strokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    ++strokeCount;
                    continue block38;
                }
                case 14: {
                    currentStroke = (Stroke)stroke[stCount];
                    ++stCount;
                    continue block38;
                }
                case 15: {
                    currentTR = TRvalues[trCount];
                    ++trCount;
                    continue block38;
                }
                case 17: {
                    strokeOpacity = opacity[opCount];
                    ++opCount;
                    continue block38;
                }
                case 31: {
                    this.blendMode = BMvalues[BMCount];
                    ++BMCount;
                    continue block38;
                }
                case 18: {
                    fillOpacity = opacity[opCount];
                    ++opCount;
                    continue block38;
                }
                case 16: {
                    Shape s1 = this.g2.getClip();
                    this.g2.setClip(defaultClip);
                    AffineTransform defaultAf = this.g2.getTransform();
                    String displayValue = (String)currentObject;
                    double[] af = new double[6];
                    this.g2.getTransform().getMatrix(af);
                    if (super.getMode() != DynamicVectorRenderer.Mode.XFA) {
                        if (af[2] != 0.0) {
                            af[2] = -af[2];
                        }
                        if (af[3] != 0.0) {
                            af[3] = -af[3];
                        }
                    }
                    this.g2.setTransform(new AffineTransform(af));
                    Font javaFont = (Font)javaObjects[stringCount];
                    this.g2.setFont(javaFont);
                    if ((currentTR & 2) == 2) {
                        if (textFillCol != null) {
                            textFillCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
                        } else if (DecoderOptions.Helper != null) {
                            DecoderOptions.Helper.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(textFillCol);
                        }
                    }
                    if ((currentTR & 1) == 1) {
                        if (textStrokeCol != null) {
                            textStrokeCol.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
                        } else if (DecoderOptions.Helper != null) {
                            DecoderOptions.Helper.setPaint(this.g2, textFillCol, this.rawPageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(textFillCol);
                        }
                    }
                    this.g2.drawString(displayValue, x, y);
                    this.g2.setTransform(defaultAf);
                    this.g2.setClip(s1);
                    ++stringCount;
                    continue block38;
                }
                case 23: {
                    Shape s2 = this.g2.getClip();
                    this.g2.setClip(defaultClip);
                    AffineTransform af2 = this.g2.getTransform();
                    JPedalCustomDrawObject customObj = (JPedalCustomDrawObject)currentObject;
                    if (this.isPrinting) {
                        customObj.print(this.g2, this.rawPageNumber);
                    } else {
                        customObj.paint(this.g2);
                    }
                    this.g2.setTransform(af2);
                    this.g2.setClip(s2);
                }
            }
        }
        itemToRender = -1;
        if (highlights != null) {
            for (h = 0; h != highlights.length; ++h) {
                this.renderHighlight(highlights[h], this.g2);
            }
        }
        if (this.needsHighlights && highlights != null) {
            for (h = 0; h != highlights.length; ++h) {
                this.ignoreHighlight = false;
                this.renderHighlight(highlights[h], this.g2);
            }
        }
        if (ocr_highlights != null) {
            SwingDisplay.paintOCRHighlights(ocr_highlights, this.g2);
        }
        if (this.g2 != null) {
            this.g2.setClip(defaultClip);
            this.g2.setTransform(rawScaling);
        }
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (DecoderOptions.showErrorMessages) {
                String status = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, status);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        --this.paintThreadCount;
        this.lastItemPainted = this.optimsePainting ? count : -1;
        this.lastScaling = this.scaling;
    }

    private void paintTrueType(Rectangle[] highlights, Vector_Rectangle ocr_highlights, Set<String> ocr_used, double[] afValues1, double[] afValues2, double[] afValues3, double[] afValues4, Object currentObject, int currentTR, int lineWidth, float fillOpacity, float strokeOpacity, float x, float y, int afCount, PdfPaint textStrokeCol, PdfPaint textFillCol, Rectangle currentArea, Rectangle highlight) {
        if (afCount != -1) {
            String key;
            AffineTransform aff = new AffineTransform(afValues1[afCount], afValues2[afCount], afValues3[afCount], afValues4[afCount], (double)x, (double)y);
            if (!invertHighlight) {
                highlight = this.setHighlightForGlyph(currentArea, highlights);
            }
            if (this.hasOCR && highlight != null && ocr_used.contains(key = highlight.x + " " + highlight.y)) {
                ocr_used.add(key);
                ocr_highlights.addElement(highlight);
            }
            this.renderEmbeddedText(currentTR, currentObject, 4, aff, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity, lineWidth);
        }
    }

    private void paintShape(int fillType, Shape defaultClip, Object currentObject, float fillOpacity, float strokeOpacity, PdfPaint fillCol, PdfPaint strokeCol, Stroke currentStroke, int i) {
        Shape s = null;
        if (endItem != -1 && endItem < i) {
            s = this.g2.getClip();
            this.g2.setClip(defaultClip);
        }
        this.renderShape(defaultClip, fillType, strokeCol, fillCol, currentStroke, (Shape)currentObject, strokeOpacity, fillOpacity);
        if (endItem != -1 && endItem < i) {
            this.g2.setClip(s);
        }
    }

    private void paintText(Rectangle[] highlights, Vector_Rectangle ocr_highlights, Set<String> ocr_used, double[] afValues1, double[] afValues2, double[] afValues3, double[] afValues4, Area currentObject, int currentTR, float fillOpacity, float strokeOpacity, float x, float y, int afCount, PdfPaint textStrokeCol, PdfPaint textFillCol, Rectangle currentArea, Rectangle highlight) {
        String key;
        if (!invertHighlight) {
            highlight = this.setHighlightForGlyph(currentArea, highlights);
        }
        if (this.hasOCR && highlight != null && ocr_used.contains(key = highlight.x + " " + highlight.y)) {
            ocr_used.add(key);
            ocr_highlights.addElement(highlight);
        }
        AffineTransform def = this.g2.getTransform();
        if (afCount != -1) {
            this.g2.transform(new AffineTransform(afValues1[afCount], afValues2[afCount], -afValues3[afCount], -afValues4[afCount], (double)x, (double)y));
            this.renderText(x, y, currentTR, currentObject, highlight, textStrokeCol, textFillCol, strokeOpacity, fillOpacity);
            this.g2.setTransform(def);
        }
    }

    static void paintOCRHighlights(Vector_Rectangle ocr_highlights, Graphics2D g2) {
        Rectangle[] highlights2 = ocr_highlights.get();
        Composite comp = g2.getComposite();
        Paint p = g2.getPaint();
        for (int h = 0; h != highlights2.length; ++h) {
            if (highlights2[h] != null) {
                g2.setComposite(AlphaComposite.getInstance(3, DecoderOptions.highlightComposite));
                g2.setPaint(DecoderOptions.highlightColor);
                g2.fill(highlights2[h]);
            }
            g2.setComposite(comp);
            g2.setPaint(p);
        }
    }

    private Rectangle getObjectArea(double[] afValues1, int[] fsValues, double[] afValues2, double[] afValues3, double[] afValues4, Object[] pageObjects, int[][] rectParams, int type, float x, float y, int fsCount, int afCount, int i) {
        Rectangle currentArea = null;
        if (this.objectAreas == null || this.objectAreas.length != rectParams.length) {
            this.objectAreas = new Rectangle[rectParams.length];
            for (int r = 0; r < this.objectAreas.length; ++r) {
                if (this.objectAreas[r] == null) continue;
                this.objectAreas[r] = new Rectangle(rectParams[r][0], rectParams[r][1], rectParams[r][2], rectParams[r][3]);
            }
        }
        if (afValues1 != null && type == 3) {
            if (this.objectAreas != null) {
                currentArea = this.objectAreas[i];
            }
        } else if (afValues1 != null && type == 2) {
            currentArea = ((Shape)pageObjects[i]).getBounds();
        } else if (type == 1 && afCount > -1) {
            currentArea = RenderUtils.getAreaForGlyph(new float[][]{{(float)afValues1[afCount], (float)afValues2[afCount], 0.0f}, {(float)afValues3[afCount], (float)afValues4[afCount], 0.0f}, {x, y, 1.0f}});
        } else if (fsCount != -1 && afValues1 != null) {
            int realSize = fsValues[fsCount];
            currentArea = realSize < 0 ? new Rectangle((int)x + realSize, (int)y, -realSize, -realSize) : new Rectangle((int)x, (int)y, realSize, realSize);
        }
        return currentArea;
    }

    private void renderImage(double[] afValues1, double[] afValues2, double[] afValues3, double[] afValues4, Object[] pageObjects, Object currentObject, float fillOpacity, float x, float y, int iCount, int afCount, int imageUsed, int i) {
        int sampling = 1;
        int w1 = 0;
        int pY = 0;
        int defaultSampling = 1;
        String key = Integer.toString(this.rawPageNumber) + Integer.toString(iCount);
        if (this.useHiResImageForDisplay && !this.isType3Font && this.objectStoreRef.isRawImageDataSaved(key)) {
            float scalingToUse = this.scaling;
            if (this.useHiResImageForDisplay && this.scaling < 1.0f) {
                scalingToUse = 1.0f;
            }
            int defaultX = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_pX);
            int pX = (int)((float)defaultX * scalingToUse);
            int defaultY = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_pY);
            pY = (int)((float)defaultY * scalingToUse);
            w1 = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_WIDTH);
            int h1 = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_HEIGHT);
            byte[] maskCol = (byte[])this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_MASKCOL);
            int colorspaceID = (Integer)this.objectStoreRef.getRawImageDataParameter(key, ObjectStore.IMAGE_COLORSPACE);
            BufferedImage image = null;
            if (pX > 0) {
                int defscaleY;
                int scaleY;
                int newH;
                int newW = w1;
                int smallestH = pY << 2;
                int smallestW = pX << 2;
                for (newH = h1; newW > smallestW && newH > smallestH; newW >>= 1, newH >>= 1) {
                    sampling <<= 1;
                }
                int scaleX = w1 / pX;
                if (scaleX < 1) {
                    scaleX = 1;
                }
                if ((scaleY = h1 / pY) < 1) {
                    scaleY = 1;
                }
                if ((sampling = scaleX) > scaleY) {
                    sampling = scaleY;
                }
                int defnewW = w1;
                int defsmallestH = pY << 2;
                int defsmallestW = pX << 2;
                for (int defnewH = h1; defnewW > defsmallestW && defnewH > defsmallestH; defnewW >>= 1, defnewH >>= 1) {
                    defaultSampling <<= 1;
                }
                int defscaleX = w1 / defaultX;
                if (defscaleX < 1) {
                    defscaleX = 1;
                }
                if ((defscaleY = h1 / defaultY) < 1) {
                    defscaleY = 1;
                }
                if ((defaultSampling = defscaleX) > defscaleY) {
                    defaultSampling = defscaleY;
                }
                if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && sampling >= 1 && this.lastScaling != this.scaling) {
                    newW = w1 / sampling;
                    newH = h1 / sampling;
                    image = this.resampleImageData(sampling, w1, h1, maskCol, newW, newH, key, colorspaceID);
                }
            }
            if (image != null) {
                if (this.singleImage != null) {
                    this.singleImage = image;
                }
                pageObjects[i] = image;
                currentObject = image;
            }
        }
        if (this.useHiResImageForDisplay) {
            double aa = 1.0;
            if (sampling >= 1 && this.scaling > 1.0f && w1 > 0) {
                aa = (float)sampling / (float)defaultSampling;
            }
            AffineTransform imageAf = new AffineTransform(afValues1[afCount] * aa, afValues2[afCount] * aa, afValues3[afCount] * aa, afValues4[afCount] * aa, (double)x, (double)y);
            BufferedImage img = null;
            if (currentObject != null) {
                img = (BufferedImage)currentObject;
            }
            if (currentObject == null) {
                img = this.reloadCachedImage(imageUsed, i, img);
            }
            if (img != null) {
                this.renderImage(imageAf, img, fillOpacity, null, x, y);
            }
        } else {
            AffineTransform before = this.g2.getTransform();
            if (pY > 0) {
                double ratio;
                double[] matrix = new double[6];
                this.g2.getTransform().getMatrix(matrix);
                matrix[0] = ratio = (double)((float)pY / (float)((BufferedImage)currentObject).getHeight());
                matrix[1] = 0.0;
                matrix[2] = 0.0;
                matrix[3] = -ratio;
                this.g2.scale(1.0f / this.scaling, 1.0f / this.scaling);
                this.g2.setTransform(new AffineTransform(matrix));
            }
            this.renderImage(null, (BufferedImage)currentObject, fillOpacity, null, x, y);
            this.g2.setTransform(before);
        }
    }

    private BufferedImage resampleImageData(int sampling, int w1, int h1, byte[] maskCol, int newW, int newH, String key, int ID2) {
        byte[] data = this.objectStoreRef.getRawImageData(key);
        byte[] index = null;
        if (maskCol != null && ID2 != 1785221209) {
            index = maskCol;
        }
        int size = newW * newH;
        if (index != null) {
            size *= 3;
        }
        byte[] newData = new byte[size];
        int[] flag = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int origLineLength = w1 + 7 >> 3;
        int offset = 0;
        for (int y1 = 0; y1 < newH; ++y1) {
            for (int x1 = 0; x1 < newW; ++x1) {
                int ii;
                int bytes = 0;
                int count1 = 0;
                int wCount = sampling;
                int hCount = sampling;
                int wGapLeft = w1 - x1;
                int hGapLeft = h1 - y1;
                if (wCount > wGapLeft) {
                    wCount = wGapLeft;
                }
                if (hCount > hGapLeft) {
                    hCount = hGapLeft;
                }
                for (int yy = 0; yy < hCount; ++yy) {
                    for (int xx = 0; xx < wCount; ++xx) {
                        int ptr = (yy + y1 * sampling) * origLineLength + (x1 * sampling + xx >> 3);
                        int currentByte = ptr < data.length ? data[ptr] : -1;
                        int bit = currentByte & flag[7 - (x1 * sampling + xx & 7)];
                        if (bit != 0) {
                            ++bytes;
                        }
                        ++count1;
                    }
                }
                if (count1 > 0) {
                    if (index == null) {
                        newData[x1 + newW * y1] = (byte)(255 * bytes / count1);
                        continue;
                    }
                    for (ii = 0; ii < 3; ++ii) {
                        newData[offset] = (float)(bytes / count1) < 0.5f ? (int)(maskCol[ii] & 0xFF) : -1;
                        ++offset;
                    }
                    continue;
                }
                if (index == null) {
                    newData[x1 + newW * y1] = -1;
                    continue;
                }
                for (ii = 0; ii < 3; ++ii) {
                    newData[offset] = -1;
                    ++offset;
                }
            }
        }
        int type = 10;
        DataBufferByte db = new DataBufferByte(newData, newData.length);
        int[] bands = new int[]{0};
        int count = 1;
        if (maskCol == null && w1 * h1 * 3 == data.length) {
            type = 1;
            bands = new int[]{0, 1, 2};
            count = 3;
        }
        BufferedImage image = new BufferedImage(newW, newH, type);
        WritableRaster raster = Raster.createInterleavedRaster(db, newW, newH, newW * count, count, bands, null);
        image.setData(raster);
        return image;
    }

    private BufferedImage reloadCachedImage(int imageUsed, int i, BufferedImage img) {
        block8: {
            try {
                BufferedImage currentObject = this.singleImage != null ? this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight()) : (this.rawKey == null ? this.largeImages.get("HIRES_" + i) : this.largeImages.get("HIRES_" + i + '_' + this.rawKey));
                if (currentObject == null) {
                    int keyID = i;
                    if (imageUsed != -1) {
                        keyID = imageUsed;
                    }
                    if ((currentObject = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + keyID) : this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + keyID + '_' + this.rawKey)) == null) {
                        this.renderFailed = true;
                    }
                    if (!this.isPrinting) {
                        if (this.rawKey == null) {
                            this.largeImages.put("HIRES_" + i, currentObject);
                        } else {
                            this.largeImages.put("HIRES_" + i, currentObject + "_" + this.rawKey);
                        }
                    }
                }
                img = currentObject;
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return img;
    }

    @Override
    public void setMessageFrame(Container frame) {
        this.frame = frame;
    }

    private Rectangle setHighlightForGlyph(Rectangle area, Rectangle[] highlights) {
        if (highlights == null || this.textHighlightsX == null) {
            return null;
        }
        this.ignoreHighlight = false;
        for (int j = 0; j != highlights.length; ++j) {
            if (highlights[j] == null || area == null || !highlights[j].intersects(area)) continue;
            Rectangle intersection = highlights[j].intersection(area);
            float iArea = intersection.width * intersection.height;
            float tArea = (float)(area.width * area.height) / 4.0f;
            if (!(highlights[j].contains(area.x, area.y) && iArea > tArea) && !(iArea > (float)(area.width * area.height) / 1.667f)) continue;
            if (!this.drawnHighlights[j]) {
                this.ignoreHighlight = false;
                this.drawnHighlights[j] = true;
                return highlights[j];
            }
            this.ignoreHighlight = true;
            return highlights[j];
        }
        return null;
    }

    @Override
    public void drawText(float[][] Trm, String text, GraphicsState currentGraphicsState, float x, float y, Font javaFont) {
        int newCol;
        PdfPaint currentCol;
        int text_fill_type;
        double[] nextAf;
        if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
        }
        if (((text_fill_type = currentGraphicsState.getTextRenderType()) & 2) == 2) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.pageObjects.addElement(text);
        this.javaObjects.addElement(javaFont);
        this.objectType.addElement(16);
        int fontSize = javaFont.getSize();
        int[] rectParams = new int[]{(int)x, (int)y, fontSize, fontSize};
        if (fontSize > 100) {
            this.areas.addElement(rectParams);
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    @Override
    public int drawImage(int pageNumber, BufferedImage image, GraphicsState currentGraphicsState, boolean alreadyCached, String name, int previousUse) {
        if (previousUse != -1) {
            return this.redrawImage(pageNumber, currentGraphicsState, name, previousUse);
        }
        this.rawPageNumber = pageNumber;
        float[][] CTM = currentGraphicsState.CTM;
        float x = currentGraphicsState.x;
        float y = currentGraphicsState.y;
        double[] nextAf = new double[6];
        boolean cacheInMemory = image.getWidth() < 100 && image.getHeight() < 100 || image.getHeight() == 1;
        String key = this.rawKey == null ? pageNumber + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        AffineTransform upside_down = new AffineTransform(CTM[0][0], CTM[0][1], CTM[1][0], CTM[1][1], 0.0f, 0.0f);
        upside_down.getMatrix(nextAf);
        this.drawAffine(nextAf);
        if (this.useHiResImageForDisplay) {
            int h;
            int w;
            if (!alreadyCached || this.cachedWidths.get(key) == null) {
                w = image.getWidth();
                h = image.getHeight();
            } else {
                w = (Integer)this.cachedWidths.get(key);
                h = (Integer)this.cachedHeights.get(key);
            }
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
            if (!alreadyCached && !cacheInMemory) {
                if (!this.isPrinting) {
                    if (this.rawKey == null) {
                        this.largeImages.put("HIRES_" + this.currentItem, image);
                    } else {
                        this.largeImages.put("HIRES_" + this.currentItem + '_' + this.rawKey, image);
                    }
                    if (this.imageCount == 0) {
                        this.singleImage = image.getSubimage(0, 0, image.getWidth(), image.getHeight());
                        ++this.imageCount;
                    } else {
                        this.singleImage = null;
                    }
                }
                if (this.rawKey == null) {
                    this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem, image, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem);
                } else {
                    this.objectStoreRef.saveStoredImage(pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey, image, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + this.currentItem + '_' + this.rawKey);
                }
                key = this.rawKey == null ? pageNumber + "_" + this.currentItem : this.rawKey + '_' + this.currentItem;
                this.cachedWidths.put(key, w);
                this.cachedHeights.put(key, h);
            }
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        this.objectType.addElement(3);
        float WidthModifier = 1.0f;
        float HeightModifier = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!alreadyCached) {
                WidthModifier = image.getWidth();
                HeightModifier = image.getHeight();
            } else {
                WidthModifier = ((Integer)this.cachedWidths.get(key)).intValue();
                HeightModifier = ((Integer)this.cachedHeights.get(key)).intValue();
            }
        }
        if (CTM[0][0] > 0.0f && (double)CTM[0][0] < 0.05 && CTM[0][1] != 0.0f && CTM[1][0] != 0.0f && CTM[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            this.w = (int)(CTM[0][0] * WidthModifier);
            if (this.w == 0) {
                this.w = (int)(CTM[0][1] * WidthModifier);
            }
            this.h = (int)(CTM[1][1] * HeightModifier);
            if (this.h == 0) {
                this.h = (int)(CTM[1][0] * HeightModifier);
            }
            if (!this.useHiResImageForDisplay && CTM[1][0] < 0.0f && CTM[0][1] > 0.0f && CTM[0][0] == 0.0f && CTM[1][1] == 0.0f) {
                int tmp = this.w;
                this.w = -this.h;
                this.h = tmp;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            int x1 = (int)currentGraphicsState.x;
            int y1 = (int)currentGraphicsState.y;
            int w1 = this.w;
            int h1 = this.h;
            if (h1 < 0) {
                y1 += h1;
                h1 = -h1;
            }
            if (h1 == 0) {
                h1 = 1;
            }
            int[] rectParams = new int[]{x1, y1, w1, h1};
            this.areas.addElement(rectParams);
            this.checkWidth(rectParams);
        }
        if (this.useHiResImageForDisplay && !cacheInMemory) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(image);
        }
        this.imageID.put(name, this.currentItem);
        this.storedImageValues.put("imageAff-" + this.currentItem, nextAf);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private int redrawImage(int pageNumber, GraphicsState currentGraphicsState, String name, int previousUse) {
        this.rawPageNumber = pageNumber;
        float x = currentGraphicsState.x;
        float y = currentGraphicsState.y;
        if (this.useHiResImageForDisplay) {
            double[] nextAf = (double[])this.storedImageValues.get("imageAff-" + previousUse);
            this.drawAffine(nextAf);
            this.lastAf[0] = nextAf[0];
            this.lastAf[1] = nextAf[1];
            this.lastAf[2] = nextAf[2];
            this.lastAf[3] = nextAf[3];
            if (this.rawKey == null && this.imageIDtoName.containsKey(previousUse)) {
                this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + previousUse);
            } else {
                this.imageIDtoName.put(this.currentItem, pageNumber + "_HIRES_" + previousUse + '_' + this.rawKey);
            }
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = x;
        this.y_coord[this.currentItem] = y;
        this.objectType.addElement(29);
        int[] previousRectangle = this.areas.elementAt(previousUse);
        int[] newRect = null;
        if (previousRectangle != null) {
            newRect = new int[]{(int)x, (int)y, previousRectangle[2], previousRectangle[3]};
        }
        this.areas.addElement(newRect);
        if (previousRectangle != null) {
            this.checkWidth(newRect);
        }
        this.pageObjects.addElement(previousUse);
        this.imageID.put(name, previousUse);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private void checkWidth(int[] rect) {
        int x1 = rect[0];
        int y2 = rect[1];
        int y1 = y2 + rect[3];
        int x2 = x1 + rect[2];
        if (x1 < this.pageX1) {
            this.pageX1 = x1;
        }
        if (x2 > this.pageX2) {
            this.pageX2 = x2;
        }
        if (y1 > this.pageY1) {
            this.pageY1 = y1;
        }
        if (y2 < this.pageY2) {
            this.pageY2 = y2;
        }
    }

    @Override
    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    @Override
    public void drawShape(Shape currentShape, GraphicsState currentGraphicsState, int cmd) {
        int newCol;
        PdfPaint currentCol;
        int fillType = currentGraphicsState.getFillType();
        if (currentShape.getBounds().getWidth() == 1.0 && currentShape.getBounds().getHeight() == 1.0 && currentGraphicsState.getLineWidth() < 1.0f) {
            currentShape = new Rectangle(currentShape.getBounds().x, currentShape.getBounds().y, 1, 1);
        }
        if (fillType == 2 || fillType == 3) {
            currentCol = currentGraphicsState.getNonstrokeColor();
            if (currentCol == null) {
                currentCol = new PdfColor(0, 0, 0);
            }
            if (currentCol.isPattern()) {
                this.drawFillColor(currentCol);
                this.fillSet = true;
            } else {
                newCol = currentCol.getRGB();
                if (!this.fillSet || this.lastFillCol != newCol) {
                    this.lastFillCol = newCol;
                    this.drawFillColor(currentCol);
                    this.fillSet = true;
                }
            }
        }
        if (fillType == 1 || fillType == 3) {
            currentCol = currentGraphicsState.getStrokeColor();
            if (currentCol instanceof Color) {
                newCol = currentCol.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != newCol) {
                    this.lastStrokeCol = newCol;
                    this.drawStrokeColor(currentCol);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(currentCol);
                this.strokeSet = true;
            }
        }
        Stroke newStroke = currentGraphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(newStroke)) {
            if (((BasicStroke)newStroke).getLineWidth() < 1.0f && !(this instanceof T3Display)) {
                newStroke = new BasicStroke(1.0f);
            }
            this.lastStroke = newStroke;
            this.drawStroke(newStroke);
        }
        this.pageObjects.addElement(currentShape);
        this.objectType.addElement(2);
        int[] shapeParams = new int[]{currentShape.getBounds().x, currentShape.getBounds().y, currentShape.getBounds().width, currentShape.getBounds().height};
        this.areas.addElement(shapeParams);
        this.checkWidth(shapeParams);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = currentGraphicsState.x;
        this.y_coord[this.currentItem] = currentGraphicsState.y;
        this.shapeType.addElement(fillType);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    private void drawColor(PdfPaint currentCol, int type) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(type);
        this.text_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    @Override
    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawFillColor(PdfPaint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = currentCol.getRGB();
    }

    @Override
    public void setGraphicsState(int fillType, float value, int BM) {
        if (BM != 1111314299 || this.BMvalues != null) {
            if (this.BMvalues == null) {
                this.BMvalues = new Vector_Int(5000);
                this.BMvalues.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            this.objectType.addElement(31);
            this.BMvalues.addElement(BM);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
        if (fillType == 1) {
            if (this.lastFillOpacity == value) {
                return;
            }
            this.lastFillOpacity = value;
        }
        if (fillType == 2) {
            if (this.lastStrokeOpacity == value) {
                return;
            }
            this.lastStrokeOpacity = value;
        }
        if (value != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (fillType == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] type, Color[] colors, Object[] obj) throws PdfException {
        if (obj == null) {
            return;
        }
        if (endItem == -1) {
            endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
            }
            this.TRvalues.setCheckpoint();
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
            }
            this.fs.setCheckpoint();
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
            }
            this.lw.setCheckpoint();
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
            if (this.BMvalues != null) {
                this.BMvalues.setCheckpoint();
            }
        }
        this.drawUserContent(type, obj, colors);
    }

    @Override
    public void flushAdditionalObjOnPage() {
        if (endItem != -1) {
            this.currentItem = endItem;
        }
        endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        if (this.BMvalues != null) {
            this.BMvalues.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
    }

    @Override
    public void drawStrokeColor(Paint currentCol) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(currentCol);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    @Override
    public void drawCustom(Object value) {
        this.pageObjects.addElement(value);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawTR(int value) {
        if (value != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = value;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(value);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawStroke(Stroke current) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(current);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawClip(GraphicsState currentGraphicsState, Shape defaultClip, boolean canBeCached) {
        boolean resetClip = false;
        Area clip = currentGraphicsState.getClippingShape();
        if (!canBeCached || !this.hasClips || this.lastClip != null || clip != null) {
            if (!canBeCached || this.lastClip == null || clip == null) {
                resetClip = true;
            } else {
                Rectangle bounds = clip.getBounds();
                Rectangle oldBounds = this.lastClip.getBounds();
                if (bounds.x != oldBounds.x || bounds.y != oldBounds.y || bounds.width != oldBounds.width || bounds.height != oldBounds.height) {
                    resetClip = true;
                }
            }
        }
        if (resetClip) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = clip;
            if (clip == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement(BaseDisplay.convertPDFClipToJavaClip(clip));
            }
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = currentGraphicsState.x;
            this.y_coord[this.currentItem] = currentGraphicsState.y;
            ++this.currentItem;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] Trm, int fontSize, PdfGlyph embeddedGlyph, Object javaGlyph, int type, GraphicsState gs, double[] at, String glyf, PdfFont currentFontData, float glyfWidth) {
        int newCol;
        PdfPaint currentCol;
        int text_fill_type = gs.getTextRenderType();
        if ((text_fill_type & 2) == 2) {
            currentCol = gs.getNonstrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 2);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != newCol) {
                    this.lastFillTextCol = newCol;
                    this.drawColor(currentCol, 2);
                    this.resetTextColors = false;
                }
            }
        }
        if ((text_fill_type & 1) == 1) {
            currentCol = gs.getStrokeColor();
            if (currentCol.isPattern()) {
                this.drawColor(currentCol, 1);
                this.resetTextColors = true;
            } else {
                newCol = currentCol.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != newCol) {
                    this.resetTextColors = false;
                    this.lastStrokeCol = newCol;
                    this.drawColor(currentCol, 1);
                }
            }
        }
        this.setLineWidth((int)gs.getLineWidth());
        this.drawFontSize(fontSize);
        if (javaGlyph != null) {
            double[] nextAf;
            if (Trm != null && (this.lastAf[0] != (nextAf = new double[]{Trm[0][0], Trm[0][1], Trm[1][0], Trm[1][1], Trm[2][0], Trm[2][1]})[0] || this.lastAf[1] != nextAf[1] || this.lastAf[2] != nextAf[2] || this.lastAf[3] != nextAf[3])) {
                this.drawAffine(nextAf);
                this.lastAf[0] = nextAf[0];
                this.lastAf[1] = nextAf[1];
                this.lastAf[2] = nextAf[2];
                this.lastAf[3] = nextAf[3];
            }
            if (!(javaGlyph instanceof Area)) {
                type = -type;
            }
        } else if (this.lastAf[0] != at[0] || this.lastAf[1] != at[1] || this.lastAf[2] != at[2] || this.lastAf[3] != at[3]) {
            this.drawAffine(at);
            this.lastAf[0] = at[0];
            this.lastAf[1] = at[1];
            this.lastAf[2] = at[2];
            this.lastAf[3] = at[3];
        }
        if (embeddedGlyph == null) {
            this.pageObjects.addElement(javaGlyph);
        } else {
            this.pageObjects.addElement(embeddedGlyph);
        }
        this.objectType.addElement(type);
        if (type < 0) {
            this.areas.addElement(null);
        } else if (javaGlyph != null) {
            int[] rectParams = new int[]{(int)Trm[2][0], (int)Trm[2][1], fontSize, fontSize};
            this.areas.addElement(rectParams);
            this.checkWidth(rectParams);
        } else {
            int realSize = fontSize;
            if (realSize < 0) {
                realSize = -realSize;
            }
            int[] area = new int[]{(int)Trm[2][0], (int)Trm[2][1], realSize, realSize};
            this.areas.addElement(area);
            this.checkWidth(area);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = Trm[2][0];
        this.y_coord[this.currentItem] = Trm[2][1];
        ++this.currentItem;
    }

    @Override
    public void drawFontBounds(Rectangle newfontBB) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(newfontBB);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawAffine(double[] afValues) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(afValues[0]);
        this.af2.addElement(afValues[1]);
        this.af3.addElement(afValues[2]);
        this.af4.addElement(afValues[3]);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)afValues[4];
        this.y_coord[this.currentItem] = (float)afValues[5];
        ++this.currentItem;
    }

    @Override
    public void drawFontSize(int fontSize) {
        int realSize = fontSize;
        if (realSize < 0) {
            realSize = -realSize;
        }
        if (realSize != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(fontSize);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = realSize;
        }
    }

    @Override
    public void setLineWidth(int lineWidth) {
        if (lineWidth != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(lineWidth);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = lineWidth;
        }
    }

    public SwingDisplay(byte[] stream, Map fonts) {
        block5: {
            this.lastStrokeOpacity = -1.0f;
            this.lastFillOpacity = -1.0f;
            this.lastItemPainted = -1;
            this.pageX1 = 9999;
            this.pageX2 = -9999;
            this.pageY1 = -9999;
            this.pageY2 = 9999;
            this.cachedWidths = new HashMap(10);
            this.cachedHeights = new HashMap(10);
            this.fonts = new HashMap(50);
            this.fontsUsed = new HashSet<String>(50);
            this.imageID = new HashMap(10);
            this.storedImageValues = new HashMap(10);
            this.largeImages = new WeakHashMap(10);
            this.lastAf = new double[4];
            this.lastTR = 2;
            this.lastFS = -1;
            this.lastLW = -1;
            this.resetTextColors = true;
            this.needsHighlights = true;
            this.type = 1;
            try {
                this.fonts = fonts;
                ByteArrayInputStream bis = new ByteArrayInputStream(stream);
                int version = bis.read();
                if (version != 1) {
                    throw new PdfException("Unknown version in serialised object " + version);
                }
                int isHires = bis.read();
                this.useHiResImageForDisplay = isHires == 1;
                this.rawPageNumber = bis.read();
                this.x_coord = (float[])RenderUtils.restoreFromStream(bis);
                this.y_coord = (float[])RenderUtils.restoreFromStream(bis);
                this.text_color = (Vector_Object)RenderUtils.restoreFromStream(bis);
                this.textFillType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.stroke_color = new Vector_Object();
                this.stroke_color.restoreFromStream(bis);
                this.fill_color = new Vector_Object();
                this.fill_color.restoreFromStream(bis);
                this.stroke = new Vector_Object();
                this.stroke.restoreFromStream(bis);
                this.pageObjects = new Vector_Object();
                this.pageObjects.restoreFromStream(bis);
                this.javaObjects = (Vector_Object)RenderUtils.restoreFromStream(bis);
                this.shapeType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.af1 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af2 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af3 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.af4 = (Vector_Double)RenderUtils.restoreFromStream(bis);
                this.fontBounds = new Vector_Rectangle();
                this.fontBounds.restoreFromStream(bis);
                this.clips = new Vector_Shape();
                this.clips.restoreFromStream(bis);
                this.objectType = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.opacity = (Vector_Float)RenderUtils.restoreFromStream(bis);
                this.BMvalues = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.TRvalues = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.fs = (Vector_Int)RenderUtils.restoreFromStream(bis);
                this.lw = (Vector_Int)RenderUtils.restoreFromStream(bis);
                int fontCount = (Integer)RenderUtils.restoreFromStream(bis);
                for (int ii = 0; ii < fontCount; ++ii) {
                    Object key = RenderUtils.restoreFromStream(bis);
                    Object glyphs = RenderUtils.restoreFromStream(bis);
                    fonts.put(key, glyphs);
                }
                int alteredFontCount = (Integer)RenderUtils.restoreFromStream(bis);
                for (int ii = 0; ii < alteredFontCount; ++ii) {
                    Object key = RenderUtils.restoreFromStream(bis);
                    PdfJavaGlyphs updatedFont = (PdfJavaGlyphs)fonts.get(key);
                    updatedFont.setDisplayValues((Map)RenderUtils.restoreFromStream(bis));
                    updatedFont.setCharGlyphs((Map)RenderUtils.restoreFromStream(bis));
                    updatedFont.setEmbeddedEncs((Map)RenderUtils.restoreFromStream(bis));
                }
                bis.close();
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.currentItem = this.pageObjects.get().length;
    }

    @Override
    public void stopClearOnNextRepaint(boolean flag) {
        this.noRepaint = flag;
    }

    @Override
    public byte[] serializeToByteArray(Set fontsAlreadyOnClient) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(1);
        if (this.useHiResImageForDisplay) {
            bos.write(1);
        } else {
            bos.write(0);
        }
        bos.write(this.rawPageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.BMvalues != null) {
            this.BMvalues.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        RenderUtils.writeToStream(bos, this.x_coord);
        RenderUtils.writeToStream(bos, this.y_coord);
        RenderUtils.writeToStream(bos, this.text_color);
        RenderUtils.writeToStream(bos, this.textFillType);
        this.stroke_color.writeToStream(bos);
        this.fill_color.writeToStream(bos);
        this.stroke.writeToStream(bos);
        this.pageObjects.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.javaObjects);
        RenderUtils.writeToStream(bos, this.shapeType);
        RenderUtils.writeToStream(bos, this.af1);
        RenderUtils.writeToStream(bos, this.af2);
        RenderUtils.writeToStream(bos, this.af3);
        RenderUtils.writeToStream(bos, this.af4);
        this.fontBounds.writeToStream(bos);
        this.clips.writeToStream(bos);
        RenderUtils.writeToStream(bos, this.objectType);
        RenderUtils.writeToStream(bos, this.opacity);
        RenderUtils.writeToStream(bos, this.BMvalues);
        RenderUtils.writeToStream(bos, this.TRvalues);
        RenderUtils.writeToStream(bos, this.fs);
        RenderUtils.writeToStream(bos, this.lw);
        int fontCount = 0;
        int updateCount = 0;
        HashSet<String> fontsAlreadySent = new HashSet<String>(10);
        HashSet<String> newFontsToSend = new HashSet<String>(10);
        for (String fontUsed : this.fontsUsed) {
            if (!fontsAlreadyOnClient.contains(fontUsed)) {
                ++fontCount;
                newFontsToSend.add(fontUsed);
                continue;
            }
            ++updateCount;
            fontsAlreadySent.add(fontUsed);
        }
        RenderUtils.writeToStream(bos, fontCount);
        for (String key : newFontsToSend) {
            RenderUtils.writeToStream(bos, key);
            RenderUtils.writeToStream(bos, this.fonts.get(key));
            fontsAlreadyOnClient.add(key);
        }
        RenderUtils.writeToStream(bos, updateCount);
        for (String key : fontsAlreadySent) {
            RenderUtils.writeToStream(bos, key);
            PdfJavaGlyphs aa = (PdfJavaGlyphs)this.fonts.get(key);
            RenderUtils.writeToStream(bos, aa.getDisplayValues());
            RenderUtils.writeToStream(bos, aa.getCharGlyphs());
            RenderUtils.writeToStream(bos, aa.getEmbeddedEncs());
        }
        bos.close();
        this.fontsUsed.clear();
        return bos.toByteArray();
    }

    @Override
    public void checkFontSaved(Object glyph, String name, PdfFont currentFontData) {
        this.pageObjects.addElement(glyph);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.contains(name) || currentFontData.isFontSubsetted()) {
            this.fonts.put(name, currentFontData.getGlyphData());
            this.fontsUsed.add(name);
        }
    }

    @Override
    public Rectangle getArea(int i) {
        return new Rectangle(this.areas.elementAt(i)[0], this.areas.elementAt(i)[1], this.areas.elementAt(i)[2], this.areas.elementAt(i)[3]);
    }

    @Override
    public void setPrintPage(int currentPrintPage) {
        this.rawPageNumber = currentPrintPage;
    }

    @Override
    public void flagImageDeleted(int i) {
        this.objectType.setElementAt(27, i);
    }

    @Override
    public void setOCR(boolean isOCR) {
        this.hasOCR = isOCR;
    }

    @Override
    protected void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

