/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;

public final class PdfPrintTransform {
    private boolean autoRotate;
    private final boolean chooseSourceByPDFSize;
    private int scalingMode;
    private double scalingFactor;
    private boolean centerOnScaling;
    private Rectangle crop;
    private PageFormat format;

    public PdfPrintTransform(boolean autoRotate, boolean centerOnScaling, int scalingMode, boolean chooseSourceByPDFSize) {
        this.autoRotate = autoRotate;
        this.centerOnScaling = centerOnScaling;
        this.chooseSourceByPDFSize = chooseSourceByPDFSize;
        this.setPageScaling(scalingMode);
        this.scalingFactor = 1.0;
    }

    public AffineTransform getPageTransform(int cropBoxX, int cropBoxY, int width, int height, int pageRotation, PageFormat pageFormat) {
        return this.getPageTransform(new Rectangle(cropBoxX, cropBoxY, width, height), pageRotation, pageFormat);
    }

    public void setAutoRotateAndCenter(boolean b) {
        this.autoRotate = b;
        this.centerOnScaling = b;
    }

    public void setAutoRotateAndCenter(boolean rotate, boolean center) {
        this.autoRotate = rotate;
        this.centerOnScaling = center;
    }

    public void setPageScaling(int scalingMode) {
        switch (scalingMode) {
            case 0: 
            case 1: 
            case 2: {
                this.scalingMode = scalingMode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Scaling mode type: " + scalingMode);
            }
        }
    }

    public AffineTransform getPageTransform(Rectangle cropBox, int pageRotation, PageFormat pageFormat) {
        this.crop = cropBox;
        this.format = pageFormat;
        AffineTransform result = new AffineTransform();
        this.scalingFactor = 1.0;
        boolean shouldRotate = false;
        if (this.autoRotate || this.chooseSourceByPDFSize) {
            boolean isImageWidthLong;
            boolean isPageWidthLong = pageFormat.getImageableWidth() > pageFormat.getImageableHeight();
            boolean bl = isImageWidthLong = this.crop.width > this.crop.height;
            if (pageRotation == 90 || pageRotation == 270) {
                isImageWidthLong = this.crop.width < this.crop.height;
            }
            boolean bl2 = shouldRotate = isPageWidthLong != isImageWidthLong;
        }
        if (!shouldRotate) {
            if ((pageRotation += 180) > 360) {
                pageRotation -= 360;
            }
        } else if ((pageRotation += 90) > 360) {
            pageRotation -= 360;
        }
        double w = pageRotation % 180 == 0 ? (double)this.crop.width : (double)this.crop.height;
        double h = pageRotation % 180 == 0 ? (double)this.crop.height : (double)this.crop.width;
        double widthRatio = (pageFormat.getImageableWidth() - 1.0) / w;
        double heightRatio = (pageFormat.getImageableHeight() - 1.0) / h;
        if ((widthRatio < 1.0 || heightRatio < 1.0) && this.scalingMode == 2 || this.scalingMode == 1) {
            double d = this.scalingFactor = widthRatio < heightRatio ? widthRatio : heightRatio;
        }
        if (pageRotation != 0 || shouldRotate) {
            this.applyRotation(result, pageRotation);
        }
        if (this.crop.x != 0 || this.crop.y != 0) {
            this.applyCrop(result, pageRotation);
        }
        this.applyOffset(result, pageRotation);
        if (this.centerOnScaling) {
            this.applyCentering(result, pageRotation);
        }
        if (this.scalingMode != 0) {
            result.scale(this.scalingFactor, this.scalingFactor);
        }
        result.scale(-1.0, 1.0);
        result.translate(-this.crop.width, 0.0);
        this.crop = null;
        this.format = null;
        return result;
    }

    private void applyRotation(AffineTransform result, int rotation) {
        int factor = rotation / 90;
        result.rotate((double)factor * Math.PI / 2.0);
        switch (factor) {
            case 1: {
                result.translate(0.0, -((double)this.crop.height * this.scalingFactor));
                break;
            }
            case 2: {
                result.translate(-((double)this.crop.width * this.scalingFactor), -((double)this.crop.height * this.scalingFactor));
                break;
            }
            case 3: {
                result.translate(-((double)this.crop.width * this.scalingFactor), 0.0);
            }
        }
    }

    private void applyCrop(AffineTransform result, int rotation) {
        switch (rotation) {
            case 0: {
                result.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 90: {
                result.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 180: {
                result.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
                break;
            }
            case 270: {
                result.translate((double)this.crop.x * this.scalingFactor, (double)(-this.crop.y) * this.scalingFactor);
            }
        }
    }

    private void applyOffset(AffineTransform result, int rotation) {
        switch (rotation) {
            case 0: {
                result.translate(this.format.getImageableX(), this.format.getImageableY());
                break;
            }
            case 90: {
                result.translate(this.format.getImageableX(), -this.format.getImageableY());
                break;
            }
            case 180: {
                result.translate(-this.format.getImageableX(), -this.format.getImageableY());
                break;
            }
            case 270: {
                result.translate(-this.format.getImageableX(), this.format.getImageableY());
            }
        }
    }

    private void applyCentering(AffineTransform result, int rotation) {
        double centerOnX = 0.0;
        double centerOnY = 0.0;
        switch (rotation) {
            case 0: {
                centerOnX = (this.format.getImageableWidth() - (double)this.crop.width * this.scalingFactor) / 2.0;
                centerOnY = (this.format.getImageableHeight() - (double)this.crop.height * this.scalingFactor) / 2.0;
                break;
            }
            case 90: {
                centerOnX = (this.format.getImageableHeight() - (double)this.crop.width * this.scalingFactor) / 2.0;
                centerOnY = -((this.format.getImageableWidth() - (double)this.crop.height * this.scalingFactor) / 2.0);
                break;
            }
            case 180: {
                centerOnX = -(this.format.getImageableWidth() - (double)this.crop.width * this.scalingFactor) / 2.0;
                centerOnY = -(this.format.getImageableHeight() - (double)this.crop.height * this.scalingFactor) / 2.0;
                break;
            }
            case 270: {
                centerOnX = -(this.format.getImageableHeight() - (double)this.crop.width * this.scalingFactor) / 2.0;
                centerOnY = (this.format.getImageableWidth() - (double)this.crop.height * this.scalingFactor) / 2.0;
            }
        }
        result.translate(centerOnX, centerOnY);
    }
}

