/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.awt.geom.AffineTransform;
import org.jpedal.objects.PageOrigins;
import org.jpedal.objects.PdfPageData;

public class ScalingFactory {
    public static double[] getScalingForImage(int pageNumber, int rotation, float scaling, PdfPageData pageData) {
        double mediaX = (float)pageData.getMediaBoxX(pageNumber) * scaling;
        double mediaY = (float)pageData.getMediaBoxY(pageNumber) * scaling;
        double mediaH = (float)pageData.getMediaBoxHeight(pageNumber) * scaling;
        double crw = (float)pageData.getCropBoxWidth(pageNumber) * scaling;
        double crh = (float)pageData.getCropBoxHeight(pageNumber) * scaling;
        double crx = (float)pageData.getCropBoxX(pageNumber) * scaling;
        double cry = (float)pageData.getCropBoxY(pageNumber) * scaling;
        AffineTransform displayScaling = new AffineTransform();
        double[] displayScalingArray = new double[6];
        int x_size = (int)(crw + (crx - mediaX));
        int y_size = (int)(crh + (cry - mediaY));
        if (rotation == 270) {
            displayScaling.rotate(-1.5707963267948966, x_size / 2, y_size / 2);
            if (pageData.getOrigin() == PageOrigins.BOTTOM_LEFT) {
                double x_change = displayScaling.getTranslateX();
                double y_change = displayScaling.getTranslateY();
                displayScaling.translate((double)y_size - y_change, -x_change);
                displayScaling.translate(0.0, y_size);
                displayScaling.scale(1.0, -1.0);
                displayScaling.translate(-(crx + mediaX), -(mediaH - crh - (cry - mediaY)));
            }
        } else if (rotation == 180) {
            displayScaling.rotate(Math.PI, x_size / 2, y_size / 2);
            if (pageData.getOrigin() == PageOrigins.BOTTOM_LEFT) {
                displayScaling.translate(-(crx + mediaX), (double)y_size + (cry + mediaY) - (mediaH - crh - (cry - mediaY)));
                displayScaling.scale(1.0, -1.0);
            }
        } else if (rotation == 90) {
            displayScaling.rotate(1.5707963267948966);
            if (pageData.getOrigin() == PageOrigins.BOTTOM_LEFT) {
                displayScaling.translate(0.0, cry + mediaY - (mediaH - crh - (cry - mediaY)));
                displayScaling.scale(1.0, -1.0);
            }
        } else if (pageData.getOrigin() == PageOrigins.BOTTOM_LEFT) {
            displayScaling.translate(0.0, y_size);
            displayScaling.scale(1.0, -1.0);
            displayScaling.translate(0.0, -(mediaH - crh - (cry - mediaY)));
        }
        displayScaling.scale(scaling, scaling);
        displayScaling.getMatrix(displayScalingArray);
        return displayScalingArray;
    }
}

