/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import org.jpedal.utils.LogWriter;

public abstract class SwingWorker {
    private Object value;
    final ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
            while (t.isAlive()) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    if (!LogWriter.isOutput()) continue;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception in handling thread " + e);
                }
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        Runnable doConstruct = new Runnable(){

            @Override
            public void run() {
                try {
                    SwingWorker.this.setValue(SwingWorker.this.construct());
                }
                catch (Exception e) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Caught a Exception " + e);
                    }
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
            }
        };
        Thread t = new Thread(doConstruct);
        t.setDaemon(true);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

