/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.PreInterruptCallback;
import org.junit.jupiter.api.extension.PreInterruptContext;

final class PreInterruptThreadDumpPrinter
implements PreInterruptCallback {
    private static final String NL = "\n";

    PreInterruptThreadDumpPrinter() {
    }

    public void beforeThreadInterrupt(PreInterruptContext preInterruptContext, ExtensionContext extensionContext) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder("Thread ");
        PreInterruptThreadDumpPrinter.appendThreadName(sb, preInterruptContext.getThreadToInterrupt());
        sb.append(" will be interrupted.");
        sb.append(NL);
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stack = entry.getValue();
            if (stack.length <= 0) continue;
            sb.append(NL);
            PreInterruptThreadDumpPrinter.appendThreadName(sb, thread);
            for (StackTraceElement stackTraceElement : stack) {
                sb.append(NL);
                sb.append("\tat ");
                sb.append(stackTraceElement);
            }
            sb.append(NL);
        }
        System.out.println(sb);
    }

    private static void appendThreadName(StringBuilder builder, Thread thread) {
        builder.append("\"");
        builder.append(thread.getName());
        builder.append("\"");
        if (thread.isDaemon()) {
            builder.append(" daemon");
        }
        builder.append(" prio=");
        builder.append(thread.getPriority());
        builder.append(" Id=");
        builder.append(thread.getId());
        builder.append(" ");
        builder.append((Object)thread.getState());
    }
}

