/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.LdapURL;
import org.ldaptive.provider.AbstractProviderConnectionFactory;
import org.ldaptive.provider.Provider;
import org.ldaptive.provider.ProviderConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDConnectionFactory;
import org.ldaptive.provider.unboundid.UnboundIDProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDStartTLSConnectionFactory;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.TLSSocketFactory;

public class UnboundIDProvider
implements Provider<UnboundIDProviderConfig> {
    private UnboundIDProviderConfig config = new UnboundIDProviderConfig();

    public ProviderConnectionFactory<UnboundIDProviderConfig> getConnectionFactory(ConnectionConfig cc) {
        LDAPConnectionOptions options;
        SSLSocketFactory factory = this.config.getSSLSocketFactory();
        if (factory == null && (cc.getUseStartTLS() || cc.getUseSSL())) {
            factory = this.getHostnameVerifierSocketFactory(cc);
        }
        if ((options = this.config.getConnectionOptions()) == null) {
            options = this.getDefaultLDAPConnectionOptions(cc);
        }
        AbstractProviderConnectionFactory cf = cc.getUseStartTLS() ? new UnboundIDStartTLSConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, factory, options) : (cc.getUseSSL() ? new UnboundIDConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, factory, options) : new UnboundIDConnectionFactory(cc.getLdapUrl(), cc.getConnectionStrategy(), this.config, null, options));
        return cf;
    }

    protected SSLSocketFactory getHostnameVerifierSocketFactory(ConnectionConfig cc) {
        LdapURL ldapUrl = new LdapURL(cc.getLdapUrl());
        return TLSSocketFactory.getHostnameVerifierFactory((SslConfig)cc.getSslConfig(), (String[])ldapUrl.getHostnames());
    }

    protected LDAPConnectionOptions getDefaultLDAPConnectionOptions(ConnectionConfig cc) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        if (cc.getConnectTimeout() != null) {
            options.setConnectTimeoutMillis((int)cc.getConnectTimeout().toMillis());
        }
        if (cc.getResponseTimeout() != null) {
            options.setResponseTimeoutMillis(cc.getResponseTimeout().toMillis());
        }
        return options;
    }

    public UnboundIDProviderConfig getProviderConfig() {
        return this.config;
    }

    public void setProviderConfig(UnboundIDProviderConfig pc) {
        this.config = pc;
    }

    public UnboundIDProvider newInstance() {
        return new UnboundIDProvider();
    }
}

