/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import org.lionsoul.jcseg.extractor.KeyphraseExtractor;
import org.lionsoul.jcseg.extractor.KeywordsExtractor;
import org.lionsoul.jcseg.extractor.SummaryExtractor;
import org.lionsoul.jcseg.extractor.impl.TextRankKeyphraseExtractor;
import org.lionsoul.jcseg.extractor.impl.TextRankKeywordsExtractor;
import org.lionsoul.jcseg.extractor.impl.TextRankSummaryExtractor;
import org.lionsoul.jcseg.sentence.SentenceSeg;
import org.lionsoul.jcseg.tokenizer.NLPSeg;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;
import org.lionsoul.jcseg.util.ArrayUtil;

public class JcsegTest {
    JcsegTaskConfig tokenizerConfig = new JcsegTaskConfig(true);
    ADictionary dic = null;
    ISegment tokenizerSeg = null;
    ISegment extractorSeg = null;
    KeywordsExtractor keywordsExtractor = null;
    KeyphraseExtractor keyphraseExtractor = null;
    SummaryExtractor summaryExtractor = null;

    public JcsegTest() throws JcsegException, IOException, CloneNotSupportedException {
        JcsegTaskConfig extractorConfig = this.tokenizerConfig.clone();
        this.dic = DictionaryFactory.createSingletonDictionary(this.tokenizerConfig);
        this.tokenizerSeg = SegmentFactory.createJcseg(2, this.tokenizerConfig, this.dic);
        extractorConfig.setAppendCJKPinyin(false);
        extractorConfig.setClearStopwords(true);
        extractorConfig.setKeepUnregWords(false);
        this.extractorSeg = SegmentFactory.createJcseg(2, extractorConfig, this.dic);
        this.keywordsExtractor = new TextRankKeywordsExtractor(this.tokenizerSeg);
        this.keyphraseExtractor = new TextRankKeyphraseExtractor(this.tokenizerSeg);
        this.summaryExtractor = new TextRankSummaryExtractor(this.tokenizerSeg, new SentenceSeg());
        TextRankKeyphraseExtractor trkp = (TextRankKeyphraseExtractor)this.keyphraseExtractor;
        trkp.setAutoMinLength(4);
        trkp.setMaxWordsNum(4);
        System.out.println("jcseg\u53c2\u6570\u8bbe\u7f6e\uff1a");
        System.out.println("\u5f53\u524d\u52a0\u8f7d\u7684\u914d\u7f6e\u6587\u4ef6\uff1a" + this.tokenizerConfig.getPropertieFile());
        System.out.println("\u6700\u5927\u5207\u5206\u5339\u914d\u8bcd\u6570\uff1a" + this.tokenizerConfig.MAX_LENGTH);
    }

    public void tokenize(String str) throws IOException {
        StringBuffer sb = new StringBuffer();
        IWord word = null;
        long _start = System.nanoTime();
        boolean isFirst = true;
        boolean entity = this.tokenizerSeg instanceof NLPSeg;
        int counter = 0;
        this.tokenizerSeg.reset(new StringReader(str));
        while ((word = this.tokenizerSeg.next()) != null) {
            if (isFirst) {
                sb.append(word.getValue());
                isFirst = false;
            } else {
                sb.append(" ");
                sb.append(word.getValue());
            }
            if (word.getPartSpeech() != null) {
                sb.append('/');
                sb.append(word.getPartSpeech()[0]);
            }
            if (entity) {
                sb.append('/');
                sb.append(ArrayUtil.implode("|", word.getEntity()));
            }
            word = null;
            ++counter;
        }
        long e = System.nanoTime();
        System.out.println("\u5206\u8bcd\u7ed3\u679c\uff1a");
        System.out.println(sb.toString());
        System.out.format("Done, total:" + this.tokenizerSeg.getStreamPosition() + ", tokens:" + counter + ", in %.5fsec\n", (double)((float)e - (float)_start) / 1.0E9);
    }

    public void resetMode(int mode) throws JcsegException {
        this.tokenizerSeg = SegmentFactory.createJcseg(mode, this.tokenizerConfig, this.dic);
    }

    public void keywords(String str) throws IOException {
        long _start = System.nanoTime();
        List<String> keywords = this.keywordsExtractor.getKeywordsFromString(str);
        long e = System.nanoTime();
        System.out.println("Top10\u5173\u952e\u8bcd\uff1a");
        System.out.println(keywords);
        System.out.format("Done in %.5fsec\n", (double)((float)e - (float)_start) / 1.0E9);
    }

    public void keyphrase(String str) throws IOException {
        long _start = System.nanoTime();
        List<String> keyphrase = this.keyphraseExtractor.getKeyphraseFromString(str);
        long e = System.nanoTime();
        System.out.println("Top10\u5173\u952e\u77ed\u8bed\uff1a");
        System.out.println(keyphrase);
        System.out.format("Done in %.5fsec\n", (double)((float)e - (float)_start) / 1.0E9);
    }

    public void sentence(String str) throws IOException {
        long _start = System.nanoTime();
        List<String> sentence = this.summaryExtractor.getKeySentenceFromString(str);
        long e = System.nanoTime();
        System.out.println("Top6\u76f8\u5173\u53e5\u5b50\uff1a");
        System.out.println("+-Key sentence: ");
        int count = 1;
        for (String sen : sentence) {
            System.out.println(count + ": " + sen);
            ++count;
        }
        System.out.format("Done in %.5fsec\n", (double)((float)e - (float)_start) / 1.0E9);
    }

    public void summary(String str) throws IOException {
        long _start = System.nanoTime();
        String summary = this.summaryExtractor.getSummaryFromString(str, 86);
        long e = System.nanoTime();
        System.out.println("\u6458\u8981\u7ed3\u679c\uff1a");
        System.out.println(summary);
        System.out.format("Done in %.5fsec\n", (double)((float)e - (float)_start) / 1.0E9);
    }

    public static void main(String[] args) throws JcsegException, IOException, CloneNotSupportedException {
        String str = "\u6b67\u4e49\u548c\u540c\u4e49\u8bcd:\u7814\u7a76\u751f\u547d\u8d77\u6e90\uff0c\u6df7\u5408\u8bcd: \u505aB\u8d85\u68c0\u67e5\u8eab\u4f53\uff0cx\u5c04\u7ebf\u672c\u8d28\u662f\u4ec0\u4e48\uff0c\u4eca\u5929\u53bb\u5947\u90fdktv\u5531\u5361\u62c9ok\u53bb\uff0c\u54c6\u5566a\u68a6\u662f\u4e00\u4e2a\u52a8\u6f2b\u4e2d\u7684\u4e3b\u89d2\uff0c\u5355\u4f4d\u548c\u5168\u89d2: 2009\u5e74\uff18\u6708\uff16\u65e5\u5f00\u59cb\u5927\u5b66\u4e4b\u65c5\uff0c\u5cb3\u9633\u4eca\u5929\u7684\u6c14\u6e29\u4e3a38.6\u2103, \u4e5f\u5c31\u662f101.48\u2109, \u4e2d\u6587\u6570\u5b57/\u5206\u6570: \u4f60\u5206\u4e09\u5341\u5206\u4e4b\u4e8c, \u5c0f\u9648\u62ff\u4e09\u5341\u5206\u4e4b\u4e94,\u5269\u4e0b\u7684\u4e09\u5341\u5206\u4e4b\u4e8c\u5341\u4e09\u5168\u90e8\u662f\u6211\u7684\uff0c\u90a3\u662f\u4e00\u4e5d\u4e5d\u516b\u5e74\u524d\u7684\u4e8b\u4e86\uff0c\u56db\u5ddd\u9ebb\u8fa3\u70eb\u5f88\u597d\u5403\uff0c\u4e94\u56db\u8fd0\u52a8\u7559\u4e0b\u7684\u4e94\u56db\u7cbe\u795e\u3002\u7b14\u8bb0\u672c\u4e94\u6298\u5305\u90ae\u4e8f\u672c\u5927\u7529\u5356\u3002\u4eba\u540d\u8bc6\u522b: \u6211\u662f\u9648\u946b\uff0c\u4e5f\u662fjcseg\u7684\u4f5c\u8005\uff0c\u4e09\u56fd\u65f6\u671f\u7684\u8bf8\u845b\u4eae\u662f\u4e2a\u5929\u624d\uff0c\u6211\u4eec\u4e00\u8d77\u7ed9\u5218\u7fd4\u52a0\u6cb9\uff0c\u7f57\u5fd7\u9ad8\u5174\u594b\u6781\u4e86\u56e0\u4e3a\u8001\u5434\u9001\u4e86\u4ed6\u4e00\u53f0\u7b14\u8bb0\u672c\u3002\u51b0\u5c9b\u65f6\u95f47\u67081\u65e5\uff0c\u6b63\u5728\u5f53\u5730\u62cd\u7247\u7684\u6c64\u59c6\u00b7\u514b\u9c81\u65af\u901a\u8fc7\u53d1\u8a00\u4eba\u627f\u8ba4\uff0c\u4ed6\u4e0e\u7b2c\u4e09\u4efb\u59bb\u5b50\u51ef\u8482\u00b7\u8d6b\u5c14\u58a8\u65af\uff08\u7b2c\u4e00\u4e8c\u4efb\u59bb\u5b50\u5206\u522b\u4e3a\u54aa\u54aa\u00b7\u7f57\u6770\u65af\u3001\u59ae\u53ef\u00b7\u57fa\u5fb7\u66fc\uff09\u7684\u5a5a\u59fb\u5373\u5c06\u7ed3\u675f\u3002\u914d\u5bf9\u6807\u70b9: \u672c\u6b21\u300e\u7545\u60f3\u676f\u300f\u9ed1\u5ba2\u6280\u672f\u5927\u8d5b\u7684\u5f97\u4e3b\u4e3a\u7535\u4fe109-2BF\u7684\u5f20\u4e09\uff0c\u5956\u52b1C++\u7a0b\u5e8f\u8bbe\u8ba1\u8bed\u8a00\u4e00\u4e66\u548c\u3010\u7545\u60f3\u7f51\u7edc\u3011\u7684\u300ePHP\u6559\u7a0b\u300f\u4e00\u5957\u3002\u7279\u6b8a\u5b57\u6bcd: \u3010\u2160\u3011\uff08\u2161\uff09\uff0c\u82f1\u6587\u6570\u5b57: bug report chenxin619315@gmail.com or visit http://code.google.com/p/jcseg, we all admire the hacker spirit!\u7279\u6b8a\u6570\u5b57: \u2460 \u2469 \u247d \u3229.";
        int action = 0;
        String cmd = null;
        String module = "tokenizer:complex";
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        JcsegTest demo = new JcsegTest();
        System.out.println(str);
        try {
            demo.tokenize(str);
            JcsegTest.printHelpMenu();
            while (true) {
                System.out.print("jcseg~" + module + ">> ");
                cmd = reader.readLine();
                if (cmd != null) {
                    if ("".equals(cmd = cmd.trim())) continue;
                    if (cmd.charAt(0) == ':') {
                        if (":complex".equals(cmd)) {
                            demo.resetMode(2);
                            module = "tokenzier:complex";
                            action = 0;
                            System.out.println("Entered complex tokenize mode!");
                            continue;
                        }
                        if (":simple".equals(cmd)) {
                            demo.resetMode(1);
                            module = "tokenzier:simple";
                            action = 0;
                            System.out.println("Entered simple tokenize mode!");
                            continue;
                        }
                        if (":search".equals(cmd)) {
                            demo.resetMode(4);
                            module = "tokenzier:search";
                            action = 0;
                            System.out.println("Entered search tokenize mode!");
                            continue;
                        }
                        if (":detect".equals(cmd)) {
                            demo.resetMode(3);
                            module = "tokenzier:detect";
                            action = 0;
                            System.out.println("Entered detect tokenize mode!");
                            continue;
                        }
                        if (":delimiter".equals(cmd)) {
                            demo.resetMode(5);
                            module = "tokenzier:delimiter";
                            action = 0;
                            System.out.println("Entered delimiter tokenize mode!");
                            continue;
                        }
                        if (":NLP".equals(cmd)) {
                            demo.resetMode(6);
                            module = "tokenzier:NLP";
                            action = 0;
                            System.out.println("Entered NLP tokenize mode!");
                            continue;
                        }
                        if (":keywords".equals(cmd)) {
                            module = "keywords";
                            action = 1;
                            System.out.println("Entered keywords extract mode!");
                            continue;
                        }
                        if (":keyphrase".equals(cmd)) {
                            module = "keyphrase";
                            action = 2;
                            System.out.println("Entered keyphrase extract mode!");
                            continue;
                        }
                        if (":sentence".equals(cmd)) {
                            action = 3;
                            module = "sentence";
                            System.out.println("Entered sentence extract mode!");
                            continue;
                        }
                        if (":summary".equals(cmd)) {
                            action = 4;
                            module = "summary";
                            System.out.println("Entered summary extract mode!");
                            continue;
                        }
                        if (":help".equals(cmd)) {
                            JcsegTest.printHelpMenu();
                            continue;
                        }
                        if (":quit".equals(cmd)) {
                            System.out.println("Thanks for trying jcseg, Bye!");
                            System.exit(0);
                        }
                    }
                    switch (action) {
                        case 0: {
                            demo.tokenize(cmd);
                            break;
                        }
                        case 1: {
                            demo.keywords(cmd);
                            break;
                        }
                        case 2: {
                            demo.keyphrase(cmd);
                            break;
                        }
                        case 3: {
                            demo.sentence(cmd);
                            break;
                        }
                        case 4: {
                            demo.summary(cmd);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Bye!");
    }

    static void printHelpMenu() {
        System.out.println("+--------Jcseg chinese word tokenizer demo---------------+");
        System.out.println("|- @Author chenxin<chenxin619315@gmail.com>              |");
        System.out.println("|- :seg_mode  : switch to specified tokenizer mode.      |");
        System.out.println("|- (:complex,:simple,:search,:detect,:delimiter,:NLP)    |");
        System.out.println("|- :keywords  : switch to keywords extract mode.         |");
        System.out.println("|- :keyphrase : switch to keyphrase extract mode.        |");
        System.out.println("|- :sentence  : switch to sentence extract mode.         |");
        System.out.println("|- :summary   : switch to summary extract mode.          |");
        System.out.println("|- :help      : print this help menu.                    |");
        System.out.println("|- :quit      : to exit the program.                     |");
        System.out.println("+--------------------------------------------------------+");
    }
}

