/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.segmenter.Entity;
import org.lionsoul.jcseg.segmenter.Word;

public class TimeUtil {
    public static final int DATETIME_NONE = -1;
    public static final int DATETIME_Y = 0;
    public static final int DATETIME_M = 1;
    public static final int DATETIME_D = 2;
    public static final int DATETIME_A = 3;
    public static final int DATETIME_H = 4;
    public static final int DATETIME_I = 5;
    public static final int DATETIME_S = 6;
    private static final String[] KeyMap = new String[]{"y", "m", "d", "tm", "h", "i", "s"};

    public static final int getDateTimeIndex(String entity) {
        if (entity == null) {
            return -1;
        }
        int sIdx = entity.indexOf(46);
        if (sIdx == -1) {
            return -1;
        }
        String attr = entity.substring(sIdx + 1);
        if (attr.length() < 1) {
            return -1;
        }
        if (attr.startsWith("y")) {
            return 0;
        }
        if (attr.startsWith("m")) {
            return 1;
        }
        if (attr.startsWith("d")) {
            return 2;
        }
        if (attr.startsWith("a")) {
            return 3;
        }
        if (attr.startsWith("h")) {
            return 4;
        }
        if (attr.startsWith("i")) {
            return 5;
        }
        if (attr.startsWith("s")) {
            return 6;
        }
        return -1;
    }

    public static final IWord[] createDateTimePool() {
        return new IWord[]{null, null, null, null, null, null, null};
    }

    public static final int fillDateTimePool(IWord[] wPool, IWord word) {
        int pIdx = TimeUtil.getDateTimeIndex(word.getEntity(0));
        if (pIdx == -1) {
            return -1;
        }
        if (wPool[pIdx] == null) {
            wPool[pIdx] = word;
            return pIdx;
        }
        return -1;
    }

    public static final void fillDateTimePool(IWord[] wPool, int pIdx, IWord word) {
        if (wPool[pIdx] == null) {
            wPool[pIdx] = word;
        }
    }

    public static final String getTimeKey(String entity) {
        if (entity == null) {
            return null;
        }
        int sIdx = entity.indexOf(46);
        if (sIdx == -1) {
            return null;
        }
        return entity.substring(sIdx + 1);
    }

    public static final String getTimeKey(IWord word) {
        return TimeUtil.getTimeKey(word.getEntity(0));
    }

    public static final String getTimeKey(int pIdx) {
        if (pIdx < 0 || pIdx > 12) {
            return null;
        }
        return KeyMap[pIdx];
    }

    public static final void fillTimeToPool(IWord[] wPool, String timeVal) {
        String[] p = timeVal.split(":");
        TimeUtil.fillDateTimePool(wPool, 4, new Word(p[0] + "\u70b9", 1, Entity.E_TIME_H_A));
        TimeUtil.fillDateTimePool(wPool, 5, new Word(p[1] + "\u5206", 1, Entity.E_TIME_I_A));
        if (p.length == 3) {
            TimeUtil.fillDateTimePool(wPool, 6, new Word(p[2] + "\u79d2", 1, Entity.E_TIME_S_A));
        }
    }
}

