/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.parser.LiquibaseParser;
import liquibase.parser.core.xml.LiquibaseSchemaResolver;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializer;
import liquibase.util.StreamUtil;
import liquibase.util.file.FilenameUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LiquibaseEntityResolver
implements EntityResolver2 {
    private LiquibaseParser parser;
    private LiquibaseSerializer serializer;
    private ResourceAccessor resourceAccessor;
    private String basePath;
    private Logger log = LogService.getLog(this.getClass());

    public LiquibaseEntityResolver(LiquibaseSerializer serializer) {
        this.serializer = serializer;
    }

    public LiquibaseEntityResolver(LiquibaseParser parser) {
        this.parser = parser;
    }

    public void useResoureAccessor(ResourceAccessor resourceAccessor, String basePath) {
        this.resourceAccessor = resourceAccessor;
        this.basePath = basePath;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        this.log.debug(LogType.LOG, "Resolving XML entity name='" + name + "', publicId='" + publicId + "', baseURI='" + baseURI + "', systemId='" + systemId + "'");
        if (systemId == null) {
            this.log.debug(LogType.LOG, "Unable to resolve XML entity locally. Will load from network.");
            return null;
        }
        InputSource resolved = null;
        if (systemId.toLowerCase().endsWith(".xsd")) {
            if (systemId.startsWith("http://www.liquibase.org/xml/ns/migrator/")) {
                systemId = systemId.replace("http://www.liquibase.org/xml/ns/migrator/", "http://www.liquibase.org/xml/ns/dbchangelog/");
            }
            resolved = this.tryResolveLiquibaseSchema(systemId, publicId);
        }
        if (resolved == null && this.resourceAccessor != null && this.basePath != null) {
            resolved = this.tryResolveFromResourceAccessor(systemId);
        }
        if (resolved == null) {
            this.log.debug(LogType.LOG, "Unable to resolve XML entity locally. Will load from network.");
        }
        return resolved;
    }

    private InputSource tryResolveLiquibaseSchema(String systemId, String publicId) {
        LiquibaseSchemaResolver liquibaseSchemaResolver = new LiquibaseSchemaResolver(systemId, publicId, this.resourceAccessor);
        if (this.serializer != null) {
            return liquibaseSchemaResolver.resolve(this.serializer);
        }
        return liquibaseSchemaResolver.resolve(this.parser);
    }

    private InputSource tryResolveFromResourceAccessor(String systemId) {
        String path = FilenameUtils.concat(this.basePath, systemId);
        this.log.debug(LogType.LOG, "Attempting to load " + systemId + " from resourceAccessor as " + path);
        try {
            InputStream resourceAsStream = StreamUtil.singleInputStream(path, this.resourceAccessor);
            if (resourceAsStream == null) {
                this.log.debug(LogType.LOG, "Could not load " + systemId + " from resourceAccessor as " + path);
                return null;
            }
            return new InputSource(resourceAsStream);
        }
        catch (Exception ex2) {
            return null;
        }
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.log.warning(LogType.LOG, "Current XML parsers seems to not support EntityResolver2. External entities won't be correctly loaded");
        return this.tryResolveLiquibaseSchema(systemId, publicId);
    }
}

