/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.EnableTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="enableTrigger", description="Enable Trigger", priority=1)
public class EnableTriggerChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String triggerName;
    private String tableName;
    private String scope;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    @DatabaseChangeProperty(requiredForDatabase={"none"})
    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Trigger has been enabled";
    }

    @Override
    protected Change[] createInverses() {
        DisableTriggerChange disableTriggerChange = new DisableTriggerChange();
        disableTriggerChange.setSchemaName(this.getSchemaName());
        disableTriggerChange.setTriggerName(this.getTriggerName());
        return new Change[]{disableTriggerChange};
    }

    @Override
    public SqlStatement[] generateStatements(Database object) {
        object = new EnableTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getTriggerName());
        ((EnableTriggerStatement)object).setScope(this.getScope());
        return new SqlStatement[]{object};
    }
}

