/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.ArrayList;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateOnNullType;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonAggregateUniqueKeysType;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunctionExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonFunctionType;
import liquibase.repackaged.net.sf.jsqlparser.expression.JsonKeyValuePair;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JsonFunction
extends ASTNodeAccessImpl
implements Expression {
    private JsonFunctionType functionType;
    private final ArrayList<JsonKeyValuePair> keyValuePairs = new ArrayList();
    private final ArrayList<JsonFunctionExpression> expressions = new ArrayList();
    private JsonAggregateOnNullType onNullType;
    private JsonAggregateUniqueKeysType uniqueKeysType;

    public ArrayList<JsonKeyValuePair> getKeyValuePairs() {
        return this.keyValuePairs;
    }

    public ArrayList<JsonFunctionExpression> getExpressions() {
        return this.expressions;
    }

    public JsonKeyValuePair getKeyValuePair(int n2) {
        return this.keyValuePairs.get(n2);
    }

    public JsonFunctionExpression getExpression(int n2) {
        return this.expressions.get(n2);
    }

    public boolean add(JsonKeyValuePair jsonKeyValuePair) {
        return this.keyValuePairs.add(jsonKeyValuePair);
    }

    public void add(int n2, JsonKeyValuePair jsonKeyValuePair) {
        this.keyValuePairs.add(n2, jsonKeyValuePair);
    }

    public boolean add(JsonFunctionExpression jsonFunctionExpression) {
        return this.expressions.add(jsonFunctionExpression);
    }

    public void add(int n2, JsonFunctionExpression jsonFunctionExpression) {
        this.expressions.add(n2, jsonFunctionExpression);
    }

    public JsonAggregateOnNullType getOnNullType() {
        return this.onNullType;
    }

    public void setOnNullType(JsonAggregateOnNullType jsonAggregateOnNullType) {
        this.onNullType = jsonAggregateOnNullType;
    }

    public JsonFunction withOnNullType(JsonAggregateOnNullType jsonAggregateOnNullType) {
        this.setOnNullType(jsonAggregateOnNullType);
        return this;
    }

    public JsonAggregateUniqueKeysType getUniqueKeysType() {
        return this.uniqueKeysType;
    }

    public void setUniqueKeysType(JsonAggregateUniqueKeysType jsonAggregateUniqueKeysType) {
        this.uniqueKeysType = jsonAggregateUniqueKeysType;
    }

    public JsonFunction withUniqueKeysType(JsonAggregateUniqueKeysType jsonAggregateUniqueKeysType) {
        this.setUniqueKeysType(jsonAggregateUniqueKeysType);
        return this;
    }

    public JsonFunctionType getType() {
        return this.functionType;
    }

    public void setType(JsonFunctionType jsonFunctionType) {
        this.functionType = Objects.requireNonNull(jsonFunctionType, "The Type of the JSON Aggregate Function must not be null");
    }

    public JsonFunction withType(JsonFunctionType jsonFunctionType) {
        this.setType(jsonFunctionType);
        return this;
    }

    public void setType(String string) {
        this.functionType = JsonFunctionType.valueOf(Objects.requireNonNull(string, "The Type of the JSON Aggregate Function must not be null").toUpperCase());
    }

    public JsonFunction withType(String string) {
        this.setType(string);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public StringBuilder append(StringBuilder stringBuilder) {
        switch (this.functionType) {
            case OBJECT: {
                this.appendObject(stringBuilder);
                break;
            }
            case POSTGRES_OBJECT: {
                this.appendPostgresObject(stringBuilder);
                break;
            }
            case ARRAY: {
                this.appendArray(stringBuilder);
            }
        }
        return stringBuilder;
    }

    public StringBuilder appendObject(StringBuilder stringBuilder) {
        stringBuilder.append("JSON_OBJECT( ");
        int n2 = 0;
        for (JsonKeyValuePair jsonKeyValuePair : this.keyValuePairs) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            if (jsonKeyValuePair.isUsingValueKeyword()) {
                if (jsonKeyValuePair.isUsingKeyKeyword()) {
                    stringBuilder.append("KEY ");
                }
                stringBuilder.append(jsonKeyValuePair.getKey()).append(" VALUE ").append(jsonKeyValuePair.getValue());
            } else {
                stringBuilder.append(jsonKeyValuePair.getKey()).append(":").append(jsonKeyValuePair.getValue());
            }
            if (jsonKeyValuePair.isUsingFormatJson()) {
                stringBuilder.append(" FORMAT JSON");
            }
            ++n2;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    stringBuilder.append(" NULL ON NULL");
                    break;
                }
                case ABSENT: {
                    stringBuilder.append(" ABSENT On NULL");
                }
            }
        }
        if (this.uniqueKeysType != null) {
            switch (this.uniqueKeysType) {
                case WITH: {
                    stringBuilder.append(" WITH UNIQUE KEYS");
                    break;
                }
                case WITHOUT: {
                    stringBuilder.append(" WITHOUT UNIQUE KEYS");
                }
            }
        }
        stringBuilder.append(" ) ");
        return stringBuilder;
    }

    public StringBuilder appendPostgresObject(StringBuilder stringBuilder) {
        stringBuilder.append("JSON_OBJECT( ");
        for (JsonKeyValuePair jsonKeyValuePair : this.keyValuePairs) {
            stringBuilder.append(jsonKeyValuePair.getKey());
            if (jsonKeyValuePair.getValue() == null) continue;
            stringBuilder.append(", ").append(jsonKeyValuePair.getValue());
        }
        stringBuilder.append(" ) ");
        return stringBuilder;
    }

    public StringBuilder appendArray(StringBuilder stringBuilder) {
        stringBuilder.append("JSON_ARRAY( ");
        int n2 = 0;
        for (JsonFunctionExpression jsonFunctionExpression : this.expressions) {
            if (n2 > 0) {
                stringBuilder.append(", ");
            }
            jsonFunctionExpression.append(stringBuilder);
            ++n2;
        }
        if (this.onNullType != null) {
            switch (this.onNullType) {
                case NULL: {
                    stringBuilder.append(" NULL ON NULL ");
                    break;
                }
                case ABSENT: {
                    stringBuilder.append(" ABSENT ON NULL ");
                }
            }
        }
        stringBuilder.append(") ");
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        return this.append(stringBuilder).toString();
    }
}

