/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.command.CommandScope;
import liquibase.command.core.SnapshotCommandStep;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseSnapshotMojo
extends AbstractLiquibaseChangeLogMojo {
    protected String snapshotFormat;
    protected File outputFile;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        Database db = liquibase.getDatabase();
        CommandScope commandScope = new CommandScope(SnapshotCommandStep.COMMAND_NAME);
        commandScope.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)db);
        commandScope.addArgumentValue(DbUrlConnectionArgumentsCommandStep.URL_ARG, (Object)db.getConnection().getURL());
        commandScope.addArgumentValue(SnapshotCommandStep.SNAPSHOT_FORMAT_ARG, (Object)this.snapshotFormat);
        PrintStream output = this.createPrintStream();
        commandScope.setOutput((OutputStream)output);
        commandScope.execute();
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "snapshotFormat: " + this.snapshotFormat));
        this.getLog().info((CharSequence)(indent + "outputFile: " + this.outputFile));
    }

    private PrintStream createPrintStream() throws LiquibaseException {
        try {
            return this.outputFile != null ? new PrintStream(this.outputFile) : System.out;
        }
        catch (FileNotFoundException e) {
            throw new LiquibaseException((Throwable)e);
        }
    }
}

